FUNCTION ecrire, x
	RETURN, STRCOMPRESS(STRING(x),/REMOVE_ALL)
END

PRO dl

	LMIN = 17
	LMAX = 37

	DMIN = 2
	DMAX = 12

	NBL = LMAX - LMIN + 1
	NBD = DMAX - DMIN + 1

	OPENW,  fd, 'dl.cef', /GET_LUN

	PRINTF, fd, 'END_OF_RECORD_MARKER = ";"'
	PRINTF, fd, 'FILE_FORMAT_VERSION = "CEF-2.0"'
	PRINTF, fd
	PRINTF, fd, 'START_VARIABLE = epoch'
	PRINTF, fd, '	PARAMETER_TYPE = "Support_Data"'
	PRINTF, fd, '	VALUE_TYPE = ISO_TIME'
	PRINTF, fd, '	UNITS = "s"'
	PRINTF, fd, '	DELTA_PLUS = duration'
	PRINTF, fd, '	DELTA_MINUS = 0.0'
	PRINTF, fd, 'END_VARIABLE = epoch'
	PRINTF, fd
	PRINTF, fd, 'START_VARIABLE = atan'
	PRINTF, fd, '	PARAMETER_TYPE = "Data"'
	PRINTF, fd, '	VALUE_TYPE = FLOAT'
	PRINTF, fd, '	PROPERTY = "???"'
	PRINTF, fd, '	UNITS = "???"'
	PRINTF, fd, '	SIZES = '+ecrire(NBD)+','+ecrire(NBL)+',1'
	PRINTF, fd, '	FILLVAL = -1E31'
	PRINTF, fd, '	DEPEND_0 = epoch'
	PRINTF, fd, '	DEPEND_1 = D'
	PRINTF, fd, '	DEPEND_2 = L'
	PRINTF, fd, '	DEPEND_3 = energy'
	PRINTF, fd, 'END_VARIABLE = atan'
	PRINTF, fd
	PRINTF, fd, 'START_VARIABLE = D'
	PRINTF, fd, '	PARAMETER_TYPE = "Support_Data"'
	PRINTF, fd, '	LABLAXIS = "D en ???"'
	PRINTF, fd, '	VALUE_TYPE = FLOAT'
	PRINTF, fd, '	UNITS = "???"'
	PRINTF, fd, '	SIZES = ' + ecrire(NBD)
	s	= '	DATA = '
	FOR i=DMIN,DMAX DO s += ecrire(i) + (i NE DMAX ? ',' : '')
	PRINTF, fd, s
	PRINTF, fd, '	DELTA_PLUS = 1'
	PRINTF, fd, '	DELTA_MINUS = 0'
	PRINTF, fd, 'END_VARIABLE = D'
	PRINTF, fd
	PRINTF, fd, 'START_VARIABLE = L'
	PRINTF, fd, '	PARAMETER_TYPE = "Support_Data"'
	PRINTF, fd, '	LABLAXIS = "L en mm"'
	PRINTF, fd, '	VALUE_TYPE = FLOAT'
	PRINTF, fd, '	UNITS = "mm"'
	PRINTF, fd, '	SIZES = ' + ecrire(NBL)
	s	= '	DATA = '
	FOR i=LMIN,LMAX DO s += ecrire(i) + (i NE LMAX ? ',' : '')
	PRINTF, fd, s
	PRINTF, fd, '	DELTA_PLUS = 1.0'
	PRINTF, fd, '	DELTA_MINUS = 0.0'
	PRINTF, fd, 'END_VARIABLE = L'
	PRINTF, fd
	PRINTF, fd, 'START_VARIABLE = energy'
	PRINTF, fd, '	PARAMETER_TYPE = "Support_Data"'
	PRINTF, fd, '	VALUE_TYPE = FLOAT'
	PRINTF, fd, '	SIZES = 1'
	PRINTF, fd, '	DATA = 1.0'
	PRINTF, fd, '	DELTA_PLUS = 0.1'
	PRINTF, fd, '	DELTA_MINUS = 0.1'
	PRINTF, fd, 'END_VARIABLE = energy'
	PRINTF, fd

	PRINTF, fd, 'DATA_UNTIL = EOF'

	s	= '2000-01-01T00:00:00.000Z,'

	FOR D=DMIN,DMAX DO BEGIN

		FOR L=LMIN,LMAX DO BEGIN

			s += ecrire(ATAN(FLOAT(D)/FLOAT(L)) * 180.0 / !PI) + (L EQ LMAX AND D EQ DMAX ? ';' : ',')
		END

	END
	PRINTF, fd, s

	FREE_LUN, fd

END
