;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: device__define.pro,v $, v $Revision: 1.28 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
FUNCTION device::check
;-------------------------------------------------------------------------------
; Verifie la taille des marges.
;-------------------------------------------------------------------------------

	IF get(self,'marge_gauche') + get(self,'marge_droite') GT get(self,'long') THEN BEGIN
		RETURN, get(self,'marge_gauche',/texte) + ' + ' + 		$
			get(self,'marge_droite',/texte) + ' must be <= ' + 	$
			get(self,'long',/texte)
	END

	IF get(self,'marge_bas') + get(self,'marge_haut') GT get(self,'larg') THEN BEGIN
		RETURN, get(self,'marge_bas',/texte) + ' + ' + 			$
			get(self,'marge_haut',/texte) + ' must be <= ' + 	$
			get(self,'larg',/texte)
	END

END

;-------------------------------------------------------------------------------
PRO device::orientation
;-------------------------------------------------------------------------------
; Change l'orientation du device.
;-------------------------------------------------------------------------------

	val = get (self,'orientation') EQ 'Portrait' ? 'Landscape' : 'Portrait'
	set, self, 'orientation', val

END

;-------------------------------------------------------------------------------
FUNCTION device::ouvrir
;-------------------------------------------------------------------------------
; Ouvre le device (EPS, GIF, BMP, JPEG, PNG, TIFF, PRINTER, ...)
;-------------------------------------------------------------------------------

	hash = self -> gethash()
	hash_general = self.general -> gethash()

	driver = getq (self, hash.driver)
	default_driver = getq (self, hash.default_driver)
	nom = getq (self, hash.nom)
	orientation = getq (self, hash.orientation)
	marge_gauche = getq (self, hash.marge_gauche)
	marge_droite = getq (self, hash.marge_droite)
	marge_haut = getq (self, hash.marge_haut)
	marge_bas = getq (self, hash.marge_bas)
	rap = getq (self, hash.rap)
	long = getq (self, hash.long)
	larg = getq (self, hash.larg)
	batch = getq (self.general, hash_general.batch)

	IF driver EQ 'EPS' THEN BEGIN
		driver_setplot = 'PS'
	END ELSE IF !CL.libplot NE '' AND driver EQ 'PNG' THEN BEGIN
		driver_setplot = 'PNG' ; driver natif de plplot
	END ELSE IF driver EQ 'GIF' OR driver EQ 'BMP' OR driver EQ 'JPEG' OR driver EQ 'PNG' OR driver EQ 'TIFF' THEN BEGIN
		driver_setplot = default_driver
	END ELSE BEGIN
		driver_setplot = driver
	END
	encapsule = driver EQ 'EPS'

	pal = getq (self.general, hash_general.pal)
	coul = pal -> code(0) ; blanc

	; Le driver 'PRINTER' comporte un bug: lorsque l'on positionne SET_PLOT a 'printer', les appels
	; a LOADCT ou TVLCT ne charge pas correctement les couleurs dans ce driver.
	; Pour corriger ce probleme, lorsque l'on a realise la vue a l'ecran, il faut utiliser /COPY
	; a l'appel de SET_PLOT, 'PRINTER' pour transferer les couleurs de l'ecran vers le device 'printer'
	; Mais, en mode TRUE COLOR, ce n'est pas la peine d'utiliser /COPY !

	true = pal -> true()
	libplot_set_plot, driver_setplot, COPY=STRUPCASE(driver_setplot) EQ 'PRINTER' AND ~true
	code = ouvrir_device (nom,orientation,encapsule,marge_gauche,marge_droite,marge_haut,marge_bas,rap,long,larg,coul,true)

	IF code EQ -1 THEN BEGIN
		IF ~batch THEN BEGIN
			lint_unused = DIALOG_MESSAGE ('Unable to save '+nom,/error) ; on ne passe pas ici en mode batch
		END ELSE BEGIN
			PRINT, "Can't create file " + nom + ' !'
		END
		libplot_set_plot, default_driver
	END

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO device::fermer,		$
;-------------------------------------------------------------------------------
	nomessage=nomessage,	$	; LINT_PROTOTYPE input
	alpha=alpha			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ferme le device (crit l'image si GIF, BMP, JPEG, PNG, TIFF).
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(nomessage) EQ 0 THEN nomessage = 0
	IF N_ELEMENTS(alpha) EQ 0 THEN alpha = 0

	hash = self -> gethash()
	hash_general = self.general -> gethash()

	batch = getq (self.general, hash_general.batch)
	web = getq (self.general, hash_general.web)
	nom = getq (self, hash.nom)
	driver = getq (self, hash.driver)
	default_driver = getq (self, hash.default_driver)

	IF libplot_get(/D_NAME) EQ 'PS' OR libplot_get(/D_NAME) EQ 'PRINTER' OR libplot_get(/D_NAME) EQ 'PNG' THEN BEGIN

		; Signature: l'afficher uniquement dans les sorties Postscript
		IF ~batch AND ~is_su(/maxi) THEN BEGIN
			signature = get_signature (self.general)
			libplot_xyouts, 0.02, 0.5, signature, /normal, color=2, alignment=0.5, orientation=90, charsize=0.5 ; bleu au centre
		END 
		IF web THEN BEGIN
			;texte = 'Produced by CLWeb!CIRAP/UPS-CNRS/CNES'
			;libplot_xyouts, 0., 0.010, /norm, texte, color=2, alignment=0., orientation=0, Charsize=0.50 ; bleu  gauche
			IF is_gdl() THEN BEGIN
				IF alpha EQ 0 THEN BEGIN
					texte = 'Produced by CLWeb (with GDL)'
					libplot_xyouts, 0., 0.0025, texte, /normal, color=2, alignment=0., orientation=0, charsize=0.75 ; bleu  gauche
				END
			END ELSE IF is_fdl() THEN BEGIN
				IF alpha EQ 0 THEN BEGIN
					texte = 'Produced by CLWeb (with FDL)'
					libplot_xyouts, 0., 0.0025, texte, /normal, color=2, alignment=0., orientation=0, charsize=0.75 ; bleu  gauche
				END
			END ELSE BEGIN
				texte = 'Produced by CLWeb'
				libplot_xyouts, 0., 0., texte, /normal, color=2, alignment=0., orientation=0, charsize=0.75 ; bleu  gauche
			END
		END ELSE BEGIN
			IF is_gdl() THEN BEGIN
				libplot_plots, [0., 1, 1, 0, 0], [0., 0, 1, 1, 0], /normal, color=11 ; cadre blanc pour forcer Bounding Box
				texte = '(GDL)'
				libplot_xyouts, 0.00, 0.0025, texte, /normal, color=2, alignment=0., orientation=0, charsize=0.75 ; bleu bas/gauche
				libplot_xyouts, 1.00, 0.0025, texte, /normal, color=2, alignment=1., orientation=0, charsize=0.75 ; bleu bas/droite
				libplot_xyouts, 0.00, 0.99,   texte, /normal, color=2, alignment=0., orientation=0, charsize=0.75 ; bleu haut/gauche
				libplot_xyouts, 1.00, 0.99,   texte, /normal, color=2, alignment=1., orientation=0, charsize=0.75 ; bleu haut/droite
			END ELSE IF is_fdl() THEN BEGIN
				texte = !CL.libplot EQ '' ? '(FDL)' : ('(FDL plplot ' + driver + ')')
				libplot_xyouts, 0.00, 0.0025, texte, /normal, color=2, alignment=0., orientation=0, charsize=0.75 ; bleu bas/gauche
				libplot_xyouts, 1.00, 0.0025, texte, /normal, color=2, alignment=1., orientation=0, charsize=0.75 ; bleu bas/droite
				libplot_xyouts, 0.00, 0.99,   texte, /normal, color=2, alignment=0., orientation=0, charsize=0.75 ; bleu haut/gauche
				libplot_xyouts, 1.00, 0.99,   texte, /normal, color=2, alignment=1., orientation=0, charsize=0.75 ; bleu haut/droite
			END
		END
		IF libplot_get(/D_NAME) EQ 'PRINTER' THEN BEGIN
			libplot_device_printer, /close_document
		END ELSE IF libplot_get(/D_NAME) EQ 'PNG' THEN BEGIN
			libplot_device_png, /close_file
		END ELSE BEGIN
			libplot_device_ps, /close_file
		END
		IF driver NE 'printer' AND ~nomessage THEN cl_msg, self.general, str_bas=nom + ' has been created'
		libplot_set_plot, default_driver

	END ELSE IF driver EQ 'GIF' OR driver EQ 'BMP' OR driver EQ 'JPEG' OR driver EQ 'PNG' OR driver EQ 'TIFF' THEN BEGIN

		xsize = getq (self.general, hash_general.xsize)
		ysize = getq (self.general, hash_general.ysize)
		pal = getq (self.general, hash_general.pal)
		true = pal -> true(/nbcolors)
		image1 = TVRD (0,0,xsize,ysize,true=true)
		IF ~true THEN pal -> get_rvb, r, v, b
		IF driver EQ 'GIF' OR driver EQ 'BMP' OR driver EQ 'PNG' OR driver EQ 'TIFF' THEN BEGIN
			IF ~true THEN BEGIN
				image = image1
			END ELSE BEGIN
				image = COLOR_QUAN (image1[0,*,*], image1[1,*,*], image1[2,*,*], r,v,b,colors=getq(self,hash.gif_nbcolors))
				nb1 = N_ELEMENTS(image1[0,*,0])
				nb2 = N_ELEMENTS(image1[0,0,*])
				image = REFORM (image,nb1,nb2)
			END
			IF driver EQ 'GIF' THEN BEGIN
				WRITE_GIF, nom, image, r, v, b
			END ELSE IF driver EQ 'BMP' THEN BEGIN
				WRITE_BMP, nom, image, r, v, b
			END ELSE IF driver EQ 'PNG' THEN BEGIN
				WRITE_PNG, nom, image, r, v, b
			END ELSE IF driver EQ 'TIFF' THEN BEGIN
				ppi = getq (self,hash.tif_ppi)
				WRITE_TIFF, nom, REVERSE(ROTATE(image,2)), RED=r, GREEN=v, BLUE=b, XRESOL=ppi, YRESOL=ppi
			END
		END ELSE IF driver EQ 'JPEG' THEN BEGIN
			IF ~true THEN BEGIN
				image = REPLICATE (0b,3,xsize,ysize)
				image[0,*,*] = r[image1]
				image[1,*,*] = v[image1]
				image[2,*,*] = b[image1]
			END ELSE BEGIN
				image = image1
			END
			WRITE_JPEG, nom, image, TRUE=1, QUALITY=getq(self,hash.jpeg_quality)
		END
		cl_msg, self.general, str_bas=nom + ' has been created'

	END

END

;-------------------------------------------------------------------------------
FUNCTION device::init,	$
;-------------------------------------------------------------------------------
	nom,		$	; LINT_PROTOTYPE input
	driver,		$	; LINT_PROTOTYPE input
	general			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de la classe "device".
;-------------------------------------------------------------------------------

	param = [ $
		{ var_obj, '', 					'oldorientation', 	0, PTR_NEW(), 							'', 				PTR_NEW(), 	PTR_NEW('Portrait')		}, 	$
		{ var_obj, '', 					'driver', 		0, PTR_NEW(), 							'', 				PTR_NEW(), 	PTR_NEW(driver)			}, 	$
		{ var_obj, '', 					'default_driver', 	0, PTR_NEW(), 							'', 				PTR_NEW(), 	PTR_NEW(libplot_get(/D_name))	}, 	$
		{ var_obj, '', 					'nom', 			0, PTR_NEW(), 							'', 				PTR_NEW(), 	PTR_NEW(nom)			}, 	$
		{ var_obj, 'Device:Orientation',		'orientation',		1, PTR_NEW(['B1','2','LABEL_LEFT','Portrait','Landscape']),	'check_always_ok',		PTR_NEW(),	PTR_NEW('Portrait')		}, 	$
		{ var_obj, 'Reduction (0..1)', 			'rap', 			0, PTR_NEW(['FL', '2','12']), 					'check_supegal_infegal', 	PTR_NEW([0,1]), PTR_NEW(1.0d)			}, 	$
		{ var_obj, '  Left Margin (in cm)', 		'marge_gauche', 	1, PTR_NEW(['FL',  '0','12']), 					'check_supegal', 		PTR_NEW([0]), 	PTR_NEW(1.5d)			}, 	$
		{ var_obj, 'Right Margin (in cm)', 		'marge_droite', 	1, PTR_NEW(['FL',  '0','12']), 					'check_supegal', 		PTR_NEW([0]), 	PTR_NEW(1.5d)			}, 	$
		{ var_obj, 'Paper Length (in cm)', 		'long', 		1, PTR_NEW(['FL','2','12']), 					'check_sup', 			PTR_NEW([0]), 	PTR_NEW(29.7d)			}, 	$
		{ var_obj, 'Bottom Margin (in cm)', 		'marge_bas', 		1, PTR_NEW(['FL','0','12']), 					'check_supegal', 		PTR_NEW([0]), 	PTR_NEW(1.5d)			}, 	$
		{ var_obj, '  Top Margin (in cm)', 		'marge_haut', 		1, PTR_NEW(['FL',  '0','12']), 					'check_supegal', 		PTR_NEW([0]), 	PTR_NEW(1.5d)			}, 	$
		{ var_obj, ' Paper Width (in cm)', 		'larg', 		1, PTR_NEW(['FL', '2','12']), 					'check_sup', 			PTR_NEW([0]), 	PTR_NEW(21.0d)			}, 	$
		{ var_obj, '     JPEG Quality (100=excellent)', 'jpeg_quality', 	1, PTR_NEW(['SL','2','300','0','100']), 			'check_always_ok', 		PTR_NEW(), 	PTR_NEW(75)			}, 	$
		{ var_obj, '             GIF-BMP-PNG Nbcolors', 'gif_nbcolors', 	1, PTR_NEW(['SL','2','300','16','256']), 			'check_always_ok', 		PTR_NEW(), 	PTR_NEW(64)			}, 	$
		{ var_obj, '             TIFF pixels per inch', 'tif_ppi', 		1, PTR_NEW(['SL','2','300','100','600']), 			'check_always_ok', 		PTR_NEW(), 	PTR_NEW(600)			} 	$
	]

	code = self -> obj::init (1, -1, -1, param, general=general,/saisissable)

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO device__define
;-------------------------------------------------------------------------------
; La classe "device" hrite de "obj".
;-------------------------------------------------------------------------------

	lint_unused = { device, 	$

		INHERITS obj 		$

	}

END
