;-------------------------------------------------------------------------------
PRO demeter_burstx_to_burst4
;-------------------------------------------------------------------------------
;
; Cr pour chaque fichier BURSTX un fichier BURST4 en sommant les spectres 4 par 4 et les nergies 2 par 2.
;-------------------------------------------------------------------------------

	date1 = tu_to_date(2004,4,1,0,0,0)
	date2 = tu_to_date(2011,1,1,0,0,0)

	;date1 = tu_to_date(2008,7,1,0,0,0)
	;date2 = tu_to_date(2008,7,1,0,0,0)

	date = date1

	WHILE date LE date2 DO BEGIN

		date_to_tu,date,annee,mois,jour,heure,minutse,seconde
		YYYYMMDD = int_str_0(annee,2)+int_str_0(mois,2)+int_str_0(jour,2)

		nom1 = '/DATA/DEMETER/DATA/L2/'+YYYYMMDD+'/DEMETER_IDP_BURSTx_'+YYYYMMDD+'_V01.bin'

		IF fichier_existe(nom1) THEN BEGIN

			nom2 = './DATA/DEMETER/DATA/L2/'+YYYYMMDD+'/DEMETER_IDP_BURST4_'+YYYYMMDD+'_V01.bin'
			mkdir_p, dirname(nom2)

			print,nom1

			enreg1 = { date:0d, burst:0b, data:REPLICATE(0UL,256) }
			enreg2 = { date:0d, burst:0b, data:REPLICATE(0UL,128) }

			OPENR, fd1, nom1, /GET_LUN, /SWAP_IF_LITTLE_ENDIAN
			OPENW, fd2, nom2, /GET_LUN, /SWAP_IF_LITTLE_ENDIAN
			nb=0L
			WHILE NOT EOF(fd1) DO BEGIN
				READU, fd1, enreg1
				;PRINT, date_to_str(enreg1.date),enreg1.data
				IF nb MOD 4 EQ 0 THEN BEGIN
					enreg = enreg2
					enreg.date = enreg1.date
					enreg.burst = enreg1.burst
				END
				enreg.data += enreg1.data[2*LINDGEN(128)] + enreg1.data[1+2*LINDGEN(128)]

				; Patch trou de donnes > 4sec
				IF enreg1.date - enreg.date GT 4000 THEN BEGIN
					nb=0
					CONTINUE
				END

				IF nb MOD 4 EQ 3 THEN BEGIN
					WRITEU, fd2, enreg
					;PRINT, date_to_str(enreg1.date),enreg1.data[0:3]
				END
				nb++
			END

			FREE_LUN, fd1
			FREE_LUN, fd2

		END

		date += 86400000d

	END

END
