;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: cw_form_new.pro,v $, v $Revision: 1.25 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------

; $Id: cw_form_new.pro,v 1.25 2021/04/27 09:48:58 penou Exp $
;
; Copyright (c) 1995-1998, Research Systems, Inc.  All rights reserved.
;	Unauthorized reproduction prohibited.
;+
; NAME:
;	CW_FORM
;
; PURPOSE:
;	CW_FORM is a compound widget that simplifies creating
;	small forms which contain text, numeric fields, buttons, 
;	lists and droplists.  Event handling is also simplified.
;
; CATEGORY:
;	Compound widgets.
;
; CALLING SEQUENCE:
;	widget = CW_FORM([Parent,] Desc)
;
; INPUTS:
;       Parent:	The ID of the parent widget.  Omitted for a top level 
;		modal widget.

; Desc: A string array describing the form.  Each element of the
;	string array contains two or more comma-delimited fields.  The
;	character '\' may be used to escape commas that appear within fields.
;	To include the backslash character, escape it with a second
;	backslash.  Field names are case insensitive.
;
;	The fields are defined as follows:
;
; Field 1: Depth: the digit 0, 1, 2, or 3.  0 continues the current
;	level, 1 begins a new level, 2 denotes the last element of the
;	current level, and 3 both begins a new level and is the last entry of
;	the current level.  Nesting is used primarily with row or column 
;	bases for layout.  See the example below.
; Field 2: Item type: BASE, BUTTON, DROPLIST, FLOAT, INTEGER, LABEL, LIST,
;		or TEXT.
;	The items return the following value types:
;	BUTTON - For single buttons, 0 if clear, 1 if set.
;		For multiple buttons, also called button groups, that are
;		exclusive, the index of the currently set button is returned.
;		For non-exclusive button groups, the value is an array
;		with an element for each button, containing 1
;		if the button is set, 0 otherwise.
;	DROPLIST, LIST - a 0 based index indicating which item is selected.
;	FLOAT, INTEGER, TEXT - return their respective data type.
;
; Field 3: Initial value.  Omitted for bases.
;	For BUTTON and DROPLIST items, the value field contains one
;		or more item names, delimited by the | character.
;	For FLOAT, INTEGER, LABEL, and TEXT items the value field contains the
;		initial value of the field.
;
; Fields 4 and following: Keywords or Keyword=value pairs that specify
;	optional attributes or options.  Keywords are case insensitive
;	and an optional leading '/' character is discarded.
;	Possibilities include:
;
;	COLUMN	If present, specifies column layout for bases or multiple
;		buttons.
;	EXCLUSIVE  If present makes an exclusive set of buttons.  The
;		default is nonexclusive.
;	EVENT=<name> specifies the name of a user-written event function that
;		is called whenever the element is changed.  The function
;		is called with one parameter, the event structure.  It may
;		return an event structure or zero to indicate that no
;		further event processing is desired.
;	FONT=<font name>  If present, the font for the item is specified.
;	FRAME:	If present, a frame is drawn around the item.  May be used
;		with all items.
;	LABEL_LEFT=<label>  annotate a button or button group with a label
;		placed to the left of the buttons.  Valid with BUTTON,
;		DROPLIST, FLOAT, INTEGER, LIST and TEXT items.
;	LABEL_TOP=<label> annotate a button or button group with a label
;		placed at the top of the buttons.  Valid with BUTTON,
;		DROPLIST, FLOAT, INTEGER, LIST and TEXT items.
;	LEFT, CENTER, or RIGHT   Specifies alignment of label items.
;	QUIT	If present, when the user activiates this entry when it
;		is activated as a modal widget, the form is destroyed
;		and its value returned as the result of CW_FORM.  For non-
;		modal form widgets, events generated by changing this item
;		have their QUIT field set to 1.
;	ROW	If present, specifies row layout for bases or multiple
;		buttons.
;	SET_VALUE  Sets the initial value of button groups or droplists.
;	TAG=<name>   the tag name  of this element.  The widget's value
;		is a structure corresponding to the form.  Each form item
;		has a corresponding tag-value pair in the widget's value.
;		Default = TAGnnn, where nnn is the index of the item
;		in the Desc array.
;	WIDTH=n Specifies the width, in characters, of a TEXT, INTEGER,
;		or FLOAT item.
;	
; KEYWORD PARAMETERS:
;	COLUMN:		  If set the main orientation is vertical, otherwise
;			  horizontal.
;	IDS:		  A named variable into which the widget id of
;				each widget corresponding to an element
;				in desc is stored.
;	TITLE:		  The title of the top level base.  Not used
;			  if a parent widget is supplied.
;	UVALUE:		  The user value to be associated with the widget.
;
; OUTPUTS:
;       If Parent is supplied, the result is the ID of the base containing
;	the form.  If Parent is omitted, the form is realized as a modal
;	top level widget. The function result is then a structure containing
;	the value of each field in the form when the user finishes.
;
;	This widget has a value that is a structure with a tag/value pair
;	for each field in the form.  WIDGET_CONTROL, id, GET_VALUE=v may
;	be used to read the current value of the form.  WIDGET_CONTROL, id,
;	SET_VALUE={ Tagname: value, ..., Tagname: value} sets the values
;	of one or more tags.
;
; SIDE EFFECTS:
;	Widgets are created.
;
; RESTRICTIONS:
;	
; EXAMPLES:

;	**** Define a form, with a label, followed by two vertical button
;	groups one non-exclusive and the other exclusive, followed by a text
;	field, and an integer field, followed lastly by OK and Done buttons.
;	If either the OK or Done buttons are pressed, the form is exited.
;	
;
;		; String array describing the form
;	desc = [ $
;	    '0, LABEL, Centered Label, CENTER', $
;		; Define a row base on a new depth.  All elements until a depth
;		; of two are included in the row.
; 	    '1, BASE,, ROW, FRAME', $
; 	    '0, BUTTON, B1|B2|B3, LABEL_TOP=Nonexclusive:, COLUMN, ' + $
;               'TAG=bg1, ' + $
;               'SET_VALUE=[1\, 0\, 1]', $   ; set first and third buttons
;		; This element terminates the row.
; 	    '2, BUTTON, E1|E2|E2, EXCLUSIVE,LABEL_TOP=Exclusive,COLUMN, ' + $
;               'TAG=bg2, ' + $
;               'SET_VALUE=1', $   ; set second button
; 	    '0, TEXT, , LABEL_LEFT=Enter File name:, WIDTH=12, TAG=fname', $
;	    '0, INTEGER, 0, LABEL_LEFT=File size:, WIDTH=6, TAG=fsize', $
;	    '1, BASE,, ROW', $
;	    '0, BUTTON, OK, QUIT,FONT=*helvetica-medium-r-*-180-*,TAG=OK', $
;	    '2, BUTTON, Cancel, QUIT']
;
;    To use the form in a modal manner:
;	  a = CW_FORM(desc, /COLUMN)
;	  help, /st,a
;    When the form is exited, (when the user presses the OK or Cancel buttons), 
;	the following structure is returned as the function's value:
;		BG1             INT       Array(3)  (Set buttons = 1, else 0)
;		BG2             INT              1  (Exclusive: a single index)
;		FNAME           STRING    'test.dat' (text field)
;		FSIZE           LONG               120 (integer field)
;		OK              LONG                 1 (this button was pressed)
;		TAG8            LONG                 0 (this button wasn't)
;	Note that if the Cancel button is pressed, the widget is exited with
;	the OK field set to 0.
;
;  *****************
;
;    To use CW_FORM inside another widget:
;	    a = widget_base(title='Testing')
;	    b = cw_form(a, desc, /COLUMN)
;	    WIDGET_CONTROL, a, /real
;	    xmanager, 'Test', a
;	In this example, an event is generated each time the value of
;	the form is changed.  The event has the following structure:
;	   ID              LONG                <id of CW_FORM widget>
;	   TOP             LONG                <id of top-level widget>
;	   HANDLER         LONG                <internal use>
;	   TAG             STRING    'xxx'	; name of field that changed
;	   VALUE           INT       xxx	; new value of changed field
;	   QUIT            INT              0	; quit flag
;    The event handling procedure (in this example, called TEST_EVENT), may use
;	the TAG field of the event structure to determine which field
;	changed and perform any data validation or special actions required.
;	It can also get and set the value of the widget by calling
;	WIDGET_CONTROL.
;    A simple event procedure might be written to monitor the QUIT field
;	of events from the forms widget, and if set, read and save the
;	widget's value, and finally destroy the widget.
;
;    To set or change a field within the form from a program, use a the
;	WIDGET_CONTROL procedure:
;	   	WIDGET_CONTROL, b, SET_VALUE={FNAME: 'junk.dat'}
;	This statement sets the file name field of this example.
;
; MODIFICATION HISTORY:
;	January, 1995.  DMS, Written.
;       June, 1996.     MLR, allowed SET_VALUE to be specified in the
;                       description string for DROPLIST widgets.
;-
;


;-------------------------------------------------------------------------------
PRO developper_arbre,	$
;-------------------------------------------------------------------------------
	i0,	$	; LINT_PROTOTYPE input
	u		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Dveloppe dynamiquement une branche de l'arbre.
;
; Note: Window n'aime pas avoir des branches vides.
;-------------------------------------------------------------------------------

	COMMON	COMMON_TREE, arbre1, tab_tree

	;print,'developper_arbre,'+val_to_str(i0)+' ['+tab_tree[i0].label+']'
	IF tab_tree[i0].widget_id EQ 0 THEN BEGIN
		RETURN
	END

	IF ~tab_tree[i0].construit THEN BEGIN
		tab_tree[i0].construit = 1
		IF tab_tree[i0+1].no EQ 0 THEN BEGIN
			FOR i=i0+1,N_ELEMENTS(tab_tree)-1 DO BEGIN
				IF tab_tree[i].no EQ 0 THEN BEGIN
					;print,'feuille i='+val_to_str(i)
				
					IF is_windows() THEN BEGIN
						WIDGET_CONTROL, tab_tree[i0].widget_id, GET_UVALUE=tmp
						bug = tmp.bug
						IF bug NE -1 THEN BEGIN
							tmp.bug = -1
							; Supprimer bug
							WIDGET_CONTROL, bug, /DESTROY
							WIDGET_CONTROL, tab_tree[i0].widget_id, SET_UVALUE=tmp
						END
						tab_tree[i].widget_id = WIDGET_TREE(tab_tree[i0].widget_id,VALUE=tab_tree[i].label, UVALUE=u)
					END ELSE BEGIN
						tab_tree[i].widget_id = WIDGET_TREE(tab_tree[i0].widget_id,VALUE=tab_tree[i].label, UVALUE=u)
					END
				END ELSE BEGIN
					BREAK
				END
			END
		END ELSE BEGIN
			FOR i=i0+1,N_ELEMENTS(tab_tree)-1 DO BEGIN
				IF tab_tree[i].no EQ 0 THEN BEGIN
				END ELSE IF tab_tree[i].no EQ tab_tree[i0].no+1 THEN BEGIN

					IF is_windows() THEN BEGIN
						WIDGET_CONTROL, tab_tree[i0].widget_id, GET_UVALUE=tmp
						bug = tmp.bug
						IF bug NE -1 THEN BEGIN
							tmp.bug = -1
							; Supprimer bug
							WIDGET_CONTROL, bug, /DESTROY
							WIDGET_CONTROL, tab_tree[i0].widget_id, SET_UVALUE=tmp
						END
						tab_tree[i].widget_id = WIDGET_TREE(tab_tree[i0].widget_id,VALUE=tab_tree[i].label, /FOLDER, EXPANDED=tab_tree[i].expand, UVALUE=u)
						WIDGET_CONTROL, tab_tree[i].widget_id, GET_UVALUE=tmp
						bug = WIDGET_TREE (tab_tree[i].widget_id, VALUE='')
						tmp.bug = bug
						WIDGET_CONTROL, tab_tree[i].widget_id, SET_UVALUE=tmp
					END ELSE BEGIN
						tab_tree[i].widget_id = WIDGET_TREE(tab_tree[i0].widget_id,VALUE=tab_tree[i].label, /FOLDER, EXPANDED=tab_tree[i].expand, UVALUE=u)
					END

					IF tab_tree[i].expand THEN developper_arbre, i, u
				END ELSE IF tab_tree[i].no LE tab_tree[i0].no+1 THEN BEGIN
					BREAK
				END
			END
		END
		
	END

END

;-------------------------------------------------------------------------------
FUNCTION cw_form_event,	$
;-------------------------------------------------------------------------------
	ev	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Event handler for CW_FORM
;-------------------------------------------------------------------------------

	COMMON	COMMON_TREE, arbre1, tab_tree

	;WIDGET_CONTROL,   ev.id, GET_UVALUE=u, /NO_COPY  ;What kind of widget?

	; pas de /NO_COPY sinon on perd la valeur de UVALUE!!!
	WIDGET_CONTROL,   ev.id, GET_UVALUE=u  ;What kind of widget?

	IF TAG_NAMES(ev,/STRUCTURE_NAME) EQ 'WIDGET_TREE_EXPAND' THEN BEGIN

		i0 = (WHERE (tab_tree.widget_id EQ ev.id))[0]
		;print,'expand '+tab_tree[i0].label
		tab_tree[i0].expand = 1 - tab_tree[i0].expand
		developper_arbre, i0, u
		RETURN,1

	END

	IF TAG_NAMES(ev,/STRUCTURE_NAME) EQ 'WIDGET_TREE_SEL' THEN BEGIN

		i0 = (WHERE (tab_tree.widget_id EQ ev.id))[0]
		IF tab_tree[i0].no EQ 0 THEN BEGIN	
			; une feuille
			tab_tree[i0].select = 1 - tab_tree[i0].select
			WIDGET_CONTROL, ev.id, GET_VALUE=xxx
			IF STRMID(xxx,0,5) EQ '---> ' THEN BEGIN
				xxx = STRMID(xxx[0],5,STRLEN(xxx)-10)
			END ELSE BEGIN
				xxx = '---> '+xxx+' <---'
			END
			WIDGET_CONTROL, ev.id, SET_VALUE=xxx	; pour mettre  jour l'affichage

			WIDGET_CONTROL, u.arbre, GET_UVALUE=xxx
			xxx.value = tab_tree.select
			WIDGET_CONTROL, u.arbre, SET_UVALUE=xxx	; pour mettre  jour la liste des slections dans l'arbre
		END ELSE BEGIN
			IF is_gdl() THEN BEGIN
				; une branche
				;print,'expand '+tab_tree[i0].label
				tab_tree[i0].expand = 1 - tab_tree[i0].expand
				developper_arbre, i0, u
				RETURN,1
			END
		END
		RETURN,1

	END

	IF (u.type EQ 1) OR (u.type EQ 6) OR (u.type EQ 9) THEN BEGIN	;Droplist?  (can't get value)
		v = ev.index
		u.value = v
	END ELSE IF u.type EQ 2 THEN BEGIN
		v = ev.select
		u.value = v
	END ELSE IF u.type EQ 7 THEN BEGIN ; PENOU: slider
		v = ev.value
		u.value = v
	END ELSE IF u.type EQ 8 THEN BEGIN ; PENOU: LIST multiple
		select = WIDGET_INFO (ev.id,/LIST_SELECT)
		v = u.value
		u.value[*]=0
		IF select[0] NE -1 THEN u.value[select]=1
	END ELSE IF u.type EQ 10 THEN BEGIN ; PENOU: tree

	END ELSE BEGIN		;Other types of widgets
		WIDGET_CONTROL, ev.id, GET_VALUE=v
		IF u.type GE 3 THEN BEGIN  ;Toss selection events from text widgets
			v = v[0]
			ret = 0
			IF ev.type EQ 3 THEN GOTO, toss
		END
		ON_IOERROR, invalid
		u.value = v			;Does an implicit conversion
		v = u.value
		GOTO, back_in

		; We come here if we get an invalid number.  
invalid: 	WIDGET_CONTROL, ev.id, SET_VALUE=''  ;Blank it out
		v = ''
		u.value = ''
	END			;u.type

back_in:
	ret = { id:u.base, top:ev.top, handler: 0L, tag:u.tag, value: v, quit:u.quit } ;Our value
toss: 
	WIDGET_CONTROL, ev.id, SET_UVALUE=u, /NO_COPY	;Save new value...

	RETURN, ret

END			;CW_FORM_EVENT


;-------------------------------------------------------------------------------
FUNCTION cw_form_parse,	$
;-------------------------------------------------------------------------------
	Extra,	$	; LINT_PROTOTYPE input
	Name,	$	; LINT_PROTOTYPE input
	Value		; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Given the extra fields in the string array Extra,
;	determine if one field starts with Name.
; If so, return TRUE, otherwise FALSE.
; If the field contains the character '=' after Name, return the contents
; of the field following the equal sign in Value.
; Return the index of the found element in Index.
;-------------------------------------------------------------------------------

	found = WHERE(STRPOS(Extra, Name) EQ 0, count)
	IF count EQ 0 THEN RETURN, 0
	IF count GT 1 THEN MESSAGE,'Ambiguous field name: '+Name, /CONTINUE

	index = found[0]
	item = Extra[index]
	nlen = STRLEN(Name)
	Value = ''			;Assume no value
	equal = STRPOS(item,'=',nlen) ;Find = character

	IF equal GE 0 THEN Value = STRMID(item, equal+1, STRLEN(item)-(equal+1))

	Extra[index] = ''			;clean it out...

	RETURN, 1

END


;-------------------------------------------------------------------------------
PRO cw_form_append,	$
;-------------------------------------------------------------------------------
	extra,			$	; LINT_PROTOTYPE input
	e,			$	; LINT_PROTOTYPE input
	keyword,		$	; LINT_PROTOTYPE input
	USE_VALUE=use_value,	$	; LINT_PROTOTYPE input
	ACTUAL_KEYWORD=akw		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Utilis en interne (pas de doc dans la routine IDL "cw_form.pro").
;-------------------------------------------------------------------------------

	IF cw_form_parse(e, keyword, value) THEN BEGIN
		IF N_ELEMENTS(akw)		LE 0 THEN akw = keyword
		IF KEYWORD_SET(use_value)	EQ 0 THEN value = 1
		IF N_ELEMENTS(extra)		EQ 0 THEN BEGIN
			extra = CREATE_STRUCT(akw, value)
		END ELSE BEGIN
			extra = CREATE_STRUCT(extra, akw, value)
		END
	END

END



;-------------------------------------------------------------------------------
PRO cw_form_label,	$
;-------------------------------------------------------------------------------
	parent,		$	; LINT_PROTOTYPE input
	nparent,	$	; LINT_PROTOTYPE output
	e,		$	; LINT_PROTOTYPE input
	frame			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Put LABEL_LEFT and/or LABEL_RIGHT on a base.
;-------------------------------------------------------------------------------

	nparent = parent
	IF cw_form_parse(e, 'LABEL_LEFT', value) THEN BEGIN
		nparent = WIDGET_BASE(nparent, /ROW, FRAME=frame) & IF !VERSION.RELEASE GE 6.1 THEN WIDGET_CONTROL, nparent, TAB_MODE=1
		frame = 0
		lint_unused = WIDGET_LABEL(nparent, VALUE=value)
	END
	IF cw_form_parse(e, 'LABEL_TOP', value) THEN BEGIN
		nparent = WIDGET_BASE(nparent, /COLUMN, FRAME=frame) & IF !VERSION.RELEASE GE 6.1 THEN WIDGET_CONTROL, nparent, TAB_MODE=1
		frame = 0
		lint_unused = WIDGET_LABEL(nparent, VALUE=value)
	END
END


;-------------------------------------------------------------------------------
FUNCTION rajouter_arbre,	$
;-------------------------------------------------------------------------------
	nparent,	$	; LINT_PROTOTYPE input
	width,		$	; LINT_PROTOTYPE input
	height,		$	; LINT_PROTOTYPE input
	type			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ajoute un widget de type arbre.
;-------------------------------------------------------------------------------

	COMMON	COMMON_TREE, arbre1, tab_tree

	tab_tree[*].widget_id = 0
	tab_tree[*].construit = 0
	tab_tree[*].select = 0

	new = WIDGET_TREE(nparent,XSIZE=width,YSIZE=height)

	U = { type:type, arbre:new, bug:-1L }
	FOR i=0L,N_ELEMENTS(tab_tree)-1 DO BEGIN
		IF tab_tree[i].no EQ 1 THEN BEGIN

			; branche
			tab_tree[i].widget_id = WIDGET_TREE(new,VALUE=tab_tree[i].label, UVALUE=U, /FOLDER, EXPANDED=tab_tree[i].expand)

			IF is_windows() THEN BEGIN
				WIDGET_CONTROL, tab_tree[i].widget_id, GET_UVALUE=tmp
				WIDGET_CONTROL, tab_tree[i].widget_id, GET_VALUE=tmpv
				bug = WIDGET_TREE (tab_tree[i].widget_id,VALUE='')
				;xxx=dialog_message('CREATION bug='+val_to_str(bug)+' branche '+val_to_str(tab_tree[i].widget_id)+' '+tmpv+' tmp.bug='+val_to_str(tmp.bug))
				tmp.bug = bug
				WIDGET_CONTROL, tab_tree[i].widget_id, SET_UVALUE=tmp
			END
			
		END
	END

	; Ne dvelopper que les branches indispensables
	ind = WHERE (tab_tree.expand EQ 1)

	IF ind[0] NE -1 THEN BEGIN
		FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
			developper_arbre, ind[i], U
		END
	END

	RETURN, new

END

;-------------------------------------------------------------------------------
PRO cw_form_build,	$
;-------------------------------------------------------------------------------
	parent,		$	; LINT_PROTOTYPE input
	desc,		$	; LINT_PROTOTYPE input
	cur,		$	; LINT_PROTOTYPE input
	ids,		$	; LINT_PROTOTYPE input
	lasttag,	$	; LINT_PROTOTYPE input
	CANCEL,		$	; LINT_PROTOTYPE output
	OK			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Recursive routine that builds the form hierarchy described in DESC.
; Returns the ID of each button in ids.
;
; Format of a field descriptor:
; Field 0,  Flags: 
; Field 1, Type of item.  BASE, LABEL, INTEGER, FLOAT, DROPLIST,
;	EXCLUSIVE_BUTTONS, TEXT
; Field 2, Value of item...
; Fields >= 3, optional flags
;
;
; Type id = 0 for bgroup, 1 for droplist, 2 for button,
;	3 for integer, 4 for float, 5 for text, 6 for list.
;-------------------------------------------------------------------------------

	COMMON	COMMON_TREE, arbre1, tab_tree

	n = N_ELEMENTS(desc)
	SEP1 = ','
	SEP2 = STRING(1b)

	WHILE cur LT n DO BEGIN

		a = my_strsplit(desc[cur], SEP1, /TRIM, ESC=STRING(2b))

		IF N_ELEMENTS(a) LT 2 THEN BEGIN
			MESSAGE,'Form element '+STRTRIM(cur,2)+'is missing a field separator'
		END

		extra = 0				;Clear extra keywords by making it undefined
		lint_unused = TEMPORARY(extra)		;Clear common param list
		type = -1				;Assume type == no events.
		quit = 0
		frame = 0
		IF N_ELEMENTS(a) GT 3 THEN BEGIN	;Addt'l common params?
			e = a[3:*]		;Remove leading/trailing blanks
			FOR i=0L, N_ELEMENTS(e)-1 DO BEGIN  ;Up case it
				s = e[i]
				IF STRMID(s,0,1) EQ '/' THEN s = STRMID(s,1,1000)  ;Disc. leading /
				equal = STRPOS(s, '=')
				e[i] = equal GT 0 ? (STRUPCASE(STRMID(s,0,equal)) + STRMID(s,equal,STRLEN(s)-equal)) : STRUPCASE(s)
			END
			quit  = cw_form_parse(e, 'QUIT', tmplint)
			frame = cw_form_parse(e, 'FRAME', tmplint)
			efn   = cw_form_parse(e, 'EVENT', event_fun)
			cw_form_append, extra, e, 'FONT', /USE_VALUE
			cw_form_append, extra, e, 'SENSITIVE', /USE_VALUE
			cw_form_append, extra, e, 'COLUMN'
			cw_form_append, extra, e, 'ROW'
			cw_form_append, extra, e, 'LEFT', ACTUAL_KEYWORD='ALIGN_LEFT'
			cw_form_append, extra, e, 'CENTER', ACTUAL_KEYWORD='ALIGN_CENTER'
			cw_form_append, extra, e, 'RIGHT', ACTUAL_KEYWORD='ALIGN_RIGHT'
		END ELSE BEGIN
			e = ''
		END

		CASE STRUPCASE(a[1]) OF		;Which widget type?

		'BASE':		BEGIN
					new = WIDGET_BASE(parent, FRAME=frame, _EXTRA=extra) & IF !VERSION.RELEASE GE 6.1 THEN WIDGET_CONTROL, new, TAB_MODE=1
				END

		'BUTTON':	BEGIN
					cw_form_append, extra, e, 'LABEL_LEFT', /USE_VALUE
					cw_form_append, extra, e, 'LABEL_TOP', /USE_VALUE
					exclusive = cw_form_parse(e,'EXCLUSIVE',tmplint)
					no_release = cw_form_parse(e,'NO_RELEASE',tmplint)
					values = my_strsplit(a[2],SEP2)
					IF N_ELEMENTS(values) GE 2 THEN BEGIN
						type = 0
						IF cw_form_parse(e, 'SET_VALUE', temp) THEN BEGIN
							sval = ~exclusive ? LONG(my_strsplit(temp,SEP2)) : LONG(temp)
							new = CW_BGROUP(parent, values, 		 				$
									EXCLUSIVE=exclusive, NONEXCLUSIVE=1-exclusive, 			$
									FRAME=frame, NO_RELEASE=no_release,  SET_VALUE=sval, _EXTRA=extra)
						END ELSE BEGIN
							new = CW_BGROUP(parent, values, 		 		$
									EXCLUSIVE=exclusive, NONEXCLUSIVE=1-exclusive, 	$
									FRAME=frame, NO_RELEASE=no_release, _EXTRA=extra)
						END
						WIDGET_CONTROL, new, GET_VALUE=value
					END ELSE BEGIN
						type = 2
						IF values[0] EQ 'Ok' AND !VERSION.RELEASE GE 6.3 THEN BEGIN
							new = WIDGET_BUTTON(parent, value=values[0], FRAME=frame, _EXTRA=extra, ACCELERATOR="Return")
						END ELSE IF values[0] EQ 'Cancel' AND !VERSION.RELEASE GE 6.3 THEN BEGIN
							new = WIDGET_BUTTON(parent, value=values[0], FRAME=frame, _EXTRA=extra, ACCELERATOR="Escape")
						END ELSE BEGIN
							new = WIDGET_BUTTON(parent, value=values[0], FRAME=frame, _EXTRA=extra)
						END
						IF values[0] EQ 'Cancel' THEN CANCEL = new
						IF values[0] EQ 'Ok' THEN OK = new
						value = 0L
					END 
					uextra = { value: value }
				END

		'DROPLIST':	BEGIN
					cw_form_label, parent, nparent, e, frame
					values = my_strsplit(a[2], SEP2)
					new = WIDGET_DROPLIST(nparent, VALUE=values, FRAME=frame, UVALUE=ids[n], _EXTRA=extra)
					IF cw_form_parse(e, 'SET_VALUE', value) THEN BEGIN
						WIDGET_CONTROL, new, SET_DROPLIST_SELECT=value
					END
					uextra = { VALUE: value }
					type = 1
				END

		'COMBOBOX':	BEGIN
					cw_form_label, parent, nparent, e, frame
					values = my_strsplit(a[2], SEP2)
					new = WIDGET_COMBOBOX(nparent, VALUE=values, FRAME=frame, UVALUE=ids[n], _EXTRA=extra)
					IF cw_form_parse(e, 'SET_VALUE', value) THEN WIDGET_CONTROL, new, SET_COMBOBOX_SELECT=value
					uextra = { VALUE: value }
					type = 9
				END

		'SLIDER':	BEGIN
					type = 7
					value = 0L
					uextra = { VALUE: value }    
					cw_form_label, parent, nparent, e, frame
					xsize = cw_form_parse(e, 'XSIZE', temp) ? LONG(temp) : 100
					mini = cw_form_parse(e, 'MINIMUM', temp) ? LONG(temp) : 0
					maxi = cw_form_parse(e, 'MAXIMUM', temp) ? LONG(temp) : 100
					new = WIDGET_SLIDER(nparent, value=a[2], UVALUE=ids[n], MINIMUM=mini, MAXIMUM=maxi,XSIZE=xsize,FRAME=frame,_EXTRA=extra)
					IF N_ELEMENTS(a) GE 3 THEN BEGIN		;Save value
						WIDGET_CONTROL, new, SET_VALUE=a[2]
						uextra.value = a[2]
					END
				END

		'INTEGER':	BEGIN
					type = 3
					value = 0L
process_integer:
					uextra = { VALUE: value }    
					cw_form_label, parent, nparent, e, frame
					width = cw_form_parse(e, 'WIDTH', temp) ? LONG(temp) : 6
					s = a[2]
					tabs = STRSPLIT (s,STRING(10b), /EXTRACT)
					IF width EQ 0 THEN BEGIN
						new = WIDGET_LABEL(parent, value=a[2], FRAME=frame, _EXTRA=extra)
					END ELSE BEGIN

						; Gestion des textes multiples dans a[2]: 'toto'+STRING(3b)'tata'+...
						tmp = ''
						IF N_ELEMENTS(a) GE 3 THEN BEGIN		;Save value
							tmp = STRSPLIT(a[2],STRING(3b), /EXTRACT, /PRESERVE_NULL)
						END
						IF N_ELEMENTS(tmp) NE 1 THEN BEGIN
							new = WIDGET_TEXT(nparent, /ALL_EVENTS, EDITABLE=N_ELEMENTS(tabs) EQ 1,$
								YSIZE=N_ELEMENTS(tmp)-1 LE 10 ? N_ELEMENTS(tmp)-1 : 10, $
								SCROLL=0, $
								XSIZE=MAX(STRLEN(tmp))+5, UVALUE=ids[n], VALUE=tmp, _EXTRA=extra)
						END ELSE BEGIN
							new = WIDGET_TEXT(nparent, /ALL_EVENTS, EDITABLE=N_ELEMENTS(tabs) EQ 1,$
								YSIZE=N_ELEMENTS(tabs), $
								SCROLL=0, $
								XSIZE=width, UVALUE=ids[n], _EXTRA=extra)
							IF N_ELEMENTS(a) GE 3 THEN BEGIN		;Save value
								WIDGET_CONTROL, new, SET_VALUE=tabs
								uextra.value = a[2]
							END
						END
					END
				END

		'FLOAT':	BEGIN
					type = 4
					value = 0.0
					GOTO, process_integer
				END

		'LABEL':	BEGIN
					new = WIDGET_LABEL(parent, value=a[2], FRAME=frame, _EXTRA=extra)
				END

		'LIST':		BEGIN
					cw_form_label, parent, nparent, e, frame
					multiple = cw_form_parse(e,'MULTIPLE',tmplint)
					texte = a[2] & IF STRMID(texte,0,1) EQ '\' THEN texte = STRMID(texte,1,STRLEN(texte)-1)
					v = my_strsplit(texte, SEP2)
					IF cw_form_parse(e, 'HEIGHT', temp) EQ 0 THEN temp = N_ELEMENTS(v)
					temp = MIN([temp,N_ELEMENTS(v)])
					new = WIDGET_LIST(nparent, VALUE=v, YSIZE=temp, MULTIPLE=multiple, FRAME=frame, UVALUE=ids[n], _EXTRA=extra)
					IF cw_form_parse(e, 'SET_VALUE', temp) THEN BEGIN
						IF multiple THEN BEGIN
							sval = LONG(my_strsplit(temp,SEP2)) 
							ind = WHERE (sval EQ 1)
							IF is_gdl() THEN BEGIN ; ok
								; sinon "% WIDGET_CONTROL: Expression must be a scalar or 1 element array in this context"
								; ind ne peut pas tre une liste dans GDL ! (arrive dans les listes  choix multiples)
								WIDGET_CONTROL, new, SET_LIST_SELECT=ind[0]
							END ELSE BEGIN
								WIDGET_CONTROL, new, SET_LIST_SELECT=ind
							END
							value = sval
							type = 8
						END ELSE BEGIN
							sval = LONG(temp)
							IF is_fdl() THEN BEGIN
								; sinon % Error: WIDGET_CONTROL: keyword not allowed: SET_LIST_SELECT
							END ELSE BEGIN
								WIDGET_CONTROL, new, SET_LIST_SELECT=sval
							END
							type = 6
							value = sval
						END
					END
					v = 0
					uextra = { value: value }
				END

		'TEXT':		BEGIN
					type = 5
					value = ''
					GOTO, process_integer
				END

		'TREE':		BEGIN
					type = 10
					cw_form_label, parent, nparent, e, frame
					width = cw_form_parse(e, 'WIDTH', temp) ? LONG(temp) : 6
					height = cw_form_parse(e, 'HEIGHT', temp) ? LONG(temp) : 6
					texte = a[2] & IF STRMID(texte,0,1) EQ '\' THEN texte = STRMID(texte,1,STRLEN(texte)-1)
					value = REPLICATE (0,N_ELEMENTS(arbre1))
					uextra = { VALUE: value }    
					new = rajouter_arbre (nparent,width,height,type)
				END

		ELSE:		BEGIN
					MESSAGE,'Illegal form element type: ' + a[1], /CONTINUE
					new = WIDGET_BASE(parent) & IF !VERSION.RELEASE GE 6.1 THEN WIDGET_CONTROL, new, TAB_MODE=1
				END

		END

		ids[cur] = new
		IF type GE 0 THEN BEGIN
			value = cw_form_parse(e, 'TAG', value) ? STRUPCASE(value) : ('TAG'+STRTRIM(cur,2))	  ;default name = TAGnnn.
			u = CREATE_STRUCT( { type:type, base:ids[n+1], tag:value, next: 0L, quit:quit }, uextra)
			WIDGET_CONTROL, new, SET_UVALUE=u

			;First tag?  If so, set child uvalue -> important widget ids.
			IF lasttag EQ 0 THEN BEGIN
				WIDGET_CONTROL, ids[n], GET_UVALUE=tmp, /NO_COPY
				tmp.head = new
				WIDGET_CONTROL, ids[n], SET_UVALUE=tmp, /NO_COPY
			END ELSE BEGIN		;Otherwise, update chain.
				WIDGET_CONTROL, lasttag, GET_UVALUE=u, /NO_COPY
				u.next = new
				WIDGET_CONTROL, lasttag, SET_UVALUE=u, /NO_COPY
			END
			lasttag = new
			IF (N_ELEMENTS(efn) NE 0) AND (N_ELEMENTS(event_fun) NE 0) THEN WIDGET_CONTROL, new, EVENT_FUNC=event_fun
		END			;Type

		i = WHERE(STRLEN(e) GT 0, count)
		IF count GT 0 THEN BEGIN	;Unrecognized fields?
			MESSAGE, /CONTINUE, 'Descriptor: '+ desc[cur]
			FOR j=0L, count-1 DO MESSAGE, /CONTINUE, 'Unrecognized field: '+ e[i[j]]
		END

		cur++
		dflags = LONG(a[0])		;Level flags
		IF dflags AND 1 THEN cw_form_build, new, desc, cur, ids, lasttag,CANCEL,OK  ;Begin new
		IF (dflags AND 2) NE 0 THEN RETURN	;End current
	END

END				;CW_FORM_BUILD


;-------------------------------------------------------------------------------
PRO cw_form_setv,	$
;-------------------------------------------------------------------------------
	id,	$	; LINT_PROTOTYPE input
	value		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Je ne sais pas quand cette routine est appelle.
;
;In this case, value = { Tagname : value, ... }
;-------------------------------------------------------------------------------

	x = WIDGET_INFO(id, /CHILD)	;Get head of list
	WIDGET_CONTROL, x, GET_UVALUE=u
	head = u.head
	tags = TAG_NAMES(value)
	n = N_ELEMENTS(tags)

	WHILE head NE 0 DO BEGIN
		WIDGET_CONTROL, head, GET_UVALUE=u, /NO_COPY
		w = WHERE(u.tag EQ tags, count)
		IF count NE 0 THEN BEGIN
			u.value = value.(w[0])	;Set the value
			IF u.type EQ 6 THEN BEGIN
				WIDGET_CONTROL, head, SET_LIST_SELECT=value.(w[0])
			END ELSE IF u.type EQ 1 THEN BEGIN
				WIDGET_CONTROL, head, SET_DROPLIST_SELECT=value.(w[0])
			END ELSE IF u.type EQ 9 THEN BEGIN
				WIDGET_CONTROL, head, SET_COMBOBOX_SELECT=value.(w[0])
			END ELSE IF u.type NE 2 THEN BEGIN
				WIDGET_CONTROL, head, SET_VALUE=value.(w[0]) ;Change the widget
			END
			n--
			next = u.next
			WIDGET_CONTROL, head, SET_UVALUE=u, /NO_COPY
			IF n LE 0 THEN RETURN		;Done...
			head = next
		END
	END

END


;-------------------------------------------------------------------------------
FUNCTION cw_form_getv,	$
;-------------------------------------------------------------------------------
	id	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne  la fin une structure avec la valeur de chaque petit widget.
;
; Return value of a CW_FORM widget.
;-------------------------------------------------------------------------------
; LINT_VARIABLES ret

	x = WIDGET_INFO(id, /CHILD)	;Get head of list
	WIDGET_CONTROL, x, GET_UVALUE=u
	head = u.head

	WHILE head NE 0 DO BEGIN
		WIDGET_CONTROL, head, GET_UVALUE=u, /NO_COPY
		IF N_ELEMENTS(ret) LE 0 THEN BEGIN
			ret = CREATE_STRUCT (u.tag, u.value)
		END ELSE BEGIN
			ret = CREATE_STRUCT (ret, u.tag, u.value)
		END
		next = u.next
		WIDGET_CONTROL, head, SET_UVALUE=u, /NO_COPY
		head = next
	END

	RETURN, ret

END


;-------------------------------------------------------------------------------
PRO cw_form_modal_event,	$
;-------------------------------------------------------------------------------
	ev	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Appell chaque fois que l'on modifie un petit widget.
;-------------------------------------------------------------------------------

	IF ev.quit NE 0 THEN BEGIN
		child = WIDGET_INFO(ev.id, /CHILD)
		WIDGET_CONTROL, child, GET_UVALUE=u  ;Get handle
		WIDGET_CONTROL, ev.id, GET_VALUE=v  ;The widget's value
		WIDGET_CONTROL, ev.top, /DESTROY
		*u.handle = v
	END

END


;-------------------------------------------------------------------------------
FUNCTION cw_form_new,	$
;-------------------------------------------------------------------------------
	desc,		$	; LINT_PROTOTYPE input
	COLUMN=column,	$	; LINT_PROTOTYPE input
	TITLE=title,	$	; LINT_PROTOTYPE input
	BLOQUE=BLOQUE		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Routine cw_forw d'IDL que j'ai modifi pour mes formulaires.
;
; Retourne une structure si OK, -1 sinon.
;-------------------------------------------------------------------------------
;  ON_ERROR, 2						;return to caller
; Set default values for the keywords

	IF KEYWORD_SET(column) THEN row = 0 ELSE BEGIN row = 1 & column = 0 & END

	IF N_ELEMENTS(BLOQUE) EQ 0 THEN BLOQUE = 0
	handle = 0L
	IF N_ELEMENTS(title) LE 0 THEN title = 'FORM Widget'

	temp = WIDGET_BASE()
	IF !VERSION.RELEASE GE 6.1 THEN WIDGET_CONTROL, temp, TAB_MODE=1

	p = WIDGET_BASE(TITLE=title, Column=column, row=row, GROUP_LEADER=temp, MODAL=BLOQUE)
	IF !VERSION.RELEASE GE 6.1 THEN WIDGET_CONTROL, p, TAB_MODE=1

	handle = PTR_NEW(/ALLOCATE_HEAP)
	base = WIDGET_BASE(p, Column=column, row=row)
	IF !VERSION.RELEASE GE 6.1 THEN WIDGET_CONTROL, base, TAB_MODE=1

	n = N_ELEMENTS(desc)
	ids = LONARR(n+2)		;Element n is ^ to child, n+1 ^ to base
	child = WIDGET_BASE(base)
	IF !VERSION.RELEASE GE 6.1 THEN WIDGET_CONTROL, child, TAB_MODE=1 ;Widget to contain info...
	ids[n] = child
	ids[n+1] = base
	lasttag = 0
	WIDGET_CONTROL, child, SET_UVALUE={ head: 0L, base: base, handle: handle }

	cw_form_build, base, desc, 0, ids, lasttag, CANCEL, OK
	IF is_gdl() THEN BEGIN ; ok
		; sinon % WIDGET_CONTROL: Keyword parameter <CANCEL_BUTTON> not allowed in call to: WIDGET_CONTROL
	END ELSE IF is_fdl() THEN BEGIN
		; sinon % Error: WIDGET_CONTROL: keyword not allowed: CANCEL_BUTTON
	END ELSE BEGIN
		WIDGET_CONTROL, p, CANCEL_BUTTON=CANCEL, DEFAULT_BUTTON=OK
	END
	WIDGET_CONTROL, base, EVENT_FUNC='cw_form_event', FUNC_GET_VALUE='cw_form_getv', PRO_SET_VALUE='cw_form_setv'

	WIDGET_CONTROL, p, /realize

bug_gdl:
	XMANAGER, 'cw_form', p, EVENT_HANDLER='cw_form_modal_event', JUST_REG=1-BLOQUE

	IF N_ELEMENTS(*handle) NE 0 THEN BEGIN
		v = TEMPORARY(*handle)
		PTR_FREE, handle
	END ELSE BEGIN
		; Le widget a t detruit: on retourne -1
		; Ca n'arrive plus avec IDL 6.3 ?
		v = -1
		IF is_gdl() THEN BEGIN ; ok
			; sinon les widgets s'affichent puis se dtruisent desuite
			GOTO, bug_gdl
		END
		IF is_fdl() THEN BEGIN ; ok
			; sinon les widgets s'affichent puis se dtruisent desuite
			GOTO, bug_gdl
		END
	END

	IF BLOQUE THEN BEGIN
		IF is_fdl() THEN BEGIN
			; sinon % Error: WIDGET_CONTROL: not implemented yet: subwindow destroy
		END ELSE BEGIN
			WIDGET_CONTROL, temp, /DESTROY
		END
	END

	RETURN, v

END
