;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: courbe__define.pro,v $, v $Revision: 1.20 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO courbe::courbe_setproperty, $
;-------------------------------------------------------------------------------
	dttrou = dttrou	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Pour changer la proprit dttrou.
;-------------------------------------------------------------------------------

	IF N_ELEMENTS (dttrou) NE 0 THEN self.dttrou = dttrou

END


;-------------------------------------------------------------------------------
PRO courbe::courbe_ajouter,	$
;-------------------------------------------------------------------------------
	tabx,			$	; LINT_PROTOTYPE input
	taby,			$	; LINT_PROTOTYPE input
	axetemps=axetemps		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ajoute ou rajoute une courbe dfinie par (tabx,taby).
; axetemps avut 1 par dfaut.
;-------------------------------------------------------------------------------

	; Les DOUBLE(tabx) et FLOAT(taby) ne sont pas toujours ncessaires.
	; Mais la routine met dans les 1e-5 secondes alors c'est pas grave!

	IF N_ELEMENTS(axetemps) EQ 0 THEN axetemps = 1

	IF PTR_VALID(self.datax) THEN BEGIN

		nb1 = N_ELEMENTS(*self.datax)
		nb2 = N_ELEMENTS(tabx)
		nb3  = nb1 + nb2
		tabx3 = REPLICATE (0d,nb3)
		IF is_string(taby) THEN BEGIN
			taby3 = REPLICATE ('',nb3)
			IF axetemps THEN BEGIN
				IF is_fdl() THEN BEGIN
					taby3 = pchar(taby3)
					lint_unused = CALL_EXTERNAL ( libname('util'), 'MELANGER_TABX_TABY_STRING_AUTO_GLUE', 			$
									nb1, nb2, *self.datax, pchar(*self.datay), DOUBLE(tabx), pchar(taby), 	$
									tabx3, taby3, nb3, LONG(axetemps), /AUTO_GLUE)
					taby3 = STRING(taby3)
				END ELSE BEGIN
					lint_unused = CALL_EXTERNAL ( libname('util'), 'MELANGER_TABX_TABY_STRING', 			$
									nb1, nb2, *self.datax, *self.datay, DOUBLE(tabx), taby, 	$
									tabx3, taby3, nb3, LONG(axetemps))
				END
			END
		;END ELSE IF 0*is_double (taby) THEN BEGIN
		;	taby3 = REPLICATE (0d,nb3)
		;	IF axetemps THEN BEGIN
		;		lint_unused = CALL_EXTERNAL ( libname('util'), 'MELANGER_TABX_TABY_DOUBLE', 				$
		;						nb1, nb2, *self.datax, *self.datay, DOUBLE(tabx), DOUBLE(taby), 	$
		;						tabx3, taby3, nb3, LONG(axetemps))
		;	END
		END ELSE BEGIN ; FLOAT
			taby3 = REPLICATE (0.,nb3)
			IF axetemps THEN BEGIN
				IF is_fdl() THEN BEGIN
					lint_unused = CALL_EXTERNAL ( libname('util'), 'MELANGER_TABX_TABY_AUTO_GLUE', 			$
									nb1, nb2, *self.datax, *self.datay, DOUBLE(tabx), FLOAT(taby), 	$
									tabx3, taby3, nb3, LONG(axetemps), /AUTO_GLUE)
				END ELSE BEGIN
					lint_unused = CALL_EXTERNAL ( libname('util'), 'MELANGER_TABX_TABY', 				$
									nb1, nb2, *self.datax, *self.datay, DOUBLE(tabx), FLOAT(taby), 	$
									tabx3, taby3, nb3, LONG(axetemps))
				END
			END
		END

		IF ~axetemps THEN BEGIN
			tabx3[0:nb1-1] = *self.datax
			tabx3[nb1:*]   = tabx
			taby3[0:nb1-1] = *self.datay
			taby3[nb1:*]   = taby
		END


		PTR_FREE, self.datax
		PTR_FREE, self.datay  
		tabx4 = tabx3[0:nb3-1] & tabx3 = 0
		taby4 = taby3[0:nb3-1] & taby3 = 0
		self.datax = PTR_NEW (tabx4, /NO_COPY)
		self.datay = PTR_NEW (taby4, /NO_COPY)

	END ELSE BEGIN

		self.datax = PTR_NEW (DOUBLE(tabx), /NO_COPY)
		self.datay = PTR_NEW (is_string(taby) OR 0*is_double(taby) ? taby : FLOAT(taby), /NO_COPY)

	END

END


;-------------------------------------------------------------------------------
FUNCTION courbe::courbe_get_nbcourbes
;-------------------------------------------------------------------------------
; Retourne le nombre de courbes.
;-------------------------------------------------------------------------------

	RETURN, self.nb

END


;-------------------------------------------------------------------------------
PRO courbe::courbe_recuperer,	$
;-------------------------------------------------------------------------------
	tabx,			$	; LINT_PROTOTYPE output
	taby				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne les valeurs tabx et taby de la courbe.
;-------------------------------------------------------------------------------

	tabx = self.datax
	taby = self.datay

END


;-------------------------------------------------------------------------------
FUNCTION courbe::courbe_get_tabx,	$
;-------------------------------------------------------------------------------
	no	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne le tableau tabx de la courbe numro "no".
;-------------------------------------------------------------------------------

	RETURN, (*self.datax)[(*self.tab_deb)[no]:(*self.tab_fin)[no]]

END


;-------------------------------------------------------------------------------
FUNCTION courbe::courbe_get_taby,	$
;-------------------------------------------------------------------------------
	no	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne le tableau taby de la courbe "no".
;-------------------------------------------------------------------------------

	RETURN, (*self.datay)[(*self.tab_deb)[no]:(*self.tab_fin)[no]]

END


;-------------------------------------------------------------------------------
PRO courbe::courbe_compute
;-------------------------------------------------------------------------------
; Intgre les trous de donnes dans les courbes.
;-------------------------------------------------------------------------------

	IF ~PTR_VALID(self.datax) THEN RETURN

	; Trous de donnes
	trou_de_donnees, *self.datax,self.dttrou,tab_deb,tab_fin

	self.nb      = N_ELEMENTS(tab_deb)
	self.tab_deb = allocfree (self.tab_deb, tab_deb, /NO_COPY)
	self.tab_fin = allocfree (self.tab_fin, tab_fin, /NO_COPY)

END


;-------------------------------------------------------------------------------
PRO courbe::courbe_remove_data
;-------------------------------------------------------------------------------
; Supprimes toutes les donnes.
;-------------------------------------------------------------------------------

	PTR_FREE, self.datax
	PTR_FREE, self.datay
	PTR_FREE, self.tab_deb
	PTR_FREE, self.tab_fin
	self.nb = 0

END


;-------------------------------------------------------------------------------
PRO courbe::cleanup
;-------------------------------------------------------------------------------
; Destructeur de la classe "courbe".
;-------------------------------------------------------------------------------

	self -> courbe_remove_data

END

;-------------------------------------------------------------------------------
FUNCTION courbe::init
;-------------------------------------------------------------------------------
; Constructeur de la classe "courbe".
;-------------------------------------------------------------------------------

	RETURN, 1

END

;-------------------------------------------------------------------------------
PRO courbe__define
;-------------------------------------------------------------------------------
; La classe "courbe" n'hrite pas.
;-------------------------------------------------------------------------------

	lint_unused = { courbe, 		$

		dttrou: 	0d, 		$
		tab_deb:	PTR_NEW(), 	$
		tab_fin: 	PTR_NEW(), 	$
		nb: 		0L, 		$
		datax: 		PTR_NEW(), 	$
		datay: 		PTR_NEW() 	$

	}

END
