;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: copyright__define.pro,v $, v $Revision: 1.14 $
;
;	Date	: $Date: 2021/02/15 14:41:24 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
FUNCTION copyright::check
;-------------------------------------------------------------------------------
; Retourne un message s'il y a une erreur avec certaines variables.
;-------------------------------------------------------------------------------

	RETURN, self -> obj::check_gauche_droite_bas_haut()

END

;-------------------------------------------------------------------------------
PRO copyright::compute
;-------------------------------------------------------------------------------
; Effcetue toutes les opérations nécessaires pour afficher l'objet.
;-------------------------------------------------------------------------------

	fenetre = self.fenetre
	general = self.general

	hash = self -> gethash()
	hash_general = general -> gethash()

	ntrace = getq (general, hash_general.ntrace)
	IF ntrace GE 1 THEN BEGIN
		msg = self -> name()
		str = STRING(msg, FORMAT='(A)')
		cl_msg, general, str_bas=" "
		cl_msg, general, str_bas=str
	END

	x          = getq (self, hash.x)
	y          = getq (self, hash.y)
	texte      = getq (self, hash.texte)
	alignment  = getq (self, hash.alignment)
	taille     = getq (self, hash.taille)
	angle      = 0
	thick      = getq (self, hash.thick)
	configname = getq (self, hash.configname) EQ 'Yes' ? 1 : 0
	coulr      = getq (self, hash.coulr)
	coulv      = getq (self, hash.coulv)
	coulb      = getq (self, hash.coulb)

	; De quelles couleurs a t-on besoin ?
	rvb = { var_pal, r:coulr, v:coulv, b:coulb } & coul   = 0

	cube = getq(self,hash.palette_cube) 
	IF cube NE 'No' AND cube NE 'True color' THEN BEGIN
		; On va quantifier les couleurs avec color_quan et cube
		r = rvb.r & v = rvb.v & b = rvb.b
		image = INDGEN(N_ELEMENTS(rvb))
		nbcube = (STRSPLIT(cube, /EXTRACT))[0]^(1./3)
		trans = COLOR_QUAN (r[image],v[image], b[image],r,v,b,cube=nbcube)
		rvb = REPLICATE ({ var_pal, r:0, v:0, b:0 }, N_ELEMENTS(r))
		rvb.r = r & rvb.v = v & rvb.b = b
	END ELSE BEGIN
		trans = INDGEN(N_ELEMENTS(rvb))
	END

	fenetre -> fsetproperty,rvb,/rvb

	CALDAT, SYSTIME(1,/julian),moi1,jou1,ann1,heu1,min1,sec1
	date = tu_to_str (ann1, moi1, jou1, heu1, min1, sec1)
	date = STRMID (date,0,11)
	texte += '   Printing date: ' + (!CL.BENCH_DATE EQ '' ? date : !CL.BENCH_DATE) ; la chaine !CL.BENCH_DATE sera utilisée en mode "-bench"

	IF configname THEN BEGIN
		graphics = get (general,'graphics')
		nomcl = basename(get (graphics,'nom'))
		texte += '   ' + nomcl
	END

	fenetre -> ajouter_texte, x, y, texte, alignment, taille, trans[coul], angle, thick

END

;-------------------------------------------------------------------------------
FUNCTION copyright::init,	$
;-------------------------------------------------------------------------------
	no,		$	; LINT_PROTOTYPE input
	container,	$	; LINT_PROTOTYPE input
	order,		$	; LINT_PROTOTYPE input
	general			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de la classe "copyright".
;-------------------------------------------------------------------------------

	param = [ $
		{ var_obj, 'Data:Text',			'texte', 	2, PTR_NEW(['TE','2','50']), 			'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('!3Produced by cl (IRAP)')	}, 	$
		{ var_obj, 'X',				'x', 		2, PTR_NEW(['FL','0','12']), 			'check_supegal_infegal', 	PTR_NEW([0,1]), PTR_NEW (0.5)				}, 	$
		{ var_obj, 'Y', 			'y', 		2, PTR_NEW(['FL','0','12']), 			'check_supegal_infegal', 	PTR_NEW([0,1]), PTR_NEW (0.5)				}, 	$
		{ var_obj, 'Alignment', 		'alignment', 	2, PTR_NEW(['FL','2','12']), 			'check_supegal', 		PTR_NEW([0]), 	PTR_NEW (0.5)				}, 	$
		{ var_obj, 'Size', 			'taille', 	2, PTR_NEW(['FL','0','12']), 			'check_supegal', 		PTR_NEW([0]), 	PTR_NEW (1.0)				}, 	$
		{ var_obj, 'Thick', 			'thick', 	2, PTR_NEW(['FL','2','12']), 			'check_sup', 			PTR_NEW(0), 	PTR_NEW (1.)				}, 	$
		{ var_obj, 'Write config name ?', 	'configname', 	2, PTR_NEW(['DR','2','LABEL_LEFT','Yes','No']), 'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('Yes')				}, 	$   
		{ var_obj, 'Color R', 			'coulr',	2, PTR_NEW(['SL','0','150','0','255']),		'check_always_ok', 		PTR_NEW(), 	PTR_NEW (0)				}, 	$
		{ var_obj, 'G', 			'coulv', 	2, PTR_NEW(['SL','0','150','0','255']), 	'check_always_ok', 		PTR_NEW(), 	PTR_NEW (0)				}, 	$
		{ var_obj, 'B', 			'coulb', 	2, PTR_NEW(['SL','2','150','0','255']), 	'check_always_ok', 		PTR_NEW(), 	PTR_NEW (0)				} 	$
	]

	code = self -> obj::init (no, container, order, param, general=general,$
		/saisissable, graphique=1,palette=3,/shortpalette,/nonbcolors)

	set, self, 'nbmincolors', 1
	set, self, 'nbmaxcolors', 1
	set, self, 'noparam', 2

	RETURN, code

END


;-------------------------------------------------------------------------------
PRO copyright__define
;-------------------------------------------------------------------------------
; La classe "copyright" hérite de "obj".
;-------------------------------------------------------------------------------


	lint_unused = { copyright, 	$

		INHERITS obj 		$

	}

END
