$;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: clweb.pro,v $, v $Revision: 1.38 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO log_png,		$
;-------------------------------------------------------------------------------
	OUTPUT_PNG,	$	; LINT_PROTOTYPE input
	login,		$	; LINT_PROTOTYPE input
	annee,		$	; LINT_PROTOTYPE input
	mois,		$	; LINT_PROTOTYPE input
	jour			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Logge les fichiers PNG produits dans clweb
;-------------------------------------------------------------------------------

	YYYYMMDD = int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)
	DIR = '/home/clweb/log/' + YYYYMMDD + '/' + login
	mkdir_p, DIR
	lint_unused = copier (OUTPUT_PNG, DIR + '/' + basename(OUTPUT_PNG))

END

;-------------------------------------------------------------------------------
PRO clweb_query_png,	$
;-------------------------------------------------------------------------------
	OUTPUT_PNG,	$	; LINT_PROTOTYPE input
	WIDTH,		$	; LINT_PROTOTYPE output
	HEIGHT			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne les dimensions d'une image qui se trouve dans un fichier PNG.
;-------------------------------------------------------------------------------

	IF QUERY_PNG (OUTPUT_PNG,info) THEN BEGIN
		WIDTH = info.dimensions[0]
		HEIGHT = info.dimensions[1]
	END ELSE BEGIN
		WIDTH = 200
		HEIGHT = 100
	END

END

;-------------------------------------------------------------------------------
PRO corriger_keys_dynatree,	$
;-------------------------------------------------------------------------------
	keys	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Corrige keys provenant de dynatree en rajoutant les branches manquantes.
;-------------------------------------------------------------------------------

	; Faut-il corriger keys ?
	; ex:
	;	expandedKeyList[0]=-1 arbre[-1]="???"
	;	expandedKeyList[1]=0 arbre[0]="1 CLWEB"
	;	expandedKeyList[2]=1871 arbre[1871]="3 TAIL"
	;	expandedKeyList[3]=1927 arbre[1927]="4 ELECTRON"
	;
	; => Il manque "2 INTERBALL"

	COMMON  COMMON_TREE, arbre1, tab_tree
	COMMON  COMMON_DYNATREE, tabno

	PRINT,'DEBUT corriger_keys_dynatree: ',keys

	newkeys = keys

	; touche sert  optimiser
	touche = REPLICATE(0,N_ELEMENTS(arbre1))

	FOR i=0L,N_ELEMENTS(keys)-1 DO BEGIN
		;no = LONG(STRMID(arbre1[keys[i]],0,2))
		no = tabno[keys[i]]
		;PRINT,'keys['+val_to_str(i)+']='+val_to_str(keys[i])+' no='+val_to_str(no)
		IF no GT 1 THEN BEGIN
			FOR j=keys[i],0,-1 DO BEGIN
				;PRINT,'j='+val_to_str(j)
				IF touche[j] THEN BEGIN
					;PRINT,'  BREAK: touche['+val_to_str(j)+']==1 arbre1['+val_to_str(j)+']='+arbre1[j]
					BREAK
				END
				;no1 = LONG(STRMID(arbre1[j],0,2))
				no1 = tabno[j]
				IF no1 LT no AND no1 NE 0 THEN BEGIN
					no = no1
					ind = WHERE (newkeys EQ j)
					IF ind[0] EQ -1 THEN BEGIN
						PRINT,'  corriger_keys_dynatree rajoute '+val_to_str(j)+' "'+arbre1[j]+'"'
						newkeys = [ newkeys , j ]
					END
					touche[j] = 1
					;PRINT,'  touche['+val_to_str(j)+'] <- 1'
					IF no1 EQ 1 THEN BEGIN
						;PRINT,'  BREAK j='+val_to_str(j)+' no1=1'
						BREAK ; on ne trouvera pas de numro infrieur  1
					END
				END
			END
			;PRINT,'  => boucle j '+val_to_str(keys[i])+'..'+val_to_str(j)
		END
		touche[keys[i]] = 1
	END

	keys = newkeys
	PRINT,'FIN corriger_keys_dynatree: ',keys

END

;-------------------------------------------------------------------------------
FUNCTION get_json, 	$
;-------------------------------------------------------------------------------
	key0,		$	; LINT_PROTOTYPE input
	tabkeys			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne json en dveloppant le contenu de arbre[key0]
;-------------------------------------------------------------------------------

	COMMON  COMMON_TREE, arbre1, tab_tree
	COMMON  COMMON_DYNATREE, tabno

	json = ''
	premier = 1

	; json pour le contenu des branches demandes
	;nokey = LONG(STRMID(arbre1[key0+1],0,2))
	nokey = tabno[key0+1]
	;PRINT,'get_json key0='+val_to_str(key0)+' => cherche les freres de '+arbre1[key0+1]

	nb = N_ELEMENTS(arbre1)

	IF nokey EQ 0 THEN BEGIN

		; Si nokey==0 alors pas la peine d'entrer dans la boucle: afficher les feuilles

		FOR j=key0+1,nb-1 DO BEGIN
			;no = LONG(STRMID(arbre1[j],0,2))
			no = tabno[j]
			IF no NE 0 THEN BREAK
			title = STRMID(arbre1[j],2)
			tooltip = ''
			pos = STRPOS (title,STRING(4b))
			IF pos NE -1 THEN BEGIN
				tmp = STRMID(title,pos+1)
				remplacer, tmp, '"', '\"' ; protger les doubles quotes pour JSON
				tooltip = '"tooltip":"'+tmp+'",'
				title = STRMID(title,0,pos)
			END
			remplacer, title, '"', '\"' ; protger les doubles quotes pour JSON
			key = j
			; pas ncessaire de mettre "isFolder": false
			json += (premier ? '' : ',') + '{"title":"'+title+'","icon":false,'+tooltip+'"key":"'+val_to_str(key)+'"}'
			premier = 0
		END

	END ELSE BEGIN 

		FOR j=key0+1,nb-1 DO BEGIN
			;no = LONG(STRMID(arbre1[j],0,2))
			no = tabno[j]

			; On recherche les lments avec no==nokey
			;   => CONTINUE si no == 0
			;   => BREAK si no < nokey
			;   => CONTINUE si no > nokey

			IF no EQ 0 THEN CONTINUE
			IF no LT nokey THEN BEGIN
				;PRINT, 'key0='+val_to_str(key0)+' BREAK en '+val_to_str(j)
				BREAK
			END
			IF no GT nokey THEN CONTINUE

			; Y a t-il parmi les descendants de j une des valeurs de keys ?

			json1 = ''
			FOR k=j,nb-1 DO BEGIN
				;no1 = LONG(STRMID(arbre1[k],0,2))
				no1 = tabno[k]
				IF no1 EQ 0 THEN CONTINUE ; feuilles
				IF no1 LT nokey THEN BREAK
				IF no1 EQ nokey AND k NE j THEN BREAK
				; k est-il un descendant de j ?
				;ind = WHERE (keys EQ k)
				IF tabkeys[k] THEN BEGIN
					;PRINT,'json1 ... ' + arbre1[k]
					json1 = get_json (k,tabkeys)
					;PRINT,'json1 ... ' + arbre1[k]+' donne ' + json1
					BREAK ; on s'arrete au premier trouv sinon ca fait n'importe quoi
				END
			END

			title = STRMID(arbre1[j],2)
			tooltip = ''
			pos = STRPOS (title,STRING(4b))
			IF pos NE -1 THEN BEGIN
				tmp = STRMID(title,pos+1)
				remplacer, tmp, '"', '\"' ; protger les doubles quotes pour JSON
				tooltip = '"tooltip":"'+tmp+'",'
				title = STRMID(title,0,pos)
			END
			remplacer, title, '"', '\"' ; protger les doubles quotes pour JSON
			key = j
			isLazy  = key EQ 0 ? ''               : '"isLazy":true,'	; branche 0 (CLWeb) n'est pas Lazy
			sexpand = key EQ 0 ? '"expand":true,' : ''			; dvelopper branche 0 (CLWeb)
			json += (premier ? '' : ',') + '{"title":"'+title+'","isFolder":true,"hideCheckbox":true,'+isLazy+sexpand+tooltip+'"key":"' + val_to_str(key)+'"'
			IF json1 NE '' THEN BEGIN
				json += ', "children":[' + json1 + ']}'
			END ELSE BEGIN
				json += '}'
			END
			premier = 0
		END
		;PRINT,'fin boucle key0='+val_to_str(key0+1)+' en j='+val_to_str(j)
	END

	RETURN, json

END

;-------------------------------------------------------------------------------
FUNCTION get_json_dynatree,	$
;-------------------------------------------------------------------------------
	key,			$	; LINT_PROTOTYPE input
	expandedKeyList			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne la valeur json correspondant  l'indice key de l'arbre (-1 pour l'arbre initial).
;-------------------------------------------------------------------------------

	COMMON  COMMON_TREE, arbre1, tab_tree
	COMMON  COMMON_DYNATREE, tabno

	; Optimisation: tabno
	tabno = LONG(STRMID(arbre1,0,2))

	IF expandedKeyList[0] NE -2 THEN BEGIN
		top1 = nbsec()
		corriger_keys_dynatree, expandedKeyList
		top2 = nbsec()
		PRINT,'corriger_keys_dynatree en ' + val_to_str(top2-top1)+' sec'
	END

	keys = expandedKeyList[0] EQ -2 ? key : [key,expandedKeyList]

	FOR i=0L,N_ELEMENTS(keys)-1 DO BEGIN
		PRINT,'keys['+val_to_str(i)+']='+val_to_str(keys[i])+' arbre['+val_to_str(keys[i])+']="',(keys[i] EQ -1 ? '???' : arbre1[keys[i]]) + '"'
	END

	; Optimisation: cration de tabkeys pour viter de recherche si un lment appartient  keys
	tabkeys = REPLICATE (0b,N_ELEMENTS(arbre1))
	ind = WHERE (keys GE 0)
	IF ind[0] NE -1 THEN tabkeys[keys[ind]] = 1
	tabkeys[0] = 1 ; pour dvelopper la branche CLWeb

	top1 = nbsec()
	json = '[' + get_json (keys[0], tabkeys) + ']'
	top2 = nbsec()
	PRINT,'get_json en ' + val_to_str(top2-top1)+' sec'

	RETURN, json

END


;-------------------------------------------------------------------------------
FUNCTION postscript_idems,	$
;-------------------------------------------------------------------------------
	nom1,			$	; LINT_PROTOTYPE input
	nom2				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Compare deux fichiers postscript. Retourne 1 s'ils sont identiques (hors commentaires).
;-------------------------------------------------------------------------------

; Les lignes avec commentaires commencent par '%%'

	top1 = nbsec()

	code = 1

	IF ~fichier_existe(nom1) THEN RETURN, 0
	IF ~fichier_existe(nom2) THEN RETURN, 0

	OPENR, fd1, nom1, /GET_LUN
	OPENR, fd2, nom2, /GET_LUN
	s1 = ''
	s2 = ''
	WHILE 1 DO BEGIN

		; diff si est n'a pas les mmes EOF pour les 2 fichiers
		is_eof_fd1 = EOF(fd1)
		is_eof_fd2 = EOF(fd2)
		IF is_eof_fd1 NE is_eof_fd2 THEN BEGIN
			code = 0
			BREAK
		END

		; sortir si EOF sur les 2 fichiers
		IF is_eof_fd1 THEN BREAK

		READF, fd1, s1
		READF, fd2, s2

		; diff si on n'a pas les mmes ISCOMMENT sur les lignes
		is_comment_fd1 = STRMID(s1,0,2) EQ '%%'
		is_comment_fd2 = STRMID(s2,0,2) EQ '%%'
		IF is_comment_fd1 NE is_comment_fd2 THEN BEGIN
			code = 0
			BREAK
		END

		; CONTINUE si les 2 lignes sont des commentaires
		IF is_comment_fd1 THEN CONTINUE

		; diff si les 2 lignes dont diffrentes
		IF s1 NE s2 THEN BEGIN
			code = 0
			BREAK
		END
	END

	FREE_LUN, fd1
	FREE_LUN, fd2
	top2 = nbsec()

	PRINT, 'postscript_idems('+nom1+','+nom2+')=='+val_to_str(code)+' en '+val_to_str(top2-top1)+' sec'

	RETURN, code
		

END


;-------------------------------------------------------------------------------
PRO clweb,	$
;-------------------------------------------------------------------------------
	state,	$	; LINT_PROTOTYPE input
	login		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Traitement effectu lorsque cl est lanc avec l'option -web: entre en boucle infinie et excute les commandes trouves dans le fichier INPUT.
;-------------------------------------------------------------------------------

	COMMON COMMON_GRAPHICS, COMMON_GENERALS, COMMON_T1, COMMON_NB, COMMON_BASE, COMMON_CLICK_T1, COMMON_CLICK_T2
	COMMON COMMON_CL, general
	COMMON COMMON_CLWEB, info_user

	graphics = get (general, 'graphics')

	IF state.nomcl NE '' THEN BEGIN

		tmp1 = basename (state.nomcl) ; ex: "BEPI_DATA_MEA1_20180116000000_86400C.png"
		tmp2 = STRSPLIT (tmp1, '_', /EXTRACT)
		IF tmp2[0] EQ "BEPI" OR tmp2[0] EQ "MAVEN" OR tmp2[0] EQ "JUNO" OR tmp2[0] EQ "MMS1" OR tmp2[0] EQ "MMS2" OR tmp2[0] EQ "MMS3" OR tmp2[0] EQ "MMS4" OR tmp2[0] EQ "TARANIS" OR tmp2[0] EQ "STEREO" OR tmp2[0] EQ 'JASON3' OR tmp2[0] EQ 'SOLAR' THEN BEGIN
			IF tmp2[0] EQ "BEPI" THEN BEGIN
				; ex: "BEPI_DATA_MEA1_20180116000000_86400C.png"
				IF tmp2[1] EQ "DATA" AND tmp2[2] EQ "WEB1" THEN nomfichier = "mmo_mea1_web_data.cl.gz"
				IF tmp2[1] EQ "DATA" AND tmp2[2] EQ "WEB2" THEN nomfichier = "mmo_mea2_web_data.cl.gz"
				IF tmp2[1] EQ "HSK1" AND tmp2[2] EQ "WEB1" THEN nomfichier = "mmo_mea1_web_hsk1.cl.gz"
				IF tmp2[1] EQ "HSK1" AND tmp2[2] EQ "WEB2" THEN nomfichier = "mmo_mea2_web_hsk1.cl.gz"
				IF tmp2[1] EQ "HSK2" AND tmp2[2] EQ "WEB1" THEN nomfichier = "mmo_mea1_web_hsk2.cl.gz"
				IF tmp2[1] EQ "HSK2" AND tmp2[2] EQ "WEB2" THEN nomfichier = "mmo_mea2_web_hsk2.cl.gz"
				IF tmp2[1] EQ "HSK3" AND tmp2[2] EQ "WEB1" THEN nomfichier = "mmo_mea1_web_hsk3.cl.gz"
				IF tmp2[1] EQ "HSK3" AND tmp2[2] EQ "WEB2" THEN nomfichier = "mmo_mea2_web_hsk3.cl.gz"
				IF tmp2[1] EQ "HSK4" AND tmp2[2] EQ "WEB1" THEN nomfichier = "mmo_mea1_web_hsk4.cl.gz"
				IF tmp2[1] EQ "HSK4" AND tmp2[2] EQ "WEB2" THEN nomfichier = "mmo_mea2_web_hsk4.cl.gz"
				IF tmp2[1] EQ "HSK5" AND tmp2[2] EQ "WEB1" THEN nomfichier = "mmo_mea1_web_hsk5.cl.gz"
				IF tmp2[1] EQ "HSK5" AND tmp2[2] EQ "WEB2" THEN nomfichier = "mmo_mea2_web_hsk5.cl.gz"
				IF tmp2[1] EQ "HSK6" AND tmp2[2] EQ "WEB1" THEN nomfichier = "mmo_mea1_web_hsk6.cl.gz"
				IF tmp2[1] EQ "HSK6" AND tmp2[2] EQ "WEB2" THEN nomfichier = "mmo_mea2_web_hsk6.cl.gz"
				sdate = tmp2[3]
				sduree = tmp2[4]
				str_nosat = '0'
			END ELSE IF tmp2[0] EQ "SOLAR" THEN BEGIN
				; ex: SOLAR_DATA_WEB1_20180524000000_86400C.png
				IF tmp2[1] EQ "DATA" AND tmp2[2] EQ "WEB1" THEN nomfichier = "solar_web_hsk.cl.gz"
				IF tmp2[1] EQ "DATA" AND tmp2[2] EQ "WEB2" THEN nomfichier = "solar_web_data.cl.gz"
				IF tmp2[1] EQ "HSK1" AND tmp2[2] EQ "WEB1" THEN nomfichier = "solar_web_hsk1.cl.gz"
				IF tmp2[1] EQ "HSK1" AND tmp2[2] EQ "WEB2" THEN nomfichier = "solar_web_hsk2.cl.gz"
				IF tmp2[1] EQ "HSK2" AND tmp2[2] EQ "WEB1" THEN nomfichier = "solar_web_hsk3.cl.gz"
				IF tmp2[1] EQ "HSK2" AND tmp2[2] EQ "WEB2" THEN nomfichier = "solar_web_hsk4.cl.gz"
				sdate = tmp2[3]
				sduree = tmp2[4]
				str_nosat = '0'
			END ELSE IF tmp2[0] EQ "MAVEN" THEN BEGIN
				IF tmp2[1] EQ "WEB1" THEN BEGIN
					nomfichier = "maven_vue_web.cl.gz"
				END ELSE IF tmp2[1] EQ "WEB2" THEN BEGIN
					nomfichier = "maven_static_products.cl.gz"
				END
				sdate = tmp2[2]
				sduree = tmp2[3]
				str_nosat = '0'
			END ELSE IF tmp2[0] EQ "JUNO" THEN BEGIN
				IF tmp2[1] EQ "WEB1" THEN BEGIN
					nomfichier = "juno_web.cl.gz"
				END ELSE IF tmp2[1] EQ "WEB2" THEN BEGIN
					nomfichier = "juno_web_new.cl.gz"
				END
				sdate = tmp2[2]
				sduree = tmp2[3]
				str_nosat = '0'
			END ELSE IF tmp2[0] EQ "MMS1" OR tmp2[0] EQ "MMS2" OR tmp2[0] EQ "MMS3" OR tmp2[0] EQ "MMS4" THEN BEGIN
				IF tmp2[0] EQ "MMS1" THEN BEGIN
					IF tmp2[1] EQ "SRVY" AND tmp2[2] EQ "WEB1" THEN BEGIN
						nomfichier = "mms_mms1_srvy_vue_web1.cl.gz"
					END ELSE IF tmp2[1] EQ "SRVY" AND tmp2[2] EQ "WEB2" THEN BEGIN
						nomfichier = "mms_mms1_srvy_vue_web2.cl.gz"
					END ELSE IF tmp2[1] EQ "BRST" AND tmp2[2] EQ "WEB1" THEN BEGIN
						nomfichier = "mms_mms1_brst_vue_web1.cl.gz"
					END
				END ELSE IF tmp2[0] EQ "MMS2" THEN BEGIN
					IF tmp2[1] EQ "SRVY" AND tmp2[2] EQ "WEB1" THEN BEGIN
						nomfichier = "mms_mms2_srvy_vue_web1.cl.gz"
					END ELSE IF tmp2[1] EQ "SRVY" AND tmp2[2] EQ "WEB2" THEN BEGIN
						nomfichier = "mms_mms2_srvy_vue_web2.cl.gz"
					END ELSE IF tmp2[1] EQ "BRST" AND tmp2[2] EQ "WEB1" THEN BEGIN
						nomfichier = "mms_mms2_brst_vue_web1.cl.gz"
					END
				END ELSE IF tmp2[0] EQ "MMS3" THEN BEGIN
					IF tmp2[1] EQ "SRVY" AND tmp2[2] EQ "WEB1" THEN BEGIN
						nomfichier = "mms_mms3_srvy_vue_web1.cl.gz"
					END ELSE IF tmp2[1] EQ "SRVY" AND tmp2[2] EQ "WEB2" THEN BEGIN
						nomfichier = "mms_mms3_srvy_vue_web2.cl.gz"
					END ELSE IF tmp2[1] EQ "BRST" AND tmp2[2] EQ "WEB1" THEN BEGIN
						nomfichier = "mms_mms3_brst_vue_web1.cl.gz"
					END
				END ELSE IF tmp2[0] EQ "MMS4" THEN BEGIN
					IF tmp2[1] EQ "SRVY" AND tmp2[2] EQ "WEB1" THEN BEGIN
						nomfichier = "mms_mms4_srvy_vue_web1.cl.gz"
					END ELSE IF tmp2[1] EQ "SRVY" AND tmp2[2] EQ "WEB2" THEN BEGIN
						nomfichier = "mms_mms4_srvy_vue_web2.cl.gz"
					END ELSE IF tmp2[1] EQ "BRST" AND tmp2[2] EQ "WEB1" THEN BEGIN
						nomfichier = "mms_mms4_brst_vue_web1.cl.gz"
					END
				END
				sdate = tmp2[3]
				sduree = tmp2[4]
				str_nosat = '0'
			END ELSE IF tmp2[0] EQ "TARANIS" THEN BEGIN
				IF tmp2[1] EQ "DATA" THEN BEGIN
					IF tmp2[2] EQ "WEB1" THEN BEGIN
						nomfichier = "taranis_ideen_web_data.cl.gz"
					END ELSE IF tmp2[2] EQ "WEB2" THEN BEGIN
						nomfichier = "taranis_ideez_web_data.cl.gz"
					END
				END ELSE IF tmp2[1] EQ "HKSX" THEN BEGIN
					IF tmp2[2] EQ "WEB1" THEN BEGIN
						nomfichier = "taranis_ideen_web_hks.cl.gz"
					END ELSE IF tmp2[2] EQ "WEB2" THEN BEGIN
						nomfichier = "taranis_ideez_web_hks.cl.gz"
					END
				END ELSE IF tmp2[1] EQ "HKXX" THEN BEGIN
					IF tmp2[2] EQ "WEB1" THEN BEGIN
						nomfichier = "taranis_ideen_web_hk.cl.gz"
					END ELSE IF tmp2[2] EQ "WEB2" THEN BEGIN
						nomfichier = "taranis_ideez_web_hk.cl.gz"
					END
				END
				sdate = tmp2[4]
				sduree = tmp2[5]
				str_nosat = '0'
			END ELSE IF tmp2[0] EQ "STEREO" THEN BEGIN
				IF tmp2[1] EQ "BERKELEY" THEN BEGIN
					nomfichier = "stereo_vue_web_berkeley.cl.gz"
					IF tmp2[2] EQ "SC1" THEN BEGIN
						str_nosat = '1'
					END ELSE IF tmp2[2] EQ "SC2" THEN BEGIN
						str_nosat = '2'
					END
					sdate = tmp2[3]
					sduree = tmp2[4]
				END
			END ELSE IF tmp2[0] EQ "JASON3" THEN BEGIN
				IF tmp2[1] EQ "WEB1" THEN BEGIN
					nomfichier = "jason3_ambre_elec1234_ion1234.cl.gz"
				END ELSE IF tmp2[1] EQ "WEB2" THEN BEGIN
					nomfichier = "jason3_ambre_all.cl.gz"
				END
				sdate = tmp2[2]
				sduree = tmp2[3]
				str_nosat = '0'
			END
			nomfichier = state.RESOURCE_PATH+'/'+nomfichier
			annee = STRMID(sdate,0,4)
			mois = STRMID(sdate,4,2)
			jour = STRMID(sdate,6,2)
			heure = STRMID(sdate,8,2)
			minute = STRMID(sdate,10,2)
			seconde = STRMID(sdate,12,2)
			duree = LONG(sduree)
			t1 = tu_to_date (annee, mois, jour, heure, minute, seconde)
			t2 = t1 + duree * 1000d
			graphics -> chargercl, nomfichier=nomfichier, /novoir
			; supprimer le chemin du nom de la vue
			; car si la vue est dans /DATA/CLUSTER/SOFT/CLL3/resource, l'utilisateur ne pourra pas la sauver
			nom = basename (get (graphics, 'nom'))
			state.nomcl = nom
			set, graphics, 'nom', nom

			str_t1 = date_to_str (t1, format=1)
			str_t2 = date_to_str (t2, format=1)
			graphics -> cnes_setproperty, str_nosat, str_t1, str_t2, nonosat=str_nosat EQ '0'
			graphics -> cnes_compute
		END ELSE BEGIN
			graphics -> new
		END
	END ELSE BEGIN
		graphics -> new
	END
	device = get (general, 'device')
	cache = get (general, 'cache')

	INPUT			= "/home/clweb/"+login+"/clweb_"+login+"_input"
	INPUT_OK		= "/home/clweb/"+login+"/clweb_"+login+"_input_ok"
	OUTPUT			= "/home/clweb/"+login+"/clweb_"+login+"_output"
	OUTPUT_BUSY		= "/home/clweb/"+login+"/clweb_"+login+"_output_busy"
	OUTPUT_OK		= "/home/clweb/"+login+"/clweb_"+login+"_output_ok"
	OUTPUT_PS		= "/home/clweb/"+login+"/clweb_"+login+"_output.ps"
	old_OUTPUT_NORMAL_PS	= "/home/clweb/"+login+"/clweb_"+login+"_output_normal.ps"
	old_OUTPUT_ALPHA_PS	= "/home/clweb/"+login+"/clweb_"+login+"_output_alpha.ps"
	OUTPUT_PNG		= ""
	old_OUTPUT_PNG		= ""
	OUTPUT_PS_OK		= ""
	OUTPUT_PDF_OK		= ""
	OUTPUT_ALPHA		= ""
	old_OUTPUT_ALPHA	= ""

	RESOURCE = GETENV('CL_ROOT')+'/resource/'
	NO_PNG = 0
	NO_ALPHA = 0

	set, general, 'timeout_inactivity', info_user.timeout_inactivity*60
	set, general, 'timeout', info_user.timeout_plot*60
	set, general, 'clweb_max_file_size', 1024L*1024L * info_user.upload_max
	set, general, 'clweb_mire', 'none'

	; Compter le nombre d'utilisateurs pour en dduire la taille du cache
	; 	-  1-11 utilisateurs: 	10240
	; 	- 12-24 utilisateurs: 	 5120
	; 	- sinon:		 2560
	cmd = 'ps -aef | grep apache | grep cl | grep "\-web" | grep -v grep'
	SPAWN, cmd, res
	nbusers = N_ELEMENTS(res)
	IF nbusers LE 11 THEN BEGIN
		taillemax = 10240
	END ELSE IF nbusers LE 24 THEN BEGIN
		taillemax = 5120
	END ELSE BEGIN
		taillemax = 2560
	END
	PRINT, 'nbusers = ', nbusers
	set, cache, 'taillemax', taillemax
	PRINT, 'CLWEB cache = ',get(cache,'taillemax')

	set, device, 'driver', 'PS'
	set, device, 'nom', OUTPUT_PS

	IF is_gdl() THEN BEGIN
		; sinon core dumped, problme d'initiaisation ?
		; avec ces 3 lignes c'est ok
		; plus ncessaire ?
		;libplot_set_plot, 'ps'
		;libplot_plot, [1,2,3], [123]
		;libplot_device_ps, /close_file
	END


	is_inactif = 0

	infos = { FONTSIZE: get(general,'clweb_FONTSIZE'), valD: get(general,'clweb_valD') }

	ZOOM = ""
	COMMON_CLICK_T1 = -1
	COMMON_CLICK_T2 = -1

	SEP1 = STRING(1B)
	SEP2 = STRING(2B)
	ligne = ''
	repweb = ''

	UI = "SIMPLE"

	top1 = nbsec()

	ERASE_COOKIE_DYNATREE = val_to_str(1)

	old_clweb_no = -1 ; 19/07/2018

	; Boucle infinie de lecture du fichier INPUT
	WHILE 1 DO BEGIN

		top2 = nbsec()
		IF top2 - top1 GT get(general,'timeout_inactivity') THEN BEGIN
			; deconnexion au bout de 'timeout_inactivity' sec d'inactivite
			PRINT,'Inactivity timeout ' + val_to_str(LONG(get (general,'timeout_inactivity'))/60)+' mn has expired'
			cl_write_config, state, general
			EXIT, status=152
		END

		top_debut = nbsec()
	
		IF fichier_existe(INPUT_OK) THEN BEGIN

			changer_normal = 2
			changer_alpha  = 1

			code = detruire (INPUT_OK)

			OPENW, fd, OUTPUT_BUSY, /GET_LUN
			FREE_LUN, fd

			; Lecture d'une seule ligne dans INPUT
			OPENR, fd, INPUT, /GET_LUN
			READF, fd, ligne
			PRINT
			PRINT,'*** '+ligne+' ***'
			FREE_LUN, fd

			; supprimer dans ligne le premier mot (qui vaut cmd normalement), mais sans transformer plusieurs blancs en un seul blanc en utilisant simplement STRSPLIT et STRJOIN
			pos = STRPOS(ligne,' ')
			ligne = STRMID(ligne,pos+1)

			; passage de ligne en (argc,argv)
			cmd = STRSPLIT (ligne, /EXTRACT)
			is_ajax = cmd[0] EQ 'AJAX'
			argv = is_ajax ? cmd[1:*] : cmd[0:*]
			argc = N_ELEMENTS(argv)

			generals = *state.generals
			COMMON_GENERALS = generals

			; Determination une fois pour toutes de requette et clweb_no
			; ----------------------------------------------------------
			;	1) Extraction de clweb_no dans argv[0] ou argv[1] qui est de la forme "requette:clweb_no"
			;		- dans argv[1] si argv[0] vaut 'setproperty' (ex: setproperty SYSTEME:1|SEP1|....)
			;		- dans argv[0] sinon
			i = argv[0] EQ 'setproperty' ? 1 : 0
			tmp = STRSPLIT(argv[i],SEP1,/EXTRACT) ;  cause de 'setproperty'
			tmp = tmp[0]
			tmp = STRSPLIT(tmp,':',/EXTRACT)
			requette = tmp[0]
			is_PROPERTIES_ACTIF = requette EQ 'PROPERTIES_ACTIF'
			is_ADD_TREE = requette EQ 'ADD_TREE'
			noreq = chercher_requette (requette, sortie)
			IF noreq NE -1 THEN changer_normal = sortie.changer_normal

			IF N_ELEMENTS(tmp) EQ 1 THEN BEGIN
				FOR i=0L,N_ELEMENTS(generals)-1 DO BEGIN
					IF get(generals[i],'base') NE -99 THEN BEGIN
						clweb_no = val_to_str(i)
						BREAK
					END
				END
			END ELSE BEGIN
				clweb_no = tmp[1]
				IF clweb_no GE N_ELEMENTS(generals) THEN clweb_no = '0' ; arrive lorsqu'un clweb deconnecte reprend la main alors qu'un autre clweb a ete lancee
			END

PRINT,'requette = ' + requette
PRINT,'clweb_no = ' + clweb_no
PRINT,'is_ajax  = ' + val_to_str(LONG(is_ajax))
PRINT,'argv  = ', argv

			general  = generals[clweb_no]

			; Rajout 19/07/2018 sinon problme lorsque l'on change les paramtres MARS_B_CONNECTION et qu'il y a plusieurs fentres
			; Problme vu par Karim
			; Ca prend 0.08s donc on ne le fait que lorsque clweb_no change
			IF clweb_no NE old_clweb_no THEN BEGIN
				;top_ici_1 = nbsec()
				synchro_general, general
				;top_ici_2 = nbsec()
				;PRINT, 'synchro_general', top_ici_2-top_ici_1
				old_clweb_no = clweb_no
			END

			graphics = get(general,'graphics')
			device = get(general,'device')

			; date1_cl pour plot_timeout: on le fixe pour tous les objets 'general'. Sinon ca ne marche pas bien...
			date1_cl = get_date()
			FOR i=0L,N_ELEMENTS(generals)-1 DO BEGIN
				set, generals[i], 'date1_cl', date1_cl
			END

			set, device, 'orientation', 'Portrait'

			set, general, 'clweb_form', ''
			set, general, 'clweb_plot_normal', ''
			set, general, 'clweb_plot_alpha', ''
			set, general, 'clweb_plot_width', ''
			set, general, 'clweb_plot_height', ''
			clweb_msg_old = get (general, 'clweb_msg')
			set, general, 'clweb_msg', ''
			set, general, 'clweb_dialog', ''
			set, general, 'clweb_alert', ''

			clweb_json = ''

			IF is_ajax THEN BEGIN

				; -----------------------------------------------------------------------------------
				; AJAX: creation d'un page contenant:
				;
				;	- <clweb_form>html pour le formulaire</clweb_form>
				;	- <clweb_plot_normal>html pour le plot</clweb_plot_nomal>
				;	- <clweb_msg>html pour le titre</clweb_msg>
				;	- <clweb_dialog>texte boite de dialogue</clweb_dialog>
				;	- <clweb_alert>message d'alerte</clweb_alert>
				;	- <clweb_mire>none ou solid</clweb_mire>
				; -----------------------------------------------------------------------------------

				param = [ { var_obj, '', '', 1, PTR_NEW(), '', PTR_NEW(), PTR_NEW () } ]

				IF argc GE 2 THEN val = argv[1] ; nom du fichier a charger pour requette="SYSTEME"

				IF device -> ouvrir() EQ -1 THEN EXIT, status=151

				IF requette EQ 'ZOOMMOUSE_TIME_ACTIF' THEN ZOOM = clweb_no
				IF argv[0] EQ 'setproperty' THEN BEGIN

					click_boutton = ""
					click_ok = 0
					click_cancel = 0
					click_nochamp = 0

					; La ligne est de la forme: 'AJAX setproperty ' puis arg1[0] puis SEP1 puis arg1[1] puis SEP1 ... arg1[dernier] puis SEP1
					; on recupere ici arg1
					arg1 = STRSPLIT (STRMID(ligne,STRLEN('AJAX setproperty')+1), SEP1, /EXTRACT)

					duree = -1 ; verrue BARTHE duree
					FOR i=0L,N_ELEMENTS(arg1)-1 DO BEGIN

						; chaque lment de arg1 est constitu de arg2[0] puis SEP2 puis arg2[1] puis SEP2 ... arg2[dernier] 
						; on recupere ici arg2
						arg2 = STRSPLIT (arg1[i], SEP2, /EXTRACT)

						;PRINT,'arg1['+val_to_str(i)+'] = [' + arg1[i] + ']'

						var = arg2[0] ; premier element de arg2

						; On met a jour le nom de la premiere variable
						IF i EQ 0 THEN BEGIN
							param[0].nom = var
					
							code = graphics -> get_objactif (tab, actif)
							IF code EQ 1 THEN BEGIN
								obj = tab[actif].obj
								IF obj -> getnovar ('nochamp') NE -1 THEN BEGIN
									choix_nochamp = (get(obj,'nochamp',/INFO))[4:*]
									nochamp = (WHERE (choix_nochamp EQ get(obj,'nochamp')))[0]
								END
							END
	
							CONTINUE

						END


						; L'utilisateur a clique sur le boutton "Cancel"
						IF var EQ "boutton_cancel" THEN BEGIN
							click_cancel = 1
							BREAK
						END 

						; L'utilisateur a clique sur le boutton "Ok"
						IF var EQ "boutton_ok" THEN BEGIN
							click_ok = 1
							CONTINUE
						END

						; L'utilisateur a clique sur un boutton "onglet"
						IF STRMID(var,0,8) EQ 'boutton_' THEN BEGIN
							click_boutton = STRMID(var,8,STRLEN(var)-8)
							CONTINUE
						END


						val = N_ELEMENTS(arg2) LE 1 ? [''] : arg2[1:*]
						; Ici, on demande donc "var" = "val"


						; verification de la compatibilite de val avec var
						tmp = STRSPLIT(val[0],'#',/EXTRACT,/PRESERVE_NULL)
						IF tmp[0] EQ 'check_strdate' OR tmp[0] EQ 'check_supegal' OR tmp[0] EQ 'check_sup' OR tmp[0] EQ 'check_supegal_infegal' OR tmp[0] EQ 'check_sup_inf' THEN BEGIN
							check = tmp[0]
							IF tmp[0] EQ 'check_strdate' THEN BEGIN
								para = PTR_NEW()
							END ELSE IF tmp[0] EQ 'check_supegal' OR tmp[0] EQ 'check_sup' THEN BEGIN
								para = PTR_NEW(FLOAT(tmp[2]))
							END ELSE IF tmp[0] EQ 'check_supegal_infegal' OR tmp[0] EQ 'check_sup_inf' THEN BEGIN
								para = PTR_NEW(FLOAT(tmp[2:3]))
							END
							val = N_ELEMENTS(val) EQ 1 ? '' : val[1:*]

							; Dbut verrue BARTHE duree
							IF var EQ 'time_t1' THEN BEGIN
								tmp = STRSPLIT (val, /EXTRACT)
								sduree = tmp[N_ELEMENTS(tmp)-1]
								IF STRMID(sduree,0,1) EQ '/' AND N_ELEMENTS(tmp) GE 2 THEN BEGIN
									; sduree est de la forme '/xxx[DHMS]'
									unit_duree = STRUPCASE(STRMID(sduree,STRLEN(sduree)-1))
									val_duree = STRMID(sduree,1,STRLEN(sduree)-2)
									CASE unit_duree OF
										'D':    duree = val_duree * 1000d * 86400
										'H':    duree = val_duree * 1000d *  3600
										'M':    duree = val_duree * 1000d *    60
										'S':    duree = val_duree * 1000d *     1
										ELSE:   duree = -1
									END
									IF duree NE -1 THEN BEGIN
										;  modifier 'time_t1' et 'time_t2'
										time_t1 = str_to_date (STRJOIN(tmp[0:N_ELEMENTS(tmp)-2],' '))
										time_t2 = time_t1 + duree
										val = date_to_str(time_t1,format=1)
									END
								END
							END ELSE IF var EQ 'time_t2' THEN BEGIN
								IF duree NE -1 THEN BEGIN
									val = date_to_str(time_t2,format=1)
								END
							END
							; Fin verrue BARTHE duree

							ret = CALL_FUNCTION (check, para, val)
							IF ret NE '' THEN BEGIN
								set, general, 'clweb_alert', tmp[1]+ret
								BREAK ; pas la peine de continuer
							END
						END


						; Suppression de tabcommentaire dans tabproduit
						; ---------------------------------------------
						IF var EQ 'tabproduit' THEN BEGIN
							FOR j=0L,N_ELEMENTS(val)-1 DO BEGIN ; pour chaque ligne
								tmp = STRSPLIT (val[j], /EXTRACT) ; transformation de la ligne en tableau de mots
								val[j] = tmp[0] ; on garde juste le premier mot (c'est le numero du produit)
							END
						END

						IF ~is_PROPERTIES_ACTIF THEN BEGIN

							; formulaire 'particulier' genre 'T1T2', 'AUTOMATIC_REORGANISATION_GLOBAL'
							; Le traitement classique de la requete a ete interrompu car on a besoin que l'utilisateur entre des parametres
							; Il va falloir reprendre le traitement de cette requette une fois connues les valeurs de tous les parametres.
							; Ces parametres sont recus ici. On les mmorise dans 'param'

							param = [ param, [ { var_obj, '', var, 1, PTR_NEW(), '', PTR_NEW(), PTR_NEW (val) } ] ]

						END ELSE BEGIN

							old_val = get(obj,var)
							siz = SIZE(old_val)
							type = siz[N_ELEMENTS(siz)-2]

							; Changement du type de val si necessaire
							IF type EQ 1 			THEN val = BYTE(val)
							IF type EQ 2 OR type EQ 12	THEN val = FIX(val)
							IF type EQ 3 OR type EQ 13	THEN val = LONG(val)
							IF type EQ 4 			THEN val = FLOAT(val)
							IF type EQ 5 			THEN val = DOUBLE(val)
							IF type EQ 14 OR type EQ 15 	THEN val = LONG64(val)

							IF STRPOS(var,'_nochamp') NE -1 THEN BEGIN
								v = get(obj,var)
								; Pointeur ou non (chaud chaud chaud): 10=POINTER
								tmp = siz[2] NE 10 ? v[nochamp] : *v[nochamp]
								siz_nochamp = SIZE(tmp)
								IF siz_nochamp[0] EQ 0 THEN val = val[0]
								IF siz[2] NE 10 THEN v[nochamp] = val ELSE *v[nochamp] = val
								val = v
							END

							; Tableau ou non ?
							IF siz[0] EQ 0 THEN val = val[0]

							dim_val = N_ELEMENTS(val)
							dim_oldval = N_ELEMENTS(old_val)
							changement = dim_val NE dim_oldval
							IF ~changement THEN lint_unused = WHERE(val NE old_val,changement)
							IF changement NE 0 THEN BEGIN
								PRINT,var,' -> ', val
								set, obj, var, val
								IF var EQ 'nochamp' THEN click_nochamp = 1
								set, obj, 'recompute', 2
							END

						END
					
					END

					; Toutes les variables ont ete passs en revue
					; Que reste t-il a faire ?
					IF get (general,'clweb_alert') NE '' THEN BEGIN

					END ELSE IF ~is_PROPERTIES_ACTIF THEN BEGIN

						IF is_ADD_TREE AND click_boutton NE "" THEN BEGIN ; onglet

							graphics -> add_tree, traceweb=param[0].nom,noparam=click_boutton ; param[0].nom est de la forme "PROPERTIES_ACTIF:no"

						END ELSE IF N_ELEMENTS(param) GT 1 THEN BEGIN ; 1 si on veut compresser un fichier mais que l'on choisi cancel

							; reprendre la requette des formulaires particuliers
							clweb_obj = OBJ_NEW('obj',1,-1,-1,param[1:*],/saisissable,general=general)
							set, general, 'clweb_obj', clweb_obj
							; ne pas remettre repweb  '' sinon ca ne marche pas avec Load Time Table
							; Tester que ca marche avec:
							;	- Load Time Table
							;	- boutton Prop
							IF click_boutton NE ""  THEN repweb = 'click_boutton '+click_boutton
							IF click_ok AND repweb NE 'Yes' THEN repweb = 'click_ok'
							IF clweb_obj -> getnovar(' Yes') NE -1 THEN repweb = 'Yes'
							traiter_requette, requette, clweb_no, state, repweb=repweb, login=login
						END

					END ELSE BEGIN

						IF get (obj, 'iscontainer') THEN BEGIN
							graphics -> maj_fils, obj
						END

						IF click_boutton NE "" OR click_nochamp THEN BEGIN ; onglet ou nochamp
							IF click_boutton NE "" THEN set, obj, 'noparam', click_boutton
							graphics -> properties, traceweb=param[0].nom ; param[0].nom est de la forme "PROPERTIES_ACTIF:no"
							changer_normal = 0
						END ELSE IF click_ok THEN BEGIN ; ok
							IF is_inactif THEN BEGIN
								graphics -> desactive
								is_inactif = 0
							END
							graphics -> cnes_compute
							changer_normal = 1
						END ELSE IF click_cancel THEN BEGIN ; cancel
							IF is_inactif THEN BEGIN
								graphics -> desactive
								is_inactif = 0
							END ELSE BEGIN
								changer_normal = 0
							END
						END
					END

				END ELSE IF noreq NE -1 THEN BEGIN
					repweb = ''
					IF argc EQ 2 THEN repweb = argv[1]
					IF argc EQ 3 THEN repweb = argv[1]+' '+argv[2]
					traiter_requette, requette, clweb_no, state, repweb=repweb, login=login, val=val
				END ELSE IF requette EQ 'MIRE' THEN BEGIN
					clweb_mire = get (general, 'clweb_mire')
					set, general, 'clweb_mire', clweb_mire EQ 'none' ? 'solid':'none'
					changer_normal = 0
				END ELSE IF requette EQ 'DYNATREE' THEN BEGIN

					; argv[0]: 'DYNATREE'
					; argv[1]: key de DYNATREE 
					PRINT,'argv[0]='+argv[0]
					PRINT,'argv[1]='+argv[1]

					; key au sens dynatree
					key = LONG(argv[1])

					expandedKeyList = '-2'
					OPENR, fd, INPUT, /GET_LUN
					WHILE ~EOF(fd) DO BEGIN
						READF, fd, ligne
						PRINT,'*** '+ligne+' ***'
						tmp = STRSPLIT (ligne, /EXTRACT)
						IF tmp[0] EQ 'expandedKeyList' AND N_ELEMENTS(tmp) GE 2 THEN expandedKeyList = LONG(STRSPLIT(tmp[1],',',/EXTRACT))
					END
					FREE_LUN, fd

					xxx1 = nbsec()
					clweb_json = get_json_dynatree (key,expandedKeyList)
					xxx2 = nbsec()
					PRINT,'get_json_dynatree en '+val_to_str(xxx2-xxx1)+' sec'

					changer_normal = 0
					changer_alpha = 0
				END ELSE IF requette EQ 'FILE_PRINT' THEN BEGIN
					graphics -> gvoir, /refresh ; obligatoire pour re-generer le postscript
				END ELSE IF requette EQ 'MOUSE_CLICK' OR requette EQ 'MOUSE_MOVE' THEN BEGIN
					boutton = argv[1]
					; valeur de boutton
					; 	FF : gauche=0 droit=2
					; 	IE : gauche=1 droit=2
					; 	MOUSE_MOVE: 10
					xsize_web = LONG(argv[4])
					ysize_web = LONG(argv[5])
					x_web     = LONG(argv[2])
					y_web     = ysize_web -LONG(argv[3])
					xn        = (xsize_web LE 0) ? 0.0 : FLOAT(x_web) / (xsize_web)
					yn        = (ysize_web LE 0) ? 0.0 : FLOAT(y_web) / (ysize_web)
					long      = get (device, 'long')
					larg      = get (device, 'larg')
					xsize     = get (general, 'xsize')
					ysize     = get (general, 'ysize')
					x_cl      = LONG(xn * xsize)
					y_cl      = LONG(yn * ysize)
					IF boutton EQ 0 OR boutton EQ 1 THEN BEGIN ; click gauche
						repweb = ''
						IF N_ELEMENTS(argv) EQ 7 THEN repweb = argv[6]
						IF N_ELEMENTS(argv) EQ 8 THEN repweb = argv[6]+' '+argv[7]
						set, general, 'clweb_simpleclick', ''
						graphics -> simpleclick, 1, 0, x_cl, y_cl, xn, yn, repweb=repweb
						graphics -> simpleclick, 0, 1, x_cl, y_cl, xn, yn, repweb=repweb
						graphics -> aspect, x_cl, y_cl, xn, yn
						IF ZOOM EQ clweb_no AND COMMON_CLICK_T1 NE -1 AND COMMON_CLICK_T2 NE -1 THEN BEGIN
							graphics -> time, 'WEB', time_t1, time_t2, t1=COMMON_CLICK_T1, t2=COMMON_CLICK_T2
							graphics -> cnes_compute
							COMMON_CLICK_T1 = -1
							COMMON_CLICK_T2 = -1
							ZOOM = ""
							changer_alpha = 0
						END ELSE BEGIN
							changer_normal = get (general, 'clweb_simpleclick') EQ '' ? 0 : 2 ; a cause de kill et minmax
						END
					END ELSE IF boutton EQ 2 THEN BEGIN ; click droit
						is_inactif = graphics -> get_is_inactif()
						graphics -> simpleclick, 4, 0, x_cl, y_cl, xn, yn, traceweb='PROPERTIES_ACTIF:'+clweb_no
						graphics -> simpleclick, 0, 4, x_cl, y_cl, xn, yn, traceweb='PROPERTIES_ACTIF:'+clweb_no
						changer_normal = 0
					END ELSE IF boutton EQ 10 THEN BEGIN ; MOUSE_MOVE
						changer_alpha = 0
						IF ZOOM EQ clweb_no AND COMMON_CLICK_T1 NE -1 AND COMMON_CLICK_T2 NE -1 THEN BEGIN
							; Retour sur la fenetre qui a demande un zoom
							graphics -> time, 'WEB', time_t1, time_t2, t1=COMMON_CLICK_T1, t2=COMMON_CLICK_T2
							graphics -> cnes_compute
							COMMON_CLICK_T1 = -1
							COMMON_CLICK_T2 = -1
							ZOOM = ""
						END ELSE IF ZOOM NE "" THEN BEGIN
							; on est en train de saisir t1 dans t2 dans ZOOM
							changer_normal = 0
							set, general, 'clweb_msg', clweb_msg_old
						END ELSE BEGIN
							; affichage des infos  la position de la souris
							graphics -> aspect, x_cl, y_cl, xn, yn
							changer_normal = 0
						END
					END
				END

				IF get(general,'clweb_alert') NE '' THEN BEGIN
					; On va afficher un message d'erreur
					; Dans CL on affiche le message et puis c'est tout, on ne change pas le trac qui est  l'cran
					; DANS CLWEB le trac ne sera pas effectu, et on aura une image vide
					; En forcant changer_normal  0 la dernire image restera affiche
					changer_normal = 0
				END

				IF changer_normal NE 0 THEN BEGIN
					PRINT, 'graphics -> estvide:', graphics -> estvide()
					IF graphics -> estvide() THEN graphics -> welcome
				END

				device -> fermer

				IF changer_normal NE 0 THEN BEGIN

					; Mettre la date dans le nom du png pour que le cache des navigateurs ne se trompe jamais
					date_to_tu, get_date(), annee, mois, jour, heure, minute, seconde
					NO_PNG++

					IF changer_normal EQ 2 THEN BEGIN
						IF ~graphics -> estvide() THEN BEGIN
							top1a = nbsec()
							; du coup la duree du 'plot_time' est completement faussee
							IF device -> ouvrir() EQ -1 THEN EXIT, status=151
							graphics -> gvoir, /refresh
							top2a = nbsec()
							PRINT,val_to_str_2decimales(top1a-top_debut)+' (voir) '+val_to_str_2decimales(top2a-top_debut)+' = '+val_to_str_2decimales(top2a-top1a)+' sec'
							device -> fermer
						END
					END

					code = get_filelengthc (OUTPUT_PS, taille)
					IF taille EQ 0 THEN BEGIN ; postscript vide
						IF ~graphics -> estvide() THEN BEGIN ; alors qu'il y a des donnes
							; erreur (ex: temps suivant en ne selectionnant pas le container, il ne reste qu'un panel composer vide, ...)
							IF device -> ouvrir() EQ -1 THEN EXIT, status=151
							graphics -> vide ; se debrouiller pour avoir une image blanche ...
							device -> fermer
						END
					END

					OUTPUT_PNG = "/home/clweb/"+login+"/clweb_"+login+"_"+int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)+'_'+int_str_0(heure,2)+int_str_0(minute,2)+int_str_0(LONG(seconde),2)+"_output_normal_"+val_to_str(NO_PNG)+'.png'
					IF requette EQ 'FILE_PRINT' THEN BEGIN

						ps2png, 'png16m', val_to_str(infos[clweb_no].valD), OUTPUT_PS, OUTPUT_PNG
						log_png, OUTPUT_PNG, login, annee, mois, jour

						code = detruire (OUTPUT_PS_OK)
						code = detruire (OUTPUT_PDF_OK)
						OUTPUT_PS_OK = STRMID(OUTPUT_PNG,0,STRLEN(OUTPUT_PNG)-3)+'ps'
						OUTPUT_PDF_OK = STRMID(OUTPUT_PNG,0,STRLEN(OUTPUT_PNG)-3)+'pdf'

						ps2pdf, val_to_str(infos[clweb_no].valD), OUTPUT_PS, OUTPUT_PDF_OK

						; Generation 'ps' standard (diffrent de ceux de clweb)
						long = get (device, 'long')
						larg = get (device, 'larg')
						IF long GT larg THEN BEGIN
							orientation = 'Portrait'
						END ELSE BEGIN
							orientation = 'Landscape'
							set, device, 'larg', long
							set, device, 'long', larg
						END
						set, device, 'orientation', orientation
						IF device -> ouvrir() EQ -1 THEN EXIT, status=151
						graphics -> gvoir, /refresh ; obligatoire
						device -> fermer
						code = copier (OUTPUT_PS, OUTPUT_PS_OK)
						IF orientation EQ 'Landscape' THEN BEGIN
							set, device, 'orientation', 'Portrait'
							set, device, 'larg', larg
							set, device, 'long', long
						END
						clweb_form = '<TABLE BORDER=0 cellpadding=0 cellspacing=0>' + $
							'<TR><TD><FONT SIZE=1 FACE=Verdana><input type=button value="PNG" onclick="javascript:window.open('+"'"+login+'/'+basename(OUTPUT_PNG)+"'"+')"></TD>' + $
							'<TD><FONT SIZE=1 FACE=Verdana><input type=button value="PS" onclick="javascript:window.open('+"'"+login+'/'+basename(OUTPUT_PS_OK)+"'"+')"></TD>' + $
							'<TD><FONT SIZE=1 FACE=Verdana><input type=button value="PDF" onclick="javascript:window.open('+"'"+login+'/'+basename(OUTPUT_PDF_OK)+"'"+')"></TD></TR></TABLE>' + $
							'<TABLE BORDER=0 cellpadding=0 cellspacing=0><TR><TD><FONT SIZE=1 FACE=Verdana><input type=button value="Cancel" onclick="ajax_complet('+"'"+'clweb.php'+"','"+'AJAX REFRESH:'+clweb_no+"'"+');"></TD></TR></TABLE>'
						set, general, 'clweb_form', clweb_form

					END ELSE BEGIN

						IF postscript_idems (OUTPUT_PS,old_OUTPUT_NORMAL_PS) THEN BEGIN
							PRINT,'=> changer_normal=0 car PS idem'
							NO_PNG--			; pour ne pas changer d'image
							OUTPUT_PNG = old_OUTPUT_PNG	; pour ne pas changer d'image
							changer_normal = 0		; pour ne pas changer d'image
						END ELSE BEGIN
							code = copier (OUTPUT_PS, old_OUTPUT_NORMAL_PS)
							ps2png, 'png16m', val_to_str(infos[clweb_no].valD), OUTPUT_PS, OUTPUT_PNG
							log_png, OUTPUT_PNG, login, annee, mois, jour
							clweb_query_png, OUTPUT_PNG, WIDTH, HEIGHT
							set, general, 'clweb_plot_width', val_to_str(WIDTH)
							set, general, 'clweb_plot_height', val_to_str(HEIGHT)
							set, general, 'clweb_plot_normal', login+'/'+basename(OUTPUT_PNG)
						END

					END
				END

				IF changer_alpha THEN BEGIN

					IF device -> ouvrir() EQ -1 THEN EXIT, status=151
					graphics -> voir_selected_actif
					device -> fermer, /alpha
					NO_ALPHA++
					OUTPUT_ALPHA = "/home/clweb/"+login+"/clweb_"+login+"_"+int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)+'_'+int_str_0(heure,2)+int_str_0(minute,2)+int_str_0(LONG(seconde),2)+"_output_alpha_"+val_to_str(NO_ALPHA)+'.png'
					IF postscript_idems (OUTPUT_PS,old_OUTPUT_ALPHA_PS) THEN BEGIN
						PRINT,'=> changer_alpha=0 car PS idem'
						NO_ALPHA--			; pour ne pas changer d'image
						OUTPUT_ALPHA = old_OUTPUT_ALPHA	; pour ne pas changer d'image
						changer_alpha = 0		; pour ne pas changer d'image
					END ELSE BEGIN
						code = copier (OUTPUT_PS, old_OUTPUT_ALPHA_PS)
						ps2png, 'pngalpha', val_to_str(infos[clweb_no].valD), OUTPUT_PS, OUTPUT_ALPHA
						clweb_query_png, OUTPUT_ALPHA, WIDTH, HEIGHT
						set, general, 'clweb_plot_alpha', login+'/'+basename(OUTPUT_ALPHA)
						set, general, 'clweb_plot_width', val_to_str(WIDTH)
						set, general, 'clweb_plot_height', val_to_str(HEIGHT)
					END

				END

				IF get(general,'clweb_msg') EQ '' THEN set, general, 'clweb_msg', basename(get(graphics,'nom'))+':  ' + graphics -> get_msg("")

				clweb_form = get(general,'clweb_form')
				IF requette EQ 'CONSTRAINT' THEN BEGIN
					clweb_form = '<TABLE BORDER=0 cellpadding=0 cellspacing=0><TR><TD><FONT SIZE=1 FACE=Verdana><input type=button value="Clear" onclick="ajax_complet('+"'"+'clweb.php'+"','"+'AJAX REFRESH:'+clweb_no+"'"+');"></TD></TR></TABLE>' + clweb_form
				END

				clweb_plot_normal = get(general,'clweb_plot_normal')
				clweb_plot_alpha = get(general,'clweb_plot_alpha')
				clweb_plot_width = get(general,'clweb_plot_width')
				clweb_plot_height = get(general,'clweb_plot_height')
				clweb_msg = get(general,'clweb_msg')
				clweb_dialog = get(general,'clweb_dialog')
				clweb_alert = get(general,'clweb_alert')
				clweb_mire = get(general,'clweb_mire')


				OPENW, fdweb, OUTPUT, /GET_LUN
				IF get(general,'base') EQ -99 THEN BEGIN
					PRINTF, fdweb, 'This window is closed'
				END ELSE IF clweb_json NE '' THEN BEGIN
					PRINT, 'clweb_json=',clweb_json
					PRINTF, fdweb, clweb_json
				END ELSE IF clweb_alert NE '' THEN BEGIN
					PRINTF, fdweb, '<clweb_alert>'+clweb_alert+'</clweb_alert>'
					IF clweb_plot_normal NE '' THEN PRINTF, fdweb, '<clweb_plot_normal>'+clweb_plot_normal+'</clweb_plot_normal>'
					IF clweb_plot_alpha  NE '' THEN PRINTF, fdweb, '<clweb_plot_alpha>'+clweb_plot_alpha+'</clweb_plot_alpha>'
					IF clweb_plot_width  NE '' THEN PRINTF, fdweb, '<clweb_plot_width>'+clweb_plot_width+'</clweb_plot_width>'
					IF clweb_plot_height NE '' THEN PRINTF, fdweb, '<clweb_plot_height>'+clweb_plot_height+'</clweb_plot_height>'
				END ELSE IF clweb_dialog NE '' THEN BEGIN
					PRINTF, fdweb, '<clweb_dialog>'+clweb_dialog+'</clweb_dialog>'
				END ELSE BEGIN
					IF clweb_form        NE '' THEN PRINTF, fdweb, '<clweb_form>'+clweb_form+'</clweb_form>'
					IF clweb_form        NE '' THEN PRINT ,        '<clweb_form>'+clweb_form+'</clweb_form>'
					IF clweb_plot_normal NE '' THEN PRINTF, fdweb, '<clweb_plot_normal>'+clweb_plot_normal+'</clweb_plot_normal>'
					IF clweb_plot_normal NE '' THEN PRINT ,        '<clweb_plot_normal>'+clweb_plot_normal+'</clweb_plot_normal>'
					IF clweb_plot_alpha  NE '' THEN PRINTF, fdweb, '<clweb_plot_alpha>'+clweb_plot_alpha+'</clweb_plot_alpha>'
					IF clweb_plot_alpha  NE '' THEN PRINT ,        '<clweb_plot_alpha>'+clweb_plot_alpha+'</clweb_plot_alpha>'
					IF clweb_plot_width  NE '' THEN PRINTF, fdweb, '<clweb_plot_width>'+clweb_plot_width+'</clweb_plot_width>'
					IF clweb_plot_width  NE '' THEN PRINT ,        '<clweb_plot_width>'+clweb_plot_width+'</clweb_plot_width>'
					IF clweb_plot_height NE '' THEN PRINTF, fdweb, '<clweb_plot_height>'+clweb_plot_height+'</clweb_plot_height>'
					IF clweb_msg         NE '' THEN PRINTF, fdweb, '<clweb_msg>'+clweb_msg+'</clweb_msg>'
					IF clweb_msg         NE '' THEN PRINT ,        '<clweb_msg>'+clweb_msg+'</clweb_msg>'
					IF clweb_mire        NE '' THEN PRINTF, fdweb, '<clweb_mire>'+clweb_mire+'</clweb_mire>'
					IF clweb_mire        NE '' THEN PRINT ,        '<clweb_mire>'+clweb_mire+'</clweb_mire>'
				END
				FREE_LUN, fdweb

				code = get_filelengthc (OUTPUT, taille)
				PRINT,'AJAX size = '+val_to_str(taille)+' bytes'

			END ELSE BEGIN

				; -----------------------------------------------------------------------------------
				; NON AJAX: cration de la page complete contenant absolument tout, en utilisant le modle "resource/clweb.html"
				; -----------------------------------------------------------------------------------


				IF requette EQ 'DEVICE_ORIENTATION' THEN BEGIN

					long = get (device, 'long')
					larg = get (device, 'larg')
					set, device, 'long', larg
					set, device, 'larg', long

				END ELSE IF STRMID(requette,0,6) EQ 'NEW_CL' THEN BEGIN

					traiter_requette, requette, clweb_no, state, repweb=repweb
					infos = [ infos, { FONTSIZE: infos[clweb_no].FONTSIZE, valD:infos[clweb_no].valD } ]
					generals = *state.generals
					clweb_no = val_to_str(N_ELEMENTS(generals)-1)
					general  = generals[clweb_no]
					graphics = get(general,'graphics')
					device = get(general,'device')

				END ELSE IF requette EQ 'NEXT_WINDOW' THEN BEGIN

					generals = *state.generals
					clweb_no_new = -1
					FOR i=LONG(clweb_no)+1,N_ELEMENTS(generals)-1 DO BEGIN
						IF get(generals[i],'base') EQ -99 THEN CONTINUE
						clweb_no_new = i
						BREAK
					END
					IF clweb_no_new EQ -1 THEN BEGIN
						OPENW, fdweb, OUTPUT, /GET_LUN
						PRINTF, fdweb, 'No more Window ...'
						FREE_LUN, fdweb
						GOTO, SUITE
						
					END
					clweb_no = val_to_str(clweb_no_new)
					general  = generals[clweb_no]
					graphics = get(general,'graphics')
					device = get(general,'device')

				END


				IF device -> ouvrir() EQ -1 THEN EXIT, status=151
					
				IF requette EQ 'DEVICE_ORIENTATION' THEN BEGIN

					traiter_requette, requette, clweb_no, state, repweb=repweb

				END ELSE IF STRMID(requette,0,9) EQ 'SIZE_PLUS' THEN BEGIN

					infos[clweb_no].valD += LONG(STRMID(requette,9,STRLEN(requette)-9))
					set, general, 'clweb_valD', infos[clweb_no].valD
					graphics -> gvoir, /refresh

				END ELSE IF STRMID(requette,0,10) EQ 'SIZE_MOINS' THEN BEGIN

					infos[clweb_no].valD -= LONG(STRMID(requette,10,STRLEN(requette)-10))
					set, general, 'clweb_valD', infos[clweb_no].valD
					graphics -> gvoir, /refresh

				END ELSE IF STRMID(requette,0,4) EQ 'SIZE' THEN BEGIN

					infos[clweb_no].valD = LONG(STRMID(requette,4))
					set, general, 'clweb_valD', infos[clweb_no].valD
					graphics -> gvoir, /refresh

				END ELSE IF STRMID(requette,0,4) EQ 'FONT' THEN BEGIN

					infos[clweb_no].FONTSIZE = LONG(STRMID(requette,4,STRLEN(requette)-4))
					graphics -> gvoir, /refresh

				END ELSE IF STRMID(requette,0,3) EQ 'UI_' THEN BEGIN

					UI = STRMID(requette,3)
					graphics -> gvoir, /refresh

				END ELSE IF requette EQ 'COMPUTE' THEN BEGIN

					traiter_requette, requette, clweb_no, state, repweb=repweb

				END ELSE IF requette EQ 'CACHE_CLEAN_COMPUTE' THEN BEGIN

					traiter_requette, requette, clweb_no, state, repweb=repweb

				END ELSE BEGIN

					; lancement du navigateur avec clweb.php par exemple

					graphics -> gvoir, /refresh

				END

				IF graphics -> estvide() THEN graphics -> welcome

				device -> fermer

				code = get_filelengthc (OUTPUT_PS, taille)
				IF taille EQ 0 THEN BEGIN ; postscript vide
					IF ~graphics -> estvide() THEN BEGIN ; alors qu'il y a des donnes
						; il ne reste qu'un panel composer vide par ex
						IF device -> ouvrir() EQ -1 THEN EXIT, status=151
						graphics -> vide
						device -> fermer
					END
				END

				; Limite valD sous IE:
				;			0	1	2	3	4	5	6	7	8	9	10	11	12	13	14	15
				limite_Landscape = [	0,	0,	0,	0,	0,	0,	0,	0,	0,	30,	36,	36,	37,	43,	44,	44]
				limite_Portrait = [	0,	0,	0,	0,	0,	0,	0,	0,	0,	44,	53,	53,	55,	63,	64,	65]
				valDmini = get(device,'long') LT get(device,'larg') ? limite_Landscape[infos[clweb_no].FONTSIZE]: limite_Portrait[infos[clweb_no].FONTSIZE]

				IF infos[clweb_no].valD LT valDmini THEN infos[clweb_no].valD = valDmini

				; Mettre la date dans le nom du png pour que le cache des navigateurs ne se trompe jamais
				date_to_tu, get_date(), annee, mois, jour, heure, minute, seconde
				NO_PNG++
				OUTPUT_PNG = "/home/clweb/"+login+"/clweb_"+login+"_"+int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)+'_'+int_str_0(heure,2)+int_str_0(minute,2)+int_str_0(LONG(seconde),2)+"_output_normal_"+val_to_str(NO_PNG)+'.png'
				ps2png, 'png16m', val_to_str(infos[clweb_no].valD), OUTPUT_PS, OUTPUT_PNG
				log_png, OUTPUT_PNG, login, annee, mois, jour
				IF fichiers_idem (OUTPUT_PNG, old_OUTPUT_PNG) THEN BEGIN
					PRINT, 'Removing ' + basename(OUTPUT_PNG)
					code = detruire (OUTPUT_PNG)	; ce fichier n'est pas utile
					NO_PNG--			; pour ne pas changer d'image
					OUTPUT_PNG = old_OUTPUT_PNG	; pour ne pas changer d'image
					changer_normal = 0		; pour ne pas changer d'image
				END
				clweb_query_png, OUTPUT_PNG, WIDTH, HEIGHT
				set, general, 'clweb_plot_normal', login+'/'+basename(OUTPUT_PNG)
				set, general, 'clweb_plot_width', val_to_str(WIDTH)
				set, general, 'clweb_plot_height', val_to_str(HEIGHT)

				IF device -> ouvrir() EQ -1 THEN EXIT, status=151
				graphics -> voir_selected_actif
				device -> fermer, /alpha
				NO_ALPHA++
				OUTPUT_ALPHA = "/home/clweb/"+login+"/clweb_"+login+"_"+int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)+'_'+int_str_0(heure,2)+int_str_0(minute,2)+int_str_0(LONG(seconde),2)+"_output_alpha_"+val_to_str(NO_ALPHA)+'.png'
				ps2png, 'pngalpha', val_to_str(infos[clweb_no].valD), OUTPUT_PS, OUTPUT_ALPHA
				IF fichiers_idem (OUTPUT_ALPHA, old_OUTPUT_ALPHA) THEN BEGIN
					PRINT, 'Removing ' + basename(OUTPUT_ALPHA)
					code = detruire (OUTPUT_ALPHA)	; ce fichier n'est pas utile
					NO_ALPHA--			; pour ne pas changer d'image
					OUTPUT_ALPHA = old_OUTPUT_ALPHA	; pour ne pas changer d'image
					changer_alpha = 0		; pour ne pas changer d'image
				END
				clweb_query_png, OUTPUT_ALPHA, WIDTH, HEIGHT
				set, general, 'clweb_plot_alpha', login+'/'+basename(OUTPUT_ALPHA)
				set, general, 'clweb_plot_width', val_to_str(WIDTH)
				set, general, 'clweb_plot_height', val_to_str(HEIGHT)

				set, general, 'clweb_msg', basename(get(graphics,'nom'))+':  ' + graphics -> get_msg("")

				TAILLEA = LONG(44.0*FLOAT(infos[clweb_no].FONTSIZE)/9.0)
				TAILLEB = TAILLEA+4
				TAILLEC = LONG(WIDTH+TAILLEB*2)

				CASE infos[clweb_no].FONTSIZE OF
					 9:	TAILLEL = 16.8
					10:	TAILLEL = 16.8
					11:	TAILLEL = 17.8
					12:	TAILLEL = 19.0
					13:	TAILLEL = 21.0
					14:	TAILLEL = 22.0
					15:	TAILLEL = 23.0
				END
				TAILLED = LONG(80.0*TAILLEL/19.0)
				TAILLEF = LONG(400.0*TAILLEL/19.0)


				; nombre de lignes en fonction de FONTSIZE
				CASE infos[clweb_no].FONTSIZE OF
					 9:	TAILLEM = 36
					10:	TAILLEM = 34
					11:	TAILLEM = 32
					12:	TAILLEM = 30
					13:	TAILLEM = 27
					14:	TAILLEM = 27
					15:	TAILLEM = 27
				END

				VALUE09PX = 'Font size '+val_to_str( 9)+"px"	& IF infos[clweb_no].FONTSIZE EQ  9 THEN VALUE09PX += " *"
				VALUE10PX = 'Font size '+val_to_str(10)+"px"	& IF infos[clweb_no].FONTSIZE EQ 10 THEN VALUE10PX += " *"
				VALUE11PX = 'Font size '+val_to_str(11)+"px"	& IF infos[clweb_no].FONTSIZE EQ 11 THEN VALUE11PX += " *"
				VALUE12PX = 'Font size '+val_to_str(12)+"px"	& IF infos[clweb_no].FONTSIZE EQ 12 THEN VALUE12PX += " *"
				VALUE13PX = 'Font size '+val_to_str(13)+"px"	& IF infos[clweb_no].FONTSIZE EQ 13 THEN VALUE13PX += " *"
				VALUE14PX = 'Font size '+val_to_str(14)+"px"	& IF infos[clweb_no].FONTSIZE EQ 14 THEN VALUE14PX += " *"
				VALUE15PX = 'Font size '+val_to_str(15)+"px"	& IF infos[clweb_no].FONTSIZE EQ 15 THEN VALUE15PX += " *"

				VALUE40   = '&nbsp;40&nbsp;(minimal)'		& IF infos[clweb_no].VALD LE  49                                 THEN VALUE40  += '&nbsp;*'+val_to_str(infos[clweb_no].VALD)
				VALUE50   = '&nbsp;50'				& IF infos[clweb_no].VALD GE  50 AND infos[clweb_no].VALD LE  59 THEN VALUE50  += '&nbsp;*'+val_to_str(infos[clweb_no].VALD)
				VALUE60   = '&nbsp;60'				& IF infos[clweb_no].VALD GE  60 AND infos[clweb_no].VALD LE  69 THEN VALUE60  += '&nbsp;*'+val_to_str(infos[clweb_no].VALD)
				VALUE70   = '&nbsp;70'				& IF infos[clweb_no].VALD GE  70 AND infos[clweb_no].VALD LE  79 THEN VALUE70  += '&nbsp;*'+val_to_str(infos[clweb_no].VALD)
				VALUE80   = '&nbsp;80&nbsp;(normal)'		& IF infos[clweb_no].VALD GE  80 AND infos[clweb_no].VALD LE  89 THEN VALUE80  += '&nbsp;*'+val_to_str(infos[clweb_no].VALD)
				VALUE90   = '&nbsp;90'				& IF infos[clweb_no].VALD GE  90 AND infos[clweb_no].VALD LE  99 THEN VALUE90  += '&nbsp;*'+val_to_str(infos[clweb_no].VALD)
				VALUE100  = '100'				& IF infos[clweb_no].VALD GE 100 AND infos[clweb_no].VALD LE 109 THEN VALUE100 += '&nbsp;*'+val_to_str(infos[clweb_no].VALD)
				VALUE110  = '110'				& IF infos[clweb_no].VALD GE 110 AND infos[clweb_no].VALD LE 119 THEN VALUE110 += '&nbsp;*'+val_to_str(infos[clweb_no].VALD)
				VALUE120  = '120&nbsp;(1900x1080)'		& IF infos[clweb_no].VALD GE 120 AND infos[clweb_no].VALD LE 129 THEN VALUE120 += '&nbsp;*'+val_to_str(infos[clweb_no].VALD)
				VALUE130  = '130'				& IF infos[clweb_no].VALD GE 130 AND infos[clweb_no].VALD LE 139 THEN VALUE130 += '&nbsp;*'+val_to_str(infos[clweb_no].VALD)
				VALUE140  = '140'				& IF infos[clweb_no].VALD GE 140 AND infos[clweb_no].VALD LE 149 THEN VALUE140 += '&nbsp;*'+val_to_str(infos[clweb_no].VALD)
				VALUE150  = '150'				& IF infos[clweb_no].VALD GE 150                                 THEN VALUE150 += '&nbsp;*'+val_to_str(infos[clweb_no].VALD)

				dx_mire 			= val_to_str(WIDTH)
				dy_mire 			= val_to_str(HEIGHT)
				idl_about 			= msg_idl_about(general)
				cl_about 			= msg_cl_about(general)
				idl_majuscule			= is_gdl() ? 'GDL' : (is_fdl() ? 'FDL' : 'IDL')
				idl_minuscule			= is_gdl() ? 'gdl' : (is_fdl() ? 'fdl' : 'idl')
				clweb_msg 			= get(general,'clweb_msg')
				clweb_form 			= get(general,'clweb_form')
				clweb_mire 			= get(general,'clweb_mire')
				clweb_plot_normal 		= get(general,'clweb_plot_normal')
				clweb_plot_alpha 		= get(general,'clweb_plot_alpha')
				clweb_plot_width 		= get(general,'clweb_plot_width')
				clweb_plot_height		= get(general,'clweb_plot_height')
				clweb_title 			= 'CLWeb ('+login+':'+clweb_no+')'
				clweb_timeout_inactivity 	= val_to_str(get (general, 'timeout_inactivity'))
				clweb_timeout 			= val_to_str(get (general, 'timeout'))
				upload_max 			= val_to_str(get (general, 'clweb_max_file_size')/1024/1024)
				
				FONTSIZE = val_to_str(infos[clweb_no].FONTSIZE)+"px"
				TAILLEA  = val_to_str(TAILLEA)
				TAILLEB  = val_to_str(TAILLEB)
				TAILLEC  = val_to_str(TAILLEC)
				TAILLED  = val_to_str(TAILLED)
				TAILLEF  = val_to_str(TAILLEF)
				TAILLEL  = val_to_str(TAILLEL)
				TAILLEM  = val_to_str(TAILLEM)

				debug = GETENV('CLWEB_DEV') EQ val_to_str(1) ? val_to_str(1) : val_to_str(0)

				; Debut creation page html
				top1a = nbsec()
				OPENR, fd1, RESOURCE+"clweb.html", /GET_LUN
				OPENW, fdweb, OUTPUT, /GET_LUN
				WHILE ~EOF(fd1) DO BEGIN
					READF, fd1, ligne
					IF ligne EQ '$MENU_ADD' THEN BEGIN

						menu_add, "Badd", state, RESOURCE, "n", fdweb=fdweb, clweb_no=clweb_no, UI

					END ELSE BEGIN

						remplacer, ligne, "$ERASE_COOKIE_DYNATREE", ERASE_COOKIE_DYNATREE

						remplacer, ligne, "$UI_NORMAL", UI EQ "NORMAL" ? "" : "//"
						remplacer, ligne, "$UI_SIMPLE", UI EQ "SIMPLE" ? "" : "//"

						remplacer, ligne, "$FONTSIZE", 			FONTSIZE
						remplacer, ligne, "$TAILLEA", 			TAILLEA
						remplacer, ligne, "$TAILLEB", 			TAILLEB
						remplacer, ligne, "$TAILLEC", 			TAILLEC
						remplacer, ligne, "$TAILLED", 			TAILLED
						remplacer, ligne, "$TAILLEF", 			TAILLEF
						remplacer, ligne, "$TAILLEL", 			TAILLEL
						remplacer, ligne, "$TAILLEM", 			TAILLEM

						remplacer, ligne, "$VALUE09PX", 		VALUE09PX
						remplacer, ligne, "$VALUE10PX", 		VALUE10PX
						remplacer, ligne, "$VALUE11PX", 		VALUE11PX
						remplacer, ligne, "$VALUE12PX", 		VALUE12PX
						remplacer, ligne, "$VALUE13PX", 		VALUE13PX
						remplacer, ligne, "$VALUE14PX", 		VALUE14PX
						remplacer, ligne, "$VALUE15PX", 		VALUE15PX

						remplacer, ligne, "$VALUE40",			VALUE40
						remplacer, ligne, "$VALUE50",			VALUE50
						remplacer, ligne, "$VALUE60",			VALUE60
						remplacer, ligne, "$VALUE70",			VALUE70
						remplacer, ligne, "$VALUE80",			VALUE80
						remplacer, ligne, "$VALUE90",			VALUE90
						remplacer, ligne, "$VALUE100",			VALUE100
						remplacer, ligne, "$VALUE110",			VALUE110
						remplacer, ligne, "$VALUE120",			VALUE120
						remplacer, ligne, "$VALUE130",			VALUE130
						remplacer, ligne, "$VALUE140",			VALUE140
						remplacer, ligne, "$VALUE150",			VALUE150

						remplacer, ligne, "$DX_MIRE", 			dx_mire
						remplacer, ligne, "$DY_MIRE", 			dy_mire
						remplacer, ligne, "$IDL_MAJUSCULE", 		idl_majuscule
						remplacer, ligne, "$IDL_MINUSCULE", 		idl_minuscule
						remplacer, ligne, "$IDL_ABOUT", 		idl_about
						remplacer, ligne, "$CL_ABOUT", 			cl_about
						remplacer, ligne, "$CLWEB_FORM", 		clweb_form
						remplacer, ligne, "$CLWEB_PLOT_NORMAL", 	clweb_plot_normal
						remplacer, ligne, "$CLWEB_PLOT_ALPHA", 		clweb_plot_alpha
						remplacer, ligne, "$CLWEB_PLOT_WIDTH", 		clweb_plot_width
						remplacer, ligne, "$CLWEB_PLOT_HEIGHT",		clweb_plot_height
						remplacer, ligne, "$CLWEB_MSG", 		clweb_msg
						remplacer, ligne, "$CLWEB_TITLE", 		clweb_title
						remplacer, ligne, "$CLWEB_MIRE", 		clweb_mire
						remplacer, ligne, "$DOWNLOAD", 			login+'/work'
						remplacer, ligne, "$CLWEB_TIMEOUT_INACTIVITY", 	clweb_timeout_inactivity
						remplacer, ligne, "$CLWEB_TIMEOUT_PLOT", 	clweb_timeout
						remplacer, ligne, "$DOC_CL", 			'cldoc.txt'
						remplacer, ligne, "$LOG1_CL", 			login+'/clweb_'+login+'_log1'
						remplacer, ligne, "$LOG2_CL", 			login+'/clweb_'+login+'_log2'
						remplacer, ligne, "$UPLOAD_MAX", 		upload_max
						remplacer, ligne, "$CLWEB_NO", 			clweb_no
						remplacer, ligne, "$DEBUG", 			debug

						taille = STRLEN(ligne)
						debut = 0L
						fin = taille-1

						; suppression des blancs et tabulations en dbut de ligne
						FOR i=0L,taille-1 DO BEGIN
							c = STRMID(ligne,i,1)
							IF c EQ ' ' OR c EQ STRING(9b) THEN BEGIN
								debut = i+1
							END ELSE BEGIN
								BREAK
							END
						END

						; suppression de ce qui est apres // (sauf dans les strings)
						inside_string1 = 0
						inside_string2 = 0
						FOR i=debut,taille-1 DO BEGIN
							c = STRMID(ligne,i,1)
							IF c EQ "'" THEN inside_string1 = inside_string1 ? 0 : 1
							IF inside_string1 THEN CONTINUE
							IF c EQ '"' THEN inside_string2 = inside_string2 ? 0 : 1
							IF inside_string2 THEN CONTINUE
							IF c EQ '/' THEN BEGIN
								IF i+1 NE taille THEN BEGIN
									c = STRMID(ligne,i+1,1)
									IF c EQ '*' THEN EXIT, STATUS=151	; je ne veux pas de '/*'
									IF c EQ '/' THEN BEGIN
										fin = i-1
										BREAK
									END
								END
							END
						END
						IF debut LT taille AND fin LT taille AND debut LE fin THEN BEGIN
							ligne = STRMID(ligne,debut,fin-debut+1)
							PRINTF, fdweb, ligne
						END
					END
				END
				FREE_LUN, fd1
				FREE_LUN, fdweb
				ERASE_COOKIE_DYNATREE = val_to_str(0)
				; Fin creation page html
				top2a = nbsec()
				code = get_filelengthc (OUTPUT, taille)
				PRINT,'HTML size = '+val_to_str(taille)+' bytes in ' + val_to_str_2decimales(top2a-top1a)+' sec'

			END
SUITE:

			code = detruire (INPUT)
			code = detruire (OUTPUT_BUSY)

			code = detruire (OUTPUT_PS)

			OPENW, fd, OUTPUT_OK, /GET_LUN
			FREE_LUN, fd

			set, general, 'clweb_FONTSIZE', infos[clweb_no].FONTSIZE
			set, general, 'clweb_valD', infos[clweb_no].valD

			IF NO_PNG NE 1 THEN IF changer_normal NE 0 THEN code = detruire (old_OUTPUT_PNG)
			old_OUTPUT_PNG = OUTPUT_PNG

			IF NO_ALPHA NE 1 THEN IF changer_alpha THEN code = detruire (old_OUTPUT_ALPHA)
			old_OUTPUT_ALPHA = OUTPUT_ALPHA

			IF requette NE 'MOUSE_CLICK' AND requette NE 'MOUSE_MOVE' AND requette NE 'ZOOMMOUSE_TIME_ACTIF' THEN BEGIN
				graphics -> wait_raz_t1_t2,0
			END

			set, general, 'clweb_form',		''
			set, general, 'clweb_plot_normal', 	''
			set, general, 'clweb_plot_alpha', 	''
			set, general, 'clweb_plot_width', 	''
			set, general, 'clweb_plot_height',	''
			;set, general, 'clweb_msg', 		''
			set, general, 'clweb_dialog', 		''
			set, general, 'clweb_alert', 		''

			top_fin = nbsec()
			PRINT, '*** TOTAL '+val_to_str_2decimales(top_fin-top_debut)+' sec ***'
		
			top1 = nbsec()

		END

		; attendre 0.01 seconde
		WAIT, 0.01

	END

END
