;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: clvm.pro,v $, v $Revision: 1.22 $
;
;	Date	: $Date: 2018/12/21 10:00:19 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
FUNCTION my_command_line_args
;-------------------------------------------------------------------------------
; Pour les versions d'IDL (<6.2) qui ne definissent pas command_line_args
;-------------------------------------------------------------------------------

	RETURN, !VERSION.RELEASE LT 6.2 ? [ GETENV('HOME'), '0', '0', '0' ] : COMMAND_LINE_ARGS()

END


;-------------------------------------------------------------------------------
PRO clvm
;-------------------------------------------------------------------------------
; Point d'entre de clvm
;-------------------------------------------------------------------------------

	argv = my_command_line_args ()
	argc = N_ELEMENTS(argv)

	PWD	= is_windows() ? ''                  : argv[0]
	true	= is_windows() ? FILE_TEST ('true')  : LONG(argv[1])
	bench	= is_windows() ? FILE_TEST ('bench') : LONG(argv[2])
	int	= is_windows() ? FILE_TEST ('int')   : LONG(argv[3])
	rt	= is_windows() ? FILE_TEST ('rt')    : LONG(argv[4])
	web	= is_windows() ? FILE_TEST ('web')   : LONG(argv[5])
	login	= is_windows() ? FILE_TEST ('login') : argv[6]
	batch	= is_windows() ? FILE_TEST ('batch') : LONG(argv[7])
	nomcl	= is_windows() ? ''                  : (argc EQ 9 ? argv[8] : '')

	IF is_windows() THEN BEGIN

		IF GETENV('CIS_ROOT') EQ '' THEN SETENV, 'CIS_ROOT=/DATA/CLUSTER'
		IF GETENV('CL_ROOT')  EQ '' THEN SETENV, 'CL_ROOT=/DATA/CLUSTER/SOFT/CLL3'

	END ELSE BEGIN

		CD, PWD 			; Revenir sur le rpertoire ou a t lanc clvm

	END
	RESTORE, GETENV('CL_ROOT')+'/bin/cl.ivm'

	cl, true, bench, int, rt, web, login, batch, nomcl

END
