;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: cluster.pro,v $, v $Revision: 1.24 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO cluster,	$
;-------------------------------------------------------------------------------
	fichier_parametres	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Utilis historiquement pour crer des tracs dans la chaine de traitement du CNES.
;-------------------------------------------------------------------------------

	UTILISER_PROFILER = 0

	IF UTILISER_PROFILER THEN PROFILER

	SET_PLOT,'ps' ; pour ne pas charger de couleurs sous X11

	nbproduit = 63
	nbcis     = 3
	nbsat     = 4

	; ----------------------
	; Creation objet general
	; ----------------------
	general = OBJ_NEW('general',1)

	; --------------------
	; Creation objet cache
	; --------------------
	; Au CNES, on prend un cache enorme que l'on ne doit pas atteindre: 1000 Mb!
	cache = OBJ_NEW ('cache',nbproduit,nbcis+1,nbsat+1,1000)
	set, general, 'cache', cache

	; ------------------
	; Creation objet pal
	; ------------------
	pal = OBJ_NEW ('pal')
	set, general,'pal', pal

	; -------------------
	; Creation objet para
	; -------------------
	para        = OBJ_NEW ('para',fichier_parametres)
	nosat       = FIX(get(para,'Satellite'))
	ann         = FIX(get(para,'Annee'))
	moi         = FIX(get(para,'Mois'))
	jou         = FIX(get(para,'Jour'))
	nbjours = date_to_nbjours (tu_to_date (ann, moi, jou, 0, 0, 0))
	ntrace      = FIX(get(para,'Niveau_trace'))
	COD_SPECTRO = get(para,'COD_SPECTRO')
	HIA_SPECTRO = get(para,'HIA_SPECTRO')

	; ----------------------
	; Creation objet version
	; ---------------------
	version = OBJ_NEW ('version')
	set, general, 'version', version

	; ----------------------------
	; Creation des objets produits 
	; ----------------------------
	p = OBJARR(nbproduit,nbcis+1,nbsat+1)
	cluster_path = '/DATA/CLUSTER/DATA'
	nb = 0
	PRINT,'Begin products: ', FORMAT='(A,$)' 

	cis = 1
	FOR produit=0L,nbproduit-1 DO BEGIN
		p[produit,cis,nosat] = OBJ_NEW ('produit',produit,cis,nosat,general, qcis=produit NE 0)
		IF OBJ_VALID(p[produit,cis,nosat]) THEN BEGIN
			var = 'COD_' + int_str_0(produit,2)
			novar = para -> getnovar(var)
			batchname = novar EQ -1 ? '*' : get(para,var)
			p[produit,cis,nosat] -> psetproperty,batchname=batchname,batchnbjours=nbjours
			nb++
		END
	END

	cis = 2
	FOR produit=0L,nbproduit-1 DO BEGIN
		p[produit,cis,nosat] = OBJ_NEW ('produit',produit,cis,nosat,general, qcis=produit NE 0)
		IF OBJ_VALID(p[produit,cis,nosat]) THEN BEGIN
			var = 'HIA_' + int_str_0(produit,2)
			novar = para -> getnovar(var)
			batchname = novar EQ -1 ? '*' : get(para,var)
			p[produit,cis,nosat] -> psetproperty,batchname=batchname,batchnbjours=nbjours
			nb++
		END
	END

	ind = [1,2]
	nom = ['ORBIT','PPD']
	cis = 3
	FOR iproduit=0L,N_ELEMENTS(ind)-1 DO BEGIN
		produit = ind[iproduit]
		p[produit,cis,nosat] = OBJ_NEW ('produit',produit,cis,nosat,general, qcis=iproduit NE 0)
		IF OBJ_VALID(p[produit,cis,nosat]) THEN BEGIN
			var = nom[iproduit]+'_file'
			batchname = get(para,var)
			p[produit,cis,nosat] -> psetproperty,batchname=batchname,batchnbjours=nbjours
			nb++
		END
	END

	PRINT, val_to_str(nb),' valid'
	set, general, 'p', p
	set, general,'cluster_path',cluster_path
	OBJ_DESTROY, para

	; ----------------------
	; Creation objet device
	; ----------------------
	device = OBJ_NEW ('device',COD_SPECTRO,'PS',general)
	set, general, 'device', device

	; -----------------------
	; Creation objet graphics
	; -----------------------
	graphics = OBJ_NEW ('graphics',general)
	set, general, 'graphics', graphics
	tab = [ 		$
		'count',	$
		'header',	$
		'title',	$
		'copyright',	$
		'orbito',	$
		'text',		$
		'image']
		graphics -> init_tabadd, tab

	clname = GETENV('TAB_PATH')+['/cnesonly_codif', '/cnesonly_hia']
	psname = [COD_SPECTRO, HIA_SPECTRO]

	FOR i=0L,1 DO BEGIN

		set, general,'batch',1 ; pour ne pas utiliser les widgets en cas de messages
		set, general,'usedico','No' ; pas de compression des donnes
		set, general,'usedico_aspera3','No' ; pas de compression des donnes
		set, general,'usedico_aspera4','No' ; pas de compression des donnes
		cl_msg, general, str_bas=' '
		graphics -> chargercl, nomfichier=clname[i],/novoir

		set, general,'ntrace',ntrace
		set, general,'batch',1
		set, device, 'nom', psname[i]
		set, device, 'driver', 'PS'

		IF device -> ouvrir() EQ -1 THEN EXIT, status=151

		FOR deb=0L,20,4 DO BEGIN

			t1 = tu_to_date (ann, moi, jou, deb, 0, 0)
			t2 = t1 + 4d*3600d*1000d
			str_t1 = date_to_str (t1, format=1)
			str_t2 = date_to_str (t2, format=1)
			str_nosat = int_str_(nosat,1)

			graphics -> cnes_setproperty, str_nosat, str_t1, str_t2
			graphics -> cnes_compute

			libplot_plot, [1,2], [1,2], /nodata, xstyle=5, ystyle=5 ; changement de page
			cache -> raz, general ; vide le cache
		END

		device -> fermer
	END


	IF UTILISER_PROFILER THEN ecrire_profiler, 0.0, 'profiler'

	PRINT, ''
	PRINT, 'Terminaison IDL correcte'

	EXIT, status=0

END
