;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: calculator__define.pro,v $, v $Revision: 1.10 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO calculator::eval,	$
;-------------------------------------------------------------------------------
	resultat,	$	; LINT_PROTOTYPE output
	erreur,		$	; LINT_PROTOTYPE output
	erreur_msg		; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne le rsultat de l'expression, un code d'erreur et l'erreur dans une chaine de caractres.
;-------------------------------------------------------------------------------

	resultat 	= 0d
	erreur 		= 0L
	erreur_msg  	= ''
	expression	= get (self,'expression')

	IF is_fdl() THEN BEGIN
		erreur_msg = REPLICATE (0b, 1024)
		lint_unused = CALL_EXTERNAL (libname('file'), 'EVALUER_SIMPLE_AUTO_GLUE', expression, resultat, erreur, erreur_msg, /AUTO_GLUE)
		erreur_msg = STRING(erreur_msg)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('file'), 'EVALUER_SIMPLE', expression, resultat, erreur, erreur_msg)
	END

END

;-------------------------------------------------------------------------------
FUNCTION calculator::init
;-------------------------------------------------------------------------------
; Constructeur de la classe "calculator".
;-------------------------------------------------------------------------------

	param = [ { var_obj, 'Calculator:Expression', 'expression', 1, PTR_NEW(['TE','2','80']), 'check_always_ok', PTR_NEW(), PTR_NEW('') }]

	code = self -> obj::init (1, -1, -1, param,/saisissable)

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO calculator__define
;-------------------------------------------------------------------------------
; La classe "calculator" hrite de "obj".
;-------------------------------------------------------------------------------

	lint_unused = { calculator,	$

		INHERITS obj		$

	}

END
