;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: cache__define.pro,v $, v $Revision: 1.38 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO cache::setproperty,	$
;-------------------------------------------------------------------------------
	nom,				$	; LINT_PROTOTYPE input
	val,				$	; LINT_PROTOTYPE input
	passaveold = passaveold			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Positionne une variable  une valeur (fait un raz du cache si on change sa taille).
;-------------------------------------------------------------------------------

	IF nom EQ 'taillemax' THEN BEGIN
		general = self.general
		self -> raz,general
	END

	self -> obj::setproperty, nom, val,passaveold=passaveold

END


;-------------------------------------------------------------------------------
PRO cache::etat_cache,	$
;-------------------------------------------------------------------------------
	general,	$	; LINT_PROTOTYPE input
	nodebug=nodebug		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche l'tat du cache  l'aide des 3 widgets 'val_etat_cache', 'val_v1_cache' et 'val_v2_cache'.
;-------------------------------------------------------------------------------

	IF get (general, 'batch') THEN RETURN

	IF N_ELEMENTS(nodebug) EQ 0 THEN nodebug = 0
	debug = get (self,'debug') NE 'No' ? 1 : 0
	IF ~nodebug AND ~debug THEN RETURN

	valeur = 100.*get(self, 'taille')/(get(self,'taillemax')*1e6)

	IF valeur LT 0 THEN valeur = 0.
	IF valeur GT 99 THEN valeur = 99.
	RESOURCE_PATH = GETENV ('CL_ROOT')+'/resource/'

	deb = 10*FIX(valeur/10)
	fin = deb EQ 90 ? 0 : deb+10

	etat_cache = get (general,'etat_cache')
	IF WIDGET_INFO (etat_cache, /VALID_ID) THEN BEGIN
		img = 'etat_'+int_str_0(deb,2)+'_'+int_str_0(fin,2)
		val_etat_cache = RESOURCE_PATH + 'images/' + img+'.bmp'
		IF 100.*get(self, 'taille')/(get(self,'taillemax')*1e6) GT 100 THEN val_etat_cache = RESOURCE_PATH + 'images/PLAYP0.bmp'
		IF get (general,'val_etat_cache') NE val_etat_cache THEN BEGIN
			IF is_gdl() THEN BEGIN ; ok
				; sinon "% WIDGET_CONTROL: Unable to read image file: /home/penou/DATA/CLUSTER/SOFT/CLL3/resource/images/etat_00_10.bmp"
			END ELSE BEGIN
				WIDGET_CONTROL, etat_cache, set_value=val_etat_cache,/BITMAP
			END
			set, general, 'val_etat_cache', val_etat_cache
		END
	END

	v1_cache = get (general,'v1_cache')
	IF WIDGET_INFO (v1_cache, /VALID_ID) THEN BEGIN
		v1 = FIX (valeur/10)
		val_v1_cache = RESOURCE_PATH + 'images/chiffre_'+val_to_str(v1)+'.bmp'
		IF get (general,'val_v1_cache') NE val_v1_cache THEN BEGIN
			IF is_gdl() THEN BEGIN ; ok
				; sinon "% WIDGET_CONTROL: Unable to read image file: /home/penou/DATA/CLUSTER/SOFT/CLL3/resource/images/chiffre_0.bmp"
			END ELSE BEGIN
				WIDGET_CONTROL, v1_cache, set_value=val_v1_cache,/BITMAP
			END
			set, general, 'val_v1_cache', val_v1_cache
		END
	END

	v2_cache = get (general,'v2_cache')
	IF WIDGET_INFO (v2_cache, /VALID_ID) THEN BEGIN
		v2 = FIX (valeur - 10*v1)
		val_v2_cache = RESOURCE_PATH + 'images/chiffre_'+val_to_str(v2)+'.bmp'
		IF get (general,'val_v2_cache') NE val_v2_cache THEN BEGIN
			IF is_gdl() THEN BEGIN ; ok
				; sinon "% WIDGET_CONTROL: Unable to read image file: /home/penou/DATA/CLUSTER/SOFT/CLL3/resource/images/chiffre_0.bmp"
			END ELSE BEGIN
				WIDGET_CONTROL, v2_cache, set_value=val_v2_cache,/BITMAP
			END
			set, general, 'val_v2_cache', val_v2_cache
		END
	END

END

;-------------------------------------------------------------------------------
PRO cache::anim_cache,	$
;-------------------------------------------------------------------------------
	general,	$	; LINT_PROTOTYPE input
	full=full,	$	; LINT_PROTOTYPE input
	nodebug=nodebug		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche l'tat du cache dans le widget 'val_anim_cache'
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(nodebug) EQ 0 THEN nodebug = 0
	debug = get (self,'debug') NE 'No' ? 1 : 0
	IF ~nodebug AND ~debug THEN RETURN

	IF N_ELEMENTS(full) EQ 1 THEN set, self, 'full', full

	full = get (self,'full')
	RESOURCE_PATH = GETENV ('CL_ROOT')+'/resource/'
	IF get(self,'arret') GE 1 THEN BEGIN
		full = 3
		set, self, 'full', full
	END

	IF get (general, 'batch') THEN RETURN

	img = ['PLAYA1','PLAYJ0','PLAYO0','PLAYC5'] & img = img[full]

	; utilis en mode 'special' qui est obsolte
	; img = ['','PLAYF1'] & img=img[special]

	val_anim_cache = RESOURCE_PATH + 'images/' + img+'.bmp'
	IF get (general, 'val_anim_cache') EQ val_anim_cache THEN BEGIN

		img = ['PLAYC1','PLAYI0','PLAYP0','PLAYD5'] & img = img[full]
		val_anim_cache = RESOURCE_PATH + 'images/' + img+'.bmp'

	END

	IF get (general, 'val_anim_cache') NE val_anim_cache THEN BEGIN

		anim_cache = get (general, 'anim_cache')
		IF ~WIDGET_INFO (anim_cache, /VALID_ID) THEN RETURN

		IF is_gdl() THEN BEGIN ; ok
			; sinon "% WIDGET_CONTROL: Unable to read image file: /home/penou/DATA/CLUSTER/SOFT/CLL3/resource/images/PLAYA1.bmp"
		END ELSE BEGIN
			WIDGET_CONTROL, anim_cache, set_value=val_anim_cache,/BITMAP
		END
		set, general, 'val_anim_cache', val_anim_cache

	END

END

;-------------------------------------------------------------------------------
PRO cache::debug
;-------------------------------------------------------------------------------
; Affiche le dtail du cache dans le terminal.
;-------------------------------------------------------------------------------

	somme = 0d
	FOR nosat=0L,N_ELEMENTS(self.tab[0,0,*])-1 DO BEGIN
		FOR nocis=0L,N_ELEMENTS(self.tab[0,*,0])-1 DO BEGIN
			FOR noproduit=0L,N_ELEMENTS(self.tab[*,0,0])-1 DO BEGIN
				IF self.tab[noproduit,nocis,nosat].taille NE 0 THEN BEGIN
					useby = self.tab[noproduit,nocis,nosat].produit -> pgetproperty(/useby)
					IF useby NE '' THEN useby = ' [useby='+useby+']'
					somme += self.tab[noproduit,nocis,nosat].taille
					PRINT, STRING(nocis_val_to_string(nocis),format='(A20)')+' P'+int_str_0(noproduit,3)+' SAT'+STRING(nosat,format='(I1)')+':'+	$
						'  '+STRING(self.tab[noproduit,nocis,nosat].taille*100.0/(get(self,'taillemax')*1e6),format='(F12.2)')+' %'+ 		$
						'  '+STRING(LONG64(self.tab[noproduit,nocis,nosat].taille),format='(I12)')+							$
						'  '+STRING(LONG64(self.tab[noproduit,nocis,nosat].taille0),format='(I12)')+							$
						'  '+STRING(LONG64(self.tab[noproduit,nocis,nosat].taillemom),format='(I12)')+useby
				END
			END
		END
	END
	PRINT,STRING('TOTAL:',FORMAT='(A31)') + '  '+STRING(somme*100.0/(get(self,'taillemax')*1e6),format='(F12.2)')+' %'+'  '+STRING(LONG64(somme),format='(I12)')

END

;-------------------------------------------------------------------------------
PRO cache::info,	$
;-------------------------------------------------------------------------------
	noproduit,	$	; LINT_PROTOTYPE input
	nocis,		$	; LINT_PROTOTYPE input
	nosat,		$	; LINT_PROTOTYPE input
	utilise,	$	; LINT_PROTOTYPE output
	dispo,		$	; LINT_PROTOTYPE output
	extend=extend		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne la taille utilise, la taille disponible (la taille dispo sera extend si ce paramtre est fourni).
;-------------------------------------------------------------------------------

	; ex: /home/penou/DATA/CLUSTER/SOFT/CLL3/resource/demeter_RLONG_RLAT_ICE_070.0kHz_100.0kHz_jour.cl.gz
	; idl = 5.9604645e-06 sec
	; gdl = 2.1934509e-05 sec
	utilise = self.tab[noproduit,nocis,nosat].taille

	dispo = get (self, 'taillemax')*1e6 - get (self, 'taille')
	IF N_ELEMENTS(extend) NE 0 THEN BEGIN
		IF dispo LT extend THEN dispo = extend ; on se garde extend pour travailler
	END

END

;-------------------------------------------------------------------------------
PRO cache::free,	$
;-------------------------------------------------------------------------------
	general,			$	; LINT_PROTOTYPE input
	noproduit=noproduit,		$	; LINT_PROTOTYPE input
	nocis=nocis,			$	; LINT_PROTOTYPE input
	nosat=nosat,			$	; LINT_PROTOTYPE input
	indice=indice,			$	; LINT_PROTOTYPE input
	cleanfilename=cleanfilename,	$	; LINT_PROTOTYPE input
	nocleanpara=nocleanpara,	$	; LINT_PROTOTYPE input
	info=info,			$	; LINT_PROTOTYPE input
	onlycount=onlycount,		$	; LINT_PROTOTYPE input
	full=full				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Efface les donnes d'un produit defini par noproduit,nocis,nosat ou indice et met a jour les infos du cache .
;-------------------------------------------------------------------------------

	self -> anim_cache, general, full=full

	IF N_ELEMENTS(onlycount) EQ 0 THEN onlycount = 0

	IF N_ELEMENTS(indice) THEN BEGIN
		tmp = self.tab[indice]
	END ELSE BEGIN
		tmp = self.tab[noproduit,nocis,nosat]
	END

	produit = tmp.produit
	IF ~OBJ_VALID(produit) THEN BEGIN
		RETURN
	END

	produit -> produit_remove_data, cleanfilename=cleanfilename, nocleanpara=nocleanpara, info=info, onlycount=onlycount

	IF onlycount THEN BEGIN
		taille_free = tmp.taille - tmp.taille0 -  tmp.taillemom
	END ELSE BEGIN
		taille_free = tmp.taille
	END

	IF taille_free EQ 0 THEN BEGIN
		RETURN
	END

	hash = self -> gethash()
	setq, self, 'taille', hash.taille, getq (self, hash.taille) - taille_free
	IF onlycount THEN BEGIN ; on enleve les coups
		tmp.taille = tmp.taille0 + tmp.taillemom
		tmp.taille0 = 0
	END ELSE BEGIN ; on enleve tout
		tmp.taille = 0
		tmp.taille0 = 0
		tmp.taillemom = 0
	END

	IF N_ELEMENTS(indice) THEN BEGIN
		self.tab[indice] = tmp
	END ELSE BEGIN
		self.tab[noproduit,nocis,nosat] = tmp
	END

	self -> etat_cache, general

END

;-------------------------------------------------------------------------------
PRO cache::alloc,	$
;-------------------------------------------------------------------------------
	noproduit,	$	; LINT_PROTOTYPE input
	nocis,		$	; LINT_PROTOTYPE input
	nosat,		$	; LINT_PROTOTYPE input
	alloc,		$	; LINT_PROTOTYPE input
	alloc0,		$	; LINT_PROTOTYPE input
	allocmom,	$	; LINT_PROTOTYPE input
	general,	$	; LINT_PROTOTYPE input
	nodeb,		$	; LINT_PROTOTYPE input
	jodeb,		$	; LINT_PROTOTYPE input
	nofin,		$	; LINT_PROTOTYPE input
	jofin			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Un produit defini par noproduit,nocis,nosat demande d'allouer alloc octets: les infos du cache sont mises a jour.
;-------------------------------------------------------------------------------

	self -> anim_cache, general
	hash = self -> gethash()

	tmp = self.tab[noproduit,nocis,nosat]

	diff = alloc - tmp.taille

	tmp.taille = alloc
	tmp.taille0 = alloc0
	tmp.taillemom = allocmom

	IF jodeb GE tmp.jodeb AND nodeb GE tmp.nodeb AND jofin LE tmp.jofin AND nofin LE tmp.nofin THEN BEGIN
		self -> anim_cache, general, full=1, /nodebug ; lecture d'un produit qui a disparu du cache
	END

	tmp.nodeb = nodeb
	tmp.jodeb = jodeb
	tmp.nofin = nofin
	tmp.jofin = jofin

	self.tab[noproduit,nocis,nosat] = tmp

	setq, self, 'taille', hash.taille, getq (self, hash.taille) + diff
	self -> etat_cache, general

END

;-------------------------------------------------------------------------------
PRO cache::cache_add,	$
;-------------------------------------------------------------------------------
	noproduit,	$	; LINT_PROTOTYPE input
	nocis,		$	; LINT_PROTOTYPE input
	nosat,		$	; LINT_PROTOTYPE input
	produit			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Initialise l'entre [noproduit,nocis,nosat] avec un produit.
;-------------------------------------------------------------------------------

	self.tab[noproduit,nocis,nosat] = { info_cache, 					$
							produit:	produit, 		$
							taille:		0d, 			$
							taille0:	0d, 			$
							taillemom:	0d, 			$
							nodeb:		0L, 			$
							jodeb:		0L, 			$
							nofin:		0L, 			$
							jofin:		0L, 			$
							noproduit:	noproduit, 		$
							nocis:		nocis, 			$
							nosat:		nosat, 			$
							temps:		!VALUES.D_INFINITY }

END

;-------------------------------------------------------------------------------
PRO cache::ctime,	$
;-------------------------------------------------------------------------------
	noproduit,	$	; LINT_PROTOTYPE input
	nocis,		$	; LINT_PROTOTYPE input
	nosat			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Modifie le temps de l'entre [noproduit,nocis,nosat]
;-------------------------------------------------------------------------------

	self.tab[noproduit,nocis,nosat].temps = SYSTIME(1)

END


;-------------------------------------------------------------------------------
PRO cache::raz_no_jo
;-------------------------------------------------------------------------------
; Met  0 les valeurs nodeb, jodeb, nofin et jofin de toutes les entres.
;-------------------------------------------------------------------------------

	self.tab.nodeb = 0
	self.tab.jodeb = 0
	self.tab.nofin = 0
	self.tab.jofin = 0

END

;-------------------------------------------------------------------------------
PRO cache::start
;-------------------------------------------------------------------------------
; Modifie le temps de start (au dbut d'un trac).
;-------------------------------------------------------------------------------

	self.start = SYSTIME(1)	; nombre de secondes depuis 1/1/1970


END

;-------------------------------------------------------------------------------
FUNCTION cache::get_temps,	$
;-------------------------------------------------------------------------------
	noproduit,		$	; LINT_PROTOTYPE input
	nocis,			$	; LINT_PROTOTYPE input
	nosat				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne la date de la dernire mise a jour des donnes d'un produit (en sec depuis le 1/1/1970)
;-------------------------------------------------------------------------------
	RETURN, self.tab[noproduit,nocis,nosat].temps

END


;-------------------------------------------------------------------------------
PRO cache::raz,	$
;-------------------------------------------------------------------------------
	general	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Supprime les donnes de tous les produits connus par le cache.
;-------------------------------------------------------------------------------

	nbproduit = N_ELEMENTS(self.tab[*,0,0])
	nbcis = N_ELEMENTS(self.tab[0,*,0])
	nbsat = N_ELEMENTS(self.tab[0,0,*])-1
	FOR nocis=0L,nbcis-1 DO BEGIN
		FOR noproduit=0L,nbproduit-1 DO BEGIN
			FOR nosat=1L,nbsat DO BEGIN
				produit = self.tab[noproduit,nocis,nosat].produit
				IF OBJ_VALID(produit) THEN BEGIN
					produit -> produit_remove_data, /cleanfilename
					self.tab[noproduit,nocis,nosat].taille = 0
					IF is_ascii(nocis) THEN BEGIN
						; mis en commentaire sinon, si le cache est plein, on va perdre les infos sur les fichiers ASCII_CEF_CDF
						;OBJ_DESTROY, produit
					END
				END
			END
		END
	END

	set, self, 'taille', 0.0
	self -> etat_cache, general, /nodebug

END

;-------------------------------------------------------------------------------
FUNCTION cache::check_lock,	$
;-------------------------------------------------------------------------------
	ind	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne les indice des produits qui ne sont pas lockes.
;-------------------------------------------------------------------------------

	ind_nonlock = [-1]
	ind1 = WHERE (self.tab[ind].taille GT 0)
	FOR i=0L,N_ELEMENTS(ind1)-1 DO BEGIN
		produit = self.tab[ind[ind1[i]]].produit
		IF OBJ_VALID(produit) THEN BEGIN
			IF ~produit -> pgetproperty(/lock) THEN ind_nonlock = ind_nonlock[0] EQ -1 ? [ind[ind1[i]]] : [ind_nonlock,ind[ind1[i]]]
		END
	END

	RETURN, ind_nonlock

END


;-------------------------------------------------------------------------------
FUNCTION cache::available_alloc,	$
;-------------------------------------------------------------------------------
	taillealloc,	$	; LINT_PROTOTYPE input
	general,	$	; LINT_PROTOTYPE input
	libre			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Essaye de faire le ncessaire pour qu'il reste taillealloc octets disponible dans le cache.
;
; Il faut donc que taille + taillealloc < taillemax, cad taille < taillemax-taillealloc
;-------------------------------------------------------------------------------

	hash = self -> gethash()

	taillemax = getq (self, hash.taillemax)*1e6 ; nombre d'octets maxi du cache en octets

	ind1 = SORT(self.tab.temps)
	maxi = taillemax - taillealloc

	FOR phase=1L,2 DO BEGIN

		IF phase EQ 1 THEN BEGIN ; on ne touche pas aux produits avec temps GE self.start

			ind = WHERE (self.tab[ind1].temps LT self.start)
			IF ind[0] NE -1 THEN ind = ind1[ind]

		END ELSE BEGIN ; phase 2: on touche  tous les produits

			ind = ind1

		END

		; Ne pas toucher aux produits lock
		ind = self -> check_lock (ind)

		IF ind[0] NE -1 THEN BEGIN

			; Recherche des produits dont les comptages n'ont pas t supprims
			indok = WHERE (self.tab[ind].taille  GT 0 AND $
				       self.tab[ind].taille0 GT 0 AND $
			     	       self.tab[ind].taille  NE self.tab[ind].taille0, nb)

			IF nb NE 0 THEN BEGIN
				; Est-ce suffisant de ne supprimer que les comptages ?
				onlycount = TOTAL (self.tab.taille) 			$	; tous les produits
					    - TOTAL (self.tab[ind[indok]].taille) 	$	; les produits que l'on va toucher
					    + TOTAL (self.tab[ind[indok]].taille0)	$	; les produits que l'on va toucher aprs suppression des comptages
					    + TOTAL (self.tab[ind[indok]].taillemom)	$	; les produits que l'on va toucher taille pour les donnes moments
					    + taillealloc LE taillemax
			END ELSE BEGIN
				onlycount = 0
			END

			IF ~onlycount THEN indok = WHERE (self.tab[ind].taille GT 0, nb)

			i = 0
			WHILE getq (self, hash.taille) GT maxi AND i LT nb DO BEGIN
				self -> free, indice=ind[indok[i]], general, /info, onlycount=onlycount
				i++
			END 

			libre = taillemax - getq (self, hash.taille)
			IF libre GE taillealloc THEN RETURN, libre GE taillealloc
		END

	END

	libre = taillemax - getq (self, hash.taille)
	RETURN, libre GE taillealloc

END


;-------------------------------------------------------------------------------
PRO cache::cleanup
;-------------------------------------------------------------------------------
; Destructeur de la classe "cache".
;-------------------------------------------------------------------------------

	self -> obj::cleanup

END

;-------------------------------------------------------------------------------
FUNCTION cache::init,	$
;-------------------------------------------------------------------------------
	taillemax,	$	; LINT_PROTOTYPE input
	general			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de la classe "cache".
;-------------------------------------------------------------------------------

	param = [ $
		{ var_obj,	'',				'taille',	0,	PTR_NEW(),								'',			PTR_NEW(),	PTR_NEW (0.0)		}, 	$
		{ var_obj,	'',				'arret',	0,	PTR_NEW(),								'',			PTR_NEW(),	PTR_NEW (0L)		}, 	$
		{ var_obj,	'',				'full',		0,	PTR_NEW(),								'',			PTR_NEW(),	PTR_NEW (0L)		}, 	$

		{ var_obj,	'Cache:Cache Size (Mbytes)',	'taillemax',	1,	PTR_NEW(['SL','2','300','1','10240']),					'check_always_ok',	PTR_NEW(),	PTR_NEW(taillemax)	},	$
		{ var_obj,	'Debug mode',			'debug',	1,	PTR_NEW(['B1','2','LABEL_LEFT','No','Yes (reduce performance)']),	'check_always_ok',	PTR_NEW(),	PTR_NEW('No')		}]

	code = self -> obj::init (1,-1,-1,param,general=general,/saisissable)

	RETURN, code

END



;-------------------------------------------------------------------------------
PRO cache__define
;-------------------------------------------------------------------------------
; La classe "cache" hrite de "obj".
;-------------------------------------------------------------------------------

	lint_unused = { info_cache, 			$

		produit:   	OBJ_NEW(), 		$
		taille:    	0d,			$ ; pas de FLOAT sinon erreur d'arrondi lors du clean du cache
		taille0:   	0d,			$ ; pas de FLOAT sinon erreur d'arrondi lors du clean du cache
		taillemom: 	0d,			$ ; pas de FLOAT sinon erreur d'arrondi lors du clean du cache
		nodeb:     	0L,			$
		jodeb:     	0L,			$
		nofin:     	0L,			$
		jofin:     	0L,			$
		noproduit: 	0L,			$
		nocis:     	0L,			$
		nosat:     	0L,			$
		temps:     	!VALUES.D_INFINITY 	$
	}

	lint_unused = { cache, 										$

		INHERITS 	obj,									$
		tab:		REPLICATE ({ info_cache }, !CL.nbproduit, !CL.nbcis+1, !CL.nbsat+1),	$
		start: 		0d									$

	}

END
