;-------------------------------------------------------------------------------
FUNCTION lire_data_aspera3_imaparam,	$
;-------------------------------------------------------------------------------
	filename,	$	; LINT_PROTOTYPE input
	data			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Lit le fichier cdf filename et stocke les donnes dans data.
;
;	Entres:
;	-------
;		filename:	nom du fichier CDF imaextra  traiter
;
;       Retourne:
;       ---------
;               1 si OK
;               0 si PB
;-------------------------------------------------------------------------------

	ON_IOERROR, erreur

	top1 = nbsec()

	nblignes = get_nblignes_cdf_c (filename, 'EPOCH')
	IF nblignes EQ 0 THEN BEGIN
		PRINT, 'AIE *** NBLIGNES=0 ' + filename
		RETURN, 0
	END

	inf = [ ['date',		'EPOCH',		''      ], $
		['Density_P',		'Density_P',		''      ], $
		['Velocity_P',		'Velocity_P',		''      ], $
		['Temperature_P',	'Temperature_P',	''      ], $
		['EnergyThermal_P',	'EnergyThermal_P',	''      ], $
		['Quality_P',		'Quality_P',		''      ], $
		['Density_O',		'Density_O',		''      ], $
		['Velocity_O',		'Velocity_O',		''      ], $
		['Temperature_O',	'Temperature_O',	''      ], $
		['EnergyThermal_O',	'EnergyThermal_O',	''      ], $
		['Quality_O',		'Quality_O',		''      ], $
		['Density_O',		'Density_O',		''      ], $
		['ScanFlag',		'ScanFlag',		''      ]]

	data = REPLICATE ({	date:			0d,			$
				Density_P:		0.0,			$
				Velocity_P:		REPLICATE(0.0,3),	$
				Temperature_P:		0.0,			$
				EnergyThermal_P:	0.0,			$
				Quality_P:		0.0,			$
				Density_O:		0.0,			$
				Velocity_O:		REPLICATE(0.0,3),	$
				Temperature_O:		0.0,			$
				EnergyThermal_O:	0.0,			$
				Quality_O:		0.0,			$
				ScanFlag:		0.0 }, nblignes)
	lire_struct_cdf_c, filename, data, inf[0,*], inf[1,*], inf[2,*], 0, nblignes
	top2 = nbsec()
	PRINT,'Lecture de ' + val_to_str(nblignes)+' lignes avec lire_struct_cdf en ' + val_to_str_2decimales(top2-top1)+' sec'
	RETURN, 1

erreur:
	PRINT, 'AIE *** ' + filename
	RETURN, 0

END

;-------------------------------------------------------------------------------
FUNCTION lire_aspera3_imaparam,	$
;-------------------------------------------------------------------------------
	nom,	$	; LINT_PROTOTYPE input
	data_mom	; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Lit le fichier nom et stocke les donnes dans data_nom.
;-------------------------------------------------------------------------------

	PRINT,'Reading ' + nom

	code = lire_data_aspera3_imaparam (nom, data_mom)
	RETURN, code

END


;-------------------------------------------------------------------------------
FUNCTION get_liste_aspera3_imaparam,	$
;-------------------------------------------------------------------------------
	YYYY,	$	; LINT_PROTOTYPE input
	MM,	$	; LINT_PROTOTYPE input
	DD		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne la liste des fichiers  lire pour crer les donnes de YYY MM DD
;-------------------------------------------------------------------------------

	liste = ''

	date1 = tu_to_date (YYYY,  1,  1, 0, 0, 0)
	date2 = tu_to_date (YYYY, MM, DD, 0, 0, 0)
	DOY = LONG ((date2-date1) / (86400 * 1000d))

	noms = FILE_SEARCH("/DATA/ASPERA3/DATA/IMAPARAM/imaparam*.cdf")

	cherche = 'imaparam'+int_str_0(YYYY,4)+int_str_0(DOY,3)
	deb = (WHERE (STRMID(noms,28,15) GE cherche))[0]

	IF deb[0] EQ -1 THEN RETURN,liste

	; On commence  deb[0]-1 s'il existe, deb[0] sinon
	; On continue tant que l'on est infrieur ou gal  DOY
	deb = deb[0] EQ 0 ? deb[0] : deb[0]-1
	fin = WHERE (STRMID(noms,28,15) LE cherche)
	fin = fin[0] EQ -1 ? deb : fin[N_ELEMENTS(fin)-1]

	liste = noms[deb:fin]
	ind = WHERE (liste NE '')
	RETURN, ind[0] EQ -1 ? '' : liste[ind]

END


;-------------------------------------------------------------------------------
FUNCTION extraire_data_aspera3_imaparam,	$
;-------------------------------------------------------------------------------
	annee,	$	; LINT_PROTOTYPE input
	mois,	$	; LINT_PROTOTYPE input
	jour,	$	; LINT_PROTOTYPE input
	liste,	$	; LINT_PROTOTYPE input
	data_mom	; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Lit tous les fichiers de liste et met dans data_mom les donnes pour le jour annee/mois/jour.
;
;       Retourne:
;               1 il y a des donnes
;               0 pas de donnes
;-------------------------------------------------------------------------------

	datedeb = tu_to_date (annee, mois, jour, 0, 0, 0)
	datefin = datedeb + 86400d * 1000d

	vide = 1

	FOR i=0L,N_ELEMENTS(liste)-1 DO BEGIN
		IF liste[i] NE '' THEN BEGIN
			code = lire_aspera3_imaparam (liste[i], dataf_mom)
			IF code EQ 0 THEN CONTINUE
			ind = WHERE (dataf_mom.date GE datedeb AND dataf_mom.date LT datefin)
			IF ind[0] NE -1 THEN BEGIN
				IF vide THEN BEGIN
					data_mom = dataf_mom[ind]
					vide = 0
				END ELSE BEGIN
					data_mom = [ data_mom, dataf_mom[ind] ]

				END
			END
		END
	END

	RETURN, vide ? 0 : 1

END

;-------------------------------------------------------------------------------
PRO ecrire_data_aspera3_imaparam,	$
;-------------------------------------------------------------------------------
	nom,	$	; LINT_PROTOTYPE input
	data		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ecrit data dans le fichier nom.
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(data) EQ 0 THEN RETURN

	nblignes = N_ELEMENTS(data)
	PRINT, 'Writing ' + nom + '  '+val_to_str(nblignes)+' lines  ' + val_to_str(nblignes*(8+16l*16l*96l*4) / 1024.0 / 1024.0)+' Mbytes'

	OPENW, fd, nom, /GET_LUN, /SWAP_IF_LITTLE_ENDIAN
	WRITEU, fd, data
	FREE_LUN, fd

END

;-------------------------------------------------------------------------------
PRO aspera3_imaparam,	$
;-------------------------------------------------------------------------------
	YYYYMMDD1,	$	; LINT_PROTOTYPE input
	YYYYMMDD2,	$	; LINT_PROTOTYPE input
	force			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Cre les fichiers /DATA/ASPERA3/DATA/FEDOROV/MEX_ASP3_IMAx_MOMxxCLEAN de YYYYMMDD1  YYYYMMDD2.
;
;	force: mettre  1 pour forcer le traitement, sinon le traitement ne se fait que si c'est ncessaire (fichier cdf modifi ou nouveau fichier cdf)
;-------------------------------------------------------------------------------

	annee1 = STRMID(YYYYMMDD1,0,4)
	mois1 = STRMID(YYYYMMDD1,4,2)
	jour1 = STRMID(YYYYMMDD1,6,2)
	annee2 = STRMID(YYYYMMDD2,0,4)
	mois2 = STRMID(YYYYMMDD2,4,2)
	jour2 = STRMID(YYYYMMDD2,6,2)

	date1 = tu_to_date(annee1, mois1, jour1, 0, 0, 0)
	date2 = tu_to_date(annee2, mois2, jour2, 0, 0, 0)

	force = LONG(force)

	FOR date=date1, date2, 86400d * 1000d DO BEGIN

		date_to_tu, date, annee, mois, jour, heure, minute, seconde
		liste_cdf = get_liste_aspera3_imaparam (annee, mois, jour)
		IF liste_cdf[0] EQ '' THEN BEGIN
			PRINT,int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)+': no new data'
			CONTINUE ; pas de donnes pour ce jour la ...
		END

		PRINT,int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)
		PRINT,'--------'
		nom_mom = '/DATA/ASPERA3/DATA/FEDOROV/MEX_ASP3_IMAx_MOMxxCLEAN_'+int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)+'_V01.bin'
		liste_bin = [ nom_mom ]

		IF force EQ 0 THEN BEGIN

			; Ne retraiter que si un cdf est plus rcent qu'un bin
			; 	cad si date CDF > date bin
			; 	cad si MAX(date CDF) > min(date BIN)

			date_cdf = REPLICATE (0d, N_ELEMENTS(liste_cdf))
			FOR i=0L,N_ELEMENTS(liste_cdf)-1 DO BEGIN
				tmp = my_file_info(liste_cdf[i])
				date_cdf[i] = tmp.mtime
			END

			date_bin = REPLICATE (0d, N_ELEMENTS(liste_bin))
			FOR i=0L,N_ELEMENTS(liste_bin)-1 DO BEGIN
				tmp = my_file_info(liste_bin[i])
				date_bin[i] = tmp.mtime
			END

			retraiter = MAX(date_cdf) GT MIN(date_bin)

			IF retraiter EQ 0 THEN CONTINUE

		END

		s = 'ls -la'
		FOR i=0L,N_ELEMENTS(liste_cdf)-1 DO s += ' '+liste_cdf[i]
		SPAWN,s
		;s = 'ls -la'
		;FOR i=0L,N_ELEMENTS(liste_bin)-1 DO s += ' '+liste_bin[i]
		;SPAWN,s


		; Suppression fichiers deja prsents
		code = detruire(nom_mom)

		code = extraire_data_aspera3_imaparam (annee, mois, jour, liste_cdf, data_mom)

		IF code EQ 1 THEN BEGIN
			ecrire_data_aspera3_imaparam, nom_mom,  data_mom
		END
		PRINT

	END

	EXIT

END


