;-------------------------------------------------------------------------------
FUNCTION modifier_ordre_pour_cl_aspera3_imaextra,	$
;-------------------------------------------------------------------------------
	data	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Tranforme data[16,96,16,103] en data[96,256,103]
;
; data est dans      l'ordre IDL [16,96,16,103]
; je le veux pour cl l'ordre IDL [96,256,103]
;-------------------------------------------------------------------------------

	nblignes = N_ELEMENTS(data[0,0,0,*])
	datanew = REPLICATE(0.,96,16,16,nblignes)
	FOR ienergie=0L,95 DO BEGIN
		datanew[ienergie,*,*,*] = REFORM (data[*,ienergie,*,*], 1, 16, 16, nblignes)
	END

	RETURN, datanew

END


;-------------------------------------------------------------------------------
FUNCTION multiplier_aspera3_imaextra,	$
;-------------------------------------------------------------------------------
	HeavySpec,	$	; LINT_PROTOTYPE input
	FracO2			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne HeavySpec*FracO2
;-------------------------------------------------------------------------------

	resultat = HeavySpec*0
	FOR ianode=0L,15 DO BEGIN
		resultat[ianode,*,*,*] = HeavySpec[ianode,*,*,*]*FracO2[*,*,*]
	END
	RETURN, resultat

END


;-------------------------------------------------------------------------------
FUNCTION get_imamass_mex,	$
;-------------------------------------------------------------------------------
	date	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne la valeur de imamass_mex  utiliser  partir de date.
;-------------------------------------------------------------------------------

	COMMON	COMMN_IMAMASS, old_nom_nc, old_imamass_mex

	IF N_ELEMENTS(old_nom_nc) EQ 0 THEN old_nom_nc = ''

	; Il faut utiliser l'ancienne table ima_info_mex.nc.V4.4.1.6.11.nc ou la nouvelle table ima_info_mex.nc.V5.5.1.6.12.nc suivant les cas.
	; Il faut utiliser la nouvelle table dans les intervalles suivants:
	;       - le 21/3/2007 de 18h  20h
	;       - du 2/4/2007 de 18h au 3/4/2007  1h
	;       - aprs le 30/4/2007 16h

	lint_unused = { struct_aspera3_ima_CALIB, t1: 0d, t2: 0d, nom_nc: '' }
	tmp = [ { struct_aspera3_ima_CALIB, tu_to_date(1958,1,1,0,0,0),         tu_to_date(2007,3,21,18,0,0),   'ima_info_mex.nc.V4.4.1.6.11.nc' },      $
		{ struct_aspera3_ima_CALIB, tu_to_date(2007,3,21,18,0,0),       tu_to_date(2007,3,21,20,0,0),   'ima_info_mex.nc.V5.5.1.6.12.nc' },      $
		{ struct_aspera3_ima_CALIB, tu_to_date(2007,3,21,20,0,0),       tu_to_date(2007,4,2,18,0,0),    'ima_info_mex.nc.V4.4.1.6.11.nc' },      $
		{ struct_aspera3_ima_CALIB, tu_to_date(2007,4,2,18,0,0),        tu_to_date(2007,4,3,1,0,0),     'ima_info_mex.nc.V5.5.1.6.12.nc' },      $
		{ struct_aspera3_ima_CALIB, tu_to_date(2007,4,3,1,0,0),         tu_to_date(2007,4,30,16,0,0),   'ima_info_mex.nc.V4.4.1.6.11.nc' },      $
		{ struct_aspera3_ima_CALIB, tu_to_date(2007,4,30,16,0,0),       tu_to_date(9999,12,0,0,0,0),    'ima_info_mex.nc.V5.5.1.6.12.nc' }       ]

	ind = WHERE ((date GE tmp.t1) AND (date LT tmp.t2))
	ind = ind[0]

	nom_nc = tmp[ind].nom_nc
	nom_nc = GETENV ('CL_ROOT') + '/resource/' + nom_nc

	IF nom_nc EQ old_nom_nc THEN RETURN, old_imamass_mex

	PRINT, 'Reading ' + nom_nc + ' ...'

	fileid = NCDF_OPEN (nom_nc)

	; Table ImaEner_mex
	NCDF_VARGET, fileid, NCDF_VARID (fileid, 'ImaEner'), ImaEner_mex

	; Table ImaMassKF
	NCDF_VARGET, fileid, NCDF_VARID (fileid, 'ImaMassKF'), ImaMassKF_mex

	NCDF_CLOSE, fileid

	; Creation table ImaMass_mex
	imamass_mex = REPLICATE (0., 8, 96, 8) ; 8 PacLev / 96 energies / 8 masses (H+, He++, He+, O++, O+, CO+, O2+, CO2+)
	MQ = [1, 2, 4, 8, 16, 28, 32, 44]
	FOR PACC = 0L, 7 DO BEGIN
		FOR ie = 0L, 95 DO BEGIN
			FOR iMQ = 0L, 7 DO BEGIN
				imamass_mex [ PACC, 95-ie, iMQ ] = rm_mex_vex (ie,PACC,MQ[iMQ],ImaEner_mex,ImaMassKF_mex)
			END
		END
	END

	old_nom_nc = nom_nc
	old_imamass_mex = imamass_mex
	RETURN, imamass_mex

END


;-------------------------------------------------------------------------------
PRO get_rmspec_aspera3_imaextra,	$
;-------------------------------------------------------------------------------
	filename,	$	; LINT_PROTOTYPE input
	nblignes,	$	; LINT_PROTOTYPE input
	date,		$	; LINT_PROTOTYPE input
	pacc,		$	; LINT_PROTOTYPE input
	RestRm,		$	; LINT_PROTOTYPE input
	data,		$	; LINT_PROTOTYPE input
	nom			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Met  jour data[0:nblignes-1].dat pour la particule nom ('Hp', 'Hepp', 'Hep', 'Opp', 'Op', 'COp', 'O2p' ou 'CO2p')
;
;	Entres:
;	--------
;
;		filename:		nom du fichier cdf que l'on est en train de traiter
;					sert juste a afficher le nom du fichier en cas de problme
;		
;		nblignes:		nombre de lignes dans le fichier cdf
;
;		date:			date[nblignes]
;
;		Pacc[nblignes]
;
;
;		RestRm:
;
;
;		nom:			'Hep' ou 'Hepp' ou 'Opp' ou 'COp' ou 'CO2p'
;
;	Sorties:
;	--------
;
;		data[nblignes]:		valeurs pour la particule dfinie dans nom
;-------------------------------------------------------------------------------

	; rempli data.data pour la valeur de nom
	; 	- 'Hp'
	; 	- 'Hepp'
	; 	- 'Hep'
	; 	- 'Opp'
	; 	- 'Op'
	; 	- 'COp'
	; 	- 'O2p'
	; 	- 'CO2p'

	CASE nom OF
		'Hp':	no = 0
		'Hepp':	no = 1
		'Hep':	no = 2
		'Opp':	no = 3
		'Op':	no = 4
		'COp':	no = 5
		'O2p':	no = 6
		'CO2p':	no = 7
	END

	FOR i=0L,nblignes-1 DO BEGIN

		; ImaMass_mex [PAC, energie, no]
		; ImaMass_mex [ 8 PacLev , 96 energies , 8 masses (H+, He++, He+, O++, O+, CO+, O2+, CO2+) ]
		imamass_mex = get_imamass_mex (date[i])

		IF pacc[i] EQ -32767 THEN BEGIN
			PRINT, 'AIE *** WARNING *** pacc vaut -32767 ' + filename
			data[i].data[*,*,*] = 0
		END ELSE BEGIN
			Mline = imamass_mex[pacc[i],*,no]
			Mline = REFORM(Mline)
			FOR ie=0L,95 DO BEGIN
				Mmin = FIX(Mline[ie] - 3.5) > 3
				Mmax = FIX(Mline[ie] + 3.5) < 31
				Msize = Mmax - Mmin + 1
				IF Msize GT 0 THEN data[i].data[ie,*,*] = TOTAL(RestRm[INDGEN(Msize)+Mmin,*,ie,*,i],1)
			END
		END
	END

END


;-------------------------------------------------------------------------------
FUNCTION lire_data_aspera3_imaextra,	$
;-------------------------------------------------------------------------------
	filename,	$	; LINT_PROTOTYPE input
	data_Hp,	$	; LINT_PROTOTYPE output
	data_Op,	$	; LINT_PROTOTYPE output
	data_O2p,	$	; LINT_PROTOTYPE output
	data_Hep,	$	; LINT_PROTOTYPE output
	data_Hepp,	$	; LINT_PROTOTYPE output
	data_Opp,	$	; LINT_PROTOTYPE output
	data_COp,	$	; LINT_PROTOTYPE output
	data_CO2p		; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Lit le fichier CDF filename et stocke les donnes dans data_????
;
;	Entres:
;	-------
;		filename:	nom du fichier CDF imaextra  traiter
;
;	Retourne:
;	---------
;		1 si OK
;		0 si PB
;-------------------------------------------------------------------------------

	ON_IOERROR, erreur

	top1 = nbsec()
	id = -1 ; car sinon, si CDF_OPEN plante, id ne sera pas defini
	code = 1
	id = CDF_OPEN (filename)
	code = 2
	lire_var_cdf, id,'EPOCH',EPOCH,type		; EPOCH[nbspins]
	code = 3
	lire_var_cdf, id,'Pacc',Pacc,type		; Pacc[nbspins]
	nblignes = N_ELEMENTS(EPOCH)
	; ne pas utiliser lire_var_cdf qui modifie l'ordre des dimensions dans les variables en mettant le spin en premier
	code = 4
	CDF_VARGET, id,'HpSpec',HpSpec,REC_COUNT=nblignes	; HpSpec[16 anodes,96 energies,16 deflections,nbspins]
	code = 5
	CDF_VARGET, id,'HeavySpec',HeavySpec,REC_COUNT=nblignes	; HeavySpec[16 anodes,96 energies,16 deflections,nbspins]
	code = 6
	CDF_VARGET, id,'FracO2',FracO2,REC_COUNT=nblignes	; FracO2[96 energies,16 deflections,nbspins]
	code = 7
	CDF_VARGET, id,'RestRm',RestRm,REC_COUNT=nblignes	; RestRm[32,16 anodes,96 energies,16 deflections,nbspins]
	code = 8
	CDF_CLOSE,id
	code = 9
	top2 = nbsec()
	CDF_EPOCH, decalage, 1958, 1, 1, 0, 0, 0, /compute_epoch
	date = EPOCH - decalage
	PRINT,'Lecture de ' + val_to_str(nblignes)+' lignes avec CDF_VARGET en ' + val_to_str_2decimales(top2-top1)+' sec'

	data_Hp = REPLICATE ( { date: 0d, Pacc: 0, data: REPLICATE(0.,96,16,16) }, nblignes)
	data_Hp.date	= date
	data_Hp.Pacc	= Pacc
	data_Op		= data_Hp
	data_O2p	= data_Hp
	data_Hep	= data_Hp
	data_Hepp	= data_Hp
	data_Opp	= data_Hp
	data_COp	= data_Hp
	data_CO2p	= data_Hp


	top1 = nbsec()
	O2pSpec = multiplier_aspera3_imaextra (HeavySpec, FracO2)
	top2 = nbsec()
	PRINT,'Multiplier en ' + val_to_str_2decimales(top2-top1)+' sec'
	OpSpec = HeavySpec - O2pSpec
	data_Hp.data  = modifier_ordre_pour_cl_aspera3_imaextra (HpSpec)
	data_O2p.data  = modifier_ordre_pour_cl_aspera3_imaextra (O2pSpec)
	data_Op.data  = modifier_ordre_pour_cl_aspera3_imaextra (OpSpec)

	get_rmspec_aspera3_imaextra, filename, nblignes, date, Pacc, RestRm, data_Hep, 'Hep'
	get_rmspec_aspera3_imaextra, filename, nblignes, date, Pacc, RestRm, data_Hepp, 'Hepp'
	get_rmspec_aspera3_imaextra, filename, nblignes, date, Pacc, RestRm, data_Opp, 'Opp'
	get_rmspec_aspera3_imaextra, filename, nblignes, date, Pacc, RestRm, data_COp, 'COp'
	get_rmspec_aspera3_imaextra, filename, nblignes, date, Pacc, RestRm, data_CO2p, 'CO2p'
	RETURN, 1

erreur:
	IF code EQ 1 THEN PRINT, 'AIE *** IOERROR *** CDF_OPEN ' + filename
	IF code EQ 2 THEN PRINT, 'AIE *** IOERROR *** EPOCH ' + filename
	IF code EQ 3 THEN PRINT, 'AIE *** IOERROR *** Pacc ' + filename
	IF code EQ 4 THEN PRINT, 'AIE *** IOERROR *** HpSpec ' + filename
	IF code EQ 5 THEN PRINT, 'AIE *** IOERROR *** HeavySpec ' + filename
	IF code EQ 6 THEN PRINT, 'AIE *** IOERROR *** FracO2 ' + filename
	IF code EQ 7 THEN PRINT, 'AIE *** IOERROR *** RestRm ' + filename
	IF code EQ 7 THEN PRINT, 'AIE *** IOERROR *** CDF_CLOSE ' + filename
	RETURN, 0
	

END

;-------------------------------------------------------------------------------
FUNCTION lire_aspera3_imaextra,	$
;-------------------------------------------------------------------------------
	nom,		$	; LINT_PROTOTYPE input
	data_Hp,	$	; LINT_PROTOTYPE output
	data_Op,	$	; LINT_PROTOTYPE output
	data_O2p,	$	; LINT_PROTOTYPE output
	data_Hep,	$	; LINT_PROTOTYPE output
	data_Hepp,	$	; LINT_PROTOTYPE output
	data_Opp,	$	; LINT_PROTOTYPE output
	data_COp,	$	; LINT_PROTOTYPE output
	data_CO2p		; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Lit le fichier nom et stocke les donnes dans data_????
;-------------------------------------------------------------------------------

	PRINT,'Reading ' + nom

	code = lire_data_aspera3_imaextra (nom, data_Hp, data_Op, data_O2p, data_Hep, data_Hepp, data_Opp, data_COp, data_CO2p)
	RETURN, code

END


;-------------------------------------------------------------------------------
FUNCTION get_liste_aspera3_imaextra,	$
;-------------------------------------------------------------------------------
	YYYY,	$	; LINT_PROTOTYPE input
	MM,	$	; LINT_PROTOTYPE input
	DD		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne la liste des fichiers  lire pour crer les donnes de YYY MM DD
;-------------------------------------------------------------------------------

	liste = ''

	date1 = tu_to_date (YYYY,  1,  1, 0, 0, 0)
	date2 = tu_to_date (YYYY, MM, DD, 0, 0, 0)
	DOY = LONG ((date2-date1) / (86400 * 1000d))

	noms = FILE_SEARCH("/DATA/ASPERA3/DATA/IMAEXTRA/imaextra*.cdf")
	noms = noms[SORT(noms)]

	cherche = 'imaextra'+int_str_0(YYYY,4)+int_str_0(DOY,3)
	deb = (WHERE (STRMID(noms,28,15) GE cherche))[0]

	IF deb[0] EQ -1 THEN RETURN,liste

	; On commence  deb[0]-1 s'il existe, deb[0] sinon
	; On continue tant que l'on est infrieur ou gal  DOY
	deb = deb[0] EQ 0 ? deb[0] : deb[0]-1
	fin = WHERE (STRMID(noms,28,15) LE cherche)
	fin = fin[0] EQ -1 ? deb : fin[N_ELEMENTS(fin)-1]

	liste = noms[deb:fin]

	ind = WHERE (liste NE '')
	RETURN, ind[0] EQ -1 ? '' : liste[ind]

END


;-------------------------------------------------------------------------------
FUNCTION extraire_data_aspera3_imaextra,	$
;-------------------------------------------------------------------------------
	annee,		$	; LINT_PROTOTYPE input
	mois,		$	; LINT_PROTOTYPE input
	jour,		$	; LINT_PROTOTYPE input
	liste,		$	; LINT_PROTOTYPE input
	data_Hp,	$	; LINT_PROTOTYPE output
	data_Op,	$	; LINT_PROTOTYPE output
	data_O2p,	$	; LINT_PROTOTYPE output
	data_Hep,	$	; LINT_PROTOTYPE output
	data_Hepp,	$	; LINT_PROTOTYPE output
	data_Opp,	$	; LINT_PROTOTYPE output
	data_COp,	$	; LINT_PROTOTYPE output
	data_CO2p		; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Lit tous les fichiers de liste et met dans data_???? les donnes pour le jour annee/mois/jour.
;
;	Retourne:
;		1 il y a des donnes
;		0 pas de donnes
;-------------------------------------------------------------------------------

	datedeb = tu_to_date (annee, mois, jour, 0, 0, 0)
	datefin = datedeb + 86400d * 1000d

	vide = 1

	FOR i=0L,N_ELEMENTS(liste)-1 DO BEGIN
		IF liste[i] NE '' THEN BEGIN
			code = lire_aspera3_imaextra (liste[i], dataf_Hp, dataf_Op, dataf_O2p, dataf_Hep, dataf_Hepp, dataf_Opp,dataf_COp, dataf_CO2p)
			IF code EQ 0 THEN CONTINUE
			ind = WHERE (dataf_Hp.date GE datedeb AND dataf_Hp.date LT datefin)
			IF ind[0] NE -1 THEN BEGIN
				IF vide THEN BEGIN
					data_Hp = dataf_Hp[ind]
					data_Op = dataf_Op[ind]
					data_O2p = dataf_O2p[ind]
					data_Hep = dataf_Hep[ind]
					data_Hepp = dataf_Hepp[ind]
					data_Opp = dataf_Opp[ind]
					data_COp = dataf_COp[ind]
					data_CO2p = dataf_CO2p[ind]
					vide = 0
				END ELSE BEGIN
					data_Hp = [ data_Hp, dataf_Hp[ind]]
					data_Op = [ data_Op, dataf_Op[ind]]
					data_O2p = [ data_O2p, dataf_O2p[ind]]
					data_Hep = [ data_Hep, dataf_Hep[ind]]
					data_Hepp = [ data_Hepp, dataf_Hepp[ind]]
					data_Opp = [ data_Opp, dataf_Opp[ind]]
					data_COp = [ data_COp, dataf_COp[ind]]
					data_CO2p = [ data_CO2p, dataf_CO2p[ind]]
				END
			END
		END
	END

	RETURN, vide ? 0 : 1

END

;-------------------------------------------------------------------------------
PRO ecrire_data_aspera3_imaextra,	$
;-------------------------------------------------------------------------------
	nom,	$	; LINT_PROTOTYPE input
	data		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ecrit data dans le fichier nom.
;-------------------------------------------------------------------------------

	ON_IOERROR, erreur

	IF N_ELEMENTS(data) EQ 0 THEN RETURN

	nblignes = N_ELEMENTS(data)
	PRINT, 'Writing ' + nom + '  '+val_to_str(nblignes)+' lines  ' + val_to_str(nblignes*(8+16l*16l*96l*4) / 1024.0 / 1024.0)+' Mbytes'

	OPENW, fd, nom, /GET_LUN, /SWAP_IF_LITTLE_ENDIAN
	WRITEU, fd, data
	FREE_LUN, fd
	RETURN

erreur:
	PRINT, 'Cannot write in ' + nom

END

;-------------------------------------------------------------------------------
PRO aspera3_imaextra,	$
;-------------------------------------------------------------------------------
	YYYYMMDD1,	$	; LINT_PROTOTYPE input
	YYYYMMDD2,	$	; LINT_PROTOTYPE input
	force			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Cre les fichiers /DATA/ASPERA3/DATA/FEDOROV/MEX_ASP3_IMAx_???xCLEAN' de YYYYMMDD1  YYYYMMDD2.

;	force: mettre  1 pour forcer le traitement, sinon le traitement ne se fait que si c'est ncessaire (fichier cdf modifi ou nouveau fichier cdf)
;-------------------------------------------------------------------------------

	annee1 = STRMID(YYYYMMDD1,0,4)
	mois1 = STRMID(YYYYMMDD1,4,2)
	jour1 = STRMID(YYYYMMDD1,6,2)
	annee2 = STRMID(YYYYMMDD2,0,4)
	mois2 = STRMID(YYYYMMDD2,4,2)
	jour2 = STRMID(YYYYMMDD2,6,2)

	date1 = tu_to_date(annee1, mois1, jour1, 0, 0, 0)
	date2 = tu_to_date(annee2, mois2, jour2, 0, 0, 0)

	force = LONG(force)

	FOR date=date1, date2, 86400d * 1000d DO BEGIN

		date_to_tu, date, annee, mois, jour, heure, minute, seconde
		liste_cdf = get_liste_aspera3_imaextra (annee, mois, jour)
		IF liste_cdf[0] EQ '' THEN BEGIN
			PRINT,int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)+': no new data'
			CONTINUE ; pas de donnes pour ce jour la ...
		END

		PRINT,int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)
		nom_Hp    = '/DATA/ASPERA3/DATA/FEDOROV/MEX_ASP3_IMAx_H1xxxCLEAN_'+int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)+'_V01.bin'
		nom_Hepp  = '/DATA/ASPERA3/DATA/FEDOROV/MEX_ASP3_IMAx_HE2xxCLEAN_'+int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)+'_V01.bin'
		nom_Hep   = '/DATA/ASPERA3/DATA/FEDOROV/MEX_ASP3_IMAx_HE1xxCLEAN_'+int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)+'_V01.bin'
		nom_Opp   = '/DATA/ASPERA3/DATA/FEDOROV/MEX_ASP3_IMAx_O2xxxCLEAN_'+int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)+'_V01.bin'
		nom_Op    = '/DATA/ASPERA3/DATA/FEDOROV/MEX_ASP3_IMAx_O1xxxCLEAN_'+int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)+'_V01.bin'
		nom_COp   = '/DATA/ASPERA3/DATA/FEDOROV/MEX_ASP3_IMAx_CO1xxCLEAN_'+int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)+'_V01.bin'
		nom_O2p   = '/DATA/ASPERA3/DATA/FEDOROV/MEX_ASP3_IMAx_OO1xxCLEAN_'+int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)+'_V01.bin'
		nom_CO2p  = '/DATA/ASPERA3/DATA/FEDOROV/MEX_ASP3_IMAx_COO1xCLEAN_'+int_str_0(annee,4)+int_str_0(mois,2)+int_str_0(jour,2)+'_V01.bin'
		liste_bin = [ nom_Hp, nom_Hepp, nom_Hep, nom_Opp, nom_Op, nom_COp, nom_O2p, nom_CO2p ]

		IF ~force THEN BEGIN

			; Ne retraiter que si un cdf est plus rcent qu'un bin
			; 	cad si date CDF > date bin
			; 	cad si MAX(date CDF) > min(date BIN)
	
			date_cdf = REPLICATE (0d, N_ELEMENTS(liste_cdf))	
			FOR i=0L,N_ELEMENTS(liste_cdf)-1 DO BEGIN
				tmp = my_file_info(liste_cdf[i])
				date_cdf[i] = tmp.mtime
			END

			date_bin = REPLICATE (0d, N_ELEMENTS(liste_bin))	
			FOR i=0L,N_ELEMENTS(liste_bin)-1 DO BEGIN
				tmp = my_file_info(liste_bin[i])
				date_bin[i] = tmp.mtime
			END

			retraiter = MAX(date_cdf) GT MIN(date_bin)

			IF ~retraiter THEN CONTINUE

		END

		PRINT,'--------'

		s = 'ls -la'
		FOR i=0L,N_ELEMENTS(liste_cdf)-1 DO s += ' '+liste_cdf[i]
		SPAWN,s
		;s = 'ls -la'
		;FOR i=0L,N_ELEMENTS(liste_bin)-1 DO s += ' '+liste_bin[i]
		;SPAWN,s

		; Suppression fichiers deja prsents
		code = detruire(nom_Hp)
		code = detruire(nom_Hepp)
		code = detruire(nom_Hep)
		code = detruire(nom_Opp)
		code = detruire(nom_Op)
		code = detruire(nom_COp)
		code = detruire(nom_O2p)
		code = detruire(nom_CO2p)

		code = extraire_data_aspera3_imaextra (annee, mois, jour, liste_cdf, data_Hp, data_Op, data_O2p, data_Hep, data_Hepp, data_Opp, data_COp, data_CO2p)

		IF code EQ 1 THEN BEGIN
			ecrire_data_aspera3_imaextra, nom_Hp,  data_Hp
			ecrire_data_aspera3_imaextra, nom_Op,  data_Op
			ecrire_data_aspera3_imaextra, nom_O2p,  data_O2p
			ecrire_data_aspera3_imaextra, nom_Hep, data_Hep
			ecrire_data_aspera3_imaextra, nom_Hepp, data_Hepp
			ecrire_data_aspera3_imaextra, nom_Opp, data_Opp
			ecrire_data_aspera3_imaextra, nom_COp, data_COp
			ecrire_data_aspera3_imaextra, nom_CO2p, data_CO2p
		END
		PRINT
	END

	EXIT

END
