;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: animation__define.pro,v $, v $Revision: 1.21 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO animation::setproperty,	$
;-------------------------------------------------------------------------------
	nom,			$	; LINT_PROTOTYPE input
	val,			$	; LINT_PROTOTYPE input
	passaveold = passaveold		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Positionne la variable nom  la valeur val.
;
; Traitement particulier si nom vaut 'selection', 'time_t1' ou 'nosat'
;-------------------------------------------------------------------------------

	IF nom EQ 'selection' OR nom EQ 'time_t1' OR nom EQ 'nosat' THEN BEGIN

		selection = nom EQ 'selection' ? val : get (self,'selection')
		time_t1 = nom EQ 'time_t1' ? str_to_date(val) : str_to_date(get(self,'time_t1'))
		nosat = nom EQ 'nosat' ? val : get(self,'nosat')

		tmp		= date_to_str(time_t1, format=3)
		YYYYMMDD	= STRMID(tmp,0,4)+STRMID(tmp,5,2)+STRMID(tmp,8,2)
		YEAR		= STRMID(YYYYMMDD,0,4)
		MONTH		= STRMID(YYYYMMDD,4,2)
		DAY		= STRMID(YYYYMMDD,6,2)
		DOY		= int_str_0(year_month_day_to_doy(YEAR,MONTH,DAY),3)
		HOUR		= STRMID(tmp,11,2)
		MINUTE		= STRMID(tmp,14,2)
		SECOND		= STRMID(tmp,17,2)
		nosat		= LONG(nosat)

		selection1 = ''
		http = get(self.general,'use_local_or_nfs') EQ 'LOCAL_AND_HTTP'
		nfs = get(self.general,'use_local_or_nfs') EQ 'LOCAL_AND_NFS'
		filenames = REPLICATE('',1000)
		nofilenames = 0L
		IF selection NE '' THEN BEGIN
			no = -1L
			REPEAT BEGIN
				no++
				lint_unused = chercher_dernier_fichier (self.general, http, nfs, '', '', selection, $
									nosat, YYYYMMDD, YEAR, MONTH, DAY, DOY, HOUR, MINUTE, SECOND, selection1, no=no)
				IF nofilenames EQ N_ELEMENTS(filenames) THEN BEGIN
					cl_msg, self.general, str_bas=val_to_str(nofilenames) +' files found ...'
					filenames1 = REPLICATE ('', N_ELEMENTS(filenames)*2)
					filenames1[0:N_ELEMENTS(filenames)-1] = filenames
					filenames = filenames1
				END
				filenames[nofilenames] = selection1
				nofilenames++
			END UNTIL selection1 EQ ''
		END
		ind = WHERE (filenames NE '')
		filenames = ind[0] EQ -1 ? '' : filenames[ind]

		nbimages = N_ELEMENTS(filenames)
		IF nbimages EQ 1 THEN filenames = [filenames]
		cl_msg, self.general, str_bas=val_to_str(nbimages) +' files found ...'

		self -> obj::setproperty, 'first', '1' ; pour ne pas tre emmerd

		filenames = REFORM (filenames, nbimages)
		self -> obj::setproperty,nom,val
		self -> obj::setproperty,'filenames',filenames

		no = get (self,'no')
		self -> obj::setproperty,'no', ['SL','2','300','1',val_to_str(nbimages)], /info
		IF no GT nbimages THEN  self -> obj::setproperty,'no',nbimages
		IF nbimages GE 2 THEN BEGIN
			self -> obj::setproperty, 'no', 3, /no
		END ELSE BEGIN
			self -> obj::setproperty, 'no', 0, /no
		END

	END

	self -> image::setproperty, nom, val, passaveold=passaveold

END

;-------------------------------------------------------------------------------
FUNCTION animation::masque,	$
;-------------------------------------------------------------------------------
	nom	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne les N premiers caractres de nom, jusqu' la dernire lettre avant le dernier '.'
;-------------------------------------------------------------------------------

	commence = 0
	FOR i=STRLEN(nom)-1, 0, -1 DO BEGIN
		c = STRMID(nom,i,1)
		IF commence THEN BEGIN
			IF STRUPCASE(c) GE 'A' AND STRUPCASE(c) LE 'Z' THEN BREAK
		END ELSE IF c EQ '.' THEN BEGIN
			commence = 1
		END
	END
	RETURN, STRMID(nom, 0, i)
	
END

;-------------------------------------------------------------------------------
PRO animation::compute
;-------------------------------------------------------------------------------
; Visualise l'animation
;-------------------------------------------------------------------------------

	no = get (self,'no')
	delais = get (self,'delais')
	filenames = get (self,'filenames')
	nbimages = N_ELEMENTS(filenames)

	IF get (self,'play') EQ '1' THEN BEGIN
		first = no
		last = nbimages
	END ELSE IF get (self,'first') EQ '1' THEN BEGIN
		first = 1
		last = first
	END ELSE IF get (self,'next') EQ '1' THEN BEGIN
		first = no EQ nbimages ? 1 : no+1
		last = first
	END ELSE IF get (self,'previous') EQ '1' THEN BEGIN
		first = no EQ 1 ? nbimages : no-1
		last = first
	END ELSE IF get (self,'last') EQ '1' THEN BEGIN
		first = nbimages
		last = first
	END ELSE IF get (self,'reverse') EQ '1' THEN BEGIN
		first = no
		last = 1
	END ELSE IF get (self,'previous_chap') EQ '1' THEN BEGIN
		first = get (self,'no')
		IF first NE 1 THEN BEGIN
			masque = self -> masque(filenames[first-2])
			FOR i=first-1, 1, -1 DO BEGIN
				IF self -> masque(filenames[i-1]) NE masque THEN BEGIN
					BREAK
				END
				first = i
			END
		END
		last = first
	END ELSE IF get (self,'next_chap') EQ '1' THEN BEGIN
		first = get (self,'no')
		masque = self -> masque(filenames[first-1])
		FOR i=first+1, nbimages DO BEGIN
			IF self -> masque(filenames[i-1]) NE masque THEN BEGIN
				first = i
			BREAK
		END
		END
		last = first
	END ELSE BEGIN
		first = no
		last = first
	END

	general = self.general
	cache = get (general, 'cache')
	set, cache, 'arret', 0

	i = first
	REPEAT BEGIN
		self -> image::setproperty, 'filename', filenames[i-1]
		set, self, 'no', i
		self -> image::compute
		fini = i EQ last

		; loop
		IF fini AND first NE last THEN BEGIN
			i = first LT last ? 0 : nbimages+1
			fini = 0
		END

		IF fini THEN BEGIN
		END ELSE IF ~cl_arret(general) THEN BEGIN

			IF i-1 GT 0 && i LT N_ELEMENTS(filenames) && chaine_contient(filenames[i-1],'dl0.png') AND chaine_contient(filenames[i],'dl1.png') AND fichiers_idem(filenames[i-1],filenames[i]) THEN BEGIN
				self -> image::voirandremove_lastimage, /novoir
				i = first LT last ? i+2 : i-2
				IF i-1 GE N_ELEMENTS(filenames) THEN i = 1
			END ELSE BEGIN
				self -> image::voirandremove_lastimage
				WAIT, delais
				i = first LT last ? i+1 : i-1
			END
		END
	END UNTIL fini OR get(cache,'arret')

	set, cache, 'arret', 0

	set, self, 'first', '0'
	set, self, 'next', '0'
	set, self, 'previous', '0'
	set, self, 'last', '0'
	set, self, 'play', '0'
	set, self, 'reverse', '0'
	set, self, 'previous_chap', '0'
	set, self, 'next_chap', '0'

END

;-------------------------------------------------------------------------------
FUNCTION animation::init,	$
;-------------------------------------------------------------------------------
	no,			$	; LINT_PROTOTYPE input
	container,		$	; LINT_PROTOTYPE input
	order,			$	; LINT_PROTOTYPE input
	general				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de la classe animation
;-------------------------------------------------------------------------------

	nosat_list = get_nosat_list()
	nosat_list = val_to_str(INDGEN(N_ELEMENTS(nosat_list))+1)

	param = [ $
		{ var_obj, '',				'format',		0, PTR_NEW(),												'',			PTR_NEW(),	PTR_NEW('')				},	$
		{ var_obj, '',				'nbx',			0, PTR_NEW(),												'',			PTR_NEW(),	PTR_NEW(0)				},	$
		{ var_obj, '',				'nby',			0, PTR_NEW(),												'',			PTR_NEW(),	PTR_NEW(0)				},	$
		{ var_obj, '',				'filename',		0, PTR_NEW(),												'',			PTR_NEW(),	PTR_NEW('')				}, 	$

		{ var_obj, '',				'filenames',		0, PTR_NEW(),												'',			PTR_NEW(),	PTR_NEW(0)				}, 	$

		{ var_obj, 'Time:Start',		'time_t1',		2, PTR_NEW(['TE','0','23']),										'check_strdate',	PTR_NEW(),	PTR_NEW('29 06 1999 14 30 00.000')	}, 	$
		{ var_obj, '  End',			'time_t2',		2, PTR_NEW(['TE','2','23']),										'check_strdate',	PTR_NEW(),	PTR_NEW('29 06 1999 15 30 00.000')	}, 	$

		{ var_obj, 'Data: Spacecraft',		'nosat',		3, PTR_NEW(['DR','2','LABEL_LEFT',nosat_list]),								'check_always_ok',	PTR_NEW(),	PTR_NEW('1')				}, 	$
		{ var_obj, 'Selection',			'selection',		3, PTR_NEW(['CH','2','60']),										'check_always_ok',	PTR_NEW(),	PTR_NEW()				}, 	$
		{ var_obj, 'Constraint',		'constraint',		3, PTR_NEW(['DR','2','LABEL_LEFT','None','Proportion','Original size']),				'check_always_ok',	PTR_NEW(),	PTR_NEW('Proportion')			}, 	$
		{ var_obj, 'Constraint window',		'constraintw',		3, PTR_NEW(['DR','2','LABEL_LEFT','Bottom left','Bottom right','Top left','Top right','Center','No']),	'check_always_ok',	PTR_NEW(),	PTR_NEW('No')				}, 	$
		{ var_obj, 'Rotation (deg)',		'rotation',		3, PTR_NEW(['DR','2','LABEL_LEFT','0','90','180','270']),						'check_always_ok',	PTR_NEW(),	PTR_NEW('0')				}, 	$
		{ var_obj, '',				'first',		3, PTR_NEW(['B','0','|<-']),										'check_always_ok',	PTR_NEW(),	PTR_NEW('0')				}, 	$
		{ var_obj, '',				'previous_chap',	3, PTR_NEW(['B','0','<<']),										'check_always_ok',	PTR_NEW(),	PTR_NEW('0')				}, 	$
		{ var_obj, '',				'previous',		3, PTR_NEW(['B','0','<-']),										'check_always_ok',	PTR_NEW(),	PTR_NEW('0')				}, 	$
		{ var_obj, '',				'next',			3, PTR_NEW(['B','0','->']),										'check_always_ok',	PTR_NEW(),	PTR_NEW('0')				}, 	$
		{ var_obj, '',				'next_chap',		3, PTR_NEW(['B','0','>>']),										'check_always_ok',	PTR_NEW(),	PTR_NEW('0')				}, 	$
		{ var_obj, '',				'last',			3, PTR_NEW(['B','2','->|']),										'check_always_ok',	PTR_NEW(),	PTR_NEW('0')				}, 	$
		{ var_obj, '',				'no',			3, PTR_NEW(['SL','2','300','1','2']),									'check_always_ok',	PTR_NEW(),	PTR_NEW('1')				}, 	$
		{ var_obj, '',				'reverse',		3, PTR_NEW(['B','0','Reverse']),									'check_always_ok',	PTR_NEW(),	PTR_NEW('0')				}, 	$
		{ var_obj, '',				'play',			3, PTR_NEW(['B','2','Play']),										'check_always_ok',	PTR_NEW(),	PTR_NEW('0')				}, 	$
		{ var_obj, 'Delay (in sec)',		'delais',		3, PTR_NEW(['FL','2','12']),										'check_supegal',	PTR_NEW([0]), 	PTR_NEW(0.0d)				}, 	$
		{ var_obj, '            Y2',		'y2',			3, PTR_NEW(['IN','2','4']),										'check_always_ok',	PTR_NEW(),	PTR_NEW(-1)				}, 	$
		{ var_obj, 'X1',			'x1',			3, PTR_NEW(['IN','0','4']),										'check_always_ok',	PTR_NEW(),	PTR_NEW(-1)				}, 	$
		{ var_obj, '               X2',		'x2',			3, PTR_NEW(['IN','0','4']),										'check_always_ok',	PTR_NEW(),	PTR_NEW(-1)				}, 	$
		{ var_obj, '       Interpolation',	'interp',		3, PTR_NEW(['DR','2','LABEL_LEFT','None','congrid']),							'check_always_ok',	PTR_NEW(),	PTR_NEW('congrid')			}, 	$
		{ var_obj, '            Y1',		'y1',			3, PTR_NEW(['IN','2','4']),										'check_always_ok',	PTR_NEW(),	PTR_NEW (-1)				}	$
	]

	code = self -> obj::init (no, container, order, param, general=general,/saisissable,graphique=1,palette=4,/shortpalette)

	set, self, 'nbmaxcolors', 256
	set, self, 'palette_cube', 'No'
	set, self, 'directory','/'
	set, self, 'selection',''
	set, self, 'noparam', 2

	RETURN, code

END


;-------------------------------------------------------------------------------
PRO animation__define
;-------------------------------------------------------------------------------
; La classe animation hrite de image
;-------------------------------------------------------------------------------

	lint_unused = { animation, 	$

			INHERITS image 	$

	}

END
