;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: tnaxes.pro,v $, v $Revision: 1.5 $
;
;	Date	: $Date: 2020/03/05 13:22:24 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------
;+
; NAME:
;       TNAXES
; PURPOSE:
;       Find nice time axis tics.
; CATEGORY:
; CALLING SEQUENCE:
;       tnaxes, xmn, xmx, nx, mjx1, mjx2, xinc, [mnx2, mnx2, xinc2]
; INPUTS:
;       xmn, xmx = Axis min and max in sec.          in
;       nx = Desired number of axis tics.            in
; KEYWORD PARAMETERS:
;       Keywords:
;         FORM=form  returns a suggested format, suitable
;           for use in formatting time axis labels.
;           Ex: h$:m$:s$, h$:m$, d$
; OUTPUTS:
;       mjx1 = first major tic position in sec.      out
;       mjx2 = last major tic position in sec.       out
;       xinc = Suggested major tic spacing in sec.   out
;       mnx1 = first minor tic position in sec.      out
;       mnx2 = last minor tic position in sec.       out
;       xinc2 = suggested minor tic spacing in sec.  out
; COMMON BLOCKS:
; NOTES:
; MODIFICATION HISTORY:
;       R. Sterner. 18 Nov, 1988.
;       R. Sterner, 22 Feb, 1991 --- converted to IDL V2.
;       R. Sterner, 25 Feb, 1991 --- added minor ticks.
;       Johns Hopkins University Applied Physics Laboratory.
;
; Copyright (C) 1988, Johns Hopkins University/Applied Physics Laboratory
; This software may be used, copied, or redistributed as long as it is not
; sold and this copyright notice is reproduced on each copy made.  This
; routine is provided as is without any express or implied warranties
; whatsoever.  Other limitations apply as described in the file disclaimer.txt.
;-
;-------------------------------------------------------------
 
	pro tnaxes, dx0,dx1,nx, mjx1,mjx2,xi, mnx1, mnx2, xi2, $
	  help=hlp, form=form
 
	if (n_params(0) lt 6) or (keyword_set(hlp)) then begin
	  print,' Find nice time axis tics.'
	  print,' tnaxes, xmn, xmx, nx, mjx1, mjx2, xinc, [mnx2, mnx2, xinc2]'
	  print,'   xmn, xmx = Axis min and max in sec.          in'
	  print,'   nx = Desired number of axis tics.            in'
	  print,'   mjx1 = first major tic position in sec.      out'
	  print,'   mjx2 = last major tic position in sec.       out'
	  print,'   xinc = Suggested major tic spacing in sec.   out'
	  print,'   mnx1 = first minor tic position in sec.      out'
	  print,'   mnx2 = last minor tic position in sec.       out'
	  print,'   xinc2 = suggested minor tic spacing in sec.  out'
	  print,' Keywords:'
	  print,'   FORM=form  returns a suggested format, suitable'
	  print,'     for use in formatting time axis labels.'
	  print,'     Ex: h$:m$:s$, h$:m$, d$'
	  return
	endif
 
	dx = double(dx1 - dx0)	; Axis range.
 
	if dx gt 0 then begin	; Forward axis.
	  x0 = double(dx0)
	  x1 = double(dx1)
	endif else begin	; Reverse axis.
	  x0 = double(dx1)
	  x1 = double(dx0)
	endelse

	xinc = (x1-x0)/nx	; Approx. inc size. en micro sec

	;------------  Less than 0.001 sec  -------------------
	if xinc lt 1000.0d then begin	; < 1 milli sec
	                                                        xi = 1000000ULL & xi2 =  200000ULL			; < 1000 micro	=> 1000 micro - 200   micro
	  if xinc lt 500.0d or long(dx*1000/xi) lt 2 then begin xi =  500000ULL & xi2 =  100000ULL & endif		; <  500 micro	=>  500 micro - 100   micro
	  if xinc lt 200.0d or long(dx*1000/xi) lt 2 then begin xi =  250000ULL & xi2 =   50000ULL & endif		; <  200 micro	=>  250 micro -  50   micro
	  if xinc lt 100.0d or long(dx*1000/xi) lt 2 then begin xi =  100000ULL & xi2 =   20000ULL & endif		; <  100 micro	=>  100 micro -  20   micro
	  if xinc lt  50.0d or long(dx*1000/xi) lt 2 then begin xi =   50000ULL & xi2 =   10000ULL & endif		; <   50 micro	=>   50 micro -  10   micro
	  if xinc lt  30.0d or long(dx*1000/xi) lt 2 then begin xi =   25000ULL & xi2 =    5000ULL & endif		; <   30 micro	=>   25 micro -   5   micro
	  if xinc lt  10.0d or long(dx*1000/xi) lt 2 then begin xi =   10000ULL & xi2 =    2000ULL & endif		; <   10 micro	=>   10 micro -   2   micro
	  if xinc lt   5.0d or long(dx*1000/xi) lt 2 then begin xi =    5000ULL & xi2 =    1000ULL & endif		; <    5 micro	=>    5 micro -   1   micro
	  if xinc lt   1.0d or long(dx*1000/xi) lt 2 then begin xi =    1000ULL & xi2 =     200ULL & endif		; <    1 micro	=>    1 micro -   0.2 micro
	  form = 's$g$'
	  goto, done
	endif

	;------------  0.001 sec sec to 1 sec  -------------------
	if xinc lt 1000000.0d then begin	; < 1 sec
	                                                           xi = 1000000000ULL & xi2 = 200000000ULL		; < 1000 milli	=> 1000 milli - 200 milli
	  if xinc lt 500000.0d or long(dx*1000/xi) lt 2 then begin xi =  500000000ULL & xi2 = 100000000ULL & endif	; <  500 milli	=>  500 milli - 100 milli
	  if xinc lt 200000.0d or long(dx*1000/xi) lt 2 then begin xi =  250000000ULL & xi2 =  50000000ULL & endif	; <  250 milli	=>  250 milli -  50 milli
	  if xinc lt 100000.0d or long(dx*1000/xi) lt 2 then begin xi =  100000000ULL & xi2 =  20000000ULL & endif	; <  100 milli	=>  100 milli -  20 milli
	  if xinc lt  50000.0d or long(dx*1000/xi) lt 2 then begin xi =   50000000ULL & xi2 =  10000000ULL & endif	; <   50 milli	=>   50 milli -  10 milli
	  if xinc lt  30000.0d or long(dx*1000/xi) lt 2 then begin xi =   25000000ULL & xi2 =   5000000ULL & endif	; <   25 milli	=>   25 milli -   5 milli
	  if xinc lt  10000.0d or long(dx*1000/xi) lt 2 then begin xi =   10000000ULL & xi2 =   2000000ULL & endif	; <   10 milli	=>   10 milli -   2 milli
	  if xinc lt   5000.0d or long(dx*1000/xi) lt 2 then begin xi =    5000000ULL & xi2 =   1000000ULL & endif	; <    5 milli	=>    5 milli -   1 milli
	  form = 'h$:m$:s$f$'
	  goto, done
	endif

	;------------  1 sec to 1 min  -----------------
	if xinc lt 60000000.0d then begin	; < 1 mn
	                                                             xi = 60000000000ULL & xi2 = 15000000000ULL		; < 60   sec	=> 60 sec - 15   sec
	  if xinc lt 42400000.0d or long(dx*1000/xi) lt 2 then begin xi = 30000000000ULL & xi2 = 10000000000ULL & endif	; < 42.4 sec	=> 30 sec - 10   sec
	  if xinc lt 21200000.0d or long(dx*1000/xi) lt 2 then begin xi = 15000000000ULL & xi2 =  5000000000ULL & endif	; < 21.2 sec	=> 15 sec -  5   sec
	  if xinc lt 12200000.0d or long(dx*1000/xi) lt 2 then begin xi = 10000000000ULL & xi2 =  2000000000ULL & endif	; < 12.2 sec	=> 10 sec -  2   sec
	  if xinc lt  7100000.0d or long(dx*1000/xi) lt 2 then begin xi =  5000000000ULL & xi2 =  1000000000ULL & endif	; <  7.1 sec	=>  5 sec -  1   sec
	  if xinc lt  3200000.0d or long(dx*1000/xi) lt 2 then begin xi =  2000000000ULL & xi2 =   500000000ULL & endif	; <  3.2 sec	=>  2 sec -  0.5 sec
	  if xinc lt  1400000.0d or long(dx*1000/xi) lt 2 then begin xi =  1000000000ULL & xi2 =   200000000ULL & endif	; <  1.4 sec	=>  1 sec -  0.2 sec
	  form = 'h$:m$:s$'
	  if xi gt 30000000000ULL then form = 'h$:m$'							; > 30 sec
	  goto, done
	endif

	;------------  1 min to 1 hr  -------------------
	xinc = xinc / 60.0d
	if xinc lt 60000000.0d then begin	; xinc in min < 1 hr.
	                                                             xi = 60000000000ULL*60ULL & xi2 = 15000000000ULL*60ULL		; < 60   mn	=> 60 mn - 15   mn
	  if xinc lt 42400000.0d or long(dx*1000/xi) lt 2 then begin xi = 30000000000ULL*60ULL & xi2 = 10000000000ULL*60ULL & endif	; < 42.4 mn	=> 30 mn - 10   mn
	  if xinc lt 21200000.0d or long(dx*1000/xi) lt 2 then begin xi = 15000000000ULL*60ULL & xi2 =  5000000000ULL*60ULL & endif	; < 21.2 mn	=> 15 mn -  5   mn
	  if xinc lt 12200000.0d or long(dx*1000/xi) lt 2 then begin xi = 10000000000ULL*60ULL & xi2 =  2000000000ULL*60ULL & endif	; < 12.2 mn	=> 10 mn -  2   mn
	  if xinc lt  7100000.0d or long(dx*1000/xi) lt 2 then begin xi =  5000000000ULL*60ULL & xi2 =  1000000000ULL*60ULL & endif	; <  7.1 mn	=>  5 mn -  1   mn
	  if xinc lt  3200000.0d or long(dx*1000/xi) lt 2 then begin xi =  2000000000ULL*60ULL & xi2 =   500000000ULL*60ULL & endif	; <  3.2 mn	=>  2 mn -  0.5 mn
	  if xinc lt  1400000.0d or long(dx*1000/xi) lt 2 then begin xi =  1000000000ULL*60ULL & xi2 =   200000000ULL*60ULL & endif	; <  1.4 mn	=>  1 mn -  0.2 mn
	  form = 'h$:m$'
	  goto, done
	endif

	;-------------  1 hr to 1 day  -----------------
	xinc = xinc/60.0d
	if xinc lt 24000000.0d then begin	; xinc in hr < 1 day.
	                                                           xi = 24000000000ULL*3600ULL & xi2 = 6000000000ULL*3600ULL		; < 24   h	=> 24 h - 6    h
	  if xinc lt 17000000d or long(dx*1000/xi) lt 2 then begin xi = 12000000000ULL*3600ULL & xi2 = 3000000000ULL*3600ULL & endif	; < 17   h	=> 12 h - 3    h
	  if xinc lt  8500000d or long(dx*1000/xi) lt 2 then begin xi =  6000000000ULL*3600ULL & xi2 = 2000000000ULL*3600ULL & endif	; <  8.5 h	=>  6 h - 2    h
	  if xinc lt  4900000d or long(dx*1000/xi) lt 2 then begin xi =  4000000000ULL*3600ULL & xi2 = 1000000000ULL*3600ULL & endif	; <  4.9 h	=>  4 h - 1    h
	  if xinc lt  2800000d or long(dx*1000/xi) lt 2 then begin xi =  2000000000ULL*3600ULL & xi2 =  500000000ULL*3600ULL & endif	; <  2.8 h	=>  2 h - 0.5  h
	  if xinc lt  1400000d or long(dx*1000/xi) lt 2 then begin xi =  1000000000ULL*3600ULL & xi2 =  250000000ULL*3600ULL & endif	; <  1.4 h	=>  1 h - 0.25 h
	  form = 'h$:m$'
	  if xi gt  4000000000ULL*3600ULL then form = 'h$:m$@d$'						; >  4 h
	  if xi gt 12000000000ULL*3600ULL then form = 'I$'							; > 12 h
	  goto, done
	endif

	;---------------  greater then 1 day  -----------------
	xinc = xinc/24000000.0d		; xinc is in days.
	p = alog10(xinc)	; Scale to 1 to 10.
	if p lt 0 then p = p-1.
	p = fix(p)
	pow = 10ULL^p
	xi = xinc/pow
	xinc = xi
	;------ Set increment to a nice value -----------
	                                                     xi = 10000000000ULL*86400ULL & xi2 = 2000000000ULL*86400ULL		; > 1 j		=> 10  j - 2    j
	if xinc lt 7.07d or long(dx*1000/xi) lt 2 then begin xi =  5000000000ULL*86400ULL & xi2 = 1000000000ULL*86400ULL & endif	; < 7.07 j	=>  5  j - 1    j
	if xinc lt 3.50d or long(dx*1000/xi) lt 2 then begin xi =  2500000000ULL*86400ULL & xi2 =  500000000ULL*86400ULL & endif	; < 3.5 j	=> 2.5 j - 0.5  j
	if xinc lt 2.24d or long(dx*1000/xi) lt 2 then begin xi =  2000000000ULL*86400ULL & xi2 =  500000000ULL*86400ULL & endif	; < 2.24 j	=> 2   j - 0.5  j
	if xinc lt 1.40d or long(dx*1000/xi) lt 2 then begin xi =  1000000000ULL*86400ULL & xi2 =  250000000ULL*86400ULL & endif	; < 1.4 j	=> 1   j - 0.25 j
	if xi ge 10000000000ULL*86400ULL then begin
	  xi = 1000000000ULL*86400ULL
	  ;p = p + 1.0d
	  pow = pow * 10ULL
	endif
	xi  = xi * pow	; xi = true increment.
	xi2 = xi2 * pow
	form = 'I$'
 
done:	if dx le 0.0d then begin xi = -xi & xi2 = -xi2 & endif

	inrange, xi,  dx0*1000ULL, dx1*1000ULL, mjx1, mjx2
	inrange, xi2, dx0*1000ULL, dx1*1000ULL, mnx1, mnx2
 
	return
 
	end
