/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: INTERFACE.h,v $
 *
 *	Version	: $Revision: 1.9 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2005/11/03 15:02:46 $
 *
 *	==========================================================================================
 *
 *	Ce module est charge de l'interface entre la chaine de traitement 
 *	et le systeme d'exploitation.
 *
 *	Il comprend notamment :
 *	- le traitement des parametres de la ligne de commande,
 *	- l'ouverture des fichiers de donnees de l'application
 *	- la gestion des fichiers temporaires
 */

#ifndef __INTERFACE_H
#define __INTERFACE_h

typedef enum { 	
	COD_12, COD_13, COD_14, COD_15, COD_16, COD_17, COD_18, COD_19, COD_20, COD_21, COD_22, COD_29, COD_47, COD_49,
	HIA_05, HIA_06, HIA_08, HIA_10, HIA_14, HIA_15, HIA_16, HIA_17, HIA_21, HIA_22, HIA_23, HIA_24,
	AUX_STOF, AUX_SATT,
	CALIB_CAT,
	PPD,
	FGM,
	CONTEXT, ENVIRON, ARCHIVE,
	TRACE,	COD_SPECTRO, HIA_SPECTRO, JSOC_SPECTRO, PPD_BIN, ORBIT
}	t_produit;


typedef struct {					/* Parametres de l'application		*/
	int		satellite;			/* - numero satellite traite		*/
	int		jour, mois, annee;		/* - date de traitement			*/
	t_filename	espace_traitement;		/* - repertoire de travail		*/
	t_filename	resultat;			/* - contient liste fichiers generes	*/
}	t_param;

extern t_param		param;				/* Parametres de l'application		*/


/***************************************************************************************************
 *
 *	Retourne le nom de fichier du produit desire
 *	--------------------------------------------
 */
char *	Nom_fichier_produit (t_produit produit);


/***************************************************************************************************
 *
 *	Ouverture d'un fichier produit
 *	------------------------------
 */
FILE *	Ouverture_produit (t_produit produit, char * mode);


/***************************************************************************************************
 *
 *	Retourne le nom du fichier temporaire associe a la cle
 *	------------------------------------------------------
 */
char *	Nom_fichier_temporaire (char * cle);


/***************************************************************************************************
 *
 *	Ouverture d'un fichier temporaire
 *	---------------------------------
 */
FILE *	Ouverture_fichier_temporaire (char * cle, char * mode);


/***************************************************************************************************
 *
 *	Chargement des fichiers de la ligne de commande
 *	-----------------------------------------------
 */
int	Chargement_parametres (char * file_1, char * file_2, char * file_3, char * file_4, char * file_5);


/***************************************************************************************************
 *
 *	Enregistre sur fichier la liste des fichiers generes
 *	----------------------------------------------------
 */
int	Genere_liste_sortie (char * fichier);


/***************************************************************************************************
 *
 *	Genere les masques des fichiers d'entree et attendus
 *	----------------------------------------------------
 */
int	Genere_masques_fichiers (char * fichier_entree, char * fichier_attendu);


#endif
