/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: ENTETE.h,v $
 *
 *	Version	: $Revision: 1.7 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2015/04/30 09:21:47 $
 *
 *	==========================================================================================
 *
 *	Ce module est charge de la lecture de l'entete des fichiers de niveau 1
 *
 *	ATTENTION	Ce module est partage par les CLL2 et CLL3
 *
 *	- Auparavant : lien dans la base CVS
 *	- Maitenant : deux fichiers separes
 */

#ifndef __ENTETE_H
#define	__ENTETE_H

/***	
 *	Introduction des donnees sur le nombre de paquets recus dans le premier octet
 *	du champ change_mode
 */
#define	LOST_PACKET			

typedef struct {				/* Structure entete produit scientifique	*/
	WORD	indice;				/* Calcule a partir de ENVIRON			*/
	double	time_in_ms;			/* Calcule					*/
	WORD	scet_day;			/* Issu de ESOC header				*/
	DWORD	scet_milli;			/* Issu de ESOC header				*/
	WORD	scet_micro;			/* Issu de ESOC header				*/
	WORD	cis_day;			/* Calcule					*/
	DWORD	cis_milli;			/* Calcule					*/
	WORD	cis_micro;			/* Calcule					*/
	WORD	spin_frame;			/* Issu de FRAME  header			*/
	WORD	sp_phase_pulse;			/* Issu de FRAME  header			*/
	WORD	spin_packet;			/* Issu de PACKET header			*/
	WORD	produit;			/* Issu de PACKET header			*/
	WORD	instrument;			/* Issu de PACKET header			*/
	WORD	sensitivity;			/* Issu de PACKET header			*/
	WORD	tlm_rate;			/* Issu de FRAME  header			*/
	WORD	op_mode;			/* Issu de FRAME  header			*/
	WORD	burst_mode;			/* Issu de PACKET header			*/
#ifdef	LOST_PACKET
	BYTE	received;			/* Nombre paquets recus/attendus * 100		*/
	BYTE	change_mode;			/* Issu de PACKET header			*/
#else
	WORD	change_mode;			/* Issu de PACKET header			*/
#endif
	float	pspin;				/* Calcule					*/
	WORD	phase_codif;			/* Calcule a partir de FRAME header config 1	*/
	WORD	phase_instr;			/* Calcule a partir de FRAME header config 2	*/
	WORD	taille_produit;			/* Taille du produit en d'octets		*/
}	t_prod_header;


/***************************************************************************************************
 *
 *	Lecture entete produit sur fichier
 *	----------------------------------
 */
int	Lecture_entete_produit (t_prod_header * entete, FILE * pf);


/***************************************************************************************************
 *
 *	Affiche entete du produit
 *	-------------------------
 */
int	Affiche_entete_produit (t_prod_header * entete);


/***************************************************************************************************
 *
 *	Ecriture entete produit sur fichier
 *	----------------------------------
 */
int	Ecriture_entete_produit (t_prod_header * entete, FILE * pf);


#endif
