/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: CONTEXTE.h,v $
 *
 *	Version	: $Revision: 1.4 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2001/12/18 14:42:55 $
 *
 *	==========================================================================================
 *
 *	Ce module permet la lecture des donnees du fichier CONTEXTE
 *
 *	Il cree une variable globale de type structure dont les valeurs influencent 
 *	le deroulement de certains traitement.
 *
 *	ATTENTION	Ce module est partage par les CLL1, CLL2 et CLL3
 */

#ifndef __CONTEXTE_H
#define	__CONTEXTE_H

#define	NB_SITE		3			/* Nombre de sites de production possibles	*/

typedef enum { CTM, CSPI, JSOC } t_site;	/* Codes des differents sites			*/

typedef struct {				/* Structure donnees contexte de l'application	*/
	int		niveau_trace;	
	t_site		site_production;		
	int		option_fgm;		
	int		production_spd;
	int		version_calibration;
	char		software_version [50];
	int		date_unique;
}	t_contexte;

extern	t_contexte	contexte;		/* Variable globale contenant le contexte	*/


/***************************************************************************************************
 *
 *	Retourne le code d'un site de production
 *	----------------------------------------
 */
int	Code_site (char * libelle);


/***************************************************************************************************
 *
 *	Retourne le libelle d'un site de production
 *	-------------------------------------------
 */
char *	Lib_site (t_site code);


/***************************************************************************************************
 *
 *	Lecture des valeurs definies dans le fichier contexte
 *	-----------------------------------------------------
 */
int	Lecture_contexte (char * fichier);


/***************************************************************************************************
 *
 *	Affichage des donnees du contexte
 *	---------------------------------
 */
int	Affiche_contexte (void);

#endif
