#! /bin/sh
#
#	Fichier	: $RCSfile: genere.sh,v $, v $Revision: 1.14 $
#
#	Date	: $Date: 2017/09/29 13:35:45 $
#
#	Auteur	: $Author: penou $
#
#	Version	: %Z% version %I% de %M% du %G%
#	___________________________________________________
#
#	Script de generation du CLL3 Cluster

OS=`uname -s`

case	$1 in

	-cc)	CC=cc
		shift
		;;
	-gcc)	CC=gcc
		shift
		;;
	*)	CC=`[ "${OS}" = "Linux" ] && echo "gcc" || echo "cc"`
esac

case	$1 in
	-32|-64)	OPTION=$1
			shift
			;;
	-gdl)		OPTION=$1
			shift
			;;
	*)		OPTION=`[ "${OS}" = "SunOS" ] && echo "-32" || echo ""`
			;;
esac

if [ -z "$DSP_ROOT" ]
then
	DSP_ROOT="/DATA/DOUBLE_STAR"
	export DSP_ROOT
fi

if	[ $# -lt 1 ]
then
	echo
	echo	"Script de generation du CLL3 Cluster"
	echo
	echo	"Syntaxe : $0  -gcc|-cc  [-32|-64|-gdl]  all|clean|raz"
	echo
	echo	"    -cc : force use of cc  compiler"
	echo	"   -gcc : force use of gcc compiler (default for Linux)"
	echo
	echo	"    -32 : force compilation in 32 bits mode (default for Solaris)"
	echo	"    -64 : force compilation in 64 bits mode"
	echo	"    -gdl : compilation for GDL"
	echo
	echo	"    all : generate executable"
	echo	"  clean : suppress unseless files"
	echo	"    raz : suppress all binaries and executables files"
	echo
	exit	100
fi

if 	[ -f configure/configure.sh ]; then
	configure/configure.sh auto $OPTION
fi

#	Generation partie IDL
#	---------------------
#
MF="mak/Makefile_idl_${CC}_${OS}"

echo
echo	"Script      : $0"
echo	"Systeme     : ${OS}"
echo	"Compilateur : ${CC}"
echo	"Makefile    : ${MF}"
echo	"Arguments   : $*"
echo

if	[ ! -f "${MF}" ]
then
	echo	"ERREUR : fichier ${MF} inexistant"
	exit	100
fi

make -f ${MF} $*
