#!/bin/sh
#
#	Fichier	: $RCSfile: configure.sh,v $, v $Revision: 1.202 $
#
#	Date	: $Date: 2021/02/11 13:07:11 $
#
#	Auteur	: $Author: penou $
#
#	Version	: %Z% version %I% de %M% du %G%
#	___________________________________________________
#
#	Script de generation du CLL3 Cluster

#-------------------------------------------------------------------------------
usage ()
#-------------------------------------------------------------------------------
{
	echo
	echo	"Script de configuration du CLL3 Cluster"
	echo
	echo	"Syntaxe : $0 [auto|cesr|cnes|dev]"
	echo
	echo	"   auto : configuration pour le CESR si aucune conf n'a ete charge, rien sinon"
	echo	"   cesr : configuration pour le CESR"
	echo	"   cnes : configuration pour le CNES"
	echo	"  clean : raz de toutes les configurations"
	echo
	exit 100
}


#-------------------------------------------------------------------------------
extraire ()
#-------------------------------------------------------------------------------

# $1: "decoder" pour lire $3 et creer $4 suivant la valeur de $2
#     "copier"  pour copier $3 dans $4 si $2=cesr, detruire $4 sinon
# $2: etiquette (cesr, cnes, clean, NBITS_32, NBITS_64, NBITS_AUTO)
# $3: nom du fichier en entree a lire
# $4: nom du fichier en sortie a creer

{

ACTION=$1
ETIQUETTE=$2
ENTREE=$3
SORTIE=$4

rm -f $SORTIE
if [ $ETIQUETTE = "clean" ]; then
  return
fi

echo $ETIQUETTE "configuration of" $SORTIE

if [ $ACTION = "copier" ]; then

  if [ $ETIQUETTE = "cesr" ]; then
    cp $ENTREE $SORTIE
    chmod -w $SORTIE
    chmod +x $SORTIE
  else
    rm -f $SORTIE
  fi

else

  OS=`uname -s`
  case $OS in
    SunOS)	AWK=nawk
            	;;
    *)		AWK=awk
		;;
  esac
  case $ETIQUETTE in
    cesr)				DIRECTIVE="CESRONLY"
					;;
    cnes) 				DIRECTIVE="CNESONLY"
	 				;;
    NBITS_32|NBITS_64|NBITS_AUTO|GDL) 	DIRECTIVE=$ETIQUETTE
	 				;;
  esac

  $AWK 'BEGIN { defini=1 }
              { if ($1=="#ifdef") {
			defini = $2==DIRECTIVE
                } else if ($1=="#else") { 
			defini = 1-defini
                } else if ($1=="#endif") { 
			defini=1
                } else if (defini==1) {
	             	print $0
		}
              }
       ' DIRECTIVE=$DIRECTIVE $ENTREE > $SORTIE

  chmod -f -w $SORTIE
  chmod +x $SORTIE

fi


}

#-------------------------------------------------------------------------------
preprocesseur_boitier_channel () {
#-------------------------------------------------------------------------------

	# $1: le fichier $1 sera utilis en lecture en entre
	# $2: le fichier $2 sera cre en sortie
	# $3: valeur de {noboitier}
	# $4: valeur de {nochannel}

	ENTREE="$1"
	SORTIE="$2"

	echo "Preprocessor of" $SORTIE

	OS=`uname -s`
	case $OS in
		SunOS)	AWK=nawk
			;;
		*)	AWK=awk
		;;
	esac

	$AWK -v MODULE=$MODULE -v VALUE1=$3 -v VALUE2=$4 ' {
		gsub("{noboitier}",VALUE1);
		gsub("{nochannel}",VALUE2);
		printf "%s\n", $0
	}' $ENTREE > $SORTIE

}

#-------------------------------------------------------------------------------
preprocesseur_mea () {
#-------------------------------------------------------------------------------

	# $1: le fichier $1 sera utilis en lecture en entre
	# $2: le fichier $2 sera cre en sortie
	# $3: valeur de {nomea}

	ENTREE="$1"
	SORTIE="$2"

	echo "Preprocessor of" $SORTIE

	OS=`uname -s`
	case $OS in
		SunOS)	AWK=nawk
			;;
		*)	AWK=awk
		;;
	esac

	$AWK -v MODULE=$MODULE -v VALUE1=$3 ' {
		gsub("{nomea}",VALUE1);
		printf "%s\n", $0
	}' $ENTREE > $SORTIE

}

#-------------------------------------------------------------------------------
preprocesseur_idee () {
#-------------------------------------------------------------------------------

	# $1: le fichier $1 sera utilis en lecture en entre
	# $2: le fichier $2 sera cre en sortie
	# $3: valeur de {noidee}
	# $4: valeur de {loweridee}
	# $5: valeur de {upperidee}

	ENTREE="$1"
	SORTIE="$2"

	echo "Preprocessor of" $SORTIE

	OS=`uname -s`
	case $OS in
		SunOS)	AWK=nawk
			;;
		*)	AWK=awk
		;;
	esac

	$AWK -v MODULE=$MODULE -v VALUE1=$3 -v VALUE2=$4 -v VALUE3=$5 ' {
		gsub("{noidee}",VALUE1);
		gsub("{loidee}",VALUE2);
		gsub("{upidee}",VALUE3);
		printf "%s\n", $0
	}' $ENTREE > $SORTIE

}

#-------------------------------------------------------------------------------
preprocesseur_jadee () {
#-------------------------------------------------------------------------------

	# $1: le fichier $1 sera utilis en lecture en entre
	# $2: le fichier $2 sera cre en sortie
	# $3: valeur de {no1jadee}
	# $4: valeur de {no2jadee}

	ENTREE="$1"
	SORTIE="$2"

	echo "Preprocessor of" $SORTIE

	OS=`uname -s`
	case $OS in
		SunOS)	AWK=nawk
			;;
		*)	AWK=awk
		;;
	esac

	$AWK -v MODULE=$MODULE -v VALUE1=$3 -v VALUE2=$4 ' {
		gsub("{no1jadee}",VALUE1);
		gsub("{no2jadee}",VALUE2);
		printf "%s\n", $0
	}' $ENTREE > $SORTIE

}


#-------------------------------------------------------------------------------
prototype ()
#-------------------------------------------------------------------------------

# $1 (MODULE): 		le fichier configure/$1__define.pro.configure (ou configure/$1.pro.configure) sera utilis en lecture en entre
# $2:			le fichier $2/$1__define.pro (ou $2/$1.pro) sera cre en sortie
# $3 (ETIQUETTE):	etiquette (cesr, cnes ou clean)

{

MODULE=$1

if [ -f configure/"$MODULE"__define.pro.configure ]; then
	ENTREE=configure/"$MODULE"__define.pro.configure
	SORTIE=$2/$1__define.pro
else
	ENTREE=configure/"$MODULE".pro.configure
	SORTIE=$2/$1.pro
fi
ETIQUETTE=$3

rm -f $SORTIE
if [ $ETIQUETTE = "clean" ]; then
  return
fi

echo "Prototype configuration $ETIQUETTE of" $SORTIE

OS=`uname -s`
case $OS in
	SunOS)	AWK=nawk
		;;
	*)	AWK=awk
	;;
esac

$AWK -v MODULE=$MODULE -v ENTREE=$ENTREE '

function MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no,is_function,declared_in_exp,txt_MOTIF,PARAM,PARAM_DECL,txt_DOC) {

	MOTIF[no]=txt_MOTIF
	if (length(txt_DOC)) {
		ligne = sprintf (";-------------------------------------------------------------------------------")
		DOC[no] = sprintf ("%s\n%s",ligne,txt_DOC)
	}
	DECLARED_EXP[no]=declared_in_exp
	if (is_function) {
		APPEL[no] 		= sprintf (        "%s (%s)",		tolower(MOTIF[no]), PARAM)
		DECLARATION1[no]	= sprintf ("FUNCTION %s::%s%s",		MODULE, tolower(MOTIF[no]), length(PARAM_DECL)==0 ? "" : ", $")
	} else {
		APPEL[no] 		= sprintf (        "%s%s %s",		tolower(MOTIF[no]), length(PARAM)==0 ? "" : ",",PARAM)
		DECLARATION1[no]	= sprintf ("PRO %s::%s%s",		MODULE, tolower(MOTIF[no]), length(PARAM_DECL)==0 ? "" : ", $")
	}

	if (length(PARAM_DECL)) {
		DECLARATION1[no]	= sprintf ("%s\n;-------------------------------------------------------------------------------",DECLARATION1[no])
		nb = split(PARAM_DECL, param_type);
		for (i=1 ; i<=nb ; i++) {
			split(param_type[i],tmp,":")
			s = sprintf ("	%s",tmp[1]);
			for (j=length(tmp[1]) ; j<=50 ; j++) s=sprintf ("%s ",s)
			if (i==nb) {
				DECLARATION2[no] = sprintf ("    ; LINT_PROTOTYPE %s",tmp[2])
			} else {
				s = sprintf ("%s, $ ; LINT_PROTOTYPE %s",s,tmp[2])
			}
			DECLARATION1[no] = sprintf ("%s\n%s",DECLARATION1[no],s);
		}
	}

}

BEGIN {

	FICHIER=ENTREE

	is_declaration = substr(MODULE,1,3) == "exp"
	no=1


	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_001_GET_NUMERO",
					"",
					"",
					"; (pour toutes les expriences) Retourne le numro unique de l exprience (entre 1 et 99)")


	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_002_GET_GROUPE",
					"noproduit",
					"noproduit:input",
					"; (pour toutes les expriences) Retourne le numro de groupe du produit (voir le champ no de la structure renvoye par group_exp())\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_003_GET_LISTENOMS",
					"",
					"",
					"; (pour toutes les expriences) Retourne une liste de noms [nom_court, nom_long, nom_principal, puis un ou plusieurs noms utiliables dans les titres]\n"\
					";\n"\
					"; Cette liste est mmorise dans le champ listenoms de la strucure T1 du COMMON UTIL_T1.\n"\
					"; Utilis dans cl.pro pour appeller util_ajouter_info_experiment")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_004_GET_COUNT3D", 
					"",
					"",
					"; (pour toutes les expriences) Retourne 1 si l exprience doit apparaitre dans la liste Experiment des objets count3d__define, 0 sinon\n"\
					";\n"\
					"; Utilis dans cl.pro pour appeller util_ajouter_info_experiment")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_005_GET_TIMESERIES",
					"",
					"",
					"; (pour toutes les expriences) Retourne 1 si l exprience doit apparaitre dans la liste Experiment des objets timeseries__define\n"\
					";\n"\
					"; Utilis dans cl.pro pour appeller util_ajouter_info_experiment")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_006_GET_CONTAINER",
					"",
					"",
					"; (pour toutes les expriences) Retourne 1 si l exprience doit apparaitre dans la liste Experiment des objets container__define, 0 sinon\n"\
					";\n"\
					"; Utilis dans cl.pro pour appeller util_ajouter_info_experiment")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_007_GET_ORBITOGEN",
					"",
					"",
					"; (pour toutes les expriences) Retourne 1 si l exprience doit apparaitre dans la liste Experiment des objets orbitogen__define, 0 sinon\n"\
					";\n"\
					"; Utilis dans cl.pro pour appeller util_ajouter_info_experiment")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_008_GET_TITLE",
					"",
					"",
					"; (pour toutes les expriences) Retourne 1 si l exprience doit apparaitre dans la liste Experiment des objets title__define, 0 sinon\n"\
					";\n"\
					"; Utilis dans cl.pro pour appeller util_ajouter_info_experiment")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_009_GET_PRODUCTSINFO",
					"",
					"",
					"; (pour toutes les expriences) Retourne 1 si l exprience doit apparaitre dans Info/Products, 0 sinon\n"\
					";\n"\
					"; Utilis dans cl.pro pour appeller util_ajouter_info_experiment")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_010_GET_COMMENTAIRE",
					"",
					"",
					"; (pour toutes les expriences) Retourne un tableau de commentaires, un commentaire par produit, qui seront affichs dans Products des objects.\n"\
					";\n"\
					"; Utilis dans cl.pro pour appeller util_ajouter_info_experiment")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_011_GET_IS_VALID",
					"noproduit",
					"noproduit:input",
					"; (pour toutes les expriences) Retourne 1 si le produit est un produit valide, 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_012_GET_IS_SPECTRO",
					"noproduit",
					"noproduit:input",
					"; (pour toutes les expriences) Retourne 1 si le produit est un produit spectrogramme, 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit\n"\
					";\n"\
					"; -----------------------------------------------\n"\
					"; Rcapitulatif pour les expriences avec EXP_MOM\n"\
					"; -----------------------------------------------\n"\
					"; 001: GET_CANCOMPUTE2D\n"\
					"; 002: GET_PHI\n"\
					"; 003: GET_XMOY\n"\
					"; 004: GET_ORDRECLUSTER\n"\
					"; 005: GET_COMPUTE_ALL\n"\
					"; 006: GET_MREP2\n"\
					"; 008: AFTER_COMPUTATION\n"\
					"; 009: GET_QUICK_SOLID\n"\
					"; 010: GET_SC_POT_VOLT\n"\
					"; 011: GET_USE_HIA_MASSE\n"\
					"; 012: GET_USE_LONG_VAR\n"\
					"; 013: GET_CORRECT_TABLE\n"\
					"; 014: GET_REP2NAME\n"\
					"; 015: USE_SCPOT\n"\
					";\n"\
					";				CALCUL DES MOMENTS			001 002 003 004 005 006 008 009 010 011 012 013 014             015\n"\
					";\n"\
					";  ace				non(pas 3D)\n"\
					";  ascii			OUI(si 3D)	faux(eff?fg?)		!\n"\
					";  aspera3:	*els*		OUI					1   ok  ok  0    0  1   ok  0   ok  0   0   0   [vide sc mso]   1\n"\
					";		*ima*		OUI					0   ok  ok  0    1  1   ok  0   ok  0   0   0   [vide sc mso]   0\n"\
					";		npd1		OUI 		absurde			!\n"\
					";		npd2		OUI 		absurde			!\n"\
					";		npi		non(pas 3D)\n"\
					";  aspera4:	*els*		OUI					1   ok  ok  0    0  1   ok  0   ok  0   0   0   [sc sc vso]     1\n"\
					";		*ima*		OUI					0   ok  ok  0    1  1   ok  0   ok  0   0   0   [sc sc vso]     0\n"\
					";		npd1		OUI 		absurde			!\n"\
					";		npd2		OUI 		absurde			!\n"\
					";		npi		non(pas 3D)\n"\
					";  cluster:	*codif*		OUI					0   ok  ok  1    1  1   ok  0   ok  0   0   0   [gse sc gse]    1\n"\
					";  		*hia*		OUI					0   ok  ok  1    1  1   ok  0   ok  1   0   0   [gse sc gse]    1\n"\
					";  		*peace*		OUI 		faux(eff?fg?)		1   ok  ok  1    1  x   ok  0   ok  0   0   0   [gse sc gse]    1\n"\
					";  demeter:	ice		non(pas 3D)\n"\
					";		idp		non(pas 3D)\n"\
					";		imsc		non(pas 3D)\n"\
					";  *dsp*			OUI					0   ok  ok  1    1  1   ok  0   ok  1   0   0   [gse sc gse]    1\n"\
					";  geotail			non(pas 3D)\n"\
					";  interball:	*electron*	OUI					0   ok  ok  1    0  1   ok  0   ok  0   0   0   [elec elec gse] 1\n"\
					";		elecxchy	non(pas 3D)\n"\
					";		ionxchy		non(pas 3D)\n"\
					";  mgs				non(pas 3D)\n"\
					";  plugin_caa			OUI(si 3D) 	faux(eff?fg?)	        !\n"\
					";  sacc				non(pas 3D)\n"\
					";  stereo:	let		non(pas 3D)\n"\
					";		plastic		non(pas 3D)\n"\
					";		sept		non(pas 3D)\n"\
					";		sit		non(pas 3D)\n"\
					";		ste		non(pas 3D)\n"\
					";		*swea*		OUI					1  ok   ok  0    1  1   ok  0   ok  0   1   0   [sc sc gse rtn] 1\n"\
					";  themis:	*eesa*		OUI					1  ok   ok  1    1  1   ok  1   ok  0   ok  0   [dsl dsl gse]   1\n"\
					";		*esst*		OUI					1  ok   ok  1    1  1   ok  0   ok  0   0   0   [dsl dsl gse]   1\n"\
					";		fbk		non(pas 3D)\n"\
					";		*iesa*		OUI					1  ok   ok  1    1  1   ok  1   ok  1   ok  0   [dsl dsl gse]   1\n"\
					";		*isst*		OUI					1  ok   ok  1    1  1   ok  0   ok  1   0   0   [dsl dsl gse]   1\n"\
					";  wind				non(pas 3D)\n"\
					";  xmm				non(pas 3D)\n"\
					";\n"\
					"; ----------------------------------------------\n"\
					"; Rcapitulatif pour les expriences avec EXP_VB\n"\
					"; ----------------------------------------------\n"\
					"; 001: GET_INPUT\n"\
					"; 002: GET_OUT\n"\
					"; 003: GET_MASSE\n"\
					"; 004: GET_DMAX\n"\
					";\n"\
					";			001	002	003				004\n"\
					";\n"\
					"; cluster_codif		ok	ok	[1.,4.,4.,16.]*MASSEPROTON	4000d\n"\
					"; cluster_hia		ok	ok	masseproton			4000d\n"\
					"; dsp			ok	ok	masseproton			4000d\n"\
					"; themis_eesa		ok	ok	masseelectron			4000d\n"\
					"; themis_iesa		ok	ok	masseproton			4000d")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_013_GET_IS_AUX",
					"noproduit,      aux_nom,       aux_enreg,       aux_taille,       champB,       moments_board",
					"noproduit:input aux_nom:output aux_enreg:output aux_taille:output champB:output moments_board:output",
					"; (pour toutes les expriences) Retourne 1 si le produit permet de calculer des donnes auxilliaires (ex: module vecteur, passage repre gsm).\n"\
					"\n"\
					"; Pour toutes les expriences\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - aux_nom:       (si ncessaire) noms des champs a afficher dans les widgets pour les donnes auxilliaires\n"\
					";  - aux_enreg:     (si ncessaire) avec les donnes auxilliaires\n"\
					";  - aux_taille:    (si ncessaire) d octets de la structure donnes auxilliaires\n"\
					";  - champB:        1 si ce produit contient des donnes champ magntique\n"\
					";  - moments_board: 1 si ce produit contient des donnes moments board")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,0,
					"EXP_ALL_014_GET_AUX",
					"general,      noproduit,      nosat,      tmp,      tmpaux",
					"general:input noproduit:input nosat:input tmp:input tmpaux:input",
					"; (pour toutes les expriences) Calcule les donnes auxilliaires.\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - general:   (RO) objet general\n"\
					";  - noproduit: (RO) numro du produit\n"\
					";  - nosat:     (RO) numro du satellite\n"\
					";  - tmp:       (RO) tableau de structure avec les donnes lues\n"\
					";  - tmpaux:    (RW) tableau de structure avec les donnes auxilliaires  calculer\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - tmpaux:    tableau de structure avec les donnes auxilliaires correspondantes calcules")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_015_GET_USEFILLVAL",
					"noproduit",
					"noproduit:input",
					"; (pour toutes les expriences) Retourne 1 si le produit utilise FILLVAL renvoy par EXP_ALL_016_GET_FILLVAL.\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_016_GET_FILLVAL",
					"noproduit",
					"noproduit:input",
					"; (pour toutes les expriences) Retourne la valeur de FILLVAL (appele uniquement si le EXP_ALL_015_GET_USEFILLVAL correspondant vaut 1).\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_017_GET_TFILLVAL",
					"noproduit",
					"noproduit:input",
					"; (pour toutes les expriences) Retourne le caractre correspondant  FILLVAL (utile si le fichier ascii ne dfinit pas bien FILLVALL).\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_ALL_018_GET_DATEMINMAX",
					"nosat",
					"nosat:input",
					"; (pour toutes les expriences) Retourne un tableau [date_debut_donnes, date_fin_donnes] (en nbmsec depuis 1/1/1958)\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - nosat: (RO) numro du satellite")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_019_GET_NOMCALIB",
					"",
					"",
					"; (pour toutes les expriences) Retourne le nom qui sera utilis lors de l appel  EXP_SPE_014_CALIB_LIRE dans  compute_timeseries et compute_count3d")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_020_GET_VERSION",
					"noproduit",
					"noproduit:input",
					"; (pour toutes les expriences) Retourne le premier caractre du numro de version dans les nom des fichier de donnes (typiquement V ou v)\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_021_GET_NOMPRODUIT",
					"noproduit",
					"noproduit:input",
					"; (pour toutes les expriences) Retourne le nom du produit qui sera affich  l cran si ncessaire\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_022_GET_REPERTOIRE",
					"racine,       noproduit,       nosat",
					"racine:input  noproduit:input  nosat:input",
					"; (pour toutes les expriences) Retourne le rpertoire o se trouve le fichier de donnes\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - racine:      (RO) racine des donnes (typiquement /DATA)\n"\
					";  - noproduit:   (RO) numro du produit\n"\
					";  - nosat:       (RO) numro du satellite")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_023_GET_FICHIER",
					"noproduit,       nosat,       version",
					"noproduit:input  nosat:input  version:input",
					"; (pour toutes les expriences) Retourne le nom du fichier de donnes\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit\n"\
					";  - nosat:     (RO) numro du satellite\n"\
					";  - version:   (RO) chaine identifiant la version (ex: V??)")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_024_GET_NON_INT_MILLI",
					"noproduit",
					"noproduit:input",
					"; (pour toutes les expriences) Retourne 1 ou 2 si la datation des donnes peut contenir des millisecondes non entires, 0 sinon\n"\
					"; 1 pour supprimer les fractions de millisecondes, 2 pour garder les fractions de millisecondes.\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_025_GET_TABPRIORITE",
					"tabpriorite",
					"tabpriorite:input",
					"; (pour toutes les expriences) Retourne un tableau[nbproduits] de priorits entre 1 (maximale) et 99 (minimale) qui sera utilis si plusieurs produits existent en mme temps dans un spectrogramme\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - tabpriorite: (RO) tableau[nbproduits] contenant que des 99")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_026_GET_HAS_CURRENT",
					"noproduit",
					"noproduit:input",
					"; (pour toutes les expriences) Retourne 1 si le produit permet de calculer current, 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_027_GET_HAS_OH",
					"noproduit",
					"noproduit:input",
					"; (pour toutes les expriences) Retourne 1 si le produit permet de calculer oh, 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_028_GET_HAS_VB",
					"noproduit",
					"noproduit:input",
					"; (pour toutes les expriences) Retourne 1 si le produit permet de calculer vb, 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_029_GET_NBSENSITIVITY",
					"",
					"",
					"; (pour toutes les expriences) Retourne le nombre de sensitivity (1 ou 2)")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_030_GET_EPOCH",
					"nosat,       noproduit",
					"nosat:input  noproduit:input",
					"; (pour toutes les expriences) Retourne un tableau [nom_variable_epoch ou chaine vide, annee_reference_epoch ou chaine vide] (utile pour les fichiers THEMIS)\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - nosat:     (RO) numro du satellite\n"\
					";  - noproduit: (RO) numro du produit")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_031_HAS_DATA_TO_CLDATA",
					"noproduit",
					"noproduit:input",
					"; (pour toutes les expriences) Retourne 1 si la routine EXP_ALL_032_DATA_TO_CLDATA doit tre appele, 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,0,
					"EXP_ALL_032_DATA_TO_CLDATA",
					"noproduit,      nosat,      filename,      tmp,      general,      REC_START,       REC_COUNT,       *self.enreg,  ENERGIES,        DT,        THETA,        PHI,        MASS,        PROPERTY,        UNIT123D,        NAME123D,        NAME_THETA,        UNIT_THETA,        NAME_PHI,        UNIT_PHI,        NAME_ENERGY,        UNIT_ENERGY,        NAME_MASS,        UNIT_MASS,       getinf=getinf",
					"noproduit:input nosat:input filename:input tmp:input general:input REC_START:input  REC_COUNT:input  struct:input  ENERGIES:output  DT:output  THETA:output  PHI:output  MASS:output  PROPERTY:output  UNIT123D:output  NAME123D:output  NAME_THETA:output  UNIT_THETA:output  NAME_PHI:output  UNIT_PHI:output  NAME_ENERGY:output  UNIT_ENERGY:output  NAME_MASS:output  UNIT_MASS:output getinf=getinf:input",
					"; (pour toutes les expriences) Traitement particulier des donnes  faire dans cette routine\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - general:           (RO) objet general\n"\
					";  - nosat:             (RO) numro du satellite\n"\
					";  - filename:          (RO) nom du fichier  lire\n"\
					";  - REC_START:         (RO) enregistrement dbut\n"\
					";  - REC_COUNT:         (RO) nombre d enregistrements a lire\n"\
					";  - noproduit:         (RO) numro du produit\n"\
					";  - tmp:               (RW) tableau de structure de donnes lues (si binaire GETCO==1) ou  lire (si ascii ou cdf)\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - tmp:               tableau de structure de donnes lues aprs traitement (si binaire et GETCO==1) ou lecture (si ascii ou cdf)\n"\
					";  - ENERGIES:          table d energies		(pas obligatoire)\n"\
					";  - DT:                structure DT			(pas obligatoire)\n"\
					";  - THETA              table d angles THETA		(pas obligatoire)\n"\
					";  - PHI:               table d angles PHI		(pas obligatoire)\n"\
					";  - MASS:              table de MASS			(pas obligatoire)\n"\
					";  - PROPERTY:          chaine PROPERTY des comptages	(pas obligatoire)\n"\
					";  - UNIT123D:          chaine UNIT des comptages	(pas obligatoire)\n"\
					";  - NAME123D:          chaine NAME des comptages	(pas obligatoire)\n"\
					";  - NAME_THETA:        chaine NAME des angles theta	(pas obligatoire)\n"\
					";  - UNIT_THETA:        chaine UNIT des angles theta	(pas obligatoire)\n"\
					";  - NAME_PHI:          chaine NAME des angles phi	(pas obligatoire)\n"\
					";  - UNIT_PHI:          chaine UNIT des angles phi	(pas obligatoire)\n"\
					";  - NAME_ENERGY:       chaine NAME des nergies	(pas obligatoire)\n"\
					";  - UNIT_ENERGY:       chaine UNIT des nergies	(pas obligatoire)\n"\
					";  - NAME_MASS:         chaine NAME des masses		(pas obligatoire)\n"\
					";  - UNIT_MASS:         chaine UNIT des masses		(pas obligatoire)")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_033_GET_NBSAT",
					"",
					"",
					"; (pour toutes les expriences) Retourne le nombre de satellites pour l exprience")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_034_GET_NOSAT",
					"nosat",
					"nosat:input",
					"; (pour toutes les expriences) Retourne la chaine de caractre SC suivi du numro du satellite\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - nosat: (RO) numro du satellite")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_035_GET_NOMSAT",
					"nosat",
					"nosat:input",
					"; (pour toutes les expriences) Retourne une chaine de caractre avec le nom du satellite\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - nosat: (RO) numro du satellite")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_036_GET_NOMNOSAT",
					"nosat",
					"nosat:input",
					"; (pour toutes les expriences) Retourne une chaine de caractre avec SC suivi du numro du satellite puis le nom du satellite entre parenthses\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - nosat: (RO) numro du satellite")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_037_GET_MISSION",
					"noproduit_dynamique,      nosat_dynamique",
					"noproduit_dynamique:input nosat_dynamique:input",
					"; (pour toutes les expriences) Retourne une chaine de caractre avec le nom de la mission\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit_dynamique: (RO) numro du produit\n"\
					";  - nosat_dynamique:     (RO) numro du satellite")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_038_GET_SOURCE_NAME",
					"noproduit_dynamique,      nosat_dynamique",
					"noproduit_dynamique:input nosat_dynamique:input",
					"; (pour toutes les expriences) Retourne une chaine de caractre avec le nom de la mission puis > mission puis spacecraft et le numro du satellite\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit_dynamique: (RO) numro du produit\n"\
					";  - nosat_dynamique:     (RO) numro du satellite")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_039_GET_DESCRIPTOR",
					"noproduit_dynamique,      nosat_dynamique",
					"noproduit_dynamique:input nosat_dynamique:input",
					"; (pour toutes les expriences) Retourne une chaine de caractre avec le nom abrge de l exprience puis > puis le nom complet de l exprience\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit_dynamique: (RO) numro du produit\n"\
					";  - nosat_dynamique:     (RO) numro du satellite")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_040_GET_PI_NAME",
					"noproduit_dynamique,      nosat_dynamique",
					"noproduit_dynamique:input nosat_dynamique:input",
					"; (pour toutes les expriences) Retourne une chaine de caractre avec le nom du PI de l exprience\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit_dynamique: (RO) numro du produit\n"\
					";  - nosat_dynamique:     (RO) numro du satellite")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_041_GET_PI_AFFILIATION",
					"noproduit_dynamique,      nosat_dynamique",
					"noproduit_dynamique:input nosat_dynamique:input",
					"; (pour toutes les expriences) Retourne une chaine de caractre avec le nom du labo du PI de l exprience\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit_dynamique: (RO) numro du produit\n"\
					";  - nosat_dynamique:     (RO) numro du satellite")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_042_GET_TXT_CEF",
					"noproduit_dynamique,      nosat_dynamique",
					"noproduit_dynamique:input nosat_dynamique:input",
					"; (pour toutes les expriences) Retourne une chaine de caractre commencant par ! avec le nom de l exprience\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit_dynamique: (RO) numro du produit\n"\
					";  - nosat_dynamique:     (RO) numro du satellite")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_ALL_043_GET_SHIFT",
					"general,      t1_calib,     t2_calib,     nosat",
					"general:input time_t1:input time_t2:input nosat:input",
					"; (pour toutes les expriences) Retourne un tableau de temps permettant de shifter les donnes\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - general:  (RO) objet general\n"\
					";  - t1_calib: (RO) temps dbut\n"\
					";  - t2_calib: (RO) temps fin\n"\
					";  - nosat:    (RO) numro du satellite\n"\
					";\n"\
					"; Retourne:\n"\
					"; ---------\n"\
					";   shift[*,0]: tableau de temps a lire (au moins temps dbut et temps fin)\n"\
					";   shift[*,1]: tableau de temps correspondant a afficher, donc aprs dcalage")

	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_044_GET_HAS_CURRENTIE",
					"noproduit",
					"noproduit:input",
					"; (pour toutes les expriences) Retourne 1 si le produit permet de calculer current avec les ions et les electrons, 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit")

	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_045_GET_HAS_GRADPRESSMOM",
					"noproduit",
					"noproduit:input",
					"; (pour toutes les expriences) Retourne 1 si le produit permet de calculer le gradient de pression avec les moments prcalculs, 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit")

	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_ALL_046_GET_HAS_LAWOHM",
					"noproduit",
					"noproduit:input",
					"; (pour toutes les expriences) Retourne 1 si le produit permet de calculer les termes de la loi d ohm, 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit")

	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,0,
					"EXP_ALL_500_INIT",
					"param0,       tab_infos,        tabcommentaire,        current_nom,        current_enreg,        current_taille,        currentie_nom,        currentie_enreg,        currentie_taille,       gradpressmom_enreg,       gradpressmom_taille,       gradpressmom_nom,       gradpressmom_unite,        gradpressmom_libelle,        lawohm_enreg,       lawohm_taille,       lawohm_nom,       lawohm_unite,       lawohm_libelle,       oh_nom,        oh_enreg,        oh_taille,        vb_nom,        vb_enreg,        vb_taille",
					"param0:input  tab_infos:output  tabcommentaire:output  current_nom:output  current_enreg:output  current_taille:output  currentie_nom:output  currentie_enreg:output  currentie_taille:output gradpressmom_enreg:output gradpressmom_taille:output gradpressmom_nom:output gradpressmom_unite:output  gradpressmom_libelle:output  lawohm_enreg:output lawohm_taille:output lawohm_nom:output lawohm_unite:output lawohm_libelle:output oh_nom:output  oh_enreg:output  oh_taille:output  vb_nom:output  vb_enreg:output  vb_taille:output",
					"; (pour toutes les expriences) Retourne des structure des donnes permettant le stockage en mmoire de certaines donnes calcules (current, oh, vb)\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - param0: (RW) structure avec au moins les champs { h1, so1, o1, he1, he2, o2, ion8, ion16, ion32, ion64 }\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - param0:           champs h1, so1, o1, he1, he2, o2, ion8, ion16, ion32, ion64 ventuellement modifis			(pas obligatoire)\n"\
					";  - tab_infos:        tableau[nbproduits] de structure avec les champs { nbspectres, nbangles, nbangles_a_lire, nbenergies }	(pas obligatoire)\n"\
					";  - tabcommentaire:   tableau de commentaires, un commentaire par produit							(pas obligatoire)\n"\
					";  - current_nom:      noms des champs dans la structure current								(pas obligatoire)\n"\
					";  - current_enreg:    structure pour les donnes current									(pas obligatoire)\n"\
					";  - current_taille:   nombre d octets dans la structure current								(pas obligatoire)\n"\
					";  - currentie_nom:    noms des champs dans la structure currentie								(pas obligatoire)\n"\
					";  - currentie_enreg:  structure pour les donnes currentie									(pas obligatoire)\n"\
					";  - currentie_taille: nombre d octets dans la structure currentie								(pas obligatoire)\n"\
					";  - oh_nom:           noms des champs dans la structure oh									(pas obligatoire)\n"\
					";  - oh_enreg:         structure pour les donnes oh										(pas obligatoire)\n"\
					";  - oh_taille:        nombre d octets dans les donnes oh									(pas obligatoire)\n"\
					";  - vb_nom:           noms des champs dans la structure vb									(pas obligatoire)\n"\
					";  - vb_enreg:         structure pour les donnes vb										(pas obligatoire)\n"\
					";  - vb_taille:        nombre d octets dans les donnes vb									(pas obligatoire)")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,0,
					"EXP_ALL_600_GET_STRUCTURE",
					"infos,       param,       isascii,        iscdf,        isorbito,        libelle,        unite,        classe,        keywords,        nom,        enreg,        enreg0b,        enreg1b,        enreg2b,        taille,        taille1,        taille1b,        enreg1,        enregcoups,        ENERGIES,        THETA,        PHI,        MASS,       DT,        PROPERTY,        UNIT123D,        NAME123D,        NAME_THETA,        UNIT_THETA,        NAME_PHI,        UNIT_PHI,        NAME_ENERGY,        UNIT_ENERGY,       NAME_MASS,        UNIT_MASS",
					"infos:input  param:input  isascii:output  iscdf:output  isorbito:output  libelle:output  unite:output  classe:output  keywords:output  nom:output  enreg:output  enreg0b:output  enreg1b:output  enreg2b:output  taille:output  taille1:output  taille1b:output  enreg1:output  enregcoups:output  ENERGIES:output  THETA:output  PHI:output  MASS:output DT:output  PROPERTY:output  UNIT123D:output  NAME123D:output  NAME_THETA:output  UNIT_THETA:output  NAME_PHI:output  UNIT_PHI:output  NAME_ENERGY:output  UNIT_ENERGY:output NAME_MASS:output  UNIT_MASS:output",
					"; (pour toutes les expriences) Retourne des informations permettant le stockage des donnes en mmoire des donnes lues\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - infos:  (RO) structure tab_infos[noproduit] renvoye par EXP_ALL_500_INIT\n"\
					";  - param:  (RO) structure, on est en train de traiter le produit param.noproduit\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - isascii :    1 si le produit concerne un fichier ascii, 0 sinon\n"\
					";  - iscdf:       1 si le produit concerne un fichier cdf, 0 sinon\n"\
					";  - isorbito:    1 si le produit contient des donnes d orbite, 0 sinon\n"\
					";  - libelle:     tableau de libells, un libell par champ du fichier de donnes\n"\
					";  - unite:       tableau d units, une unit par champ du fichier de donnes\n"\
					";  - classe:      tableau de classe, une classe par champ du fichier de donnes\n"\
					";  - keywords:    keywords associs\n"\
					";  - nom:         tableau de noms, un nom par champ du fichier de donnes\n"\
					";  - enreg:       structure pour les donnes\n"\
										";  - enreg0b:     structure pour les donnes si on supprime les comptages\n"\
					";  - enreg1b:     structure pour les donnes si on compresse les comptages sur 1 octet\n"\
					";  - enreg2b:     structure pour les donnes si on compresse les comptages sur 2 octets\n"\
					";  - taille:      nombre d octets dans la structure enreg\n"\
					";  - taille1:     utilis uniquement pour CLUSTER-CODIF P5(WEC) et P6(FGM)\n"\
					";  - taille1b:    nombre d octets dans la structure enreg1b\n"\
					";  - enreg1:      utilis uniquement pour CLUSTER-CODIF P5(WEC) et P6(FGM)\n"\
					";  - enregcoups:  utilis uniquement pour ASPERA3-IMA et ASPERA4-IMA (structure des donnes non compresses)\n"\
					";  - ENERGIES:    utilis uniquement pour PLUGIN\n"\
					";  - THETA:       utilis uniquement pour PLUGIN\n"\
					";  - PHI:         utilis uniquement pour PLUGIN\n"\
					";  - MASS:        utilis uniquement pour PLUGIN\n"\
					";  - DT:          utilis uniquement pour PLUGIN\n"\
					";  - PROPERTY:    utilis uniquement pour PLUGIN\n"\
					";  - UNIT123D:    utilis uniquement pour PLUGIN\n"\
					";  - NAME123D:    utilis uniquement pour PLUGIN\n"\
					";  - NAME_THETA:  utilis uniquement pour PLUGIN\n"\
					";  - UNIT_THETA:  utilis uniquement pour PLUGIN\n"\
					";  - NAME_PHI:    utilis uniquement pour PLUGIN\n"\
					";  - UNIT_PHI:    utilis uniquement pour PLUGIN\n"\
					";  - NAME_ENERGY: utilis uniquement pour PLUGIN\n"\
					";  - UNIT_ENERGY: utilis uniquement pour PLUGIN\n"\
					";  - NAME_MASS:   utilis uniquement pour PLUGIN\n"\
					";  - UNIT_MASS:   utilis uniquement pour PLUGIN")


	no1_spe=no
	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_MOM_001_GET_CANCOMPUTE2D",
					"",
					"",
					"; (pour les expriences spectro) Retourne 1 si on peut calculer les moments  partir de comptages 2D (modes avec un seul theta et plusieurs phi ou un seul phi et plusieurs theta)")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,1,
					"EXP_MOM_002_GET_PHI",
					"sensitivity,       nbspectres,       nbenergies,      noproduit,      phimin,        phimoy,        phimax,       IMA_PHI_MIN",
					"sensitivity:input  nbspectres:input  nbenergies:input noproduit:input phimin:output  phimoy:output  phimax:output IMA_PHI_MIN:input",
					"; (pour les expriences spectro) Retourne les tables d angles phi  utiliser dans le calcul des moments\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - sensitivity:   (RO) tableau sensitivity[nbspins]\n"\
					";  - nbspectres:    (RO) nombre de spectres\n"\
					";  - noproduit:     (RO) numro du produit\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - phimin:        tableau phimin[nbspectres] d angles PHI min  utiliser dans le calcul des moments\n"\
					";  - phimoy:        tableau phimoy[nbspectres] d angles PHI moy  utiliser dans le calcul des moments\n"\
					";  - phimax:        tableau phimax[nbspectres] d angles PHI max  utiliser dans le calcul des moments")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_MOM_003_GET_XMOY",
					"*self.data,      no1,      no2,      nb_accumulation,      tabdureespin",
					"data:input       no1:input no2:input nb_accumulation:input tabdureespin:input",
					"; (pour les expriences spectro) Retourne un tableau[nbspins] des temps mileux des points des moments (typiquement milieu du spin)\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - data:            (RO) tableau de structure des donnes lues\n"\
					";  - no1:             (RO) numro de l enregistrement correspondant au temps dbut (il y a nbspins spins de no1  no2)\n"\
					";  - no2:             (RO) numro de l enregistrement correspondant au temps fin   (il y a nbspins spins de no1  no2)\n"\
					";  - nb_accumulation: (RO) tableau[nbspins] du nombre de spins accumuls\n"\
					";  - tabdureespin:    (RO) tableau[nbspins] de dure de spin (en msec)")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_MOM_004_GET_ORDRECLUSTER",
					"",
					"",
					"; (pour les expriences spectro) Retourne 1 si les angles theta et phi ont la mme signification que pour CLUSTER\n"\
					";\n"\
					"; Retourne:\n"\
					"; ---------\n"\
					";   1 si les angles theta et phi ont la mme signification que pour CLUSTER, cad THETA=latitude et PHI=longitude\n"\
					";   0 dans le cas contraire, cad THETA=longitude et PHI=latitude")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_MOM_005_GET_COMPUTE_ALL",
					"",
					"",
					"; (pour les expriences spectro) Retourne 1 si aprs le calcul des moments on veut calculer des valeurs qui dpenent du champ magntique, 0 sinon\n"\
					";\n"\
					"; Retourne:\n"\
					"; ---------\n"\
					";   1 si aprs le calcul des moments on veut appeller:\n"\
					";       - matrep1_to_matrep2 pour exprimer le tenseur de pression    dans le repre o est exprim B (REPNAME[0])\n"\
					";                                                                 et dans un repre li  B: (B,Z^B,b^(Z^B)\n"\
					";                            et calculer An, Ng, Ppar_b, Pper1_b, Pper2_b, Tpar_b, Tper1_b, Tper2_b\n"\
					";       - get_vb pour calculer Vxpar, Vypar, Vzpar et Vpar                                         dans le repre o est exprim B (REPNAME[0])\n"\
					";                              Vxper, Vyper, Vzper et Vper                                         dans le repre o est exprim B (REPNAME[0])\n"\
					";                              Elx, Ely, Elz et El                                                 dans le repre o est exprim B (REPNAME[0])\n"\
					";                              Vxalfven_km_sec, Vyalfven_km_sec, Vzalfven_km_sec et Valfven_km_sec dans le repre o est exprim B (REPNAME[0])\n"\
					";	                       Pm_nPa, Beta, TBD_nPa, Qxpar, Qypar, Qzpar, Qpar, Qxper, Qyper, Qzper, Qper\n"\
					";   0 sinon")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,1,
					"EXP_MOM_006_GET_MREP2",
					"nomrep,       *self.param,       *self.data,       no1,       no2,       Z,       FILLVAL,       p,       nosat,       M00,       M01,       M02,       M10,       M11,       M12,       M20,       M21,       M22,        Mdate,        code,        msg",
					"nomrep:input  param:input        data:input        no1:input  no2:input  Z:input  FILLVAL:input  p:input  nosat:input  M00:output M01:output M02:output M10:output M11:output M12:output M20:output M21:output M22:output  Mdate:output  code:output  msg:output",
					"; (pour les expriences spectro) Retourne la matrice permettant de changer de repre\n"\
					";\n"\
					"; Il s agit d exprimer les vecteurs (Vx,Vy,Vz) + (Qx+Qy,Qz) + (Ex,Ey,Ez) + (Bx,By,Bz) issus du calcul des moments dans le repre nomrep\n"\
					"; Ces nouveaux vecteurs sont stocks dans des champs spcifiques de la structure Z\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - nomrep:  (RO) nom du repre destination\n"\
					";  - param:   (RO) structure\n"\
					";  - data:    (RO) tableau de structure de donnes lues\n"\
					";  - no1:     (RO) numro de l enregistrement correspondant au temps dbut (il y a nbspins spins de no1  no2)\n"\
					";  - no2:     (RO) numro de l enregistrement correspondant au temps fin   (il y a nbspins spins de no1  no2)\n"\
					";  - Z:       (RO) tableau de structure contenant les donnes moments\n"\
					";  - FILLVAL: (RO) valeur FILLVAL utilise\n"\
					";  - p:       (RO) tableau[99,66,9] de tous les produits\n"\
					";  - nosat:   (RO) numro du satellite\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - M00:   lment[nbelts] de la matrice  appliquer pour passer les vecteurs (Vx,Vy,Vz) + (Qx+Qy,Qz) + (Ex,Ey,Ez) de Z dans le repre nomrep\n"\
					";  - M01:   idem\n"\
					";  - M02:   idem\n"\
					";  - M10:   idem\n"\
					";  - M11:   idem\n"\
					";  - M12:   idem\n"\
					";  - M20:   idem\n"\
					";  - M21:   idem\n"\
					";  - M22:   idem\n"\
					";  - Mdate: tableau[nbelts] de date des lments de la matrice (nbmsec depuis 1/1/1958)\n"\
					";  - code:  -1 si le matrice n a pas pu tre obtenue, 1 ou 2 sinon\n"\
					";  - msg:   message d erreur si code==-1")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,1,
					"EXP_MOM_008_AFTER_COMPUTATION",
					"general,       nbcellules,       nbspectres,       nbenergies,       thetamin,       thetamax,       thetamoy,       phimin,       phimax,       phimoy,       sector,       sectornew,       sectornew_date,       indY,       (*self.data)[no1:no2].date, Z",
					"general:input  nbcellules:input  nbspectres:input  nbenergies:input  thetamin:input  thetamax:input  thetamoy:input  phimin:input  phimax:input  phimoy:input  sector:input  sectornew:input  sectornew_date:input  indY:input  date:input                  Z:input",
					"; (pour les expriences spectro) Traitement  effectuer aprs le calcul des momments\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - Z: (RW) tableau de structure avec les donnes moments  corriger\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - Z: tableau de structure avec les donnes moments corriges")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_MOM_009_GET_QUICK_SOLID",
					"noproduit",
					"noproduit:input",
					"; (pour les expriences spectro) Retourne 1 pour les expriences THEMIS-EESA et THEMIS-IESA, 0 sinon\n"\
					";\n"\
					"; Verrue pour les fichiers THEMIS-EESA et THEMIS-IESA qui ont 32 nergies mais certains modes n utilisent que 15 ou 24 nergies regroupes d une faon spciale");



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_MOM_010_GET_SC_POT_VOLT",
					"p,      *self.data,      no1,      no2,      nocis,      noproduit,      nosat",
					"p:input data:input       no1:input no2:input nocis:input noproduit:input nosat:input",
					"; (pour les expriences spectro) Retourne un tableau[nbspins] de potentiel de satellite (en Volt)\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - p:         (RO) tableau[99,66,9] de tous les produits\n"\
					";  - data:      (RO) tableau de structure de donnes lues\n"\
					";  - no1:       (RO) numro de l enregistrement correspondant au temps dbut (il y a nbspins spins de no1  no2)\n"\
					";  - no2:       (RO) numro de l enregistrement correspondant au temps fin   (il y a nbspins spins de no1  no2)\n"\
					";  - nocis:     (RO) numro de l exprience\n"\
					";  - noproduit: (RO) numro du produit\n"\
					";  - nosat:     (RO) numro su satellite")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_MOM_011_GET_USE_HIA_MASSE",
					"",
					"",
					"; (pour les expriences spectro) Retourne si la masse  utiliser dans le calcul de moments doit tre choisie par l utilisateur dans un widget: H+ He++ He+ ou O+, 0 sinon")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_MOM_012_GET_USE_LONG_VAR",
					"noproduit",
					"noproduit:input",
					"; (pour les expriences spectro) Retourne 1 pour considrer dans le calcul des moments que la longitude dpend de l nergie, 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit\n"\
					";\n"\
					"; Retourne:\n"\
					"; ---------\n"\
					";   1 si on doit considrer dans le calcul des moments que la longitude dpend de l nergie => calcul plus juste\n"\
					";     (indispensable pour trouver les mmes valeurs que Berkeley sur THEMIS-EESA et THEMIS-IESA)\n"\
					";   0 si on doit considrer dans le calcul des moments que la longitude ne dpend pas de l nergie => calcul un peu fauss\n"\
					";     (ce qui est fait sur CLUSTER par exemple)")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_MOM_013_GET_CORRECT_TABLE",
					"noproduit",
					"noproduit:input",
					"; (pour les expriences spectro) Retourne 1 si on doit supprimer les trous et les chevauchements dans les tables d nergies pour le calcul des moments (jamais  1 pour l instant), 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit")

	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_MOM_014_GET_REP2NAME",
					"",
					"",
					"; (pour les expriences spectro) Retourne un tableau de chaine de caractres contenant le nom du repre de B, des donnes et ls autres repres  considrer\n"\
					";\n"\
					"; Retourne:\n"\
					"; ---------\n"\
					";   Un tableau de chaine de caractres contenant des noms de repres:\n"\
					";    - nom du repre dans lequel sont exprimes les composantes du champ magntique B\n"\
					";    - puis nom du repre dans lequel sont exprimes les vecteurs  la sortie du calcul des moments en C\n"\
					";    - puis un ou plusieurs noms de repres dans lequels les vecteurs moments devront tre exprims\n"\
					";\n"\
					"; ex: pour aspera3(els+ima)                1=rien 2=sc   3=mso\n"\
					"; ex: pour aspera4(els+ima)                1=sc   2=sc   3=vso\n"\
					"; ex: pour cluster(codif+hia+peace) et dsp 1=gse  2=sc   3=gse\n"\
					"; ex: pour interball(electron)             1=elec 2=elec 3=gse\n"\
					"; ex: pour stereo(swea)                    1=sc   2=sc   3=gse 4=rtn\n"\
					"; ex: pour themis(eesa+esst+iesa+isst)     1=dsl  2=dsl  3=gse")

	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_MOM_015_USE_SCPOT",
					"",
					"",
					"; (pour les expriences spectro) Retourne 1 pour utiliser le rsultat de EXP_MOM_010_GET_SC_POT_VOLT comme potentiel de satellite dans les tracs moments, time_pitchangle et pitch_cjf, 0 sinon")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,1,
					"EXP_VB_001_GET_INPUT",
					"(*self.data)[no1+ind], m,      FILLVAL,       Vx,                   Vy,                   Vz,                   N_cm3,        Pp_nPa,       Pper_nPa",
					"data:input             m:input FILLVAL:input  Vx_gse_km_sec:output  Vy_gse_km_sec:output  Vz_gse_km_sec:output  N_cm3:output  Pp_nPa:input  Pper_nPa:input",
					"; (pour les expriences spectro) Retourne les les donnes qui seront utilises en entre lors du calcul de VB avec les moments bords\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - data:     (RO) tableau de structure contenant les donnes moments bord\n"\
					";  - m:        (RO) numro de la masse (0 pour la premire)\n"\
					";  - FILLVAL:  (RO) valeur fillaire\n"\
					";  - Pp_nPa:   (RW) tableau initialis  FILLVALL\n"\
					";  - Pper_nPa: (RW) tableau initialis  FILLVALL\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - Vx_gse_km_sec: tableau de composantes vitesse en X en km/sec\n"\
					";  - Vy_gse_km_sec: tableau de composantes vitesse en Y en km/sec\n"\
					";  - Vz_gse_km_sec: tableau de composantes vitesse en Z en km/sec\n"\
					";  - N_cm3:         tableau de densits en 1/cm3\n"\
					";  - Pp_nPa:        tableau de Pp (???) en nPa\n"\
					";  - Pper_nPa:      tableau de pression perpendiculaire (???) en nPa")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_VB_002_GET_OUT",
					"",
					"",
					"; (pour les expriences spectro) Retourne les noms des champs dans la structure vb_enreg o seront stockes les rsultats\n"\
					";\n"\
					"; Retourne:\n"\
					"; ---------\n"\
					";   un tableau [20,nbmasses] de noms de champs dans la structure vb_enreg o seront stockes les rsultats:\n"\
					";     0: Vxpar\n"\
					";     1: Vypar\n"\
					";     2: Vzpar\n"\
					";     3: Vpar\n"\
					";     4: Vxper\n"\
					";     5: Vyper\n"\
					";     6: Vzper\n"\
					";     7: Vper\n"\
					";     8: Elx\n"\
					";     9: Ely\n"\
					";    10: Elz\n"\
					";    11: El\n"\
					";    12: Pp_nPa\n"\
					";    13: Pm_nPa\n"\
					";    14: Beta\n"\
					";    15: TBD_nPa\n"\
					";    16: Vxalfven_gse_km_sec\n"\
					";    17: Vyalfven_gse_km_sec\n"\
					";    18: Vzalfven_gse_km_sec\n"\
					";    19: Valfven_km_sec")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_VB_003_GET_MASSE",
					"noproduit",
					"noproduit:input",
					"; (pour les expriences spectro) Retourne un tableau avec les diffrentes masses en kg\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit:       (RO) numro du produit")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_VB_004_GET_DMAX",
					"",
					"",
					"; (pour les expriences spectro) Retourne le nombre de ms qu il faut ajouter aux temps des donnes moments bord pour obtenir le temps fin de validit")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_001_GET_SENSITIVITY",
					"*self.data, no1,       no2,       nbspins,       G",
					"data:input  no1:input  no2:input  nbspins:input  G:input",
					"; (pour les expriences spectro) Retourne un tableau[nbspins] de sensitivity (1 pour high, 0 pour low)\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - data:    (RO) tableau de structure contenant les donnes lues\n"\
					";  - no1:     (RO) numro de l enregistrement correspondant au temps dbut (il y a nbspins spins de no1  no2)\n"\
					";  - no2:     (RO) numro de l enregistrement correspondant au temps fin   (il y a nbspins spins de no1  no2)\n"\
					";  - nbspins: (RO) nombre de spins lus\n"\
					";  - G:       (RO) (uniquement pour cluster_hia et dsp, non dfini pour les autres expriences) 1 pour grand G et 0 pour petit g\n"\
					";\n"\
					"; la mthode mre retourne un tableau de 0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_002_GET_PHASE",
					"*self.data, no1,       no2,       nbspins,      self.indP",
					"data:input  no1:input  no2:input  nbspins:input indP:input",
					"; (pour les expriences spectro) Retourne un tableau[nbspins] de phase instrument\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - data:    (RO) tableau de structure contenant les donnes lues\n"\
					";  - no1:     (RO) numro de l enregistrement correspondant au temps dbut (il y a nbspins spins de no1  no2)\n"\
					";  - no2:     (RO) numro de l enregistrement correspondant au temps fin   (il y a nbspins spins de no1  no2)\n"\
					";  - nbspins: (RO) nombre de spins lus\n"\
					";  - indP:    (RO) indP lu dans un fichier ASCII\n"\
					";\n"\
					"; la mthode mre retourne un tableau de 0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_003_GET_CIS_MODE",
					"*self.data, no1,       no2,       nbspins",
					"data:input  no1:input  no2:input  nbspins:input",
					"; (pour les expriences spectro) Retourne un tableau[nbspins] de cis_mode\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - data:    (RO) tableau de structure contenant les donnes lues\n"\
					";  - no1:     (RO) numro de l enregistrement correspondant au temps dbut (il y a nbspins spins de no1  no2)\n"\
					";  - no2:     (RO) numro de l enregistrement correspondant au temps fin   (il y a nbspins spins de no1  no2)\n"\
					";  - nbspins: (RO) nombre de spins lus\n"\
					";\n"\
					"; la mthode mre retourne un tableau de 0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_004_GET_MAG",
					"cis_mode,       *self.data, no1,       no2,       nbspins",
					"cis_mode:input  data:input  no1:input  no2:input  nbspins:input",
					"; (pour les expriences spectro) Retourne un tableau[nbspins] de magun tableau[nbspins] de mag\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - data:    (RO) tableau de structure contenant les donnes lues\n"\
					";  - no1:     (RO) numro de l enregistrement correspondant au temps dbut (il y a nbspins spins de no1  no2)\n"\
					";  - no2:     (RO) numro de l enregistrement correspondant au temps fin   (il y a nbspins spins de no1  no2)\n"\
					";  - nbspins: (RO) nombre de spins lus\n"\
					";\n"\
					"; Retourne:\n"\
					"; ---------\n"\
					";   un tableau[nbspins] de mag:\n"\
					";        0 pour les modes solar wind\n"\
					";        1 pour les modes magntosphriques classiques (cis_mode >= 5.5)\n"\
					";        2 pour les modes magntosphriques CODIF cis_mode==12 ou cis_mode==13  partir du 2/11/2003\n"\
					";\n"\
					"; la mthode mre retourne un tableau de 1")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_005_GET_HVTBL",
					"*self.data, no1,       no2,       nbspins",
					"data:input  no1:input  no2:input  nbspins:input",
					"; (pour les expriences spectro) Retourne un tableau[nbspins] de hvtbl(numro de table d nergie utilise par HIA)\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - data:    (RO) tableau de structure contenant les donnes lues\n"\
					";  - no1:     (RO) numro de l enregistrement correspondant au temps dbut (il y a nbspins spins de no1  no2)\n"\
					";  - no2:     (RO) numro de l enregistrement correspondant au temps fin   (il y a nbspins spins de no1  no2)\n"\
					";  - nbspins: (RO) nombre de spins lus\n"\
					";\n"\
					"; la mthode mre retourne un tableau de 0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_006_GET_PMAG",
					"nocis,       nosat,       p,       Bresolution",
					"nocis:input  nosat:input  p:input  Bresolution:input",
					"; (pour les expriences spectro) Retourne l objet contenant les donnes champ magntique\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - nocis:       (RO) numro de l exprience\n"\
					";  - nosat:       (RO) numro du satellite\n"\
					";  - p:           (RO) tableau[99,66,9] de tous les produits\n"\
					";  - Bresolution: (RO) chaine identifiant la source du champ magntique (ex: 1 sec ou 4 sec)\n"\
					";\n"\
					"; la mthode mre retourne -1")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,1,
					"EXP_SPE_007_GET_NOB",
					"datafgm,      noBx,       noBy,       noBz",
					"datafgm:input noBx:output noBy:output noBz:output",
					"; (pour les expriences spectro) Retourne les numros des champs des composantes du champ magntique\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - datafgm: (RO) structure de donnes champ magntique lues\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - noBx: numro du champ dans la structure qui contient la composante X de B\n"\
					";  - noBy: numro du champ dans la structure qui contient la composante Y de B\n"\
					";  - noBz: numro du champ dans la structure qui contient la composante Z de B\n"\
					";\n"\
					"; la mthode mre ne fait rien")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,1,
					"EXP_SPE_008_GET_INFOB",
					"Bresolution,      BaverageT,      BaverageN,      ordre_cluster,      nox,      noy,      noz,      time_t1,      time_t2,      nosat,      moins180plus180,      datafgm,      noBx,      noBy,      noBz,      info_B",
					"Bresolution:input BaverageT:input BaverageN:input ordre_cluster:input nox:input noy:input noz:input time_t1:input time_t2:input nosat:input moins180plus180:input datafgm:input noBx:input noBy:input noBz:input info_B:output",
					"; (pour les expriences spectro) Retourne les donnes champ magntique en angle theta et phi\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - Bresolution:     (RO) chaine identifiant la source du champ magntique (ex: 1 sec ou 4 sec) (indispensable pour INTERBALL)\n"\
					";  - BaverageT:       (RO) chaine identifiant le type de moyenne pour B\n"\
					";  - BaverageN:       (RO) nombre de secondes si on fait la moyenne de B\n"\
					";  - ordre_cluster:   (RO) valeur retourne par EXP_MOM_004_GET_ORDRECLUSTER\n"\
					";  - nox:             (RO) valeur retourne par EXP_SPE_046_GET_NOX\n"\
					";  - noy:             (RO) valeur retourne par EXP_SPE_047_GET_NOY\n"\
					";  - noz:             (RO) valeur retourne par EXP_SPE_048_GET_NOZ\n"\
					";  - time_t1:         (RO) on demande les donnes champ magntique  partir de time_t1 (nbmsec depuis 1/1/1958)\n"\
					";  - time_t2:         (RO) on demande les donnes champ magntique jusqu      time_t2 (nbmsec depuis 1/1/1958)\n"\
					";  - nosat:           (RO) numro du satellite\n"\
					";  - moins180plus180: (RO) 1 pour obtenir des angles entre -180 et +180, 0 pour les avoir entre 0 et +360\n"\
					";  - datafgm:         (RO) tableau de structure des donnes champ magntique lues\n"\
					";  - noBx:            (RO) numro du champ dans la structure qui contient la composante X de B\n"\
					";  - noBy:            (RO) numro du champ dans la structure qui contient la composante Y de B\n"\
					";  - noBz:            (RO) numro du champ dans la structure qui contient la composante Z de B\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - info_B: pointeur sur un tableau[N,3] o N est le nombre de points\n"\
					";             indice 0: valeur de l angle theta\n"\
					";             indice 1: valeur de l angle phi\n"\
					";             indice 2: 1 pour +B et 2 pour -B\n"\
					";\n"\
					"; la mthode mre fait le traitement pour cluster, dsp et themis")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,1,
					"EXP_SPE_009_GET_B",
					"*self.data,      noproduit,      nb_accumulation,      no1,      ind,      datafgm,      noBx,      noBy,      noBz,      FILLVAL,      Bresolution,      BaverageT,      BaverageN,      isVB,      Bx,       By,       Bz",
					"data:input       noproduit:input nb_accumulation:input no1:input ind:input datafgm:input noBx:input noBy:input noBz:input FILLVAL:input Bresolution:input BaverageT:input BaverageN:input isVB:input Bx:output By:output Bz:output",
					"; (pour les expriences spectro) Retourne les composantes du champ magntique\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - data:            (RO) tableau de structure des donnes lues (avec comptages si isVB==0, momentsboard si isVB==1)\n"\
					";  - noproduit:       (RO) numro du produit\n"\
					";  - nb_accumulation: (RO) tableau[nbspins] du nombre de spins accumuls\n"\
					";  - no1:             (RO) numro de l enregistrement correspondant au temps dbut\n"\
					";  - ind:             (RO) tableau d indices, on s intresse aux donnes data[no1+ind]\n"\
					";  - datafgm:         (RO) tableau de structure des donnes champ magntique lues\n"\
					";  - noBx:            (RO) numro du champ dans la structure datafgm qui contient la composante X de B\n"\
					";  - noBy:            (RO) numro du champ dans la structure datafgm qui contient la composante Y de B\n"\
					";  - noBz:            (RO) numro du champ dans la structure datafgm qui contient la composante Z de B\n"\
					";  - FILLVAL:         (RO) valeur fillaire utilise dans les donnes champ magntique\n"\
					";  - Bresolution:     (RO) chaine identifiant la source du champ magntique (ex: 1 sec ou 4 sec)\n"\
					";  - BaverageT:       (RO) chaine identifiant le type de moyenne pour B\n"\
					";  - BaverageN:       (RO) nombre de secondes si on fait la moyenne de B\n"\
					";  - isVB:            (RO) 1 si l est dans produit::get_vb, 0 sinon\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - Bx: tableau de Bx aux temps de data[no1+ind], de mme dimension que ind\n"\
					";  - By: tableau de By aux temps de data[no1+ind], de mme dimension que ind\n"\
					";  - Bz: tableau de Bz aux temps de data[no1+ind], de mme dimension que ind\n"\
					";\n"\
					"; la mthode mre fait le traitement pour cluster, dsp et themis")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,1,
					"EXP_SPE_010_GET_VBOARD",
					"p,      nocis,      nosat,      time_t,      ion,      Vx,       Vy,       Vz",
					"p:input nocis:input nosat:input time_t:input ion:input Vx:output Vy:output Vz:output",
					"; (pour les expriences spectro) Retourne les composantes de la vitesse trouves dans les donnes moments bord\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - p:     (RO) tableau[99,66,9] de tous les produits\n"\
					";  - nocis: (RO) nom de l exprience\n"\
					";  - nosat: (RO) numro du satellite\n"\
					";  - time_t:(RO) tableau de temps (en ms depuis 1/1/1958)\n"\
					";  - ion:   (RO) nom de l ion H+ He++ He+ O+\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - Vx: tableau de composantes X de la vitesse aux temps time_t\n"\
					";  - Vy: tableau de composantes Y de la vitesse aux temps time_t\n"\
					";  - Vz: tableau de composantes Z de la vitesse aux temps time_t\n"\
					";\n"\
					"; la mthode mre fait rien")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_011_GET_ORBITE_HAS_L_ORBIT",
					"",
					"",
					"; (pour les expriences spectro) Retourne 1 si les donnes orbite contiennent les champs L et orbit (ex: demeter_ice et demeter_idp), 0 sinon\n"\
					";\n"\
					"; la mthode mre retourne 0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_012_GET_PORBITE",
					"p,       nosat",
					"p:input  nosat:input",
					"; (pour les expriences spectro) Retourne l objet contenant les donnes orbite\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - p:     (RO) tableau[99,66,9] de tous les produits\n"\
					";  - nosat: (RO) numro du satellite\n"\
					";\n"\
					"; la mthode mre retourne 0")


		
	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_013_CALIB_INIT",
					"nosat",
					"nosat:input",
					"; (pour les expriences spectro) Routine apelle avant de lire les calibrations qui doit retourner 0 si ok\n"\
					";\n"\
					"; la mthode mre retourne 0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_014_CALIB_LIRE",
					"nomcalib,       nosat,       t1_calib,       t2_calib,        general=general",
					"nomcalib:input  nosat:input  t1_calib:input  t2_calib:output  general=general:input",
					"; (pour les expriences spectro) Retourne la date jusqu a laquelle les calibrations sont utilisables\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - nomcalib:        (RO) calibration  prendre en compte (chaine renvoye par EXP_ALL_019_GET_NOMCALIB ou EFF pour CODIF)\n"\
					";  - nosat:           (RO) numro du satellite\n"\
					";  - t1_calib:        (RO) on veut faire un trac qui commence  t1_calib (nbmsec depuis le 1/1/1958)\n"\
					";  - t2_calib:        (RW) on veut faire un trac qui se termine  t2_calib (nbmsec depuis le 1/1958)\n"\
					";  - general=general: (RO) objet general (utilis par aspera3_els et aspera4_els pour obtenir p)\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - t2_calib: date (nbmsec depuis 1/1/1958) jusqu a laquelle les calibrations sont utilisables\n"\
					";\n"\
					"; Retourne:\n"\
					"; ---------\n"\
					";  0 si OK, autre valeur sinon\n"\
					";\n"\
					"; la mthode mre ne fait que positionner t2_calib au 31/12/2999 23:59:59.999\n"\
					";-------------------------------------------------------------------------------")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,0,
					"EXP_SPE_015_GET_CALIB",
					"nocis,       nosat,       general,       noproduit,       nbspins,       nbenergies,       nbcellules,       nbmasses,       nbspectres,       *self.data,       ENERGIES,       t1,       t2,       rpa,       no1,       no2,       cis_mode,       spin_average,       Q,       masses,       B,       mag,       hvtbl,       ntrace,       pindY,       mass,      use_Eproton,      E,        nb_accumulation,        indY,        indC,        duree_comptage,        facteurG,        efficacite,        deadtimes,        IMA_MASS,        IMA_MASS_POS1,        IMA_MASS_POS2,        IMA_REVMASS,        IMA_THETA,        IMA_PHI,        IMA_E,        IMA_M,        IMA_MASS_MULT,        IMA_PHI_MIN,        IMA_PHI_MAX,        sampling,       DEMETER_TAB_FULLNRJRATIO_IDP,       DEMETER_TAB_FULLNRJCOUNT_IDP,       DEMETER_HISTO_PER_ENERGY_SPEC,       DEMETER_TABLE_DEMETER,       DEMETER_TABLE_TARANIS,       gf",
					"nocis:input  nosat:input  general:input  noproduit:input  nbspins:input  nbenergies:input  nbcellules:input  nbmasses:input  nbspectres:input  data:input        ENERGIES:input  t1:input  t2:input  rpa:input  no1:input  no2:input  cis_mode:input  spin_average:input  Q:input  masses:input  B:input  mag:input  hvtbl:input  ntrace:input  pindY:input  mass:input use_Eproton:input E:output  nb_accumulation:output  indY:output  indC:output  duree_comptage:output  facteurG:output  efficacite:output  deadtimes:output  IMA_MASS:output  IMA_MASS_POS1:output  IMA_MASS_POS2:output  IMA_REVMASS:output  IMA_THETA:output  IMA_PHI:output  IMA_E:output  IMA_M:output  IMA_MASS_MULT:output  IMA_PHI_MIN:output  IMA_PHI_MAX:output  sampling:output DEMETER_TAB_FULLNRJRATIO_IDP:output DEMETER_TAB_FULLNRJCOUNT_IDP:output DEMETER_HISTO_PER_ENERGY_SPEC:output DEMETER_TABLE_DEMETER:output DEMETER_TABLE_TARANIS:output gf:output",
					"; (pour les expriences spectro) Retourne diffrentes tables issues des calibrations (efficacite, facteur de geomtrie, ...)\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - nocis:        (RO) numro de l exprience\n"\
					";  - nosat:        (RO) numro du satellite\n"\
					";  - general:      (RO) objet general\n"\
					";  - noproduit:    (RO) numro du produit\n"\
					";  - nbspins:      (RO) nombre de spins\n"\
					";  - nbenergies:   (RO) nombre d nergies\n"\
					";  - nbcellules:   (RO) nombre de cellules\n"\
					";  - nbmasses:     (RO) nombre de masses\n"\
					";  - nbspectres:   (RO) nombre de spectres\n"\
					";  - data:         (RO) tableau de structures de donnes lues\n"\
					";  - ENERGIES:     (RO) (uniquement lorsque les tables d nergies ont t lues dans le fichier de donnes) tableau [nbenergies,3]\n"\
					";  - t1:           (RO) temps dbut des donnes\n"\
					";  - t2:           (RO) temps fin des donnes\n"\
					";  - rpa:          (RO) (uniquement pouc cluster-codif) valeur rpa\n"\
					";  - no1:          (RO) numro de l enregistrement correspondant au temps dbut\n"\
					";  - no2:          (RO) numro de l enregistrement correspondant au temps fin\n"\
					";  - cis_mode:     (RO) valeur renvoye par EXP_SPE_015_GET_CALIB\n"\
					";  - spin_average: (RO) 1 pour une rsolution de 1 spin, 0 pour une rsolution de 1 spectre\n"\
					";  - Q:            (RO) valeur renvoye par EXP_SPE_031_GET_Q_MASSE\n"\
					";  - masses:       (RO) nombre de masses\n"\
					";  - B:            (RO) pour HIA (balayage en petit g ou grand G)\n"\
					";  - mag:          (RO) valeur renvoye par EXP_SPE_004_GET_MAG\n"\
					";  - hvtbl:        (RO) valeur renvoye par EXP_SPE_005_GET_HVTBL\n"\
					";  - ntrace:       (RO) niveau de trace\n"\
					";  - pindY:        (RO) (uniquement pour les fichiers ASCII_CEF_CDF) tableau avec les numros de tables d nergies\n"\
					";  - mass:         (RO) (uniquement pour aspera3-ima) numro de la masse pour savoir si c est H+ ou non\n"\
					";  - use_Eproton:  (RO) (uniquement pour demeter-idp) 1 si on utilise les protons, 0 si on utilise les lctrons\n"\
					";\n"\
					"; Sorties:\n"\
					"; ---------\n"\
					";  - E:                             E[nbenergies,3 (0=MIN 1=MOY 2=MAX),nbtables]                                         tables d nergies\n"\
					";  - nb_accumulation:               nb_accumulation[nbspins]                                                             table de nombre de spins accumuls\n"\
					";  - indY:                          indY[nbspins]                                                                        numro de la table d nergie  utiliser\n"\
					";  - indC:                          indC[nbspins]                                                                        numro de la carte en angle  utiliser lorsqu il y en a plusieurs (arrive sur themis-iesa)\n"\
					";  - duree_comptage:                duree_comptage[nbspins]                                                              dure des comptages en sec\n"\
					";  - facteurG:                      facteurG[le nombre de dimensions dpend de EXP_SPE_039_GET_TYPE_FG]                  table de facteur de gomtrie en m2.sr.(eV/eV)\n"\
					";  - efficacite:                    efficacite[le nombre de dimensions dpend de EXP_SPE_038_GET_TYPE_EFF]               table d efficacite\n"\
					";  - deadtimes:                     (uniquement pour cluster-codif) deadtimes[2]                                         valeurs non utilises\n"\
					";  - IMA_MASS:                      (uniquement pour aspera3-ima et aspera4-ima) IMA_MASS[8 Pac,      96 nergies, 8 masses (H+, He++, He+, O++, O+, CO+, O2+, CO2+)]\n"\
					";  - IMA_MASS_POS1:                 (uniquement pour aspera3-ima et aspera4-ima) IMA_MASS_POS1[8 Pac, 96 nergies, 8 masses (H+, He++, He+, O++, O+, CO+, O2+, CO2+)]\n"\
					";  - IMA_MASS_POS2:                 (uniquement pour aspera3-ima et aspera4-ima) IMA_MASS_POS2[8 Pac, 96 nergies, 8 masses (H+, He++, He+, O++, O+, CO+, O2+, CO2+)]\n"\
					";  - IMA_REVMASS:                   (uniquement pour aspera3-ima et aspera4-ima) IMA_REVMASS[32 masses, 96 nergies, 8 Pac]\n"\
					";  - IMA_THETA:                     (uniquement pour aspera3-ima et aspera4-ima) IMA_THETA[16 angles theta]\n"\
					";  - IMA_PHI:                       (uniquement pour aspera3-ima et aspera4-ima) IMA_PHI[16 angles phi]\n"\
					";  - IMA_E:                         (uniquement pour aspera3-ima) IMA_E[96]                                              lu dans resource/ima_calib_mex, pour R. Lundin\n"\
					";  - IMA_M:                         (uniquement pour aspera3-ima) IMA_M[32]                                              lu dans resource/ima_calib_mex, pour R. Lundin\n"\
					";  - IMA_MASS_MULT:                 (uniquement pour aspera3-ima) IMA_MASS_MULT[32]                                      lu dans resource/ima_calib_mex, pour R. Lundin\n"\
					";  - IMA_PHI_MIN:                   (uniquement pour aspera3-ima et aspera4-ima) IMA_PHI_MIN[16 angles phi]              table d angles phi min\n"\
					";  - IMA_PHI_MAX:                   (uniquement pour aspera3-ima et aspera4-ima) IMA_PHI_MAX[16 angles phi]              table d angles phi max\n"\
					";  - sampling:                      (uniquement pour aspera4-ima) sampling[16,16,96]                                     valeurs non utiliss\n"\
					";  - DEMETER_TAB_FULLNRJRATIO_IDP:  (uniquement pour pour demeter-idp) DEMETER_TAB_FULLNRJRATIO_IDP[255]                 lu dans resource/demeter_idp_correction.txt\n"\
					";  - DEMETER_TAB_FULLNRJCOUNT_IDP:  (uniquement pour pour demeter-idp) DEMETER_TAB_FULLNRJCOUNT_IDP[255]                 lu dans resource/demeter_idp_correction.txt\n"\
					";  - DEMETER_HISTO_PER_ENERGY_SPEC: (uniquement pour pour demeter-idp) DEMETER_HISTO_PER_ENERGY_SPEC[256,255]            lu dans resource/demeter_idp_correction.txt\n"\
					";  - DEMETER_TABLE_DEMETER:         (uniquement pour pour demeter-idp) DEMETER_TABLE_DEMETER[nbenergies]                 table de Gangloff\n"\
					";  - DEMETER_TABLE_TARANIS:         (uniquement pour pour demeter-idp) DEMETER_TABLE_TARANIS[nbenergies]                 table de Popescu\n"\
					";\n"\
					"; la mthode mre ne fait rien")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_016_GET_CJF_UNIT",
					"noproduit",
					"noproduit:input",
					"; (pour les expriences spectro) Retourne une chaine de caractre avec l unit physique utilise\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du poduit\n"\
					";\n"\
					"; la mthode mre retourne ???\n"\
					";\n"\
					"; mthode jamais utilise")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_017_GET_CJF",
					"noproduit,       0,           1,                2,               3,           4,          5,           6",
					"noproduit:input  COUNT:input  COUNT_SPIN:input  COUNT_SEC:input  C_SEC:input  FLUX:input  FDIST:input  JE:input",
					"; (pour les expriences spectro) Indique si cl sait calculer d autres units physiques\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit:  (RO) numro du poduit\n"\
					";  - COUNT:      (RO) valeur correspondant au count\n"\
					";  - COUNT_SPIN: (RO) valeur correspondant au count/spin\n"\
					";  - COUNT_SEC:  (RO) valeur correspondant au count/s\n"\
					";  - C_SEC:      (RO) valeur correspondant au c/s\n"\
					";  - FLUX:       (RO) valeur correspondant au flux/s\n"\
					";  - FDIST:      (RO) valeur correspondant au fdist\n"\
					";  - JE:         (RO) valeur correspondant au JE\n"\
					";\n"\
					"; Retourne:\n"\
					"; ---------\n"\
					";   si les donnes sont dans une unit et que cl ne sait pas calculer les autres, l faut renvoyer cette unit + 256 (pour forcer cl  utiliser cette unit)\n"\
					";   si les donnes sont dans une unit et que cl sait calculer les autres, renvoyer cette unit\n"\
					";\n"\
					"; la mthode mre retourne FLUX+256 (le fichier contient des FLUX et cl ne sait pas calculer autre chose  partir de ces FLUX)")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_018_GET_NBCELLULES_FDIST2D",
					"",
					"",
					"; (pour les expriences spectro) Retourne le nombre de cellules  crer artificiellement dans les fonctions de distributions si le produit donne plusieurs spectres mais une seule cellule (ex: cluster-hia P10)\n"\
					";\n"\
					"; la mthode mre retourne 8")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,1,
					"EXP_SPE_019_GET_THETA",
					"sensitivity,       nosat,       nbcellules,       nbenergies,       noproduit,      IMA_THETA,       nogse=nogse,       full=full,      thetamin,        thetamoy,        thetamax",
					"sensitivity:input  nosat:input  nbcellules:input  nbenergies:input  noproduit:input IMA_THETA:input  nogse=nogse:input  full=full:input thetamin:output  thetamoy:output  thetamax:output",
					"; (pour les expriences spectro) Retourne les tables d angles theta a utiliser hors calcul des moments\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - sensitivity:   (RO) valeur renvoye par EXP_SPE_001_GET_SENSITIVITY\n"\
					";  - nosat:         (RO) numro du satellite\n"\
					";  - nbcellules:    (RO) nombre de cellules\n"\
					";  - nbenergies:    (RO) nombre d energies\n"\
					";  - IMA_THETA:     (RO) (uniquement pour aspera3-ima et aspera4-ima) table d angles theta de IMA\n"\
					";  - nogse=nogse:   (RO) (utile uniquement pour cluster) 1 pour avoir les angles dans le repre de la manip (calcul des moments), 0 pour les avoir en pseudo-gse (autres tracs)\n"\
					";  - full=full:     (RO) (utile uniquement pour JUNO-JADEE) 1 pour avoir les angles[nbcellules,nbenergies]\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - thetamin: tableau d angles min de theta en deg\n"\
					";  - thetamoy: tableau d angles moy de theta en deg\n"\
					";  - thetamax: tableau d angles max de theta en deg\n"\
					";\n"\
					"; la mthode mre retourne des angles entre -90 et +90")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_020_GET_NBSPECTRES_FDIST2D",
					"",
					"",
					"; (pour les expriences spectro) Retourne le nombre de spectres  crer artificiellement dans les fonctions de distributions si le produit donne plusieurs cellules mais un seul spectre (ex: cluster-hia P11)\n"\
					";\n"\
					"; la mthode mre retourne 16")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,1,
					"EXP_SPE_021_GET_PHI",
					"nocis,      phase,      sensitivity,      mag,      B,      nbspectres,      nbspins,      (*self.param).nbenergies, tab1ienergy,      tab2ienergy,      *self.data, no1,      no2,      noproduit,      IMA_PHI_MIN,      IMA_PHI_MAX,      phimin,       phimoy,       phimax,       start,       start_pollution_solaire,        end_pollution_solaire",
					"nocis:input phase:input sensitivity:input mag:input B:input nbspectres:input nbspins:input nbenergies:input          tab1ienergy:input tab2ienergy:input data:input  no1:input no2:input noproduit:input IMA_PHI_MIN:input IMA_PHI_MAX:input phimin:output phimoy:output phimax:output start:output start_pollution_solaire:output  end_pollution_solaire:output",
					"; (pour les expriences spectro) Retourne  les tables d angles phi a utiliser hors calcul des moments\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - nocis:       (RO) numro de l exprience\n"\
					";  - phase:       (RO) valeur renvoye par EXP_SPE_002_GET_PHASE\n"\
					";  - sensitivity: (RO) valeur renvoye par EXP_SPE_001_GET_SENSITIVITY\n"\
					";  - mag:         (RO) valeur renvoye par EXP_SPE_004_GET_MAG\n"\
					";  - B:           (RO) pour HIA (balayage en petit g ou grand G)\n"\
					";  - nbspectres:  (RO) nombre de spectres\n"\
					";  - nbspins:     (RO) nombre de spins\n"\
					";  - nbenergies:  (RO) nombre d energies\n"\
					";  - data:        (RO) tableau de structure avec les donnes lues\n"\
					";  - no1:         (RO) numro de l enregistrement correspondant au temps dbut\n"\
					";  - no2:         (RO) numro de l enregistrement correspondant au temps fin\n"\
					";  - noproduit:   (RO) numro du produit\n"\
					";  - IMA_PHI_MIN: (RO) uniquement pour aspera3-ima et aspera4-ima valeur renvoye par EXP_SPE_015_GET_CALIB\n"\
					";  - IMA_PHI_MAX: (RO) uniquement pour aspera3-ima et aspera4-ima valeur renvoye par EXP_SPE_015_GET_CALIB\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - phimin: tableau d angles min de phi en deg\n"\
					";  - phimoy: tableau d angles moy de phi en deg\n"\
					";  - phimax: tableau d angles max de phi en deg\n"\
					";  - start:                   (uniquement pour cluster et dsp) tableau[nbspins]\n"\
					";  - start_pollution_solaire: (uniquement pour cluster et dsp) tableau[nbspins]\n"\
					";  - end_pollution_solaire:   (uniquement pour cluster et dsp) tableau[nbspins]\n"\
					";\n"\
					"; la mthode mre retourne des angles entre +90 et +180")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,1,
					"EXP_SPE_022_GET_SOLID_SECTOR",
					"param,       solid,        sector,        sectornew,        sectornew_date",
					"param:input  solid:output  sector:output  sectornew:output  sectornew_date:output",
					"; (pour les expriences spectro) Retourne les tables d angles solid + sector\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - param (RO) structure avec les champs nbangles nbspectres\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - solid:          tableau[nbspectres,nbcellules] contenant le numro de comptages  lire pour chaque couple(cellule,spectre)\n"\
					";  - sector:         tableau[nbspectres,nbcellules] contenant une valeur par laquelle le comptage doit tre divis (en cas de regroupement de cellules)\n"\
					";  - sectornew:      tableau[nbspectres,nbcellules]  utiliser  la place de sector  partir de la date sectornew_date\n"\
					";  - sectornew_date: date (nbmsec depuis 1/1/1958)  partir de laquelle il faut utiliser sectornew ( cause de HIA)\n"\
					";\n"\
					"; la mthode mre donne pour solid des valeurs allant de 0  nbspectres*nbcellules-1, 1 pour sector, avec sectornew_data au 1/1/9999")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_SPE_023_GET_DUREEVALIDITESPIN",
					"*self.data,       no1,       no2,       nbspins,       nbenergies,       nbspectres,       noproduit,       nb_accumulation,       DT",
					"data:input        no1:input  no2:input  nbspins:input  nbenergies:input  nbspectres:input  noproduit:input  nb_accumulation:input  DT:input",
					"; (pour les expriences spectro) Retourne un tableau[nbspins] de dure de validit des donnes de chaque spin (en sec), en incluant les spins accumuls\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - data:            (RO) tableau de structure avec les donnes lues\n"\
					";  - no1:             (RO) numro de l enregistrement correspondant au temps dbut (il y a nbspins entre no1 et no2)\n"\
					";  - no2:             (RO) numro de l enregistrement correspondant au temps fin (il y a nbspins entre no1 et no2)\n"\
					";  - nbspins:         (RO) nombre de spins\n"\
					";  - nbenergies:      (RO) nombre d nergies\n"\
					";  - nbspectres:      (RO) nombre de spectres\n"\
					";  - noproduit:       (RO) numro du produit\n"\
					";  - nb_accumulation: (RO) tableau[nbspins] avec le nombre de spins accumuls\n"\
					";  - DT:              (RO) (uniquement pour les fichiers avec mtdonnes) structure avec les champs DELTA_PLUS et DELTA_MINUS\n"\
					";\n"\
					"; la mthode mre retourne un tableau[nbspins] avec que des 1")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_SPE_024_GET_DUREESPIN",
					"*self.data,       no1,       no2,       nbspins,       nbenergies,       nbspectres,       noproduit,       DT",
					"data:input        no1:input  no2:input  nbspins:input  nbenergies:input  nbspectres:input  noproduit:input  DT:input",
					"; (pour les expriences spectro) Retourne un tableau[nbspins] de dure de validit des donnes de chaque spin (en sec), sans inclure les spins accumuls\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - data:            (RO) tableau de structure avec les donnes lues\n"\
					";  - no1:             (RO) numro de l enregistrement correspondant au temps dbut (il y a nbspins entre no1 et no2)\n"\
					";  - no2:             (RO) numro de l enregistrement correspondant au temps fin (il y a nbspins entre no1 et no2)\n"\
					";  - nbspins:         (RO) nombre de spins\n"\
					";  - nbenergies:      (RO) nombre d nergies\n"\
					";  - nbspectres:      (RO) nombre de spectres\n"\
					";  - noproduit:       (RO) numro du produit\n"\
					";  - DT:              (RO) (uniquement pour les fichiers avec mtdonnes) structure avec les champs DELTA_PLUS et DELTA_MINUS\n"\
					";\n"\
					"; la mthode mre retourne un tableau[nbspins] avec que des 1")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,0,
					"EXP_SPE_025_GET_EMOY",
					"general,       nosat,       t1_calib,       ENERGIES=ENERGIES,      Emoy",
					"general:input  nosat:input  t1_calib:input  ENERGIES=ENERGIES:input Emoy:output",
					"; (pour les expriences spectro) Retourne les nergies qui seront affiches dans le widget Tools\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - general:          (RO) objet general\n"\
					";  - nosat:            (RO) numro du satellite\n"\
					";  - t1_calib:         (RO) temps (nbmsec depuis 1/1/1958)  partir duquel on doit lire les calibrations\n"\
					";  - ENERGIES=ENERGIES (RO) table d nergies dja lue dans le fichier\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - Emoy: tableau de chane de caractres avec les nergies qui seront affiches dans le widget Tools\n"\
					";\n"\
					"; la mthode mre ne fait rien")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_026_GET_EMIN",
					"",
					"",
					"; (pour les expriences spectro) Retourne la valeur emin qui sera utilise en chelle automatique dans les spectros avec l nergie en ordonne\n"\
					";\n"\
					"; la mthode mre retourne 10.0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_027_GET_EMAX",
					"",
					"",
					"; (pour les expriences spectro) Retourne la valeur emax qui sera utilise en chelle automatique dans les spectros avec l nergie en ordonne\n"\
					";\n"\
					"; la mthode mre retourne 40000.0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_028_USE_SCPOT",
					"",
					"",
					"; (pour les expriences spectro) Retourne 1 si la valeur du potentiel du satellite doit tre ajout aux tables d nergies (1 uniquement pour aspera3-ima et aspera4-ima, pour R. Lundin), 0 sinon\n"\
					";\n"\
					"; la mthode mre retourne 0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_029_GET_DEADTIME",
					"param",
					"param:input",
					"; (pour les expriences spectro) Retourne un tableau[2] (duree en sec et valeur min du denominateur) qui sera utilis en C pour passer en valeurs physiques\n"\
					";\n"\
					"; la mthode mre retourne un tableau de 0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,1,
					"EXP_SPE_030_GET_INFOMASSES",
					"noproduit,       infos,       param",
					"noproduit:input  infos:input  param:input",
					"; (pour les expriences spectro) Retourne des informations sur les imasses\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit\n"\
					";  - infos:     (RO) structure tab_infos[noproduit] renvoye par EXP_ALL_500_INIT\n"\
					";  - param:     (RO) structure avec les champs avec au moins les champs { ion8, ion16, ion32, nbcellules, B, G, masses, nbmasses, index }\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - param.masses:     diffrentes masses\n"\
					";  - param.nbmasses:   nombre de masses\n"\
					";  - param.index:      (uniquement pour aspera3-ima et aspera4-ima) 1 pour les donnes avec fichiers d index)\n"\
					";  - param.B:          (uniquement pour cluster-hia et dsp)\n"\
					";  - param.G:          (uniquement pour cluster-hia et dsp)\n"\
					";  - param.nbcellules: (uniquement pour aspera3-npd1, aspera3-npd2, aspera4-npd1 et aspera4-npd2)\n"\
					";\n"\
					"; la mthode mre positionne juste param.nbmasses  1")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,1,
					"EXP_SPE_031_GET_Q_MASSE",
					"noproduit,       MASSEPROTON,       MASSEELECTRON,       nbmasses,       masses,       hia_masse=hia_masse,      Q,        MASSE",
					"noproduit:input  MASSEPROTON:input  MASSEELECTRON:input  nbmasses:input  masses:input  hia_masse=hia_masse:input Q:output  MASSE:output",
					"; (pour les expriences spectro) Retourne un tableau de charges et de masses\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit:           (RO) numro du produit\n"\
					";  - MASSEPROTON:         (RO) masse proton en kg\n"\
					";  - MASSEELECTRON:       (RO) masse lectron en kg\n"\
					";  - nbmasses:            (RO) nombre de masses\n"\
					";  - masses:              (RO) tableau de masses\n"\
					";  - hia_masse=hia_masse: (RO) numro de la masse  utiliser (0=H+ 1=He++ 2=He+ 3=O+)\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - Q:     tableau de charges\n"\
					";  - MASSE: tableau de masses (en kg)\n"\
					";\n"\
					"; la mthode mre positionne Q  1 et MASSE  MASSEELECTRON")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,0,
					"EXP_SPE_032_GET_NBYTES",
					"noproduit",
					"noproduit:input",
					"; (pour les expriences spectro) Retourne le nombre d octets utiliss par un comptage (1, 2 ou 4)\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit\n"\
					";\n"\
					"; la mthode mre n existe pas")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_033_GETCO",
					"noproduit,      filename",
					"noproduit:input filename:input",
					"; (pour les expriences spectro) Retourne 1 s il faut lire les donnes en utilisant enreg1b, puis dcompresser les comptages avec dico, 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit\n"\
					";  - filename:  (RO) nom du fichier  lire\n"\
					";\n"\
					"; la mthode mre retourne 0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,0,1,
					"EXP_SPE_034_GET_DICO",
					"noproduit,      nbdico,       dico",
					"noproduit:input nbdico:output dico:output",
					"; (pour les expriences spectro) Retourne le dictionnaire permettant de dcompresser les comptages\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit\n"\
					";\n"\
					"; Sorties:\n"\
					"; --------\n"\
					";  - nbdico: nombre de vleurs dans dico\n"\
					";  - dico:   tableau[nbdico] de valeurs  utiliser pour dcompresser les comptages\n"\
					";\n"\
					"; la mthode mre ne fait rien")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_035_GET_CANUSEDICO",
					"noproduit",
					"noproduit:input",
					"; (pour les expriences spectro) Retourne 1 si les comptages peuvent tre compresss sur 1 ou 2 octets en mmoire en crant dynamiquement un dictionnaire, 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit\n"\
					";\n"\
					"; la mthode mre retourne 0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_036_GET_IS_FLOAT",
					"noproduit",
					"noproduit:input",
					"; (pour les expriences spectro) Retourne 1 si les comptages sont sur des float de 4 octets, 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit\n"\
					";\n"\
					"; la mthode mre retourne 0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_037_GET_RESPECT_SOLID",
					"",
					"",
					"; (pour les expriences spectro) Retourne 1 si dans les spectros time_energy il ne faut comptabiliser q une seule fois les comptages regroupant plusieurs thetas/phis, 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";  1 si dans les spectros time_energy il ne faut comptabiliser q une seule fois les comptages regroupant plusieurs thetas/phis\n"\
					";       (indispensable pour avoir les mmes rsultats que Berkeley sur themis)\n"\
					";  0 sinon\n"\
					";\n"\
					"; la mthode mre retourne 0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_038_GET_TYPE_EFF",
					"",
					"",
					"; (pour les expriences spectro) Retourne une valeur indiquant les dimensions de la table d efficacite\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";  1 si le tableau efficacite est de la forme efficacite[sensitivity,cellule,table,energie,masse]\n"\
					";  2 si le tableau efficacite est de la forme efficacite[cellule,spectre,energie]\n"\
					";  3 si le tableau efficacite est de la forme efficacite[cellule,spectre,spin]\n"\
					";\n"\
					"; la mthode mre retourne 1")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_039_GET_TYPE_FG",
					"",
					"",
					"; (pour les expriences spectro) Retourne une valeur indiquant les dimensions de la table de facteur de geometrie\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";  1 si le tableau facteurG est de la forme facteurG[sensitivity,cellule,table,energie]\n"\
					";  2 si le tableau facteurG est de la forme facteurG[energie,cellule,spectre,pac]\n"\
					";  3 si le tableau facteurG est de la forme facteurG[ienergie,ispin]\n"\
					";  4 si le tableau facteurG est de la forme facteurG[icellule,ispectre]\n"\
					";\n"\
					"; la mthode mre retourne 1")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_040_GET_NOMS_MAG",
					"",
					"",
					"; (pour les expriences spectro) Retourne un tableau de noms de Bresolution qui donne les diffrentes sources possibles du champ magntique que l utilisateur pourra choisir\n"\
					";\n"\
					"; la mthode mre retourne None")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_041_GET_TMIN",
					"",
					"",
					"; (pour les expriences spectro) Retourne la valeur thetamin a utilisee en chelle automatique dans les tracs time_theta et phi_theta\n"\
					";\n"\
					"; la mthode mre retourne -90")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_042_GET_TMAX",
					"",
					"",
					"; (pour les expriences spectro) Retourne la valeur thetamax a utilisee en chelle automatique dans les tracs time_theta et phi_theta\n"\
					";\n"\
					"; la mthode mre retourne 90")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_043_GET_PMIN",
					"",
					"",
					"; (pour les expriences spectro) Retourne la valeur phimin a utiliser en chelle automatique dans les tracs time_phi\n"\
					";\n"\
					"; la mthode mre retourne 0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_044_GET_PMAX",
					"",
					"",
					"; (pour les expriences spectro) Retourne la valeur phimax a utiliser en chelle automatique dans les tracs time_phi\n"\
					";\n"\
					"; la mthode mre retourne 360")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_045_GET_TPFRAME",
					"",
					"",
					"; (pour les expriences spectro) Retourne le nom du repre qui sera affich comme lgende des angles theta et phi dans les tracs time_theta, phi_theta et time_phi\n"\
					";\n"\
					"; la mthode mre retourne une chaine vide")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_046_GET_NOX",
					"",
					"",
					"; (pour les expriences spectro) Retourne une valeur exprimant la composante X issu du calcul des moments dans le repre exprience\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";  0 si la composante X issu du calcul des moments donne X dans le repre exprience\n"\
					";  1 si la composante X issu du calcul des moments donne Y dans le repre exprience\n"\
					";  2 si la composante X issu du calcul des moments donne Z dans le repre exprience\n"\
					";\n"\
					"; la mthode mre retourne 0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_047_GET_NOY",
					"",
					"",
					"; (pour les expriences spectro) Retourne une valeur exprimant la composante Y issu du calcul des moments dans le repre exprience\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";  0 si la composante Y issu du calcul des moments donne X dans le repre exprience\n"\
					";  1 si la composante Y issu du calcul des moments donne Y dans le repre exprience\n"\
					";  2 si la composante Y issu du calcul des moments donne Z dans le repre exprience\n"\
					";\n"\
					"; la mthode mre retourne 1")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_048_GET_NOZ",
					"",
					"",
					"; (pour les expriences spectro) Retourne une valeur exprimant la composante Z issu du calcul des moments dans le repre exprience\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";  0 si la composante Z issu du calcul des moments donne X dans le repre exprience\n"\
					";  1 si la composante Z issu du calcul des moments donne Y dans le repre exprience\n"\
					";  2 si la composante Z issu du calcul des moments donne Z dans le repre exprience\n"\
					";\n"\
					"; la mthode mre retourne 2")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_049_GET_NOXX",
					"",
					"",
					"; (pour les expriences spectro) Retourne une valeur exprimant la composante XX issu du calcul des moments dans le repre exprience\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";  0 si la composante XX issu du calcul des moments donne XX dans le repre exprience\n"\
					";  1 si la composante XX issu du calcul des moments donne XY dans le repre exprience\n"\
					";  2 si la composante XX issu du calcul des moments donne XZ dans le repre exprience\n"\
					";  3 si la composante XX issu du calcul des moments donne YY dans le repre exprience\n"\
					";  4 si la composante XX issu du calcul des moments donne YZ dans le repre exprience\n"\
					";  5 si la composante XX issu du calcul des moments donne ZZ dans le repre exprience\n"\
					";\n"\
					"; la mthode mre retourne 0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_050_GET_NOXY",
					"",
					"",
					"; (pour les expriences spectro) Retourne une valeur exprimant la composante XY issu du calcul des moments dans le repre exprience\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";  0 si la composante XY issu du calcul des moments donne XX dans le repre exprience\n"\
					";  1 si la composante XY issu du calcul des moments donne XY dans le repre exprience\n"\
					";  2 si la composante XY issu du calcul des moments donne XZ dans le repre exprience\n"\
					";  3 si la composante XY issu du calcul des moments donne YY dans le repre exprience\n"\
					";  4 si la composante XY issu du calcul des moments donne YZ dans le repre exprience\n"\
					";  5 si la composante XY issu du calcul des moments donne ZZ dans le repre exprience\n"\
					";\n"\
					"; la mthode mre retourne 1")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_051_GET_NOXZ",
					"",
					"",
					"; (pour les expriences spectro) Retourne une valeur exprimant la composante XZ issu du calcul des moments dans le repre exprience\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";  0 si la composante XZ issu du calcul des moments donne XX dans le repre exprience\n"\
					";  1 si la composante XZ issu du calcul des moments donne XY dans le repre exprience\n"\
					";  2 si la composante XZ issu du calcul des moments donne XZ dans le repre exprience\n"\
					";  3 si la composante XZ issu du calcul des moments donne YY dans le repre exprience\n"\
					";  4 si la composante XZ issu du calcul des moments donne YZ dans le repre exprience\n"\
					";  5 si la composante XZ issu du calcul des moments donne ZZ dans le repre exprience\n"\
					";\n"\
					"; la mthode mre retourne 2")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_052_GET_NOYY",
					"",
					"",
					"; (pour les expriences spectro) Retourne une valeur exprimant la composante YY issu du calcul des moments dans le repre exprience\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";  0 si la composante YY issu du calcul des moments donne XX dans le repre exprience\n"\
					";  1 si la composante YY issu du calcul des moments donne XY dans le repre exprience\n"\
					";  2 si la composante YY issu du calcul des moments donne XZ dans le repre exprience\n"\
					";  3 si la composante YY issu du calcul des moments donne YY dans le repre exprience\n"\
					";  4 si la composante YY issu du calcul des moments donne YZ dans le repre exprience\n"\
					";  5 si la composante YY issu du calcul des moments donne ZZ dans le repre exprience\n"\
					";\n"\
					"; la mthode mre retourne 3")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_053_GET_NOYZ",
					"",
					"",
					"; (pour les expriences spectro) Retourne une valeur exprimant la composante YZ issu du calcul des moments dans le repre exprience\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";  0 si la composante YZ issu du calcul des moments donne XX dans le repre exprience\n"\
					";  1 si la composante YZ issu du calcul des moments donne XY dans le repre exprience\n"\
					";  2 si la composante YZ issu du calcul des moments donne XZ dans le repre exprience\n"\
					";  3 si la composante YZ issu du calcul des moments donne YY dans le repre exprience\n"\
					";  4 si la composante YZ issu du calcul des moments donne YZ dans le repre exprience\n"\
					";  5 si la composante YZ issu du calcul des moments donne ZZ dans le repre exprience\n"\
					";\n"\
					"; la mthode mre retourne 4")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_054_GET_NOZZ",
					"",
					"",
					"; (pour les expriences spectro) Retourne une valeur exprimant la composante ZZ issu du calcul des moments dans le repre exprience\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";  0 si la composante ZZ issu du calcul des moments donne XX dans le repre exprience\n"\
					";  1 si la composante ZZ issu du calcul des moments donne XY dans le repre exprience\n"\
					";  2 si la composante ZZ issu du calcul des moments donne XZ dans le repre exprience\n"\
					";  3 si la composante ZZ issu du calcul des moments donne YY dans le repre exprience\n"\
					";  4 si la composante ZZ issu du calcul des moments donne YZ dans le repre exprience\n"\
					";  5 si la composante ZZ issu du calcul des moments donne ZZ dans le repre exprience\n"\
					";\n"\
					"; la mthode mre retourne 5")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_055_GET_IONS",
					"",
					"",
					"; (pour les expriences spectro) Retourne une chaine de caractres donnant les ions pouvant tre choisis dans les widgets\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";  un tableau de chaine de caractres:\n"\
					";   - premire chaine:   1 ou 2, 1 si on ne peut slectionner q un seul ion, 2 si on peut choisir plusieurs ions\n"\
					";   - chaines suivantes: nom des ions\n"\
					";\n"\
					"; la mthode mre retourne la chaine 0")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_056_GET_VPAR_VPERP_STEP",
					"",
					"",
					"; (pour les expriences spectro) Retourne le pas  utiliser dans les fonctions de distribution 1DVperp, 1DVpar et 2D\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";  le pas en Vperp         qui sera utilis par dfaut dans les fonctions de distribution 1DVperp Vpar Vperp\n"\
					";  le pas en Vpar          qui sera utilis par dfaut dans les fonctions de distribution 1DVpar  Vpar Vperp\n"\
					";  le pas en Vpar et Vperp qui sera utilis par dfaut dans les fonctions de distribution 2D      Vpar Vperp\n"\
					";\n"\
					"; la mthode mre retourne 50")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_057_GET_COUNTFACTOR",
					"nbenergies,       (*self.param).rpa", 
					"nbenergies:input  rpa:input",
					"; (pour les expriences spectro) Retourne la valeur par laquelle le coup de la dernire nergie devra tre multiplie (ex: dans les modes cluster o les 31 nergies ont t regroupes en 8 ou 16)\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - nbenergies: (RO) nombre d nergies\n"\
					";  - rpa:        (RO) (uniquement pou cluster-codif) 1 pour un mode rpa\n"\
					";\n"\
					"; la mthode mre retourne 1")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_058_GET_CORRECT_TABLE",
					"noproduit", 
					"noproduit:input",
					"; (pour les expriences spectro) Retourne 1 si on doit supprimer les trous et les chevauchements dans les tables d nergies en dehors du calcul des moments, 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro du produit\n"\
					";\n"\
					"; la mthode mre retourne 1")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_059_COUNT2D_GET_VISIBLE",
					"var,      type,      vb,      current,       currentie,      gradpressmom,      tabproduit", 
					"var:input type:input vb:input current:input  currentie:input gradpressmom:input tabproduit:input",
					"; (pour les expriences spectro) Retourne 1 si une variable doit apparaitre dans un widget 2d\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - var:        (RO) nom de la variable  afficher dans un widget\n"\
					";  - type:       (RO) type de trac count2d (ex: moments, time_cjf)\n"\
					";  - vb:         (RO) si on est dans un objet vb\n"\
					";  - current:    (RO) si on est dans un objet current\n"\
					";  - currentie:  (RO) si on est dans un objet currentie\n"\
					";  - tabproduit: (RO) tableau de numros de produit\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";   1 pour afficher la variable var dans ce widget\n"\
					";   0 pour ne pas afficher la variable\n"\
					";\n"\
					"; la mthode mre fait dja pas mal de travail, trop long  expliquer ici ...")



	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_060_COUNT3D_GET_VISIBLE",
					"var,      type,      tabproduit", 
					"var:input type:input tabproduit:input",
					"; (pour les expriences spectro) Retourne 1 si une variable doit apparaitre dans un widget 3d\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - var:        (RO) nom de la variable  afficher dans un widget\n"\
					";  - type:       (RO) type de trac count2d (ex: time_energy, time_theta)\n"\
					";  - tabproduit: (RO) tableau de numros de produit\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";   1 pour afficher la variable var dans ce widget\n"\
					";   0 pour ne pas afficher la variable\n"\
					";\n"\
					"; la mthode mre fait dja pas mal de travail, trop long  expliquer ici ...")


	MOTIF_PARAM_TO_DECLARATION_APPEL(MODULE,MOTIF,APPEL,DECLARATION1,DECLARATION2,PARAMETRES,no++,1,1,
					"EXP_SPE_061_IS_ENERGY_TABLE_CONSTANT",
					"noproduit", 
					"noproduit:input",
					"; (pour les expriences spectro) Retourne 1 si la table d energie d un produit est constante pour toute la mission, 0 sinon\n"\
					";\n"\
					"; Entres:\n"\
					"; --------\n"\
					";  - noproduit: (RO) numro de produit\n"\
					";\n"\
					"; Retourne:\n"\
					"; --------\n"\
					";   1 si la table d energie du produit est constante pour toute la mission\n"\
					";   0 sinon\n"\
					";\n"\
					"; la mthode mre retourne 0")


	no2_spe=no-1

	for (imotif in MOTIF) {
		EXISTE[imotif]=0
	}

}

{

	no_declaration_function=0;

	for (imotif in MOTIF) {

		position = index($0, MOTIF[imotif])
		if (position) {
			if (is_declaration && substr($0,position+length(MOTIF[imotif]),1)=="!") {
				# le symbole est suivi de "!": cela signifie qu il faut utiliser la methode de la classe mere
				# donc ne pas declarer la classe dans le module
				if (MODULE!="exp" && DECLARED_EXP[imotif]==1) {
					EXISTE[imotif]=1;
				}
				if (MODULE=="exp" && DECLARED_EXP[imotif]==0) {
					EXISTE[imotif]=1;
				}
				$0=sprintf (";%s\n", tolower($0));
				continue;
			}
			if (is_declaration && substr($0,position+length(MOTIF[imotif]),2)=="()") {
				no_declaration_function=imotif;
				valeur_retour = substr($0,position+length(MOTIF[imotif])+2)
				EXISTE[imotif]=1
			}

			if (gsub (MOTIF[imotif], is_declaration && position==1 ? DECLARATION1[imotif] : APPEL[imotif]) != 0) {
				if (is_declaration && position==1) $0 = sprintf ("%s%s\n%s", $0,DECLARATION2[imotif],DOC[imotif]);
				if (is_declaration==0 || position==1)
					EXISTE[imotif]=1
			}
			istrange = index ($0, ")(");
			if (istrange) {
				AVANT = substr ($0, 1, istrange-1);
				APRES = substr ($0, istrange+2);
				$0 = sprintf ("%s, %s", AVANT, APRES);
			}
		}
	}

	if (no_declaration_function) {

		# ex: "EXP_ALL_009_GET_PRODUCTSINFO()          1"
		printf (";-------------------------------------------------------------------------------\n")
		printf ("%s%s\n", DECLARATION1[no_declaration_function],DECLARATION2[no_declaration_function])
		printf ("%s\n", DOC[no_declaration_function])
		printf (";-------------------------------------------------------------------------------\n")
		printf ("\tRETURN, %s\nEND\n\n", valeur_retour);

	} else if (substr($1,1,12)=="BEGIN_MACRO_") {
#		nbmacros++;
#		inside_macro=nbmacros;
#		macro_name[nbmacros]=substr($1,13);
	} else if (substr($1,1,9)=="END_MACRO") {
#		inside_macro=0;
	} else if (inside_macro>=1) {
#		macro_data[inside_macro] = sprintf ("%s%s\n",macro_data[inside_macro],$0);
	} else if (inside_macro==0) {
		if (substr($1,1,6)=="MACRO_") {
#			for (no_macro=1 ; no_macro<=nbmacros; no_macro++) {
#				if (substr($1,7)==macro_name[no_macro]) {
#					break;
#				}
#			}
#			printf ";-------------------------------------------------------------------------------\n"
#			printf ";BEGIN MACRO_%s\n",macro_name[no_macro]
#			printf ";-------------------------------------------------------------------------------\n"
#			printf "%s\n", macro_data[no_macro]
#			printf ";-------------------------------------------------------------------------------\n"
#			printf ";END MACRO_%s\n",macro_name[no_macro]
#			printf ";-------------------------------------------------------------------------------\n"
		} else {
			printf "%s\n", $0
		}
	}

}

END {

	#if (is_declaration && MODULE != "exp") {
	if (is_declaration) {

		un_all_indefini=0
		for (imotif=1 ; imotif<no1_spe ; imotif++) {
			if (EXISTE[imotif]==0)
				un_all_indefini=1
		}

		if (un_all_indefini) {
			for (imotif=1 ; imotif<no1_spe ; imotif++) {
				if (EXISTE[imotif]==0) {
					if (0 && DECLARED_EXP[imotif]==1) {
						#printf ("    WARNING: %2d/%2d %-40s OK-IMPLICIT\n", imotif,no1_spe-1,MOTIF[imotif]) > "/dev/stderr"
					} else {
						printf ("    WARNING: %2d/%2d %-40s MANQUE dans %s\n", imotif,no1_spe-1,MOTIF[imotif], FICHIER) > "/dev/stderr"
					}
				} else {
					#printf ("    WARNING: %2d/%2d %-40s OK\n", imotif,no1_spe-1,MOTIF[imotif]) > "/dev/stderr"
				}
			}
				
		}

		aucun_spe=1
		for (imotif=no1_spe ; imotif<=no2_spe ; imotif++) {
			if (EXISTE[imotif]==1)
				aucun_spe=0
		}

		un_spe_indefini=0
		for (imotif=no1_spe ; imotif<=no2_spe ; imotif++) {
			if (EXISTE[imotif]==0)
				un_spe_indefini=1
		}

		if (aucun_spe) {
					#printf ("    WARNING: aucun SPE dfini dans %s\n", FICHIER) > "/dev/stderr"
		} else if (un_spe_indefini) {
			for (imotif=no1_spe ; imotif<=no2_spe ; imotif++) {
				if (EXISTE[imotif]==0) {
					if (0 && DECLARED_EXP[imotif]==1) {
						#printf ("    WARNING: %2d/%2d %-40s OK-IMPLICIT\n", imotif-no1_spe+1,no2_spe-no1_spe+1, MOTIF[imotif]) > "/dev/stderr"
					} else {
						printf ("    WARNING: %2d/%2d %-40s MANQUE dans %s\n", imotif-no1_spe+1,no2_spe-no1_spe+1, MOTIF[imotif], FICHIER) > "/dev/stderr"
					}
				} else {
					#printf ("    WARNING: %2d/%2d %-40s OK\n", imotif-no1_spe+1,no2_spe-no1_spe+1, MOTIF[imotif]) > "/dev/stderr"
				}
			}
		}
	}

}

' $ENTREE > $SORTIE

chmod -f -w $SORTIE

}


#-------------------------------------------------------------------------------
# main()
#-------------------------------------------------------------------------------

if	[ $# -lt 1 ]; then
	usage
fi

case $1 in
 auto|cesr|cnes|clean)	;;
 *) 			usage
			;;
esac

OS=`uname -s`

case $OS in
  SunOS)	AWK=nawk
          	;;
  *)		AWK=awk
		;;
esac

case $2 in
  -32)	ETIQUETTE="NBITS_32"
	;;
  -64)	ETIQUETTE="NBITS_64"
	;;
  -gdl)	ETIQUETTE="GDL"
	;;
  *)	ETIQUETTE=`[ "${OS}" = "SunOS" ] && echo "NBITS_32" || echo "NBITS_AUTO"`
	;;
esac

if [ $1 = "clean" ]; then
	ETIQUETTE=$1
fi

if [ src/prototype.c -nt bin/prototype ]; then
	gcc -Wno-trigraphs -O src/prototype.c -o bin/prototype
fi

extraire decoder $ETIQUETTE configure/Makefile_idl_gcc_Linux.configure 			mak/Makefile_idl_gcc_Linux
extraire decoder $ETIQUETTE configure/Makefile_idl_gcc_Darwin.configure 		mak/Makefile_idl_gcc_Darwin
extraire decoder $ETIQUETTE configure/COMPILE_ALL_pro.configure 			bin/COMPILE_ALL_pro
extraire decoder $ETIQUETTE configure/cl.configure 					bin/cl
extraire decoder $ETIQUETTE configure/clvm.configure 					bin/clvm
mkdir -p lib
extraire decoder $ETIQUETTE configure/lint.dlm.configure 				lib/lint.dlm

if [ $1 = "auto" ]; then
  if [ -f "pro/produit__define.pro" ]; then
    exit 
  else
    ETIQUETTE="cesr"
  fi
else
  ETIQUETTE=$1
fi

extraire decoder $ETIQUETTE configure/list_exp.configure 					resource/list_exp

extraire copier  $ETIQUETTE configure/current__define.pro.configure           			pro/current__define.pro
extraire copier  $ETIQUETTE configure/currentie__define.pro.configure           		pro/currentie__define.pro
extraire copier  $ETIQUETTE configure/oh__define.pro.configure           			pro/oh__define.pro
extraire copier  $ETIQUETTE configure/cluster_current.cl.gz.configure          			resource/cluster_current.cl.gz
extraire copier  $ETIQUETTE configure/cluster_oh.cl.gz.configure           			resource/cluster_oh.cl.gz
extraire copier  $ETIQUETTE configure/cluster_N_board_cdf.cl.gz.configure     			resource/cluster_N_board_cdf.cl.gz
extraire copier  $ETIQUETTE configure/cluster_T_board_cdf.cl.gz.configure           		resource/cluster_T_board_cdf.cl.gz
extraire copier  $ETIQUETTE configure/cluster_V_board_cdf.cl.gz.configure           		resource/cluster_V_board_cdf.cl.gz
extraire copier  $ETIQUETTE configure/cluster_moments_board_cdf.cl.gz.configure          	resource/cluster_moments_board_cdf.cl.gz
extraire decoder $ETIQUETTE configure/cldoc.txt.configure 					resource/cldoc.txt
if [ -f resource/cldoc.txt ]; then
	chmod +w resource/cldoc.txt # sinon bug sous Windows lors de la visualisation de la doc
fi
extraire decoder $ETIQUETTE configure/exp_cluster_oth__define.pro.configure 			pro/exp_cluster_oth__define.pro

extraire copier  $ETIQUETTE configure/aspera3_ima_mso.cl.gz.configure           		resource/aspera3_ima_mso.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_ima.cl.gz.configure           			resource/aspera3_ima.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_ima_hk1.cl.gz.configure           		resource/aspera3_ima_hk1.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_ima_hk2.cl.gz.configure           		resource/aspera3_ima_hk2.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_els.cl.gz.configure				resource/aspera3_els.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_els_theta_phi.cl.gz.configure			resource/aspera3_els_theta_phi.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_ima_theta_phi_ions.cl.gz.configure		resource/aspera3_ima_theta_phi_ions.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_ima_theta_phi_ions_multi.cl.gz.configure		resource/aspera3_ima_theta_phi_ions_multi.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_mu_hk1.cl.gz.configure				resource/aspera3_mu_hk1.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_mu_hk2.cl.gz.configure				resource/aspera3_mu_hk2.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_mu_hk3.cl.gz.configure				resource/aspera3_mu_hk3.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_mu_hk4.cl.gz.configure				resource/aspera3_mu_hk4.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_mu_hk5.cl.gz.configure				resource/aspera3_mu_hk5.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_mu_hk6.cl.gz.configure				resource/aspera3_mu_hk6.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_els_energy_cjf.cl.gz.configure			resource/aspera3_els_energy_cjf.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_els_time_cjf.cl.gz.configure			resource/aspera3_els_time_cjf.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_ima_time_cjf.cl.gz.configure			resource/aspera3_ima_time_cjf.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_ima_energy_cjf.cl.gz.configure			resource/aspera3_ima_energy_cjf.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_vue_web.cl.gz.configure				resource/aspera3_vue_web.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_els_distributions.cl.gz.configure			resource/aspera3_els_distributions.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_ima_distributions.cl.gz.configure			resource/aspera3_ima_distributions.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_npi.cl.gz.configure				resource/aspera3_npi.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_els_anodes.cl.gz.configure			resource/aspera3_els_anodes.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_ima_anodes.cl.gz.configure			resource/aspera3_ima_anodes.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_ima_clean.cl.gz.configure				resource/aspera3_ima_clean.cl.gz

extraire copier  $ETIQUETTE configure/maven_swea_phi_theta_new_64E.cl.gz.configure		resource/maven_swea_phi_theta_new_64E.cl.gz
extraire copier  $ETIQUETTE configure/maven_swea_phi_theta_new_32E.cl.gz.configure		resource/maven_swea_phi_theta_new_32E.cl.gz
extraire copier  $ETIQUETTE configure/maven_swea_phi_theta_new_16E.cl.gz.configure		resource/maven_swea_phi_theta_new_16E.cl.gz
extraire copier  $ETIQUETTE configure/maven_swea_phi_theta_aitoff_64E.cl.gz.configure		resource/maven_swea_phi_theta_aitoff_64E.cl.gz
extraire copier  $ETIQUETTE configure/maven_swea_phi_theta_aitoff_32E.cl.gz.configure		resource/maven_swea_phi_theta_aitoff_32E.cl.gz
extraire copier  $ETIQUETTE configure/maven_swea_phi_theta_aitoff_16E.cl.gz.configure		resource/maven_swea_phi_theta_aitoff_16E.cl.gz
extraire copier  $ETIQUETTE configure/maven_swea_phi_theta_new_64E_multi.cl.gz.configure	resource/maven_swea_phi_theta_new_64E_multi.cl.gz
extraire copier  $ETIQUETTE configure/maven_swea_phi_theta_new_32E_multi.cl.gz.configure	resource/maven_swea_phi_theta_new_32E_multi.cl.gz
extraire copier  $ETIQUETTE configure/maven_swea_phi_theta_new_16E_multi.cl.gz.configure	resource/maven_swea_phi_theta_new_16E_multi.cl.gz
extraire copier  $ETIQUETTE configure/maven_vue_web.cl.gz.configure				resource/maven_vue_web.cl.gz
extraire copier  $ETIQUETTE configure/maven_static_EM.cl.gz.configure				resource/maven_static_EM.cl.gz
extraire copier  $ETIQUETTE configure/maven_swea_mag_swia_static.cl.gz.configure		resource/maven_swea_mag_swia_static.cl.gz
extraire copier  $ETIQUETTE configure/maven_ephemeris_orbitXY.cl.gz.configure			resource/maven_ephemeris_orbitXY.cl.gz
extraire copier  $ETIQUETTE configure/maven_static_products.cl.gz.configure			resource/maven_static_products.cl.gz
extraire copier  $ETIQUETTE configure/maven_swia_products.cl.gz.configure			resource/maven_swia_products.cl.gz
extraire copier  $ETIQUETTE configure/maven_swea_products.cl.gz.configure			resource/maven_swea_products.cl.gz
extraire copier  $ETIQUETTE configure/maven_swea_distributions_1D.cl.gz.configure		resource/maven_swea_distributions_1D.cl.gz
extraire copier  $ETIQUETTE configure/maven_swea_distributions.cl.gz.configure			resource/maven_swea_distributions.cl.gz
extraire copier  $ETIQUETTE configure/maven_swea_energy_cjf.cl.gz.configure			resource/maven_swea_energy_cjf.cl.gz

extraire copier  $ETIQUETTE configure/mgs_all.cl.gz.configure					resource/mgs_all.cl.gz
extraire copier  $ETIQUETTE configure/mgs_magSS.cl.gz.configure					resource/mgs_magSS.cl.gz
extraire copier  $ETIQUETTE configure/mgs_magPC.cl.gz.configure					resource/mgs_magPC.cl.gz
extraire copier  $ETIQUETTE configure/mgs_energy_cjf.cl.gz.configure				resource/mgs_energy_cjf.cl.gz
extraire copier  $ETIQUETTE configure/mgs_time_cjf.cl.gz.configure				resource/mgs_time_cjf.cl.gz

extraire copier  $ETIQUETTE configure/aspera3_ima_mass_energy_ions_01.cl.gz.configure		resource/aspera3_ima_mass_energy_ions_01.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_ima_mass_energy_ions_16.cl.gz.configure		resource/aspera3_ima_mass_energy_ions_16.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_ima_mass_energy_ions_09.cl.gz.configure		resource/aspera3_ima_mass_energy_ions_09.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_ima_massQ_energy_ions_09.cl.gz.configure		resource/aspera3_ima_massQ_energy_ions_09.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_moments3d_els.cl.gz.configure			resource/aspera3_moments3d_els.cl.gz
extraire copier  $ETIQUETTE configure/aspera3_moments3d_ima.cl.gz.configure			resource/aspera3_moments3d_ima.cl.gz

extraire copier  $ETIQUETTE configure/demeter_energy_cjf.cl.gz.configure			resource/demeter_energy_cjf.cl.gz
extraire copier  $ETIQUETTE configure/demeter_ondes.cl.gz.configure				resource/demeter_ondes.cl.gz
extraire copier  $ETIQUETTE configure/demeter_vue_web.cl.gz.configure				resource/demeter_vue_web.cl.gz
extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT.cl.gz.configure			resource/demeter_RLONG_RLAT.cl.gz
extraire copier  $ETIQUETTE configure/demeter_ondes_puissance_critere.cl.gz.configure		resource/demeter_ondes_puissance_critere.cl.gz
extraire copier  $ETIQUETTE configure/demeter_idp_ice_imsl_isl.cl.gz.configure			resource/demeter_idp_ice_imsl_isl.cl.gz
extraire copier  $ETIQUETTE configure/demeter_idp_ice_imsl_isl_mag.cl.gz.configure		resource/demeter_idp_ice_imsl_isl_mag.cl.gz
extraire copier  $ETIQUETTE configure/demeter_datlowe.cl.gz.configure				resource/demeter_datlowe.cl.gz

extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_003.0kHz_006.0kHz_jour.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_003.0kHz_006.0kHz_jour.cl.gz
extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_003.0kHz_006.0kHz_nuit.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_003.0kHz_006.0kHz_nuit.cl.gz

extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_009.0kHz_011.0kHz_jour.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_009.0kHz_011.0kHz_jour.cl.gz
extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_009.0kHz_011.0kHz_nuit.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_009.0kHz_011.0kHz_nuit.cl.gz

extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_015.0kHz_016.5kHz_jour.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_015.0kHz_016.5kHz_jour.cl.gz
extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_015.0kHz_016.5kHz_nuit.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_015.0kHz_016.5kHz_nuit.cl.gz

extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_016.5kHz_020.0kHz_jour.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_016.5kHz_020.0kHz_jour.cl.gz
extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_016.5kHz_020.0kHz_nuit.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_016.5kHz_020.0kHz_nuit.cl.gz

extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_010.0kHz_020.0kHz_jour.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_010.0kHz_020.0kHz_jour.cl.gz
extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_010.0kHz_020.0kHz_nuit.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_010.0kHz_020.0kHz_nuit.cl.gz

extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_020.0kHz_030.0kHz_jour.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_020.0kHz_030.0kHz_jour.cl.gz
extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_020.0kHz_030.0kHz_nuit.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_020.0kHz_030.0kHz_nuit.cl.gz

extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_020.0kHz_040.0kHz_jour.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_020.0kHz_040.0kHz_jour.cl.gz
extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_020.0kHz_040.0kHz_nuit.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_020.0kHz_040.0kHz_nuit.cl.gz

extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_040.0kHz_060.0kHz_jour.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_040.0kHz_060.0kHz_jour.cl.gz
extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_040.0kHz_060.0kHz_nuit.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_040.0kHz_060.0kHz_nuit.cl.gz

extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_040.0kHz_080.0kHz_jour.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_040.0kHz_080.0kHz_jour.cl.gz
extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_040.0kHz_080.0kHz_nuit.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_040.0kHz_080.0kHz_nuit.cl.gz

extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_060.0kHz_080.0kHz_jour.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_060.0kHz_080.0kHz_jour.cl.gz
extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_060.0kHz_080.0kHz_nuit.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_060.0kHz_080.0kHz_nuit.cl.gz

extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_070.0kHz_100.0kHz_jour.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_070.0kHz_100.0kHz_jour.cl.gz
extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_070.0kHz_100.0kHz_nuit.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_070.0kHz_100.0kHz_nuit.cl.gz

extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_080.0kHz_160.0kHz_jour.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_080.0kHz_160.0kHz_jour.cl.gz
extraire copier  $ETIQUETTE configure/demeter_RLONG_RLAT_ICE_080.0kHz_160.0kHz_nuit.cl.gz.configure resource/demeter_RLONG_RLAT_ICE_080.0kHz_160.0kHz_nuit.cl.gz

extraire copier	$ETIQUETTE configure/creertar.sh.configure				./creertar.sh
extraire decoder $ETIQUETTE configure/COMPILE1.pro.configure				pro/COMPILE1.pro


for i in cnesonly_els cnesonly_ima cnesonly_npd1 cnesonly_npd2 cnesonly_npi cnesonly_web els_anodes els els_distributions els_energy_cjf els_theta_phi els_time_cjf ima_anodes ima ima_distributions ima_energy_cjf ima_hk1 ima_hk2 ima_mass_energy_ions_01 ima_mass_energy_ions_09 ima_mass_energy_ions_16 ima_massQ_energy_ions_09 ima_vso ima_theta_phi_ions ima_theta_phi_ions_multi ima_time_cjf mu_hk1 mu_hk2 mu_hk3 mu_hk4 mu_hk5 mu_hk6 npi vue_web els_vso web_orbitX_mag web_orbitY_mag web_orbitXY_mag moments3d_els moments3d_ima vue_web_new mag ima_pad ima_clean; do
	extraire copier	$ETIQUETTE configure/aspera4_"$i".cl.gz.configure	resource/aspera4_"$i".cl.gz
done

extraire copier	$ETIQUETTE configure/omni_1.cl.gz.configure		resource/omni_1.cl.gz
extraire copier	$ETIQUETTE configure/sacc_h0_icare.cl.gz.configure	resource/sacc_h0_icare.cl.gz
extraire copier	$ETIQUETTE configure/xmm_h0_ermd.cl.gz.configure	resource/xmm_h0_ermd.cl.gz

for i in k0_3dp ehsp_3dp elsp_3dp plsp_3dp pm_3dp k0_epa h0_mfi_1mn h0_mfi_3sec or_pre k0_sms h1_swe h0_wav h5_swe HIRES SURVEY; do
	extraire copier	$ETIQUETTE configure/wind_"$i".cl.gz.configure	resource/wind_"$i".cl.gz
done

for i in HIRES SURVEY; do
	extraire copier	$ETIQUETTE configure/ace_"$i".cl.gz.configure	resource/ace_"$i".cl.gz
done

for i in 1h_aehv 1h_dst 3h_kpap 1m_pcn 1m_aehv; do
	extraire copier	$ETIQUETTE configure/indices_"$i".cl.gz.configure	resource/indices_"$i".cl.gz
done

for i in 1m_xray 5m_xray 1m_geomag 5m_particle 5m_pchan; do
	extraire copier	$ETIQUETTE configure/goes_"$i".cl.gz.configure	resource/goes_"$i".cl.gz
done

for i in swea momentscef MAG1MN MAG_CDF MAGB_CDF swea_anod swea_distributions swea_distributions_1D  swea_phi_theta swea_sc swea_sc_CDF swea_time_cjf_all_energies swea_time_cjf_all_thetas swea_energy_cjf swea_time_theta swea_time_phi pad_3d_pitch2345_cjf pad_pot_pourri swea_phi_theta_multi A_B_pitch vue_web_Q vue_web_berkeley swea_pitch_cjf_spectro plastic plastic_2spectro swea_moments3d swea_moments3d_andrea_correction ste let sept sit dayofcr_cr_Q dayofcr_cr_Qr dayofcr_cr_B dayofcr_cr_Br dayofcr_cr_Vp dayofcr_cr_Np; do
	extraire copier	$ETIQUETTE configure/stereo_"$i".cl.gz.configure	resource/stereo_"$i".cl.gz
done

for i in gif anim_gif ; do
	extraire copier	$ETIQUETTE configure/superdarn_"$i".cl.gz.configure	resource/superdarn_"$i".cl.gz
done

for i in web_data web_hsk1 web_hsk2 web_hsk3 web_hsk4 web_hsk5 web_hsk6 products time_cjf distributions hsk software_hsk hk_security hk_commands; do
	extraire copier	$ETIQUETTE configure/mmo_mea1_${i}.cl.gz.configure	resource/mmo_mea1_${i}.cl.gz
	if [ -f resource/mmo_mea1_${i}.cl.gz ]; then 
		# Crer la vue mea2
		gzip -dc resource/mmo_mea1_${i}.cl.gz | sed -e 's/MEA1/MEA2/g' | gzip -f > resource/mmo_mea2_${i}.cl.gz
	fi
done
for i in energy_cjf 3dmoments vm hk_all data_manu phi_theta_16E phi_theta_32E; do
	extraire copier	$ETIQUETTE configure/mmo_mea1_${i}.cl.gz.configure	resource/mmo_mea1_${i}.cl.gz
	extraire copier	$ETIQUETTE configure/mmo_mea2_${i}.cl.gz.configure	resource/mmo_mea2_${i}.cl.gz
done
for i in necp_data_mea1 necp_data_mea2 necp_hsk_mea1 necp_hsk_mea2; do
	extraire copier	$ETIQUETTE configure/mmo_${i}.cl.gz.configure	resource/mmo_${i}.cl.gz
done

for i in products hsk; do
	extraire copier	$ETIQUETTE configure/mmo_mea1_mea2_${i}.cl.gz.configure	resource/mmo_mea1_mea2_${i}.cl.gz
done

for i in pas_iabg_currents pas_iabg_science pas_iabg_temperatures pas_iabg_tensions pas_commissioning_1 pas_commissioning_2 pas_science_1 pas_science_2 pas_science_3 pas_science_4 pas_science_5 pas_3d pas_phi_theta web_data web_hsk web_hsk1 web_hsk2 web_hsk3 web_hsk4; do
	extraire copier	$ETIQUETTE configure/solar_${i}.cl.gz.configure	resource/solar_${i}.cl.gz
done

extraire copier	$ETIQUETTE configure/taranis_ideen.cl.gz.configure		resource/taranis_ideen.cl.gz
extraire copier	$ETIQUETTE configure/taranis_ideen_web_data.cl.gz.configure	resource/taranis_ideen_web_data.cl.gz
extraire copier	$ETIQUETTE configure/taranis_ideen_web_hk.cl.gz.configure	resource/taranis_ideen_web_hk.cl.gz
extraire copier	$ETIQUETTE configure/taranis_ideen_web_hks.cl.gz.configure	resource/taranis_ideen_web_hks.cl.gz
# Crer les vues ideez
if [ -f resource/taranis_ideen.cl.gz ]; then
	gzip -dc resource/taranis_ideen.cl.gz | sed -e 's/IDEEN/IDEEZ/g' | gzip -f > resource/taranis_ideez.cl.gz
fi
if [ -f resource/taranis_ideen_web_data.cl.gz ]; then 
	gzip -dc resource/taranis_ideen_web_data.cl.gz | sed -e 's/IDEEN/IDEEZ/g' | gzip -f > resource/taranis_ideez_web_data.cl.gz
fi
if [ -f resource/taranis_ideen_web_hk.cl.gz ]; then
	gzip -dc resource/taranis_ideen_web_hk.cl.gz | sed -e 's/IDEEN/IDEEZ/g' | gzip -f > resource/taranis_ideez_web_hk.cl.gz
fi
if [ -f resource/taranis_ideen_web_hks.cl.gz ]; then
	gzip -dc resource/taranis_ideen_web_hks.cl.gz | sed -e 's/IDEEN/IDEEZ/g' | gzip -f > resource/taranis_ideez_web_hks.cl.gz
fi

extraire copier	$ETIQUETTE configure/imp8_mag.cl.gz.configure		resource/imp8_mag.cl.gz
extraire copier	$ETIQUETTE configure/isee_x_mag.cl.gz.configure		resource/isee_x_mag.cl.gz
extraire copier	$ETIQUETTE configure/isee_x_bex.cl.gz.configure		resource/isee_x_bex.cl.gz
extraire copier	$ETIQUETTE configure/isee_1_par.cl.gz.configure		resource/isee_1_par.cl.gz
extraire copier	$ETIQUETTE configure/isee_2_par.cl.gz.configure		resource/isee_2_par.cl.gz
extraire copier	$ETIQUETTE configure/geotail_kp_mgf.cl.gz.configure	resource/geotail_kp_mgf.cl.gz
extraire copier	$ETIQUETTE configure/geotail_kp_cpi.cl.gz.configure	resource/geotail_kp_cpi.cl.gz
extraire copier	$ETIQUETTE configure/geotail_kp_epi.cl.gz.configure	resource/geotail_kp_epi.cl.gz
extraire copier	$ETIQUETTE configure/geotail_kp_lep.cl.gz.configure	resource/geotail_kp_lep.cl.gz

extraire copier	$ETIQUETTE configure/interball_electron_cot.cl.gz.configure			resource/interball_electron_cot.cl.gz
extraire copier	$ETIQUETTE configure/interball_electron_te2.cl.gz.configure			resource/interball_electron_te2.cl.gz
extraire copier	$ETIQUETTE configure/interball_electron_nfq.cl.gz.configure			resource/interball_electron_nfq.cl.gz
extraire copier	$ETIQUETTE configure/interball_electron_moments.cl.gz.configure			resource/interball_electron_moments.cl.gz
extraire copier	$ETIQUETTE configure/interball_electron.cl.gz.configure				resource/interball_electron.cl.gz
extraire copier	$ETIQUETTE configure/interball_electron_anod.cl.gz.configure			resource/interball_electron_anod.cl.gz
extraire copier	$ETIQUETTE configure/interball_electron_pad.cl.gz.configure			resource/interball_electron_pad.cl.gz
extraire copier	$ETIQUETTE configure/interball_electron_distributions.cl.gz.configure		resource/interball_electron_distributions.cl.gz
extraire copier	$ETIQUETTE configure/interball_electron_energy_cjf.cl.gz.configure		resource/interball_electron_energy_cjf.cl.gz
extraire copier	$ETIQUETTE configure/interball_electron_phi_theta.cl.gz.configure		resource/interball_electron_phi_theta.cl.gz
extraire copier	$ETIQUETTE configure/interball_electron_phi_theta_multi.cl.gz.configure		resource/interball_electron_phi_theta_multi.cl.gz
extraire copier	$ETIQUETTE configure/interball_electron_time_theta_multi.cl.gz.configure	resource/interball_electron_time_theta_multi.cl.gz
extraire copier	$ETIQUETTE configure/interball_electron_phi_theta_aitoff_16E.cl.gz.configure	resource/interball_electron_phi_theta_aitoff_16E.cl.gz
extraire copier	$ETIQUETTE configure/interball_electron_phi_theta_aitoff_32E.cl.gz.configure	resource/interball_electron_phi_theta_aitoff_32E.cl.gz
extraire copier	$ETIQUETTE configure/interball_fm3i.cl.gz.configure				resource/interball_fm3i.cl.gz
extraire copier	$ETIQUETTE configure/interball_mifm.cl.gz.configure				resource/interball_mifm.cl.gz

extraire copier	$ETIQUETTE configure/interball_elec1_elec2.cl.gz.configure			resource/interball_elec1_elec2.cl.gz
extraire copier	$ETIQUETTE configure/interball_ion1_ion2_H1.cl.gz.configure			resource/interball_ion1_ion2_H1.cl.gz
extraire copier	$ETIQUETTE configure/interball_ion2ch2.cl.gz.configure				resource/interball_ion2ch2.cl.gz
extraire copier	$ETIQUETTE configure/interball_imap3_sc.cl.gz.configure				resource/interball_imap3_sc.cl.gz
extraire copier	$ETIQUETTE configure/interball_imap3_gsm.cl.gz.configure			resource/interball_imap3_gsm.cl.gz

extraire copier	$ETIQUETTE configure/change2_1.cl.gz.configure					resource/change2_1.cl.gz

extraire copier	$ETIQUETTE configure/lightning_1.cl.gz.configure				resource/lightning_1.cl.gz

extraire copier	$ETIQUETTE configure/poes_n17.cl.gz.configure					resource/poes_n17.cl.gz
extraire copier	$ETIQUETTE configure/poes_n17_RLAT_RLONG.cl.gz.configure			resource/poes_n17_RLAT_RLONG.cl.gz

for i in \
	efi_eff 			\
	efi_efp 			\
	efi_efw 			\
	efi_vaf 			\
	efi_vap 			\
	efi_vaw 			\
	eesa_sc12345_l2_full		\
	eesa_sc12345_l2_burst		\
	eesa_sc12345_l2_reduced		\
	eesa_products			\
	eesa_moments3d_l1_full		\
	eesa_moments3d_l1_burst		\
	eesa_moments3d_l1_reduced	\
	eesa_moments3d_l2_full		\
	eesa_moments3d_l2_burst		\
	eesa_moments3d_l2_reduced	\
	eesa_momentsboard		\
	eesa_VB_full			\
	eesa_VB_burst			\
	eesa_VB_reduced			\
	eesa_pad_full			\
	eesa_pad_burst			\
	eesa_pad_reduced		\
	eesa_phi_theta_full		\
	eesa_phi_theta_burst		\
	eesa_phi_theta_reduced		\
	eesa_energy_cjf_full		\
	eesa_energy_cjf_burst		\
	eesa_energy_cjf_reduced		\
	eesa_distributions_full		\
	eesa_distributions_burst	\
	eesa_distributions_reduced	\
	iesa_sc12345_l2_full		\
	iesa_sc12345_l2_burst		\
	iesa_sc12345_l2_reduced		\
	iesa_products			\
	iesa_moments3d_l1_full		\
	iesa_moments3d_l1_burst		\
	iesa_moments3d_l1_reduced	\
	iesa_moments3d_l2_full		\
	iesa_moments3d_l2_burst		\
	iesa_moments3d_l2_reduced	\
	iesa_momentsboard		\
	iesa_VB_full			\
	iesa_VB_burst			\
	iesa_VB_reduced			\
	iesa_pad_full			\
	iesa_pad_burst			\
	iesa_pad_reduced		\
	iesa_phi_theta_full		\
	iesa_phi_theta_burst		\
	iesa_phi_theta_reduced16E	\
	iesa_phi_theta_reduced24E	\
	iesa_energy_cjf_full		\
	iesa_energy_cjf_burst		\
	iesa_energy_cjf_reduced		\
	iesa_distributions_full		\
	iesa_distributions_burst	\
	iesa_distributions_reduced	\
	esst_products			\
	esst_moments3d_l1_full		\
	esst_moments3d_l1_reduced	\
	esst_pad_full			\
	esst_pad_reduced		\
	esst_phi_theta_full		\
	esst_energy_cjf_full		\
	esst_distributions_full		\
	isst_products			\
	isst_moments3d_l1_full		\
	isst_moments3d_l1_reduced	\
	isst_pad_full			\
	isst_pad_reduced		\
	isst_phi_theta_full		\
	isst_energy_cjf_full		\
	isst_distributions_full		\
	fbk_l2 				\
	fgm_l2 				\
	fbk_l1 				\
	oth_fit				\
	oth_mom				\
	oth_state			\
	scm_scf 			\
	scm_scp			 	\
	scm_scw	; do
					\
	extraire copier	$ETIQUETTE configure/themis_$i.cl.gz.configure	resource/themis_$i.cl.gz
done

extraire copier	$ETIQUETTE configure/cluster_peace.cl.gz.configure				resource/cluster_peace.cl.gz
extraire copier	$ETIQUETTE configure/cluster_peace_distrib.cl.gz.configure			resource/cluster_peace_distrib.cl.gz
extraire copier	$ETIQUETTE configure/cluster_peace_distributions_multi.cl.gz.configure		resource/cluster_peace_distributions_multi.cl.gz
extraire copier	$ETIQUETTE configure/cluster_peace_distributions_multi_zoom.cl.gz.configure	resource/cluster_peace_distributions_multi_zoom.cl.gz

for i in \
	mms_mms1_srvy_vue_web1			\
	mms_mms1_srvy_vue_web2			\
	mms_mms1_brst_vue_web1			\
	mms_time_burst_all			\
	mms_des_time_burst			\
	mms_dis_time_burst			\
	mms_DES_BURST_ALL			\
	mms_DIS_BURST_ALL			\
	mms_DIST_DIS				\
	mms_FPI_SURVEY				\
	mms_manu_1mn				\
	mms_manu_5mn				\
	mms_manu_fdist_elec			\
	mms_manu_fdist_ions			\
	mms_manu_fdist_elec_1d			\
	mms_manu_fdist_ions_1d			\
	mms_manu_phi_theta_aitoff_elec		\
	mms_manu_phi_theta_aitoff_ions 		\
	mms_manu_des_3dmoments 			; do

	extraire copier	$ETIQUETTE configure/$i.cl.gz.configure	resource/$i.cl.gz
done

for i in vue_web1 vue_web2; do
	if [ -f resource/mms_mms1_srvy_${i}.cl.gz ]; then 
		# Crer les vue mms2 mms3 mms4
		gzip -dc resource/mms_mms1_srvy_${i}.cl.gz | sed -e 's/MMS1/MMS2/g' | sed -e 's/mms1/mms2/g' | awk '{if (modif==1) {print 2;modif=0} else {print $0;modif=($0=="nosat")}}' | gzip -f > resource/mms_mms2_srvy_${i}.cl.gz
		gzip -dc resource/mms_mms1_srvy_${i}.cl.gz | sed -e 's/MMS1/MMS3/g' | sed -e 's/mms1/mms3/g' | awk '{if (modif==1) {print 3;modif=0} else {print $0;modif=($0=="nosat")}}' | gzip -f > resource/mms_mms3_srvy_${i}.cl.gz
		gzip -dc resource/mms_mms1_srvy_${i}.cl.gz | sed -e 's/MMS1/MMS4/g' | sed -e 's/mms1/mms4/g' | awk '{if (modif==1) {print 4;modif=0} else {print $0;modif=($0=="nosat")}}' | gzip -f > resource/mms_mms4_srvy_${i}.cl.gz
	fi
done

for i in vue_web1; do
	if [ -f resource/mms_mms1_brst_${i}.cl.gz ]; then 
		# Crer les vue mms2 mms3 mms4
		gzip -dc resource/mms_mms1_brst_${i}.cl.gz | sed -e 's/MMS1/MMS2/g' | sed -e 's/mms1/mms2/g' | awk '{if (modif==1) {print 2;modif=0} else {print $0;modif=($0=="nosat")}}' | gzip -f > resource/mms_mms2_brst_${i}.cl.gz
		gzip -dc resource/mms_mms1_brst_${i}.cl.gz | sed -e 's/MMS1/MMS3/g' | sed -e 's/mms1/mms3/g' | awk '{if (modif==1) {print 3;modif=0} else {print $0;modif=($0=="nosat")}}' | gzip -f > resource/mms_mms3_brst_${i}.cl.gz
		gzip -dc resource/mms_mms1_brst_${i}.cl.gz | sed -e 's/MMS1/MMS4/g' | sed -e 's/mms1/mms4/g' | awk '{if (modif==1) {print 4;modif=0} else {print $0;modif=($0=="nosat")}}' | gzip -f > resource/mms_mms4_brst_${i}.cl.gz
	fi
done


for i in \
	maven_manu_fdist_static_D0			\
	maven_manu_fdist_swea				\
	maven_manu_fdist_swia_swica			\
	maven_manu_fdist_swia_swics			\
	maven_manu_fdist_swia_swifa			\
	maven_manu_fdist_swia_swifs			\
	maven_manu_phi_theta_aitoff_static		\
	maven_manu_phi_theta_aitoff_swea		\
	maven_manu_phi_theta_aitoff_swia_swica		\
	maven_manu_phi_theta_aitoff_swia_swics		\
	maven_manu_phi_theta_aitoff_swia_swifa1		\
	maven_manu_phi_theta_aitoff_swia_swifs1		\
	maven_manu_phi_theta_aitoff_swia_swifs2		\
	maven_manu_phi_theta_aitoff_swia_swifa2 	; do

	extraire copier	$ETIQUETTE configure/$i.cl.gz.configure	resource/$i.cl.gz
done

for i in \
	jason3_ambre_elec1234_ion1234		\
	jason3_ambre_all			\
	jason3_ambre_carte			; do

	extraire copier	$ETIQUETTE configure/$i.cl.gz.configure	resource/$i.cl.gz
done

for i in \
	juno_web				\
	juno_web_new				\
	juno_jadee_products			\
	juno_jadei_products			\
	juno_jadei_SP3_SP4_SP5			\
	juno_jadei_moments			\
	juno_jadei_one_time			\
	juno_jadee_vpar_vperp			; do

	extraire copier	$ETIQUETTE configure/$i.cl.gz.configure	resource/$i.cl.gz
done

for x in 1 2; do
	for y in 1 2; do
		cp configure/exp_interball_elecxchy__define.pro.configure configure/exp_interball_elec"$x"ch"$y"__define.pro.configure
		cp configure/exp_interball_ionxchy__define.pro.configure  configure/exp_interball_ion"$x"ch"$y"__define.pro.configure
	done
done

for x in 1 2; do
	cp configure/exp_bepi_meax__define.pro.configure configure/exp_bepi_mea"$x"__define.pro.configure
done

cp configure/exp_taranis_ideex__define.pro.configure configure/exp_taranis_ideen__define.pro.configure
cp configure/exp_taranis_ideex__define.pro.configure configure/exp_taranis_ideez__define.pro.configure

for i in exp exp_ascii exp_cdf exp_ace exp_aspera3_els exp_aspera3_ima exp_aspera3_npd1 exp_aspera3_npd2 exp_aspera3_npi exp_aspera3_oth exp_aspera4_els exp_aspera4_ima exp_aspera4_npd1 exp_aspera4_npd2 exp_aspera4_npi exp_aspera4_oth exp_aspera4_mag1sec exp_cluster_codif exp_cluster_hia exp_cluster_oth exp_demeter_ice exp_demeter_idp exp_demeter_imsc exp_demeter_isl exp_demeter_mag exp_dsp exp_dsp_oth exp_goes exp_indices exp_mgs exp_sacc exp_stereo_swea exp_stereo_ste exp_stereo_sept exp_stereo_sit exp_stereo_let exp_stereo_plastic exp_wind exp_xmm exp_imp8 exp_isee exp_geotail exp_interball_electron exp_interball_fm3i exp_interball_mifm exp_themis_fgm exp_themis_efi exp_themis_scm exp_themis_oth exp_themis_eesa exp_themis_iesa exp_themis_esst exp_themis_isst exp_themis_fbk exp_plugin_caa exp_plugin_csa exp_cluster_peace exp_omni exp_interball_elec1ch1 exp_interball_elec1ch2 exp_interball_elec2ch1 exp_interball_elec2ch2 exp_interball_ion1ch1 exp_interball_ion1ch2 exp_interball_ion2ch1 exp_interball_ion2ch2 exp_change2 exp_poesn17 exp_lightning exp_maven_swea exp_bepi_mea1 exp_bepi_mea2 exp_maven_swia exp_maven_mag exp_maven_ephemeris exp_maven_static exp_maven_models exp_maven_lpw exp_maven_sep exp_maven_kp exp_maven_ngi exp_maven_euv exp_taranis_ideen exp_taranis_ideez exp_taranis_xgre exp_taranis_ephemeris exp_rosina_rtof exp_map exp_rosina_cops exp_juno_ephemeris exp_juno_jadee exp_juno_jadei exp_juno_mag exp_mms_des exp_mms_dfg exp_mms_dis exp_mms_mec exp_mms_fpi exp_mms_edi exp_mms_edp exp_mms_feepse exp_mms_feepsi exp_mms_fgm exp_mms_hpca exp_mms_eis exp_mms_scm exp_mms_aspoc exp_mms_dsp exp_jason3_ephemeris exp_jason3_ambre exp_interball_imap3 exp_solar_pas exp_solar_mag exp_solar_formagonly exp_solar_ephemeris exp_psp_spa exp_psp_spb exp_psp_spc exp_psp_mag exp_psp_formagonly exp_psp_kp exp_psp_spe exp_psp_spi exp_psp_ephemeris exp_bepi_mpomag; do
	bin/prototype $i pro $ETIQUETTE
done

for i in cl produit general libcl container count3d timeseries obj graphics compute_orbito compute_timeseries compute_count3d compute_title; do
	bin/prototype $i pro $ETIQUETTE
done

for x in 1 2; do
	for y in 1 2; do
		rm -f configure/exp_interball_elec"$x"ch"$y"__define.pro.configure
		if [ -f pro/exp_interball_elec"$x"ch"$y"__define.pro ]; then
			mv pro/exp_interball_elec"$x"ch"$y"__define.pro .
			preprocesseur_boitier_channel exp_interball_elec"$x"ch"$y"__define.pro pro/exp_interball_elec"$x"ch"$y"__define.pro "$x" "$y"
			rm -f exp_interball_elec"$x"ch"$y"__define.pro
		fi
		rm -f configure/exp_interball_ion"$x"ch"$y"__define.pro.configure
		if [ -f pro/exp_interball_ion"$x"ch"$y"__define.pro ]; then
			mv pro/exp_interball_ion"$x"ch"$y"__define.pro .
			preprocesseur_boitier_channel exp_interball_ion"$x"ch"$y"__define.pro pro/exp_interball_ion"$x"ch"$y"__define.pro "$x" "$y"
			rm -f exp_interball_ion"$x"ch"$y"__define.pro
		fi
	done
done
rm -f pro/exp_interball_elecxchy__define.pro
rm -f pro/exp_interball_ionxchy__define.pro

for x in 1 2; do
	rm -f configure/exp_bepi_mea"$x"__define.pro.configure
	if [ -f pro/exp_bepi_mea"$x"__define.pro ]; then
		mv pro/exp_bepi_mea"$x"__define.pro .
		preprocesseur_mea exp_bepi_mea"$x"__define.pro pro/exp_bepi_mea"$x"__define.pro "$x"
		rm -f exp_bepi_mea"$x"__define.pro
	fi
done
rm -f pro/exp_bepi_meax__define.pro

rm -f configure/exp_taranis_ideen__define.pro.configure
if [ -f pro/exp_taranis_ideen__define.pro ]; then
	mv pro/exp_taranis_ideen__define.pro .
	preprocesseur_idee exp_taranis_ideen__define.pro pro/exp_taranis_ideen__define.pro "0" "n" "N"
	rm -f exp_taranis_ideen__define.pro
fi
rm -f configure/exp_taranis_ideez__define.pro.configure
if [ -f pro/exp_taranis_ideez__define.pro ]; then
	mv pro/exp_taranis_ideez__define.pro .
	preprocesseur_idee exp_taranis_ideez__define.pro pro/exp_taranis_ideez__define.pro "1" "z" "Z"
	rm -f exp_taranis_ideez__define.pro
fi
rm -f pro/exp_taranis_ideex__define.pro

if [ -f pro/COMPILE1.pro ]; then
	chmod +w pro/COMPILE1.pro
	cat resource/list_exp | $AWK '{ printf ".run exp_%s__define.pro\n", $1 }' >> pro/COMPILE1.pro
fi
