<?php


	// Lecture du fichier "get_arbre_csa.txt" qui provient du wget
	$nbdatasets=0;
	$poubelle=1;
	$fd = fopen ("get_arbre_csa.txt","r");
	$id="";
	while (1) {
		$ligne = fgets($fd);
		if (feof($fd)) break;
		printf ("ligne=%s",$ligne);

		$pos=0;
		$info = array();
		$i = 0;
		while (1) {
			$ret = strpos ($ligne,'"',$pos);
			//printf ("ret=%d\n",$ret);
			if ($ret===false) {
				break;
			}
			$pos = $ret+1;
			$info[$i] = $ret;
			$i++;
			
		}
		//var_dump($info);

		$id		= substr ($ligne, $info[0]+1, $info[1]-$info[0]-1);
		if ($id=="DATASET.DATASET_ID") {
			continue;	// 1ere ligne  sauter
		}
		if ($info[3]==$info[2]+1) {
			continue;
			$startTime	= "";
		} else {
			$startTime	= substr ($ligne, $info[2]+1, 10) . 'T' . substr ($ligne, $info[2]+12, 10) . '00Z';
		}
		if ($info[5]==$info[4]+1) {
			continue;
			$endTime	= "";
		} else {
			$endTime	= substr ($ligne, $info[4]+1, 10) . 'T' . substr ($ligne, $info[2]+12, 10) . '00Z';
		}
		$label		= substr ($ligne, $info[6]+1, $info[7]-$info[6]-1);
		printf ("id        = %s\n",$id);
		printf ("startTime = %s\n",$startTime);
		printf ("endTime   = %s\n",$endTime);
		printf ("label     = %s\n",$label);
		printf ("\n");
		if ($label=="") {
			printf ("LABEL VIDE !!!\n");
			continue;
		}
		$c = substr($id,0,1);
		if ($c=='C' || $c=='D') {
			$datasets[$nbdatasets++] = array(
				"id" 		=> $id,
				"label"		=> $label,
				"startTime"	=> $startTime,
				"endTime"	=> $endTime
			);
			printf ("  id=[%s] startTime=[%s] endTime=[%s] label=[%s]\n",$id,$startTime,$endTime,$label);
		}
	}

	fclose($fd);

	// Cration du fichier "get_arbre_csa_0"
	$nom_fichier = sprintf ("get_arbre_csa_0");
	$fd = fopen ($nom_fichier,"w");

	$nb_datasets=0;

	for ($j=0 ; $j<count($datasets) ; $j++) {

		$nb_datasets++;

		$dataset = $datasets[$j];
		$id = $dataset["id"];
		$label = $dataset["label"];
		$endTime = $dataset["endTime"];
		$startTime = $dataset["startTime"];
		$date = $startTime;

		if (substr($id,0,3) == "D1_" || substr($id,0,3) == "D2_") { 
			$groups = "DOUBLE-STAR";
		} else {
			$groups = "CLUSTER";
		}

		//if (substr($id,3) != "CP_WHI_ELECTRON_DENSITY") continue;

		$date = $datasets[$j]["startTime"];
		for ($k=0 ; $k<count($datasets) ; $k++) {
			if ($k==$j) continue;
			if (substr($datasets[$k]["id"],2) == substr($datasets[$j]["id"],2)) {
				if (strcmp($datasets[$k]["startTime"],$date)>0) {
					$date = $datasets[$k]["startTime"];
				}
			}
		}

		if ($startTime != $date) {
			printf ("%s: startTime=%s => date=%s\n",$id,$startTime,$date);
		}


		if ($id=="C1_CP_STA_PSD" || $id=="C2_CP_STA_PSD" || $id=="C3_CP_STA_PSD" || $id=="C4_CP_STA_PSD") {
			// Les mtadonnes de 20010101 donnent des noms de variables "BB_xxyyzz_isr2" et "EE_xxyy_isr2"
			// alors que pour les autres jours on a "BB_xxyyzz_sr2" et "BB_xxyyzz_sr2"
			$date = '2001-01-02T00:00:00.000Z';
		}


		printf ("id=[%s]\n",$id);
		$tmp = explode("_",$id);
		$sat = $tmp[0];
		$xxx = $tmp[1];
		$exp = $tmp[2];

		if ($xxx == "CP") {
			// ex: "C1_CP_FGM_SPIN"
		} else {
			//continue;
		}

		if (substr($id,3) == "CP_WHI_ELECTRON_DENSITY") {
			//$date = "2001-02-05";
		}

		$YEAR = substr($date,0,4);
		$MONTH = substr($date,5,2);
		$DAY = substr($date,8,2);
		$YYYYMMDD = $YEAR . $MONTH . $DAY;

		$masque = sprintf ("http://csa/%s/%s/%s/\$YEAR/\$MONTH/%s_\$YYYYMMDD_V01.cef",$sat,$exp,$id,$id);

		$ok="OK";
		printf ("%4d) %-6s %-55s %-38s %s\n",$nb_datasets,$ok,$groups,$id,substr($masque[0],28));
		if (strcmp($ok,"OK")) continue;

		fprintf ($fd,"%s#%s#%s#%s#%s#%s#%s#%s",
				$groups."_".$sat,$exp,$id,$label,$startTime,$endTime,$masque,$YYYYMMDD);
		fprintf ($fd,"\n");
			
		$is_ephemeris = strcmp($id,"C1_CP_AUX_POSGSE_1M")==0 || strcmp($id,"C2_CP_AUX_POSGSE_1M")==0 || strcmp($id,"C3_CP_AUX_POSGSE_1M")==0 || strcmp($id,"C4_CP_AUX_POSGSE_1M")==0;

		if ($is_ephemeris) {
			fprintf ($fd,"%s#%s#%s#%s#%s#%s#%s#%s",
					$groups."_".$sat,"00000ephemeris",$id,$label,$startTime,$endTime,$masque,$YYYYMMDD);
			fprintf ($fd,"\n");
		}
	}
	fclose ($fd);
	printf ("nb_datasets = %d\n",$nb_datasets);

?>

