<?php

//-------------------------------------------------------------------------------
function url_to_masque ($cdfurls,$date,&$YEAR,&$MONTH,&$DAY,&$DOY) {
//-------------------------------------------------------------------------------

	$DEBUG=1;


	$masque = $cdfurls;
	$YEAR = substr($date,0,4);
	$MONTH = substr($date,5,2);
	$DAY = substr($date,8,2);
	
	// Rajout 11/04/2017
	date_default_timezone_set('UTC');

	$tmp = date('z',mktime (0,0,0,$MONTH,$DAY,$YEAR));	// entre 0-365
	$DOY = sprintf ("%03d",$tmp+1);				// entre 1-366

	$YYYYMMDD = $YEAR . $MONTH . $DAY;

	//printf ("url=[%s] date=[%s]  YEAR=[%s]  MONTH=[%s]  DAY=[%s]  YYYYMMDD=[%s]  DOY=[%s]\n",$cdfurls[0],$date,$YEAR,$MONTH,$DAY,$YYYYMMDD,$DOY);
	//printf ("date=[%s]  YEAR=[%s]  MONTH=[%s]  DAY=[%s]  YYYYMMDD=[%s]  DOY=[%s]\n",$date,$YEAR,$MONTH,$DAY,$YYYYMMDD,$DOY);

	if (strcmp(substr($masque[0],-4,1),".")==0 && strcmp(substr($masque[0],-8,2),"_v")==0) {
		$debut = substr($masque[0],0,strlen($masque[0])-6);
		$fin = substr($masque[0],-3,3);
		$masque[0] = $debut . '??.' . $fin;
	}

	for ( ; ; ) {

		//printf ("AVANT url=%s\n",$masque[0]);

		$trouve=0;

		$pos_YYYYMMDD = strpos($masque[0],$YYYYMMDD);
		if ($pos_YYYYMMDD!=false) {
			$masque[0] = substr_replace($masque[0],"\$YYYYMMDD",$pos_YYYYMMDD,strlen($YYYYMMDD));
			$trouve=1;
			continue;
		}

		$pos_YEAR = strpos($masque[0],$YEAR);
		if ($pos_YEAR!=false) {
			$masque[0] = substr_replace($masque[0],"\$YEAR",$pos_YEAR,strlen($YEAR));
			$trouve=1;
			continue;
		}

		$pos_DOY = strpos($masque[0],$DOY);
		if ($pos_DOY!=false) {
			$masque[0] = substr_replace($masque[0],"\$DOY",$pos_DOY,strlen($DOY));
			$trouve=1;
			continue;
		}

		$pos_MONTH = strpos($masque[0],$MONTH);
		if ($pos_MONTH!=false) {
			$masque[0] = substr_replace($masque[0],"\$MONTH",$pos_MONTH,strlen($MONTH));
			$trouve=1;
			continue;
		}

		$pos_DAY = strpos($masque[0],$DAY);
		if ($pos_DAY!=false) {
			$masque[0] = substr_replace($masque[0],"\$DAY",$pos_DAY,strlen($DAY));
			$trouve=1;
			continue;
		}
		//printf ("APRES $pos_first_YEAR=%d url=%s\n",$pos_first_YEAR,$masque[0]);

		if ($trouve==0) break;

	}


	//if ($DEBUG) printf ("      date=[%s]  YEAR=[%s]  MONTH=[%s]  DAY=[%s]  => masque=[%s]\n",$date,$YEAR,$MONTH,$DAY,$masque[0]);
	if (empty($masque[0])) {
		//printf ("   **** date=[%s]  YEAR=[%s]  MONTH=[%s]  DAY=[%s]  => masque=[%s]\n",$date,$YEAR,$MONTH,$DAY,$masque[0]);
	} else {
		//printf ("   date=[%s]  YEAR=[%s]  MONTH=[%s]  DAY=[%s]  => masque=[%s]\n",$date,$YEAR,$MONTH,$DAY,$masque[0]);
	}

	//printf ("masque=%s\n",$masque[0]);

	return $masque;

}

//Cette option permet d'viter la mise en cache du WSDL, qui se renouvelle toutes les 24 heures... Pour le dveloppement, ce n'est pas gnial !!!
ini_set('soap.wsdl_cache_enabled', 0);

//On doit passer le fichier WSDL du Service en paramtre de l'objet SoapClient
//$service=new SoapClient("http://cdaweb.gsfc.nasa.gov/WS/jaxrpc?WSDL");
$service = new SoapClient("https://cdaweb.sci.gsfc.nasa.gov/WS/jaxrpc?WSDL");

//var_dump($service->__getFunctions());

for ($tentative=1 ; $tentative <= 10 ; $tentative++) {
	try {
		$descriptions = $service->getAllViewDescriptions();
		$success = 1;
		break;
	} catch (SoapFault $fault) {
		$success = 0;
		printf ("AIE tentative=%d getAllViewDescriptions(%s): %d %s\n",$tentative,$fault->faultcode,$fault->faultstring);
		sleep(10);
		continue;
	}
}
if ($success == 0) exit(0);

$nb_datasets=0;

for ($index=0 ; $index<=0 ; $index++) {

	// 0: public data from current space physics missions
	// 1: public data from older missions
	// 2: public data from all current and past space physics missions

	// Cration des fichiers "get_arbre_cdaweb_0" puis "get_arbre_cdaweb_1"
	$nom_fichier = sprintf ("get_arbre_cdaweb_%d",$index);
	$fd = fopen ($nom_fichier,"w");

	$testView = $descriptions[$index]->id;
	$testUrl = $descriptions[$index]->endpointAddress;
	$testWSDL = $testUrl."?WSDL";

	$service1 = new SoapClient($testWSDL);

	$irap_mirror = " (IRAP mirror)";

	$groups=$service1->getAllMissionGroups();

	for ($i=0 ; $i<count($groups) ; $i++) {

		printf ("DEBUG %s\n",$groups[$i]);
		//if (strcasecmp($groups[$i],"themis")) continue;

		if (0) {
			printf ("DEBUG %s\n",$groups[$i]);
			if (strcasecmp($groups[$i],"ACE")==0) continue;
			if (strcasecmp($groups[$i],"Alouette")==0) continue;
			if (strcasecmp($groups[$i],"Apollo")==0) continue;
			if (strcasecmp($groups[$i],"CRRES")==0) continue;
			if (strcasecmp($groups[$i],"DE")==0) continue;
			if (strcasecmp($groups[$i],"DMSP (selected links only)")==0) continue;
			if (strcasecmp($groups[$i],"Hawkeye")==0) continue;
			if (strcasecmp($groups[$i],"Helios")==0) continue;
			if (strcasecmp($groups[$i],"IMP (All)")==0) continue;
			if (strcasecmp($groups[$i],"ISEE")==0) continue;
			if (strcasecmp($groups[$i],"ISIS")==0) continue;
		}
		//if (strcasecmp($groups[$i],"ISIS")) break;

		if (0) {
			printf ("DEBUG %s\n",$groups[$i]);
			if (strcasecmp($groups[$i],"ace")==0) continue;
			if (strcasecmp($groups[$i],"artemis")==0) continue;
			if (strcasecmp($groups[$i],"cnofs")==0) continue;
			if (strcasecmp($groups[$i],"crres")==0) continue;
			if (strcasecmp($groups[$i],"Cluster")==0) continue;
			if (strcasecmp($groups[$i],"DMSP (selected links only)")==0) continue;
			if (strcasecmp($groups[$i],"Equator-S")==0) continue;
			if (strcasecmp($groups[$i],"FAST")==0) continue;
			if (strcasecmp($groups[$i],"GOES")==0) continue;
			if (strcasecmp($groups[$i],"GPS")==0) continue;
			if (strcasecmp($groups[$i],"Genesis")==0) continue;
			if (strcasecmp($groups[$i],"Geotail")==0) continue;
			if (strcasecmp($groups[$i],"Ground-Based Investigations")==0) continue;
			if (strcasecmp($groups[$i],"Helios")==0) continue;
			if (strcasecmp($groups[$i],"IMAGE")==0) continue;
			if (strcasecmp($groups[$i],"IMP (All)")==0) continue;
			if (strcasecmp($groups[$i],"ISS")==0) continue;
			if (strcasecmp($groups[$i],"Interball")==0) continue;
			if (strcasecmp($groups[$i],"LANL")==0) continue;
			if (strcasecmp($groups[$i],"MESSENGER")==0) continue;
			if (strcasecmp($groups[$i],"NOAA")==0) continue;
			if (strcasecmp($groups[$i],"OMNI (Combined 1AU IP Data; Magnetic and Solar Indices)")==0) continue;
			if (strcasecmp($groups[$i],"Pioneer")==0) continue;
			if (strcasecmp($groups[$i],"Polar")==0) continue;
			if (strcasecmp($groups[$i],"ROCSAT-1(FORMOSAT-1)/IPEI")==0) continue;
			if (strcasecmp($groups[$i],"SAMPEX")==0) continue;
			if (strcasecmp($groups[$i],"SNOE")==0) continue;
			if (strcasecmp($groups[$i],"SOHO")==0) continue;
			if (strcasecmp($groups[$i],"STEREO")==0) continue;
			if (strcasecmp($groups[$i],"THEMIS")==0) continue;
			if (strcasecmp($groups[$i],"TIMED")==0) continue;
			if (strcasecmp($groups[$i],"TWINS")==0) continue;
			if (strcasecmp($groups[$i],"Ulysses")==0) continue;
			if (strcasecmp($groups[$i],"Voyager")==0) continue;
		}
		//if (strcasecmp($groups[$i],"Wind")) break;

		for ($tentative=1 ; $tentative <= 10 ; $tentative++) {
			try {
				$datasets = $service1->getDatasets(array($groups[$i]),array(null));
				$success = 1;
				break;
			} catch (SoapFault $fault) {
				$success = 0;
				printf ("AIE tentative=%d getDatasets(%s): %d %s\n",$tentative,$groups[$i],$fault->faultcode,$fault->faultstring);
				sleep(10);
				continue;
			}
		}
		if ($success == 0) continue;

		//printf ("index=[%d] group=[%s] nbdatasets=[%d]\n",$index,$groups[$i],count($datasets));
		for ($j=0 ; $j<count($datasets) ; $j++) {

			$nb_datasets++;
			$id = $datasets[$j]->id;
			$label = $datasets[$j]->label;
			//if (strcmp($id,"I2_AV_TRO")) continue;
			$startTime = $datasets[$j]->startTime;
			$endTime = $datasets[$j]->endTime;
			$label = $datasets[$j]->label;

			//printf ("ICI1 id=%s label=%s startTime=%s endTime=%s\n",$id,$label,$startTime,$endTime);

			$ok="OK";
			$sixmois=0;
			$nbmultiday=0;
			$bug=0;
			$nocache=0;
			$mymasque="";


			$date = $startTime;

			// -------------------
			// un fichier par jour
			// -------------------
			       if (strcmp($id,"THA_L2_FGM")==0) {			$date = "2007-02-24T01:00:00.000Z";				// THEMIS (dbut cdaweb=20070218 berkeley=20070223) + master pour les 5 satellites
			} else if (strcmp($id,"THB_L2_FGM")==0) {			$date = "2007-02-24T01:00:00.000Z";				// THEMIS (dbut cdaweb=20070218 berkeley=20070224) + master pour les 5 satellites
			} else if (strcmp($id,"THC_L2_FGM")==0) {			$date = "2007-02-24T01:00:00.000Z";				// THEMIS (dbut cdaweb=20070218 berkeley=20070222) + master pour les 5 satellites
			} else if (strcmp($id,"THD_L2_FGM")==0) {			$date = "2007-02-24T01:00:00.000Z";				// THEMIS (dbut cdaweb=20070218 berkeley=20070223) + master pour les 5 satellites
			} else if (strcmp($id,"THE_L2_FGM")==0) {			$date = "2007-02-24T01:00:00.000Z";				// THEMIS (dbut cdaweb=20070218 berkeley=20070223) + master pour les 5 satellites

			} else if (strcmp($id,"THG_L2_MAG_FHB")==0) {			$date = "2009-05-07T01:00:00.000Z";				// THEMIS (dbut cdaweb=20090501 berkeley=20090507)
			} else if (strcmp($id,"THG_L2_MAG_GHB")==0) {			$date = "2009-05-07T01:00:00.000Z";				// THEMIS (dbut cdaweb=20090501 berkeley=20090507)
			} else if (strcmp($id,"THG_L2_MAG_HOP")==0) {			$date = "2008-09-25T01:00:00.000Z";				// THEMIS (dbut cdaweb=20080901 berkeley=20080925)
			} else if (strcmp($id,"THG_L2_MAG_JCK")==0) {			$date = "2010-09-16T01:00:00.000Z";				// THEMIS (dbut cdaweb=20080901 berkeley=20100916)
			} else if (strcmp($id,"THG_L2_MAG_TDC")==0) {			$date = "2009-09-27T01:00:00.000Z";				// THEMIS (dbut cdaweb=20090901 berkeley=20090927)

			} else if (strcmp($id,"C1_CP_FGM_SPIN")==0) {			$date = "2001-01-31T00:00:00.000Z";				// master pour les 4 satellites 
			} else if (strcmp($id,"C2_CP_FGM_SPIN")==0) {			$date = "2001-01-31T00:00:00.000Z";				// master pour les 4 satellites 
			} else if (strcmp($id,"C3_CP_FGM_SPIN")==0) {			$date = "2001-01-31T00:00:00.000Z";				// master pour les 4 satellites
			} else if (strcmp($id,"C4_CP_FGM_SPIN")==0) {			$date = "2001-01-31T00:00:00.000Z";				// master pour les 4 satellites

			} else if (strcmp($id,"STA_L2_PLA_1DMAX_1MIN")==0) {		$date = "2007-03-01T00:00:00.000Z";				// master pour les 2 satellites
			} else if (strcmp($id,"STB_L2_PLA_1DMAX_1MIN")==0) {		$date = "2007-03-01T00:00:00.000Z";				// master pour les 2 satellites

			} else if (strcmp($id,"STA_L2_PLA_1DMAX_10MIN")==0) {		$date = "2007-03-01T00:00:00.000Z";				// master pour les 2 satellites
			} else if (strcmp($id,"STB_L2_PLA_1DMAX_10MIN")==0) {		$date = "2007-03-01T00:00:00.000Z";				// master pour les 2 satellites

			} else if (strcmp($id,"STA_L2_PLA_1DMAX_1HR")==0) {		$date = "2007-03-01T00:00:00.000Z";				// master pour les 2 satellites
			} else if (strcmp($id,"STB_L2_PLA_1DMAX_1HR")==0) {		$date = "2007-03-01T00:00:00.000Z";				// master pour les 2 satellites

			} else if (strcmp($id,"STA_L1_SEPT")==0) {			$date = "2006-11-14T00:00:00.000Z";				// master pour les 2 satellites
			} else if (strcmp($id,"STB_L1_SEPT")==0) {			$date = "2006-11-14T00:00:00.000Z";				// master pour les 2 satellites

			} else if (strcmp($id,"THA_L2_FIT")==0) {			$date = "2007-02-28T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THB_L2_FIT")==0) {			$date = "2007-02-28T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THC_L2_FIT")==0) {			$date = "2007-02-28T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THD_L2_FIT")==0) {			$date = "2007-02-28T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THE_L2_FIT")==0) {			$date = "2007-02-28T01:00:00.000Z";				// master pour les 5 satellites

			} else if (strcmp($id,"THA_L2_MOM")==0) {			$date = "2007-08-20T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THB_L2_MOM")==0) {			$date = "2007-08-10T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THC_L2_MOM")==0) {			$date = "2007-08-10T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THD_L2_MOM")==0) {			$date = "2007-08-10T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THE_L2_MOM")==0) {			$date = "2007-08-10T01:00:00.000Z";				// master pour les 5 satellites

			} else if (strcmp($id,"THA_L2_SST")==0) {			$date = "2007-03-15T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THB_L2_SST")==0) {			$date = "2007-03-15T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THC_L2_SST")==0) {			$date = "2007-03-15T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THD_L2_SST")==0) {			$date = "2007-03-15T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THE_L2_SST")==0) {			$date = "2007-03-15T01:00:00.000Z";				// master pour les 5 satellites

			} else if (strcmp($id,"THA_L2_FBK")==0) {			$date = "2007-02-24T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THB_L2_FBK")==0) {			$date = "2007-02-24T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THC_L2_FBK")==0) {			$date = "2007-02-24T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THD_L2_FBK")==0) {			$date = "2007-02-24T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THE_L2_FBK")==0) {			$date = "2007-02-24T01:00:00.000Z";				// master pour les 5 satellites

			} else if (strcmp($id,"THA_L2_FFT")==0) {			$date = "2007-02-24T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THB_L2_FFT")==0) {			$date = "2007-02-24T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THC_L2_FFT")==0) {			$date = "2007-02-24T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THD_L2_FFT")==0) {			$date = "2007-02-24T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THE_L2_FFT")==0) {			$date = "2007-02-24T01:00:00.000Z";				// master pour les 5 satellites

			} else if (strcmp($id,"THA_L2_MERGED")==0) {			$date = "2010-01-01T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THB_L2_MERGED")==0) {			$date = "2010-01-01T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THC_L2_MERGED")==0) {			$date = "2010-01-01T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THD_L2_MERGED")==0) {			$date = "2010-01-01T01:00:00.000Z";				// master pour les 5 satellites
			} else if (strcmp($id,"THE_L2_MERGED")==0) {			$date = "2010-01-01T01:00:00.000Z";				// master pour les 5 satellites

			} else if (strcmp($id,"THG_L1_ASK")==0) {			$date = "2009-06-23T01:00:00.000Z";				// THEMIS pour avoir variable "talo" + petit fichier
			} else if (strcmp($id,"STA_L1_SWEA_DISB")==0) {			$date = "2007-02-01T01:00:00.000Z";				// STEREO mtadonnes incorrectes en 2006
			} else if (strcmp($id,"STB_L1_SWEA_DISB")==0) {			$date = "2007-02-01T01:00:00.000Z";				// STEREO mtadonnes incorrectes en 2006
			} else if (strcmp($id,"GE_K0_LEP")==0) { 			$date = "1993-10-05T00:00:00.000Z";				// GEOTAIL (dbut cdaweb=19920101 donne url vide)
			} else if (strcmp($id,"WI_M2_SWE")==0) { 			$date = "1994-12-29T00:00:00.000Z";				// WIND (dbut cdaweb=19941228 donne url vide)
			} else if (strcmp($id,"C1_PP_EFW")==0) { 			$date = "2001-01-01T01:00:00.000Z";				// CLUSTER (pb accs au rpertoire 2000)
			} else if (strcmp($id,"C2_PP_EFW")==0) { 			$date = "2001-01-01T01:00:00.000Z";				// CLUSTER (pb accs au rpertoire 2000)
			} else if (strcmp($id,"C3_PP_EFW")==0) { 			$date = "2001-01-01T01:00:00.000Z";				// CLUSTER (pb accs au rpertoire 2000)
			} else if (strcmp($id,"C4_PP_EFW")==0) { 			$date = "2001-01-01T01:00:00.000Z";				// CLUSTER (pb accs au rpertoire 2000)
			} else if (strcmp($id,"NOAA06_MEPED1MIN_SEM")==0) {		$date = "1979-07-01T01:00:00.000Z";				// NOAA (changer juin par juillet sinon confusion entre le nom du sat et le mois)
			} else if (strcmp($id,"NOAA07_MEPED1MIN_SEM")==0) { 		$date = "1981-08-01T01:00:00.000Z";				// NOAA (changer juillet par aout sinon confusion entre le nom du sat et le mois)
			} else if (strcmp($id,"NOAA10_MEPED1MIN_SEM")==0) { 		$date = "1986-11-01T01:00:00.000Z";				// NOAA (changer octobre par novembre sinon confusion entre le nom du sat et le mois)
			} else if (strcmp($id,"TIMED_WINDVECTORSNCAR_TIDI")==0) { 	$mymasque="timed_windvectorsncar_tidi_\$YYYYMMDD????_v??.cdf";	// TIMED
			} else if (strcmp($id,"TWINS1_L1_IMAGER")==0) { 		$mymasque="twins1_l1_imager_\$YYYYMMDD??_v??.cdf";		// TWINS
			} else if (strcmp($id,"TWINS2_L1_IMAGER")==0) { 		$mymasque="twins2_l1_imager_\$YYYYMMDD??_v??.cdf"; 		// TWINS
			} else if (strcmp($id,"DE_VS_EICS")==0) { 			$mymasque="\$YEAT\$DOY_eics_de_96s_v??.cdf"; 			// DE

			// --------------------------------------------------------
			// un fichier par jour contenant plusieurs jours de donnes
			// --------------------------------------------------------
			} else if (strcmp($id,"CRRES_H0_MEA")==0) {								$nbmultiday=32; $nocache=1;	// CRRES $YYYYMMDD (http://cdaweb.gsfc.nasa.gov/istp_public/data/crres/mea)
			} else if (strcmp($id,"IA_OR_DEF")==0) { 								$nbmultiday=32; $nocache=1;	// INTERBALL $YYYYMMDD jeudi/une semaine de donnes (http://cdaweb.gsfc.nasa.gov/istp_public/data/interball/aurora/orbit/)
			} else if (strcmp($id,"AC_OR_SSC")==0) { 	$date = "2005-03-23T01:00:00.000Z"; 			$nbmultiday=32; $nocache=1;	// ACE $YYYYMMDD (http://cdaweb.gsfc.nasa.gov/istp_public/data/ace/or_ssc)
			} else if (strcmp($id,"UY_1MIN_VHM")==0) { 								$nbmultiday=32; $nocache=1; 	// ULYSSES plusieurs jours de donnes dans un mme fichier
			} else if (strcmp($id,"ISEE1_60SEC_MFI")==0) { 								$nbmultiday=32; $nocache=1;	// ISEE $YYYYMMDD mais avec 2 ou 3 jours de donnes
			} else if (strcmp($id,"ISEE2_60SEC_MFI")==0) { 								$nbmultiday=32; $nocache=1;	// ISEE $YYYYMMDD mais avec 2 ou 3 jours de donnes
			} else if (strcmp($id,"ISS_DOSANL_TEPC")==0) { $mymasque="iss_dosanl_tepc_\$YYYYMMDD????_v??.cdf"; 	$nbmultiday=32; $nocache=1;	// ISS


			// --------------------------------------------------------
			// plusieurs fichiers par jour
			// --------------------------------------------------------
			} else if (strcmp($id,"C1_WAVEFORM_WBD")==0) {	$date = "2002-01-10T00:00:00.000Z";	$bug=1; $mymasque="c1_waveform_wbd_\$YYYYMMDD????_v??.cdf";		// CLUSTER un fichier toutes les 10 minutes (fichiers normes) + master pour les 4 satellites
			} else if (strcmp($id,"C2_WAVEFORM_WBD")==0) {	$date = "2002-01-10T00:00:00.000Z";	$bug=1; $mymasque="c2_waveform_wbd_\$YYYYMMDD????_v??.cdf";		// CLUSTER un fichier toutes les 10 minutes (fichiers normes) + master pour les 4 satellites
			} else if (strcmp($id,"C3_WAVEFORM_WBD")==0) {	$date = "2002-01-10T00:00:00.000Z";	$bug=1; $mymasque="c3_waveform_wbd_\$YYYYMMDD????_v??.cdf";		// CLUSTER un fichier toutes les 10 minutes (fichiers normes) + master pour les 4 satellites
			} else if (strcmp($id,"C4_WAVEFORM_WBD")==0) {	$date = "2002-01-10T00:00:00.000Z";	$bug=1; $mymasque="c4_waveform_wbd_\$YYYYMMDD????_v??.cdf";		// CLUSTER un fichier toutes les 10 minutes (fichiers normes) + master pour les 4 satellites
			} else if (strcmp($id,"PO_H7_PWI")==0) { 						$bug=1; $mymasque="po_h7_pwi_\$YYYYMMDD??_v??.cdf";			// POLAR un fichier par heure (fichiers normes)
			} else if (strcmp($id,"PO_H8_PWI")==0) { 						$bug=1; $mymasque="po_h8_pwi_\$YYYYMMDD??_v??.cdf";			// POLAR un fichier par heure (fichiers normes)
			} else if (strcmp($id,"PO_H9_PWI")==0) { 						$bug=1; $mymasque="po_h9_pwi_\$YYYYMMDD??_v??.cdf";			// POLAR un fichier par heure (fichiers normes)
			} else if (strcmp($id,"TIMED_EDP_GUVI")==0) { 						$bug=1; $mymasque="timed_edp_guvi_\$YYYYMMDD??????_v??.cdf";		// TIMED plusieurs fichiers par jour (petits fichiers)
			} else if (strcmp($id,"TIMED_L1CDISK_GUVI")==0) { 					$bug=1; $mymasque="timed_L1Cdisk_guvi_\$YYYYMMDD??????_v??.cdf";	// TIMED plusieurs fichiers par jour (petits fichiers)
			} else if (strcmp($id,"TIMED_L1B_SABER")==0) { 						$bug=1; $mymasque="timed_l1b_saber_\$YYYYMMDD????_v??.cdf";		// TIMED plusieurs fichiers par jour (petits fichiers)
			} else if (strcmp($id,"TIMED_L1BV7_SABER")==0) { 					$bug=1; $mymasque="timed_l1bv7_saber_\$YYYYMMDD????_v??.cdf";		// TIMED plusieurs fichiers par jour (petits fichiers)
			} else if (strcmp($id,"TIMED_L2A_SABER")==0) { 						$bug=1; $mymasque="timed_l2a_saber_\$YYYYMMDD????_v??.cdf";		// TIMED plusieurs fichiers par jour (petits fichiers)
			} else if (strcmp($id,"TIMED_L2AV7_SABER")==0) { 					$bug=1; $mymasque="timed_l2av7_saber_\$YYYYMMDD????_v??.cdf";		// TIMED plusieurs fichiers par jour
			} else if (strcmp($id,"ALOUETTE2_AV_LIM")==0) { 					$bug=1; $mymasque="alouette2_av_lim_\$YEAR\$DOY??????_v??.cdf";		// ALOUETTE plusieurs fichiers par jour
			} else if (strcmp($id,"ALOUETTE2_AV_QUI")==0) { 					$bug=1; $mymasque="alouette2_av_qui_\$YEAR\$DOY??????_v??.cdf";		// ALOUETTE plusieurs fichiers par jour
			} else if (strcmp($id,"ALOUETTE2_AV_SNT")==0) { 					$bug=1; $mymasque="alouette2_av_snt_\$YEAR\$DOY??????_v??.cdf";		// ALOUETTE plusieurs fichiers par jour
			} else if (strcmp($id,"ALOUETTE2_AV_SOL")==0) { 					$bug=1; $mymasque="alouette2_av_sol_\$YEAR\$DOY??????_v??.cdf";		// ALOUETTE plusieurs fichiers par jour
			} else if (strcmp($id,"ALOUETTE2_AV_WNK")==0) { 					$bug=1; $mymasque="alouette2_av_wnk_\$YEAR\$DOY??????_v??.cdf";		// ALOUETTE plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_SNT")==0) { 						$bug=1; $mymasque="i2_av_snt_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_TRO")==0) {	$date="1973-02-02T01:00:00.000Z"; 	$bug=1; $mymasque="i2_av_tro_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_AME")==0) { 						$bug=1; $mymasque="i2_av_ame_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I1_AV_TRO")==0) { 						$bug=1; $mymasque="i1_av_tro_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_SOD")==0) { 						$bug=1; $mymasque="i2_av_sod_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I1_AV_ORR")==0) { 						$bug=1; $mymasque="i1_av_orr_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_SOL")==0) { 						$bug=1; $mymasque="i2_av_sol_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I1_AV_KWA")==0) { 						$bug=1; $mymasque="i1_av_kwa_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I1_AV_ALL")==0) { 						$bug=1; $mymasque="i1_av_all_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_KRU")==0) { 						$bug=1; $mymasque="i2_av_kru_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_BRZ")==0) { 						$bug=1; $mymasque="i2_av_brz_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_KER")==0) { 						$bug=1; $mymasque="i2_av_ker_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_RES")==0) { 						$bug=1; $mymasque="i2_av_res_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_QUI")==0) { 	$date="1973-02-03T01:00:00.000Z"; 	$bug=1; $mymasque="i2_av_qui_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_KSH")==0) { 						$bug=1; $mymasque="i2_av_ksh_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I1_AV_KER")==0) { 						$bug=1; $mymasque="i1_av_ker_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_ULA")==0) { 	$date="1973-01-31T01:00:00.000Z"; 	$bug=1; $mymasque="i2_av_ula_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_OTT")==0) { 						$bug=1; $mymasque="i2_av_ott_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_BUR")==0) { 						$bug=1; $mymasque="i2_av_bur_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I1_AV_SOD")==0) { 						$bug=1; $mymasque="i1_av_sod_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_ODG")==0) { 						$bug=1; $mymasque="i2_av_odg_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I1_AV_SNT")==0) { 						$bug=1; $mymasque="i1_av_snt_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I1_AV_RES")==0) { 						$bug=1; $mymasque="i1_av_res_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_ADL")==0) { 						$bug=1; $mymasque="i2_av_adl_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_ORR")==0) { 						$bug=1; $mymasque="i2_av_orr_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I1_AV_WNK")==0) { 						$bug=1; $mymasque="i1_av_wnk_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I1_AV_OTT")==0) { 						$bug=1; $mymasque="i1_av_ott_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_KWA")==0) { 						$bug=1; $mymasque="i2_av_kwa_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I1_AV_ULA")==0) { 						$bug=1; $mymasque="i1_av_ula_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_SYO")==0) { 						$bug=1; $mymasque="i2_av_syo_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_LAU")==0) { 						$bug=1; $mymasque="i2_av_lau_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_WNK")==0) { 						$bug=1; $mymasque="i2_av_wnk_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I1_AV_KSH")==0) { 						$bug=1; $mymasque="i1_av_ksh_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_CNA")==0) { 						$bug=1; $mymasque="i2_av_cna_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I2_AV_ACN")==0) { 						$bug=1; $mymasque="i2_av_acn_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I1_AV_QUI")==0) { 	$date="1969-02-02T01:00:00.000Z"; 	$bug=1; $mymasque="i1_av_qui_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour
			} else if (strcmp($id,"I1_AV_ODG")==0) { 						$bug=1; $mymasque="i1_av_odg_\$YEAR\$DOY??????_v??.cdf";		// ISIS plusieurs fichiers par jour


			// -------------------
			// un fichier par mois
			// -------------------
			} else if (strcmp($id,"OMNI_HRO_1MIN")==0) { 				$date = "1995-02-02T00:00:00.000Z";	// OMNI
			} else if (strcmp($id,"OMNI_HRO_5MIN")==0) { 				$date = "1995-02-02T00:00:00.000Z";	// OMNI
			} else if (strcmp($id,"OMNI_COHO1HR_MERGED_MAG_PLASMA")==0) { 		$date = "1963-02-02T00:00:00.000Z";	// OMNI
			} else if (strcmp($id,"THA_OR_SSC")==0) { 				$date = "2007-03-02T00:00:00.000Z";	// THEMIS (sauf pour le premier jour 19/02/2007)
			} else if (strcmp($id,"THB_OR_SSC")==0) { 				$date = "2007-03-02T00:00:00.000Z";	// THEMIS (sauf pour le premier jour 19/02/2007)
			} else if (strcmp($id,"THC_OR_SSC")==0) { 				$date = "2007-03-02T00:00:00.000Z";	// THEMIS (sauf pour le premier jour 19/02/2007)
			} else if (strcmp($id,"THD_OR_SSC")==0) { 				$date = "2007-03-02T00:00:00.000Z";	// THEMIS (sauf pour le premier jour 19/02/2007)
			} else if (strcmp($id,"THE_OR_SSC")==0) { 				$date = "2007-03-02T00:00:00.000Z";	// THEMIS (sauf pour le premier jour 19/02/2007)
			} else if (strcmp($id,"THB_L2_MERGED")==0) { 				$date = "2010-02-02T01:00:00.000Z";	// THEMIS
			} else if (strcmp($id,"THC_L2_MERGED")==0) { 				$date = "2010-02-02T01:00:00.000Z";	// THEMIS
			} else if (strcmp($id,"C1_JP_PMP")==0) { 				$date = "2000-10-02T01:00:00.000Z";	// CLUSTER
			} else if (strcmp($id,"C1_JP_PSE")==0) { 				$date = "2000-10-02T01:00:00.000Z";	// CLUSTER
			} else if (strcmp($id,"CL_JP_PGP")==0) { 				$date = "2000-09-02T01:00:00.000Z";	// CLUSTER
			} else if (strcmp($id,"CT_JP_PSE")==0) { 				$date = "2000-08-02T01:00:00.000Z";	// CLUSTER
			} else if (strcmp($id,"GENESIS_3DL2_GIM")==0) { 			$date = "2001-09-02T01:00:00.000Z";	// GENESIS
			} else if (strcmp($id,"HELIOS1_COHO1HR_MERGED_MAG_PLASMA")==0) {	$date = "1975-02-02T01:00:00.000Z";	// HELIOS
			} else if (strcmp($id,"HELIOS2_COHO1HR_MERGED_MAG_PLASMA")==0) {	$date = "1976-02-02T01:00:00.000Z";	// HELIOS
			} else if (strcmp($id,"IM_ELECTRON_DENSITY_RPI")==0) { 			$date = "2001-02-02T01:00:00.000Z";	// IMAGE
			} else if (strcmp($id,"PIONEER10_COHO1HR_MERGED_MAG_PLASMA")==0) { 	$date = "1972-04-02T01:00:00.000Z";	// PIONEER
			} else if (strcmp($id,"PIONEER11_COHO1HR_MERGED_MAG_PLASMA")==0) { 	$date = "1973-05-02T01:00:00.000Z";	// PIONEER
			} else if (strcmp($id,"PIONEERVENUS_COHO1HR_MERGED_MAG_PLASMA")==0) {	$date = "1979-02-02T00:00:00.000Z"; 	// PIONEER
			} else if (strcmp($id,"SX_K0_POF")==0) { 				$date = "1992-08-02T01:00:00.000Z";	// SAMPEX
			} else if (strcmp($id,"STA_COHO1HR_MERGED_MAG_PLASMA")==0) { 		$date = "2007-02-02T01:00:00.000Z";	// STEREO
			} else if (strcmp($id,"STB_COHO1HR_MERGED_MAG_PLASMA")==0) { 		$date = "2007-02-02T01:00:00.000Z";	// STEREO
			} else if (strcmp($id,"TIMED_L3A_SEE")==0) { 				$date = "2003-04-02T01:00:00.000Z";	// TIMED
			} else if (strcmp($id,"UY_COHO1HR_MERGED_MAG_PLASMA")==0) { 		$date = "1990-11-02T01:00:00.000Z";	// ULYSSES
			} else if (strcmp($id,"VOYAGER1_COHO1HR_MERGED_MAG_PLASMA")==0) { 	$date = "1979-03-02T01:00:00.000Z";	// VOYAGER
			} else if (strcmp($id,"VOYAGER2_COHO1HR_MERGED_MAG_PLASMA")==0) { 	$date = "1977-09-02T01:00:00.000Z";	// VOYAGER
			} else if (strcmp($id,"ALOUETTE1_NEPROF_TOPS")==0) { 			$date = "1962-10-02T00:00:00.000Z";	// ALOUETTE
			} else if (strcmp($id,"ALOUETTE2_NEPROF_TOPS")==0) { 			$date = "1966-10-02T00:00:00.000Z";	// ALOUETTE
			} else if (strcmp($id,"I1_NEPROF_TOPS")==0) { 				$date = "1969-02-02T00:00:00.000Z";	// ISIS
			} else if (strcmp($id,"I2_NEPROF_TOPS")==0) { 				$date = "1971-05-02T00:00:00.000Z";	// ISIS
			} else if (strcmp($id,"OHZORA_H0_HEP")==0) { 				$date = "1984-12-02T00:00:00.000Z";	// OHZORA

			// -------------------------------------
			// un fichier tous les 6 mois (01 et 07)
			// -------------------------------------
			} else if (strcmp($id,"OMNI2_H0_MRG1HR")==0) {				$date="1963-07-02T00:00:00.000Z";$sixmois=1; 	// OMNI2
			} else if (strcmp($id,"I8_H0_GME")==0) {				$date="1974-07-02T00:00:00.000Z";$sixmois=1;	// IMP8
			} else if (strcmp($id,"I8_OR_SSC")==0) {				$date="1974-07-02T00:00:00.000Z";$sixmois=1;	// IMP8
			} else if (strcmp($id,"PIONEER10_15MIN_GTT")==0) { 			$date="1991-07-02T00:00:00.000Z";$sixmois=1;	// PIONEER

			// -----------------
			// un fichier par an
			// -----------------
			} else if (strcmp($id,"AC_H3_CRIS")==0) { 			$date = "2000-02-02T00:00:00.000Z";	// ACE
			} else if (strcmp($id,"AC_H4_SWI")==0) { 			$date = "1998-02-02T00:00:00.000Z";	// ACE
			} else if (strcmp($id,"STA_L2_PLA_IRON_Q_2HR")==0) { 		$date = "2007-02-02T01:00:00.000Z";	// STEREO
			} else if (strcmp($id,"STB_L2_PLA_IRON_Q_2HR")==0) { 		$date = "2007-02-02T01:00:00.000Z";	// STEREO
			} else if (strcmp($id,"APOLLO12_SWS_1HR")==0) { 		$date = "1975-02-02T00:00:00.000Z";	// APOLLO
			} else if (strcmp($id,"APOLLO15_SWS_1HR")==0) { 		$date = "1972-02-02T00:00:00.000Z";	// APOLLO


			// --------------------
			// je ne sais pas faire
			// --------------------


			} else {
				$date = $startTime;
			}

			$tmp = explode("_",$id);
			$sat = $tmp[0];
			if (count($tmp) <= 2) {
				$exp = "???"; // arrive sur id RBSPB_ECT-HOPE-SCI-L2SA
			} else {
				$exp = $tmp[2];
			}

			//if ($id != "THG_L1_ASK") continue;

			printf ("DEBUG %s %s\n",$groups[$i],$id);

			for ($tentative=1 ; $tentative <= 10 ; $tentative++) {
				try {
					$cdfurls = $service1->getDataUrls($id,$date,substr($date,0,11)."23:59:59.999");
					$success = 1;
					break;
				} catch (SoapFault $fault) {
					$success = 0;
					printf ("AIE tentative=%d getDataUrls(%s,%s,%s): %d %s\n",$tentative,$id,$date,substr($date,0,11)."23:59:59.999",$fault->faultcode,$fault->faultstring);
					sleep(10);
					continue;
				}
			}
			if ($success == 0) continue;

			printf ("DEBUG getDataUrls => $cdfurls[0]\n");


			$localname = $cdfurls[0];
			if (empty($localname)) {
				$ok="NOFILE";
			}
			//printf ("ICI2 localname=%s\n",$localname);

			       if (strcmp($id,"I2_NEPROF_TOPIST")==0) { 	$masque = $cdfurls;	// ISIS un seul fichier qui contient plusieurs annes de donnes
			} else if (strcmp($id,"CL_JP_PCY")==0) { 		$masque = $cdfurls;	// CLUSTER un seul fichier qui contient plusieurs annes de donnes
			} else {
				$masque = url_to_masque ($cdfurls,$date,$YEAR,$MONTH,$DAY,$DOY);
			}
			//printf ("      YEAR=[%s] MONTH=[%s] DAY=[%s]\n",$YEAR,$MONTH,$DAY);
			//printf ("ICI3 masque=%s\n",$masque[0]);

			for ($tentative=1 ; $tentative <= 10 ; $tentative++) {
				try {
					$params = $service1->getDatasetVariables($id);
					$success = 1;
					break;
				} catch (SoapFault $fault) {
					$success = 0;
					printf ("AIE tentative=%d getDatasetVariables(%s): %d %s\n",$tentative,$id,$fault->faultcode,$fault->faultstring);
					sleep(10);
					continue;
				}
			}
			if ($success == 0) continue;

			printf ("DEBUG getDatasetVariables(%s):\n",$id);
			for ($l=0 ; $l<count($params) ; $l++) {
				$var = is_numeric(substr($params[$l][0],0,1)) ? "_".$params[$l][0] : $params[$l][0];
				printf ("  - %s %s\n",$var,$params[$l][1]);
			}

			//TMP printf ("      no=[%d] dataset=[%s] nbvar=[%d]\n",$j,$id,count($params));
			if (count($params)==0) $ok="NOVAR";	// pas de variables

			if (!empty($mymasque)) {
				$masque[0] = substr($masque[0],0,strrpos($masque[0],"/")) . "/" . $mymasque;
			} else if ($sixmois) {
				$masque[0] = str_replace ("\$YEAR\$MONTH01", "\$YEAR\$MONTS??", $masque[0]);
			} else {
				$masque[0] = str_replace ("\$YEAR\$MONTH01", "\$YEAR\$MONTH??", $masque[0]);
				$masque[0] = str_replace ("\$YEAR0101", "\$YEAR????", $masque[0]);
			}
			if ($nbmultiday) {
				$masque[0] = $masque[0]."{MULTIDAY:".$nbmultiday."}";
			}

			//$masque[0]    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/", "http://clweb.irap.omp.eu/cdaweb.php?URL=", $masque[0]);

			$is_irap = strcmp($id,"AC_H0_SWE")==0 || strcmp($id,"AC_K0_EPM")==0 || strcmp($id,"AC_K0_SIS")==0 || strcmp($id,"AC_K0_SWE")==0 || 
				   strcmp($id,"AC_K1_MFI")==0 || strcmp($id,"AC_H0_MFI")==0 || strcmp($id,"AC_H3_MFI")==0 ||

				   strncmp($id,"THA_",4)==0 || strncmp($id,"THB_",4)==0 || strncmp($id,"THC_",4)==0 || strncmp($id,"THD_",4)==0 || strncmp($id,"THE_",4)==0 ||
				   strncmp($id,"THG_L2_MAG_",11)==0 || strcmp($id,"THG_L1_ASK")==0 ||

				   strcmp($id,"STA_L1_MAG_SC")==0 || strcmp($id,"STA_L1_MAG_RTN")==0 || strcmp($id,"STA_L1_MAGB_SC")==0 || strcmp($id,"STA_L1_MAGB_RTN")==0 ||
				   strcmp($id,"STA_L1_LET")==0 || strcmp($id,"STA_L1_SEPT")==0 || strcmp($id,"STA_L1_SIT")==0 || strcmp($id,"STA_L1_STE")==0 ||
			 	   strcmp($id,"STA_L1_SWEA_DIST")==0 || strcmp($id,"STA_L1_SWEA_DISB")==0 ||

				   strcmp($id,"STB_L1_MAG_SC")==0 || strcmp($id,"STB_L1_MAG_RTN")==0 || strcmp($id,"STB_L1_MAGB_SC")==0 || strcmp($id,"STB_L1_MAGB_RTN")==0 ||
				   strcmp($id,"STB_L1_LET")==0 || strcmp($id,"STB_L1_SEPT")==0 || strcmp($id,"STB_L1_SIT")==0 || strcmp($id,"STB_L1_STE")==0 ||
			 	   strcmp($id,"STB_L1_SWEA_DIST")==0 || strcmp($id,"STB_L1_SWEA_DISB")==0 ||

				   strcmp($id,"OMNI_HRO_1MIN")==0 || strcmp($id,"OMNI_HRO_5MIN")==0 || strcmp($id,"OMNI_COHO1HR_MERGED_MAG_PLASMA")==0 ||

				   strcmp($id,"GE_K0_CPI")==0 || strcmp($id,"GE_K0_EPI")==0 || strcmp($id,"GE_K0_LEP")==0 || strcmp($id,"GE_K0_MGF")==0 ||

				   strcmp($id,"WI_ELPD_3DP")==0 || strcmp($id,"WI_ELSP_3DP")==0 || strcmp($id,"WI_H0_MFI")==0 || strcmp($id,"WI_H0_WAV")==0 ||
				   strcmp($id,"WI_H1_SWE")==0 || strcmp($id,"WI_H5_SWE")==0 || strcmp($id,"WI_K0_3DP")==0 || strcmp($id,"WI_K0_EPA")==0 ||
				   strcmp($id,"WI_K0_SMS")==0 || strcmp($id,"WI_OR_PRE")==0 || strcmp($id,"WI_PLSP_3DP")==0 || strcmp($id,"WI_PM_3DP")==0 ||
				   strcmp($id,"WI_H2_MFI")==0 || strcmp($id,"WI_K0_SWE")==0;

			if (strcmp($id,"THA_L2_MERGED")==0 || strcmp($id,"THA_OR_SSC")==0) $is_irap=0;
			if (strcmp($id,"THB_L2_MERGED")==0 || strcmp($id,"THB_OR_SSC")==0) $is_irap=0;
			if (strcmp($id,"THC_L2_MERGED")==0 || strcmp($id,"THC_OR_SSC")==0) $is_irap=0;
			if (strcmp($id,"THD_L2_MERGED")==0 || strcmp($id,"THD_OR_SSC")==0) $is_irap=0;
			if (strcmp($id,"THE_L2_MERGED")==0 || strcmp($id,"THE_OR_SSC")==0) $is_irap=0;

			$is_ephemeris = 

					// ACE
					strcmp($id,"AC_OR_DEF")==0 || strcmp($id,"AC_OR_SSC")==0 ||

					// CLUSTER
					strcmp($id,"C1_CP_FGM_SPIN")==0 || strcmp($id,"C2_CP_FGM_SPIN")==0 || strcmp($id,"C3_CP_FGM_SPIN")==0 || strcmp($id,"C4_CP_FGM_SPIN")==0 ||

					// GEOTAIL
					strcmp($id,"GE_OR_DEF")==0 || strcmp($id,"GE_OR_PRE")==0 ||

					// IMP8
					strcmp($id,"I8_OR_SSC")==0 ||

					// INTERBALL IA
					strcmp($id,"IA_OR_DEF")==0 ||

					// INTERBALL IT
					strcmp($id,"IT_OR_DEF")==0 ||

					// POLAR
					strcmp($id,"PO_OR_DEF")==0 || strcmp($id,"PO_OR_PRE")==0 ||

					// SOHO
					strcmp($id,"SO_OR_DEF")==0 || strcmp($id,"SO_OR_PRE")==0 ||

					// STEREO
					strcmp($id,"STA_COHO1HR_MERGED_MAG_PLASMA")==0 || strcmp($id,"STB_COHO1HR_MERGED_MAG_PLASMA")==0 ||

					// THEMIS
					strcmp($id,"THA_L2_MERGED")==0 || strcmp($id,"THA_OR_SSC")==0 || strcmp($id,"THA_L1_STATE")==0 ||
					strcmp($id,"THB_L2_MERGED")==0 || strcmp($id,"THB_OR_SSC")==0 || strcmp($id,"THB_L1_STATE")==0 ||
					strcmp($id,"THC_L2_MERGED")==0 || strcmp($id,"THC_OR_SSC")==0 || strcmp($id,"THC_L1_STATE")==0 ||
					strcmp($id,"THD_L2_MERGED")==0 || strcmp($id,"THD_OR_SSC")==0 || strcmp($id,"THD_L1_STATE")==0 ||
					strcmp($id,"THE_L2_MERGED")==0 || strcmp($id,"THE_OR_SSC")==0 || strcmp($id,"THE_L1_STATE")==0 ||

					// TWINS
					strcmp($id,"TWINS1_OR_DEF")==0 || strcmp($id,"TWINS2_OR_DEF")==0 ||

					// WIND
					strcmp($id,"WI_OR_DEF")==0 || strcmp($id,"WI_OR_PRE")==0;


			if ($bug) {
				$id = $id." *** BUG_CL_PLOT_ONLY_LAST_FILE_OF_DAY *** ";
			}
			if ($nocache) {
				$id = $id." *** NO_CACHE_CL *** ";
			}


			//printf ("%4d) %-6s %d %-55s %-38s %s\n",$nb_datasets,$ok,$index,$groups[$i],$id,substr($masque[0],28));
			printf ("%4d) %-6s %d %-55s %-38s %s\n",$nb_datasets,$ok,$index,$groups[$i],$id,$masque[0]);
			if (strcmp($ok,"OK")) continue;

			$YEAR = substr($date,0,4);
			$MONTH = substr($date,5,2);
			$DAY = substr($date,8,2);
			$YYYYMMDD = $YEAR . $MONTH . $DAY;

			fprintf ($fd,"%s#%s#%s#%s#%s#%s#%s#%s",
				$groups[$i]."_".$sat,$exp,$id,$label,$startTime,$endTime,
				$masque[0],$YYYYMMDD);
			for ($l=0 ; $l<count($params) ; $l++) {
				$var = is_numeric(substr($params[$l][0],0,1)) ? "_".$params[$l][0] : $params[$l][0];
				fprintf ($fd,"#%s%c%s",$var,2,$params[$l][1]);
			}
			fprintf ($fd,"\n");

			
			if ($is_irap) {
				if (strcmp($id,"AC_H0_SWE")==0) {
					$masque1    = "/DATA/ACE/DATA/CDF/H0_SWE/ac_h0_swe_\$YYYYMMDD_v??.cdf";
				} else if (strcmp($id,"AC_K0_EPM")==0) {
					$masque1    = "/DATA/ACE/DATA/CDF/K0_EPM/AC_K0_EPM_\$YYYYMMDD_V??.CDF";
				} else if (strcmp($id,"AC_K0_SIS")==0) {
					$masque1    = "/DATA/ACE/DATA/CDF/K0_SIS/ac_k0_sis_\$YYYYMMDD_v??.cdf";
				} else if (strcmp($id,"AC_K0_SWE")==0) {
					$masque1    = "/DATA/ACE/DATA/CDF/K0_SWE/AC_K0_SWE_\$YYYYMMDD_V??.CDF";
				} else if (strcmp($id,"AC_K1_MFI")==0) {
					$masque1    = "/DATA/ACE/DATA/CDF/K1_MFI/AC_K1_MFI_\$YYYYMMDD_V??.CDF";
				} else if (strcmp($id,"AC_H0_MFI")==0) {
					$masque1    = "/DATA/ACE/DATA/CDF/mfi_h0/\$YEAR/ac_h0_mfi_\$YYYYMMDD_v??.cdf";
				} else if (strcmp($id,"AC_H3_MFI")==0) {
					$masque1    = "/DATA/ACE/DATA/CDF/mfi_h3/\$YEAR/ac_h3_mfi_\$YYYYMMDD_v??.cdf";

				} else if (strncmp($id,"THA_",4)==0 || strncmp($id,"THB_",4)==0 || strncmp($id,"THC_",4)==0 || strncmp($id,"THD_",4)==0 || strncmp($id,"THE_",4)==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/themis/", "/DATA/THEMIS/DATA/", $masque[0]);

				} else if (strncmp($id,"THG_L2_MAG_",11)==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/themis/", "/DATA/THEMIS/DATA/", $masque[0]);

				} else if (strcmp($id,"THG_L1_ASK")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/themis/thg/l1/ask/", "/DATA/THEMIS/DATA/thg/l1/asi/ask/", $masque[0]);

				} else if (strncmp($id,"STA_",4)==0 || strncmp($id,"STB_",4)==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/stereo/", "/DATA/STEREO/DATA/l1data/", $masque[0]);
					$id1 = substr($id,4);
					if (strcmp($id1,"L1_MAG_SC")==0) {
						$masque1    = str_replace ("l1/impact/sc/mag", "mag/SC", $masque1);
					} else if (strcmp($id1,"L1_MAG_RTN")==0) {
						$masque1    = str_replace ("l1/impact/rtn/mag", "mag/RTN", $masque1);
					} else if (strcmp($id1,"L1_MAGB_SC")==0) {
						$masque1    = str_replace ("l1/impact/sc/magb", "mag/SC", $masque1);
					} else if (strcmp($id1,"L1_MAGB_RTN")==0) {
						$masque1    = str_replace ("l1/impact/rtn/magb", "mag/RTN", $masque1);
					} else if (strcmp($id1,"L1_LET")==0) {
						$masque1    = str_replace ("l1/impact/let", "let", $masque1);
					} else if (strcmp($id1,"L1_SEPT")==0) {
						$masque1    = str_replace ("l1/impact/sept", "sept", $masque1);
					} else if (strcmp($id1,"L1_SIT")==0) {
						$masque1    = str_replace ("l1/impact/sit", "sit", $masque1);
					} else if (strcmp($id1,"L1_STE")==0) {
						$masque1    = str_replace ("l1/impact/ste", "ste", $masque1);
					} else if (strcmp($id1,"L1_SWEA_DIST")==0) {
						$masque1    = str_replace ("l1/impact/swea_dist", "swea", $masque1);
					} else if (strcmp($id1,"L1_SWEA_DISB")==0) {
						$masque1    = str_replace ("l1/impact/swea_disb", "swea", $masque1);
					}
					$masque1    = dirname($masque1) . "/\$MONTH/" . strtoupper(basename($masque1));
					$masque1    = substr($masque1,0,strlen($masque1)-3) . "cdf";

				} else if (strcmp($id,"OMNI_HRO_1MIN")==0 || strcmp($id,"OMNI_HRO_5MIN")==0 || strcmp($id,"OMNI_COHO1HR_MERGED_MAG_PLASMA")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/omni/", "/DATA/OMNI/DATA/", $masque[0]);

				} else if (strcmp($id,"GE_K0_CPI")==0 || strcmp($id,"GE_K0_EPI")==0 || strcmp($id,"GE_K0_LEP")==0 || strcmp($id,"GE_K0_MGF")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/geotail/", "/DATA/GEOTAIL/DATA/Kp/", $masque[0]);
					$masque1    = dirname(dirname($masque1)) . "/" . basename($masque1);

				} else if (strcmp($id,"WI_ELPD_3DP")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/wind/3dp/3dp_elpd/", "/DATA/WIND/DATA/CDF/3dp_elpd/", $masque[0]);

				} else if (strcmp($id,"WI_ELSP_3DP")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/wind/3dp/3dp_elsp/", "/DATA/WIND/DATA/CDF/ELSP_3DP/", $masque[0]);
					$masque1    = dirname(dirname($masque1)) . "/" . basename($masque1);

				} else if (strcmp($id,"WI_H0_MFI")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/wind/mfi/mfi_h0/", "/DATA/WIND/DATA/CDF/H0_MFI/", $masque[0]);
					$masque1    = dirname(dirname($masque1)) . "/" . basename($masque1);

				} else if (strcmp($id,"WI_H0_WAV")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/wind/waves/wav_h0/", "/DATA/WIND/DATA/CDF/H0_WAV/", $masque[0]);
					$masque1    = dirname(dirname($masque1)) . "/" . basename($masque1);

				} else if (strcmp($id,"WI_H1_SWE")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/wind/swe/swe_h1/", "/DATA/WIND/DATA/CDF/H1_SWE/", $masque[0]);
					$masque1    = dirname(dirname($masque1)) . "/" . basename($masque1);

				} else if (strcmp($id,"WI_H5_SWE")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/wind/swe/swe_h5/", "/DATA/WIND/DATA/CDF/H5_SWE/", $masque[0]);
					$masque1    = dirname(dirname($masque1)) . "/" . basename($masque1);

				} else if (strcmp($id,"WI_K0_3DP")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/wind/3dp/3dp_k0/", "/DATA/WIND/DATA/CDF/K0_3DP/", $masque[0]);
					$masque1    = dirname(dirname($masque1)) . "/" . basename($masque1);

				} else if (strcmp($id,"WI_K0_EPA")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/wind/epact/epact_k0/", "/DATA/WIND/DATA/CDF/K0_EPA/", $masque[0]);
					$masque1    = dirname(dirname($masque1)) . "/" . basename($masque1);

				} else if (strcmp($id,"WI_K0_SMS")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/wind/swics/sms_k0/", "/DATA/WIND/DATA/CDF/K0_SMS/", $masque[0]);
					$masque1    = dirname(dirname($masque1)) . "/" . basename($masque1);

				} else if (strcmp($id,"WI_OR_PRE")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/wind/orbit/pre_or/", "/DATA/WIND/DATA/CDF/OR_PRE/", $masque[0]);
					$masque1    = dirname(dirname($masque1)) . "/" . basename($masque1);

				} else if (strcmp($id,"WI_PLSP_3DP")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/wind/3dp/3dp_plsp/", "/DATA/WIND/DATA/CDF/PLSP_3DP/", $masque[0]);
					$masque1    = dirname(dirname($masque1)) . "/" . basename($masque1);

				} else if (strcmp($id,"WI_PM_3DP")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/wind/3dp/3dp_pm/", "/DATA/WIND/DATA/CDF/PM_3DP/", $masque[0]);
					$masque1    = dirname(dirname($masque1)) . "/" . basename($masque1);

				} else if (strcmp($id,"WI_H2_MFI")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/wind/mfi/mfi_h2/", "/DATA/WIND/DATA/CDF/mfi_h2/", $masque[0]);

				} else if (strcmp($id,"WI_K0_SWE")==0) {
					$masque1    = str_replace ("https://cdaweb.sci.gsfc.nasa.gov/sp_phys/data/wind/swe/swe_k0/", "/DATA/WIND/DATA/CDF/swe/", $masque[0]);

				}

				fprintf ($fd,"%s#%s#%s#%s#%s#%s#%s#%s",
					$groups[$i]."_".$sat,$exp,$id.$irap_mirror,$label,$startTime,$endTime,
					$masque1,$YYYYMMDD);
				for ($l=0 ; $l<count($params) ; $l++) {
					$var = is_numeric(substr($params[$l][0],0,1)) ? "_".$params[$l][0] : $params[$l][0];
					fprintf ($fd,"#%s%c%s",$var,2,$params[$l][1]);
				}
				fprintf ($fd,"\n");
			}

			if ($is_ephemeris) {
				fprintf ($fd,"%s#%s#%s#%s#%s#%s#%s#%s",
					$groups[$i]."_".$sat,"00000ephemeris",$id,$label,$startTime,$endTime,
					$masque[0],$YYYYMMDD);
				for ($l=0 ; $l<count($params) ; $l++) {
					fprintf ($fd,"#%s%c%s",$var,2,$params[$l][1]);
				}
				fprintf ($fd,"\n");
				if ($is_irap) {
					fprintf ($fd,"%s#%s#%s#%s#%s#%s#%s#%s",
						$groups[$i]."_".$sat,"00000ephemeris",$id.$irap_mirror,$label,$startTime,$endTime,
						$masque1,$YYYYMMDD);
					for ($l=0 ; $l<count($params) ; $l++) {
						fprintf ($fd,"#%s%c%s",$var,2,$params[$l][1]);
					}
					fprintf ($fd,"\n");
				}
			}
		}
	}
	fclose ($fd);
}

printf ("nb_datasets = %d\n",$nb_datasets);

?>

