<?php


	// Lecture du fichier "get_arbre_caa.txt" qui provient du wget
	$nbdatasets=0;
	$poubelle=1;
	$fd = fopen ("get_arbre_caa.txt","r");
	$id="";
	while (1) {
		$ligne = fgets($fd);
		//printf ("ligne=%s\n",$ligne);
		if (feof($fd)) break;
		$tmp = preg_split("/\s+/",$ligne);
		//var_dump($tmp);
		if (count($tmp)==0) continue;
		$c = substr($tmp[0],0,1);
		if ($c=='C' || $c=='D') {
			$poubelle=0;
			if (!empty($id)) {
				$datasets[$nbdatasets++] = array(
					"id" 		=> $id,
					"label"		=> $label,
					"startTime"	=> $startTime,
					"endTime"	=> $endTime
				);
				//printf ("  id=[%s] startTime=[%s] endTime=[%s] label=[%s]\n",$id,$startTime,$endTime,$label);
				$id="";
			}
			$id=$tmp[0];
			$startTime=$tmp[1].'T'.$tmp[2].'.000Z';
			$endTime=$tmp[3].'T'.$tmp[4].'.000Z';
			$label=$tmp[5];
			for ($j=6 ; $j<count($tmp) ; $j++) {
				$label = $label . " " . $tmp[$j];
			}
		} else if ($poubelle==0) {
			for ($i=0 ; $i<count($tmp) ; $i++) {
				//printf ("*** RAJOUT [%s] ***\n",$tmp[$i]);
				$label = $label . " " . $tmp[$i];
			}
		}
	}

	if (!empty($id)) {

		$datasets[$nbdatasets++] = array(
			"id" 		=> $id,
			"label"		=> $label,
			"startTime"	=> $startTime,
			"endTime"	=> $endTime
		);
	}
	fclose($fd);

	// Cration du fichier "get_arbre_caa_0"
	$nom_fichier = sprintf ("get_arbre_caa_0");
	$fd = fopen ($nom_fichier,"w");

	$groups="CLUSTER";

	$nb_datasets=0;


	for ($j=0 ; $j<count($datasets) ; $j++) {

		$nb_datasets++;

		$dataset = $datasets[$j];
		$id = $dataset["id"];
		$label = $dataset["label"];
		$endTime = $dataset["endTime"];
		$startTime = $dataset["startTime"];
		$date = $startTime;

		//if (substr($id,3) != "CP_WHI_ELECTRON_DENSITY") continue;

		$date = $datasets[$j]["startTime"];
		for ($k=0 ; $k<count($datasets) ; $k++) {
			if ($k==$j) continue;
			if (substr($datasets[$k]["id"],2) == substr($datasets[$j]["id"],2)) {
				if (strcmp($datasets[$k]["startTime"],$date)>0) {
					$date = $datasets[$k]["startTime"];
				}
			}
		}

		if ($startTime != $date) {
			printf ("%s: startTime=%s => date=%s\n",$id,$startTime,$date);
		}


		if ($id=="C1_CP_STA_PSD" || $id=="C2_CP_STA_PSD" || $id=="C3_CP_STA_PSD" || $id=="C4_CP_STA_PSD") {
			// Les mtadonnes de 20010101 donnent des noms de variables "BB_xxyyzz_isr2" et "EE_xxyy_isr2"
			// alors que pour les autres jours on a "BB_xxyyzz_sr2" et "BB_xxyyzz_sr2"
			$date = '2001-01-02T00:00:00.000Z';
		}


		$tmp = explode("_",$id);
		$sat = $tmp[0];
		$xxx = $tmp[1];
		$exp = $tmp[2];

		if ($xxx == "CP") {
			// ex: "C1_CP_FGM_SPIN"
		} else {
			//continue;
		}

		if (substr($id,3) == "CP_WHI_ELECTRON_DENSITY") {
			//$date = "2001-02-05";
		}

		$YEAR = substr($date,0,4);
		$MONTH = substr($date,5,2);
		$DAY = substr($date,8,2);
		$YYYYMMDD = $YEAR . $MONTH . $DAY;

		$masque = sprintf ("http://caa/%s/%s/%s/\$YEAR/\$MONTH/%s_\$YYYYMMDD_V01.cef",$sat,$exp,$id,$id);

		$ok="OK";
		printf ("%4d) %-6s %-55s %-38s %s\n",$nb_datasets,$ok,$groups,$id,substr($masque[0],28));
		if (strcmp($ok,"OK")) continue;

		fprintf ($fd,"%s#%s#%s#%s#%s#%s#%s#%s",
				$groups."_".$sat,$exp,$id,$label,$startTime,$endTime,$masque,$YYYYMMDD);
		fprintf ($fd,"\n");
			
		$is_ephemeris = strcmp($id,"C1_CP_AUX_POSGSE_1M")==0 || strcmp($id,"C2_CP_AUX_POSGSE_1M")==0 || strcmp($id,"C3_CP_AUX_POSGSE_1M")==0 || strcmp($id,"C4_CP_AUX_POSGSE_1M")==0;

		if ($is_ephemeris) {
			fprintf ($fd,"%s#%s#%s#%s#%s#%s#%s#%s",
					$groups."_".$sat,"00000ephemeris",$id,$label,$startTime,$endTime,$masque,$YYYYMMDD);
			fprintf ($fd,"\n");
		}
	}
	fclose ($fd);
	printf ("nb_datasets = %d\n",$nb_datasets);

?>

