<?php
 
/** 
*   @class AMDA_METHODS_WS
*   @brief  
*   
*   @version $Id:  0.1 
*/


class CLWEB_METHODS_WS {
    
	private $user, $passwd, $IP;
	private $tt, $wsParams, $localParams, $remoteParams;
	private $chain, $vars;
	private $start, $stop, $missions, $nInts;
	private $isSoap = false;
	private $IMPEXPREFIX = 'IMPEX';

	// ---------------------------------------------------------------------------
	function __construct(){
	// ---------------------------------------------------------------------------
		    
		$this->tt = 'Tt';
		$this->wsParams = 'WsParams';
		$this->localParams = 'LocalParams';
		$this->remoteParams = 'RemoteParams';
		$this->user = 'impex';
		$this->passwd = 'impexfp7';

	}

	// ---------------------------------------------------------------------------
	public function getObsDataTree() {
	// ---------------------------------------------------------------------------

		return array("success" => true, "Tree" => 'http://clweb.irap.omp.eu/clweb_tree.xml');

	}


	// ---------------------------------------------------------------------------
	public function usage_getTimeTablesList() {
	// ---------------------------------------------------------------------------

		$txt = $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];

		$message =  sprintf ("<u>Usage</u>: %s<br><br>",$txt);
		$message .= sprintf ("<table border=1>\n");
		$message .= sprintf ("<tr><td>parameterID</td><td>mandatory</td><td>id of parameter or component found in clweb_tree.xml</td></tr>");
		$message .= sprintf ("<tr><td>startTime</td><td>mandatory</td><td>start time in format YYYY-MM-DDTHH:MM</td></tr>");
		$message .= sprintf ("<tr><td>stopTime</td><td>mandatory</td><td>stop time in format YYYY-MM-DDTHH:MM</td></tr>");
		$message .= sprintf ("<tr><td>outputFormat</td><td>optional</td><td>- CEF<br>- CDF (default)<br>- netCDF<br>- VOTable<br>- pngXXX with XXX size of plot (ex: png80) </td></tr>");
		$message .= sprintf ("<tr><td>gzip</td><td>optional</td><td>- 0 (default)<br>- 1 to compress data with gzip</td></tr>");
		$message .= sprintf ("<tr><td>stream</td><td>optional</td><td>- 0 (default)<br>- 1 to obtain data directly in stream</td></tr>");
		$message .= sprintf ("</table>");

		return array("success" => false, "message" => $message);

	}

	// ---------------------------------------------------------------------------
	public function getTimeTablesList($data) {
	// ---------------------------------------------------------------------------

		if (is_object($data)) {
			$vars = get_object_vars($data); 
			$this->isSoap = true;  
		} else {
			$vars = $data;
		}


		//	userID
		//	password

		$userID		=	$vars['userID'];
		$password	=	$vars['password'];

		if ($userID=="")   $userID  ="impex";
		if ($password=="") $password="impex";

		// Rajout 19/12/2018
		date_default_timezone_set("Europe/Paris");


		$date1 = date('Ymd_His');
		$micro = microtime(false)*1e6;
		$date = sprintf ("%s_%06.0f",$date1,$micro);
		$directory = "/home/clweb/tmp/WS/" . $date;
		mkdir($directory);

		$name = $directory . "/tt.xml";

		$fd = fopen ($name,"w");

		$masque = "/home/clweb/" . $userID . "/work/TT/*.xml";

		fprintf ($fd, '<?xml version="1.0"?>' . "\n");
		fprintf ($fd, '<ws>' . "\n");
		fprintf ($fd, '<timetabList xml:id="timeTable-treeRootNode">' . "\n");

		foreach (glob($masque) as $filename) {
			fprintf ($fd, '<timetab xml:id="%s" name="%s"/>' . "\n",basename($filename),basename($filename));
		}
		fprintf ($fd, '</timetabList>' . "\n");
		fprintf ($fd, '</ws>' . "\n");

		fclose ($fd);

		$tmp = sprintf ("http://clweb.irap.omp.eu/tmp/WS/%s/%s",$date,basename($name));
		return array("success" => true, "TimeTablesList" => $tmp);

	}


	// ---------------------------------------------------------------------------
	public function usage_getTimeTable() {
	// ---------------------------------------------------------------------------

		$txt = $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];

		$message =  sprintf ("<u>Usage</u>: %s<br><br>",$txt);
		$message .= sprintf ("<table border=1>\n");
		$message .= sprintf ("<tr><td>userID</td><td>optional</td><td>username (impex by default)</td></tr>");
		$message .= sprintf ("<tr><td>password</td><td>optional</td><td>password (impex by default)</td></tr>");
		$message .= sprintf ("<tr><td>ttID</td><td>mandatory</td><td>id of timetable</td></tr>");
		$message .= sprintf ("</table>");

		return array("success" => false, "message" => $message);

	}


	// ---------------------------------------------------------------------------
	public function getTimeTable($data) {
	// ---------------------------------------------------------------------------

		if (is_object($data)) {
			$vars = get_object_vars($data); 
			$this->isSoap = true;  
		} else {
			$vars = $data;
		}

		//	userID
		//	password

		$userID		=	$vars['userID'];
		$password	=	$vars['password'];
		$ttID		=	$vars['ttID'];

		if ($userID=="")   $userID  ="impex";
		if ($password=="") $password="impex";
		if ($ttID=="")     return $this -> usage_getTimeTable();

		$date1 = date('Ymd_His');
		$micro = microtime(false)*1e6;
		$date = sprintf ("%s_%06.0f",$date1,$micro);
		$directory = "/home/clweb/tmp/WS/" . $date;
		mkdir($directory);

		$old_name = "/home/clweb/" . $userID . "/work/TT/" . $ttID;
		$new_name = $directory . "/" . $ttID;

		$code = copy($old_name,$new_name);

		$tmp = sprintf ("http://clweb.irap.omp.eu/tmp/WS/%s/%s",$date,basename($new_name));
		return array("success" => true, "ttFileURL" => $tmp);

	}


	// ---------------------------------------------------------------------------
	public function usage_getParameter() {
	// ---------------------------------------------------------------------------

		$txt = $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];

		$message .= sprintf ("<u>Usage</u>: %s<br><br>",$txt);
		$message .= sprintf ("<table border=1>\n");
		$message .= sprintf ("<tr><td>parameterID</td><td>mandatory</td><td>id of parameter or component found in clweb_tree.xml</td></tr>");
		$message .= sprintf ("<tr><td>startTime</td><td>mandatory</td><td>start time in format YYYY-MM-DDTHH:MM</td></tr>");
		$message .= sprintf ("<tr><td>stopTime</td><td>mandatory</td><td>stop time in format YYYY-MM-DDTHH:MM</td></tr>");
		$message .= sprintf ("<tr><td>outputFormat</td><td>optional</td><td>- CEF<br>- CDF (default)<br>- netCDF<br>- VOTable<br>- pngXXX with XXX size of plot (ex: png80) </td></tr>");
		$message .= sprintf ("<tr><td>gzip</td><td>optional</td><td>- 0 (default)<br>- 1 to compress data with gzip</td></tr>");
		$message .= sprintf ("<tr><td>stream</td><td>optional</td><td>- 0 (default)<br>- 1 to obtain data directly in stream</td></tr>");
		$message .= sprintf ("</table>");

		return array("success" => false, "message" => $message);
	}

	// ---------------------------------------------------------------------------
	public function getParameter($data) {
	// ---------------------------------------------------------------------------

		if (is_object($data)) {
			//return array("dataFileURLs" => "YES SOAP=1");
			$vars = get_object_vars($data); 
			$this->isSoap = true;  
		} else {
			//return array("dataFileURLs" => "YES SOAP=0");
			$vars = $data;
		}


		//	parameterID
		//	startTime
		//	stopime
		//	format		cef ou cdf
		//	gzip		1 ou 0

		//$top1 = date('H')*3600 + date('i')*60 + date('s') + microtime(false);

		$DIR = getcwd();
		//printf ("DIR=%s<br>\n",$DIR);
		$ENV = sprintf ("CLWEB_DEV=%s",$DIR == '/var/www/html/clweb_dev' ? "1" : "0");
		//printf ("ENV=%s<br>\n",$ENV);
		putenv ($ENV);
		$OPT = sprintf ("%s",$DIR == '/var/www/html/clweb_dev' ? "-D" : "");
		$OPT = sprintf ("");
		//printf ("OPT=%s<br>\n",$OPT);

		$parameter_id	=	$vars['parameterID'];
		$start_time	=	$vars['startTime'];
		$stop_time	=	$vars['stopTime'];
		$format		=	$vars['outputFormat'];	// "cdf" par dfaut
		$gzip		=	$vars['gzip'];
		$stream		=	$vars['stream'];

		if ($parameter_id=='') return $this -> usage_getParameter();
		if ($start_time=='') return $this -> usage_getParameter();
		if ($stop_time=='') return $this -> usage_getParameter();

		if ($format=="") $format="CDF";

		switch ($format) {
			case 'CEF':
				$cef	= 1;
				$ext	= 'cef';
				break;

			case 'CDF':
				$cdf	= 1;
				$ext	= 'cdf';
				break;

			case 'netCDF':
				$netcdf	= 1;
				$ext	= 'nc';
				break;

			case 'VOTable':
				$votable = 1;
				$ext     = 'xml';
				break;

			default:
				if (substr($format,0,3) == 'PNG') {
					$nomps 	= strtolower($format);
					$ext	= 'png';
				} else {
					return $this -> usage_getParameter();
				}
		}

		if ($gzip=="")   $gzip  ="0";
		switch ($gzip) {
			case '0':
			case '1':
				break;

			default:
				return $this -> usage_getParameter();
		}

		if ($stream=="")   $stream  ="0";
		switch ($stream) {
			case '0':
			case '1':
				break;

			default:
				return $this -> usage_getParameter();
		}
	
	
		$date1 = date('Ymd_His');
	        $micro = microtime(false)*1e6;
		$date = sprintf ("%s_%06.0f",$date1,$micro);

		$directory = "/home/clweb/tmp/WS/" . $date;

		mkdir ($directory, 0700, true);
		$code = chdir($directory);

		$batch = "batch";

		$fd = fopen ($batch,"w");
		fprintf ($fd,"Web_service     	= getParameter\n");
		fprintf ($fd,"Parameter_id     	= %s\n",		$parameter_id);
		fprintf ($fd,"Temps_debut     	= %s:00.000Z\n",	$start_time);
		fprintf ($fd,"Temps_fin       	= %s:00.000Z\n",	$stop_time);
		fprintf ($fd,"Cef             	= %d\n",		$cef);
		fprintf ($fd,"Cdf             	= %d\n",		$cdf);
		fprintf ($fd,"Netcdf          	= %d\n",		$netcdf);
		fprintf ($fd,"Votable           = %d\n",		$votable);
		fprintf ($fd,"Nomps             = %s\n",		$nomps);
		fclose ($fd);

		// modif pour avoir le numéro de ligne en cas de plantage
		// $OPT = "-D";

		$cmd = sprintf ("%s/cl/cl %s -batchweb %s 1> /%s/clweb_tmp_log1 2> /%s/clweb_tmp_log2", $DIR,$OPT,$batch,$directory,$directory);

		//printf ("cmd=%s<br>\n",$cmd);
		system($cmd);

		// le fichier "idl.ps" a t cr pour rien
		unlink("idl.ps");

		$pattern = sprintf("*.%s",$ext);
		$list = glob($pattern);

		if (count($list)==1) {
			$newname = sprintf("data.%s",$ext);
			$code = rename($list[0],$newname);

			if ($gzip=="1") {
				$cmd = sprintf ("gzip \"%s\"",$newname); // ""  cause des caractres spciaux
				system($cmd);
				$newname = sprintf ("%s.gz",$newname);
				$ext = 'gz';
			}

			if ($stream=="1") {
				if ($ext == 'png') {
					header('Content-type: image/png');
				} else if ($ext == 'gz') {
					header('Content-type: application/gzip');
				} else {
					header('Content-type: application/octet-stream');
				}
				readfile ($newname);
			} else {
				$tmp = sprintf ("http://%s/tmp/WS/%s/%s",
					$DIR=="/var/www/html/clweb_dev" ? "stereo.cesr.fr/clweb_dev" : "clweb.irap.omp.eu",
					$date,$newname);
				return array("success" => true, "dataFileURLs" => $tmp);
			}
		} else {
			return array("success" => false, "message" => "no data");
		}

	}


}

?>
