/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: CATALOG.h,v $
 *
 *	Version	: $Revision: 1.1.1.1 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2004/09/22 09:00:14 $
 *
 *	==========================================================================================
 *
 *	Gestion du catalogue de calibrations
 */

#ifndef __CATALOG_H
#define __CATALOG_H


/***************************************************************************************************
 *
 *	Lecture du catalogue de calibration
 *	-----------------------------------
 */
t_err	Lecture_catalogue (char * fichier, int version);


/***************************************************************************************************
 *
 *	Fermeture du catalogue
 *	----------------------
 */
t_err	Fermeture_catalogue (void);


/***************************************************************************************************
 *
 *	Affichage du catalogue
 *	----------------------
 */
t_err	Affiche_catalogue (void);


/***************************************************************************************************
 *
 *	Cherche entree correspondante dans catalogue
 *	--------------------------------------------
 */
t_err	Cherche_entree_catalogue (char * var, double date);


/***************************************************************************************************
 *
 *	Indique si une actualisation est devenue necessaire
 *	---------------------------------------------------
 */
t_err	Actualisation_necessaire (int indice, double date);


/***************************************************************************************************
 *
 *	Retourne la date de fin de validite de l'entree
 *	-----------------------------------------------
 */
t_err	Periode_validite (int indice, double * date_deb, double * date_fin);


/***************************************************************************************************
 *
 *	Retourne le nom du fichier de calibration correspondant
 *	-------------------------------------------------------
 */
char * 	Fichier_calibration (int indice);


/***************************************************************************************************
 *
 *	Retource les references de calibration
 *	--------------------------------------
 */
char * 	Reference_calibration (void);

#endif
