/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: SYMBOLS.c,v $
 *
 *	Version	: $Revision: 1.10 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2009/11/25 13:59:19 $
 *
 *	==========================================================================================
 *
 *	Module regroupant la gestion de tables de symboles
 */

#define	MODULE_NAME	"SYMBOLS"

#include "DSPLIB.h"

t_symbol	dsp_operational_mode [] = {	

		{ 0,	"M00",	"SW-1 Solar Wind mode 1"	},
		{ 1,	"M01",	"SW-2 Solar Wind mode 2"	},
		{ 2,	"M02",	"SW-3 Solar Wind mode 3"	},
		{ 3,	"M03",	"SW-4 Solar Wind mode 4"	},
		{ 4,	"M04",	"SW-C1 Solar Wind compression"	},
		{ 5,	"M05",	"SW-C2 Solar Wind compression"	},
		{ 6,	"M06",	"MAG2"				},
		{ 7,	"M07",	"Survival (PROM) or MAG1"	},
		{ 8,	"M08",	"MAG-1 Magnetospheric mode 1"	},
		{ 9,	"M09",	"MAG-2 Magnetospheric mode 2"	},
		{ 10,	"M10",	"MAG-3 Magnetospheric mode 3"	},
		{ 11,	"M11",	"MAG-4 Magnetosheath mode 1"	},
		{ 12,	"M12",	"MAG-1 Magnetospheric mode 2"	},
		{ 13,	"M13",	"MAG-C1 Compression 3Ds-1"	},
		{ 14,	"M14",	"MAG-C2 Compression 3Ds-2"	},
		{ 15,	"M15",	"Calibration Mode"		},
		{ EOF,	"???",	"Unknown operational mode"	}
};

t_symbol	dsp_sensitivity [] = {

		{ LS,	"LS",	"Low-g"			},
		{ HS,	"HS",	"High-G"		},
		{ EOF,	"??",	"Unknwown sensitivity"	}
};

t_symbol	dsp_ground_station [] = {

		{ 0,	"00",	"Unknown"	},
		{ 1,	"01",	"Villafranca"	},
		{ 2,	"02",	"Miyun"		},
		{ 3,	"03",	"Shanghai"	},
		{ 15,	"15",	"N/A"		},
		{ EOF,	"??",	"Unknown GS"	}
};


/***************************************************************************************************
 *
 *	Verifie que le symbole existe dans la table
 *	-------------------------------------------
 */
int	Unknown_symbol (t_symbol * ptr)
{
	return ptr->val == EOF;
}


/***************************************************************************************************
 *
 *	Cherche l'entree correspondant a la cle dans la table
 *	-----------------------------------------------------
 *
 *	Retourne un pointeur sur le symbole ou sur dernier element si non existant
 */
t_symbol * Search_symbol_key (t_symbol * table, char * key)
{
	t_symbol *	ptr;

	for (ptr = table; ptr->val != EOF; ptr ++) if (strcmp (ptr->key, key) == 0) return ptr;

	return ptr;
}


/***************************************************************************************************
 *
 *	Cherche l'entree correspond a la valeur dans la table
 *	-----------------------------------------------------
 *
 *	Retourne un pointeur sur le symbole ou sur dernier element si non existant
 */
t_symbol * Search_symbol_value (t_symbol * table, int value)
{
	t_symbol *	ptr;

	for (ptr = table; ptr->val != EOF; ptr ++) if (ptr->val == value) return ptr;

	return ptr;
}


int	Val (t_symbol * symbol)
{
	return	symbol->val;
}

char *	Key (t_symbol * symbol)
{
	return symbol->key;
}

char *	Lib (t_symbol * symbol)
{
	return symbol->lib;
}

char *	Lib_from_val (t_symbol * table, int value)
{
	return Lib (Search_symbol_value (table, value));
}

int	Val_from_key (t_symbol * table, char * key)
{
	return Val (Search_symbol_key (table, key));
}

char *	Key_from_val (t_symbol * table, int value)
{
	return Key (Search_symbol_value (table, value));
}
