/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: HEADER.c,v $
 *
 *	Version	: $Revision: 1.10 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2004/02/18 07:31:37 $
 *
 *	==========================================================================================
 *
 *	Module charge de la gestion des entetes de produits scientifiques
 *
 */
 
#define	MODULE_NAME	"HEADER"

#include "DSPLIB.h"


/****************************************************************************************************
 *
 *	Obtention d'informations sur le fichier produit
 *	-----------------------------------------------
 */
t_err	Get_product_info (t_prod_info * info, FILE * entree)
{
	char *		fonction = FNAME ("Get_product_info");
	t_err		error = OK;
	t_prod_header	header;

	if (ftell (entree) != 0) rewind (entree);

	info->file_size     = 0L;
	info->record_size   = 0;
	info->header_size   = 0;
	info->data_size     = 0;
	info->record_number = 0;

	if (Erreur (error = Read_product_header (& header, entree))) goto EXIT;

	if (error == WAR_eof) goto EXIT;

	info->header_size   = (int) ftell (entree);
	info->data_size     = header.size;
	info->record_size   = info->header_size + info->data_size;

	if (fseek (entree, 0, SEEK_END) == -1) {

		error = ERR_fseek;
		goto EXIT;
	}

	info->file_size     = ftell (entree);
	info->record_number = (int) (info->file_size / info->record_size);
	
	if ((long) info->record_size * info->record_number != info->file_size) {

		Affiche_erreur (fonction, "Structure fichier incorrecte");
		error = ERROR;
		goto EXIT;
	}

	rewind (entree);

EXIT:	return error;
}


/****************************************************************************************************
 *
 *	Ecriture d'une entete de produit sur fichier
 *	--------------------------------------------
 */
t_err	Write_product_header (t_prod_header * ptr, FILE * sortie)
{
	char *		fonction = FNAME ("Write_product_header");
	t_err		error = OK;
	int		nb_val = 19;
	int		count;
	t_CDS_time	data_time;
	t_CDS_time	scet_time;

	Milli_to_CDS_time (ptr->milli, & data_time);
	Milli_to_CDS_time (ptr->scet,  & scet_time);

	count	= Endian_write (& ptr->milli,         sizeof (double),   1, sortie)
		+ Endian_write (& data_time.pfield,   sizeof (byte_t),   1, sortie)
		+ Endian_write (& data_time.day,      sizeof (uint16_t), 1, sortie)
		+ Endian_write (& data_time.milli,    sizeof (uint32_t), 1, sortie)
		+ Endian_write (& scet_time.pfield,   sizeof (byte_t),   1, sortie)
		+ Endian_write (& scet_time.day,      sizeof (uint16_t), 1, sortie)
		+ Endian_write (& scet_time.milli,    sizeof (uint32_t), 1, sortie)
		+ Endian_write (& ptr->product,       sizeof (int16_t),  1, sortie)
		+ Endian_write (& ptr->sensitivity,   sizeof (int16_t),  1, sortie)
		+ Endian_write (& ptr->op_mode,       sizeof (int16_t),  1, sortie)
		+ Endian_write (& ptr->tlm_rate,      sizeof (int16_t),  1, sortie)
		+ Endian_write (& ptr->frame_counter, sizeof (int16_t),  1, sortie)
		+ Endian_write (& ptr->spin_frame,    sizeof (int16_t),  1, sortie)
		+ Endian_write (& ptr->spin_phase,    sizeof (int16_t),  1, sortie)
		+ Endian_write (& ptr->spin_packet,   sizeof (int16_t),  1, sortie)
		+ Endian_write (& ptr->phase_instr,   sizeof (int16_t),  1, sortie)
		+ Endian_write (& ptr->pspin,         sizeof (float),    1, sortie)
		+ Endian_write (& ptr->completion,    sizeof (float),    1, sortie)
		+ Endian_write (& ptr->size,          sizeof (int32_t),  1, sortie);

	if (count != nb_val) {

		Affiche_erreur (fonction, "Ecriture de %d champs au lieu de %d", count, nb_val);
		error = ERR_fwrite;
		goto EXIT;
	}
	
EXIT:	return error;
}


/****************************************************************************************************
 *
 *	Lecture d'une entete de produit sur fichier
 *	-------------------------------------------
 */
t_err	Read_product_header (t_prod_header * ptr, FILE * entree)
{
	char *		fonction = FNAME ("Read_product_header");
	t_err		error = OK;
	int		nb_val = 19;
	int		count;
	t_CDS_time	data_time;
	t_CDS_time	scet_time;

	count	= Endian_read (& ptr->milli,         sizeof (double),   1, entree)
		+ Endian_read (& data_time.pfield,   sizeof (byte_t),   1, entree)
		+ Endian_read (& data_time.day,      sizeof (uint16_t), 1, entree)
		+ Endian_read (& data_time.milli,    sizeof (uint32_t), 1, entree)
		+ Endian_read (& scet_time.pfield,   sizeof (byte_t),   1, entree)
		+ Endian_read (& scet_time.day,      sizeof (uint16_t), 1, entree)
		+ Endian_read (& scet_time.milli,    sizeof (uint32_t), 1, entree)
		+ Endian_read (& ptr->product,       sizeof (int16_t),  1, entree)
		+ Endian_read (& ptr->sensitivity,   sizeof (int16_t),  1, entree)
		+ Endian_read (& ptr->op_mode,       sizeof (int16_t),  1, entree)
		+ Endian_read (& ptr->tlm_rate,      sizeof (int16_t),  1, entree)
		+ Endian_read (& ptr->frame_counter, sizeof (int16_t),  1, entree)
		+ Endian_read (& ptr->spin_frame,    sizeof (int16_t),  1, entree)
		+ Endian_read (& ptr->spin_phase,    sizeof (int16_t),  1, entree)
		+ Endian_read (& ptr->spin_packet,   sizeof (int16_t),  1, entree)
		+ Endian_read (& ptr->phase_instr,   sizeof (int16_t),  1, entree)
		+ Endian_read (& ptr->pspin,         sizeof (float),    1, entree)
		+ Endian_read (& ptr->completion,    sizeof (float),    1, entree)
		+ Endian_read (& ptr->size,          sizeof (int32_t),  1, entree);

	if (count != nb_val) {

		if (count == 0 && feof (entree)) {

			error = WAR_eof;
		}
		else {	Affiche_erreur (fonction, "Lecture de %d champs au lieu de %d", count, nb_val);
			error = ERR_fread;
		}
		goto EXIT;
	}

	if (ptr->milli != CDS_time_to_milli (data_time)) {

		Affiche_erreur (fonction, "Temps incorrect");
		error = ERR_date;
		goto EXIT;
	}

	ptr->scet = CDS_time_to_milli (scet_time);

EXIT:	return error;
}
