/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: FILES.c,v $
 *
 *	Version	: $Revision: 1.6 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2009/11/25 13:58:45 $
 *
 *	==========================================================================================
 *
 *	Module regroupant diverses fonctions de manipulations sur les fichiers
 */

#define	MODULE_NAME	"FILES"

#include "DSPLIB.h"

char *			dsp_root = NULL;	/* Racine arborescence Double Star				*/

char *			dsp_ope_root = NULL;	/* Racine arborescence Double Star commanding operations	*/

static	glob_t		buffer;			/* Buffer utilise par glob ()					*/


/***************************************************************************************************
 *
 *	Verification existence variable DSP_ROOT
 *	----------------------------------------
 */
t_err	Check_DSP_root (void)
{
	char *		fonction = FNAME ("Check_DSP_root");
	t_err		error = OK;

	if ((dsp_root = getenv ("DSP_ROOT")) == NULL) {

		Affiche_erreur (fonction, "Variable DSP_ROOT non positionnee");
		error = ERR_getenv;
		goto EXIT;
	}

EXIT:	return error;
}


/***************************************************************************************************
 *
 *	Verification existence variable DSP_OPE_ROOT
 *	--------------------------------------------
 */
t_err	Check_DSP_ope_root (void)
{
	char *		fonction = FNAME ("Check_DSP_ope_root");
	t_err		error = OK;

	if ((dsp_ope_root = getenv ("DSP_OPE_ROOT")) == NULL) {

		Affiche_erreur (fonction, "Variable DSP_OPE_ROOT non positionnee");
		error = ERR_getenv;
		goto EXIT;
	}

EXIT:	return error;
}

/****************************************************************************************************
 *
 *	Recherche de fichiers correspondant a un masque 
 *	-----------------------------------------------
 */
t_err	Search_files (char * mask, int * count)
{
	char *		fonction = FNAME ("Search_files");
	t_err		error = OK;

	* count = 0;

	buffer.gl_offs = 0;

	if (glob (mask, 0, NULL, & buffer) == -1) {

		Affiche_erreur (fonction, "Erreur glob () : masque = %s : ", mask);
		error = ERR_glob;
		goto EXIT;
	}

	* count = buffer.gl_pathc;

EXIT:	return error;	
}


/****************************************************************************************************
 *
 *	Libere ressources memoire allouees par glob ()
 *	----------------------------------------------
 */
void	Search_free (void)
{
	globfree (& buffer);

	buffer.gl_pathc = 0;
}


/****************************************************************************************************
 *
 *	Retourne le nom du nieme fichier
 *	--------------------------------
 */
char *	Get_filename (int number)
{
	if (number < 0 || number >= buffer.gl_pathc) return (char *) NULL;

	return buffer.gl_pathv [number];
}


/****************************************************************************************************
 *
 *	Lecture d'une ligne dans un fichier et suppression du saut de ligne final
 *	-------------------------------------------------------------------------
 */
t_err	Read_line (char * buffer, FILE * pf)
{
	char *		fonction = FNAME ("Read_line");
	t_err		error = OK;
	int		end;

	if (fgets (buffer, 1024, pf) == NULL) {

		strcpy (buffer, "");

		error = feof (pf) ? WAR_eof : ERR_fgets;

		goto EXIT;
	}

	end = strlen (buffer) -1;

	if (end >= 0 && buffer [end] == '\n') buffer [end] = 0;

EXIT:	return error;
}


/****************************************************************************************************
 *
 *	Verification nombre valeurs lues = attendues
 *	--------------------------------------------
 */
t_err	Check_read_values (char * fonction, int count, int expected)
{
	t_err		error = OK;

	if (count != expected) {


		Affiche_erreur (fonction, "%d/%d valeurs lues", count, expected);
		error = ERR_fread;
	}
	return error;
}


/****************************************************************************************************
 *
 *	Verification nombre valeurs ecrites = attendues
 *	-----------------------------------------------
 */
t_err	Check_write_values (char * fonction, int count, int expected)
{
	t_err		error = OK;

	if (count != expected) {


		Affiche_erreur (fonction, "%d/%d valeurs ecrites", count, expected);
		error = ERR_fwrite;
	}

	return error;
	}
