/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: SYMBOLS.h,v $
 *
 *	Version	: $Revision: 1.11 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2009/11/25 13:59:19 $
 *
 *	==========================================================================================
 *
 *	Module regroupant la gestion de tables de symboles
 */

#ifndef	__SYMBOLS_H
#define	__SYMBOLS_H

typedef struct {		/* Entree d'une table de symboles	*/

	int	val;		/* - indice				*/
	char *	key;		/* - cle de recherche			*/
	char *	lib;		/* - libelle				*/

}	t_symbol;


#define	NB_TLM_PRODUCT	63				/* Number of DSP telemetry products	*/

#define	NB_DSP_MODE	16				/* Number of DSP operational modes	*/

#define	NB_SENSITIVITY	2				/* Number of DSP sensitivity		*/

#define	NB_ANODE	16				/* Number of anods			*/

typedef	enum { LS = 0, HS = 1 }	t_sensitivity;

extern	t_symbol	dsp_operational_mode [];	/* Table of DSP operational modes	*/

extern	t_symbol	dsp_sensitivity [];		/* Table of DSP sensitivity		*/

extern	t_symbol	dsp_ground_station [];		/* Table of DSP ground stations		*/

/*	Teste si le symbole existe dans la table
 *	----------------------------------------
 */
int	Unknown_symbol (t_symbol *);


/*	Cherche l'entree correspondant a la cle dans la table
 *	-----------------------------------------------------
 *
 *	Retourne un pointeur sur le symbole ou sur dernier element si non existant
 */
t_symbol * Search_symbol_key (t_symbol * table, char * key);


/*	Cherche l'entree correspond a la valeur dans la table
 *	-----------------------------------------------------
 *
 *	Retourne un pointeur sur le symbole ou sur dernier element si non existant
 */
t_symbol * Search_symbol_value (t_symbol * table, int value);


/*	Fonction d'acces a la valeur d'un symbole
 *	-----------------------------------------
 */
int	Val (t_symbol *);


/*      Fonction d'acces a la cle d'un symbole
 *      --------------------------------------
 */
char *	Key (t_symbol *);


/*	Fonction d'acces au libelle d'un symbole
 *	----------------------------------------
 */
char *	Lib (t_symbol *);

char *	Lib_from_val (t_symbol *, int);

char *	Key_from_val (t_symbol *, int);

int	Val_from_key (t_symbol *, char *);

#endif
