/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: MATHS.h,v $
 *
 *	Version	: $Revision: 1.1 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2007/07/19 10:44:35 $
 *
 *	==========================================================================================
 *
 *	Module definissant quelques outils de calcul
 */

#ifndef	__MATHS_H
#define	__MATHS_H

#ifndef	M_PI
#define M_PI		3.14159265358979323846
#endif

#define	DEG_TO_SR(x)	((x) * M_PI / 180.0)
#define	SR_TO_DEG(x)	((x) * 180.0 / M_PI)

extern	const float	FILL_VALUE;
extern	const float	EPSILON;

typedef	double		V3 [3];

typedef	double		M33 [3][3];


/*	Indique si la valeur est une valeur filaire
 *	-------------------------------------------
 */
int	Fill_value (double value);


/*	Norme d'un vecteur
 *	------------------
 */
double	Norm (V3 vector);


/*	Affiche contenu matrice
 *	-----------------------
 */
void	Vector_display (int level, char * fonction, char * text, V3 vector);


/*	Affiche contenu matrice
 *	-----------------------
 */
void	Matrix_display (int level, char * fonction, char * text, M33 mat);


/*	Produit de 2 matrices : dst = m1 x m2 
 *	-------------------------------------
 */
void	Matrix_product (M33 m1, M33 m2, M33 dst);


/*	Matrice inverse : dst = inverse (src)
 *	-------------------------------------
 */
t_err	Matrix_inverse (M33 src, M33 dst);


/*	Matrice transposee : dst = transpose (src)
 *	------------------------------------------
 */
void	Matrix_transpose (M33 src, M33 dst);


/*	Matrice de rotation par rapport a X d'un angle donne
 *	----------------------------------------------------
 */
void	Matrix_rotation_X_axis (double angle, M33 mat);


/*	Matrice de rotation rapport a Y d'un angle donne
 *	----------------------------------------------------
 */
void	Matrix_rotation_Y_axis (double angle, M33 mat);


/*	Matrice de rotation par rapport a Z d'un angle donne 
 *	----------------------------------------------------
 */
void	Matrix_rotation_Z_axis (double angle, M33 mat);


/*	Diagonalisation matrice par la methode de Jacobi
 *	------------------------------------------------
 *	Cette fonction calcule les valeurs propres et les vecteurs propres d'un matrice symetrique
 *	- in	matrice d'entree symetrique 
 *	- V	vecteur propre
 *	- out	matrice des valeurs propres
 */
t_err	Diagonalisation_Jacobi (M33 in, V3 V, M33 out);


/*	Isole la valeur la plus differente des trois coordonnees d'un vecteur, 
 *	puis la plus petite et la plus grande parmi celles restantes
 *	------------------------------------------------------------
 */
t_err	Find_para (V3 vector, double * para, double * smaller, double * greater);


#endif
