/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: INTERFACE.h,v $
 *
 *	Version	: $Revision: 1.13 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2012/09/11 17:43:35 $
 *
 *	==========================================================================================
 *
 *	Module charge de la gestion des fichiers Double Star
 */

#ifndef	__INTERFACE_H
#define	__INTERFACE_H

#include "DSPLIB.h"

#define	VMAX		99			/* Maximum version number		*/

typedef	enum {					/* DSP data source			*/

	GSE,					/* Ground  Segment Equipment data	*/
	CHN,					/* Level 1 Commissioning     data	*/
	L1R,					/* Level 1 Real-time         data	*/
	L1P,					/* Level 1 Playback          data	*/
	L1,					/* Level 1 Reconstitued      data	*/
	L1D,					/* Level 1 Decommuted        data	*/
	L2,					/* Level 2 data				*/
	L3					/* Level 3 data				*/

}	t_data_source;

extern	t_symbol	dsp_data_source [];

typedef	enum {					/* DSP file ident			*/

	HIA_00 = 0,
	HIA_01,
	HIA_02,
	HIA_04 = 4,
	HIA_05,
	HIA_06,
	HIA_07,
	HIA_08,
	HIA_09,
	HIA_10,
	HIA_11,
	HIA_12,
	HIA_13,
	HIA_14,
	HIA_15,
	HIA_16,
	HIA_17,
	HIA_18,
	HIA_19,
	HIA_20,
	HIA_21,
	HIA_22,
	HIA_23,
	HIA_24,
	HIA_61 = 61,
	HIA_62,
	NSD,
	HKD,
	HPD,
	SC_HKD,
	SC_HPD,
	STOF,
	STEF,
	SATT,
	TCAL,
	CMDH,
	COVM,
	INFO,
	CDROM,
	PPD,
	SPD,
	DSDS,
	SR_GSE,
	TRACE

}	t_file_ident;

extern	t_symbol	dsp_file_ident [];


/*	Verifie la source de donnees
 */
t_err	Check_data_source (char * str, t_data_source * source);


/*	Retourne la liste des fichiers correspondant a une source, date et type specifies
 */
t_err	Search_DSP_files (t_data_source source, t_date date, t_file_ident ident, t_list * list);


/*	Ouverture du fichier correspondant a la source et au type specifies
 */
FILE *	Open_DSP_file (t_data_source source, t_file_ident ident, char * mode);


/*	Ouverture si necessaire du fichier correspondant a la source et au type specifies
 */
FILE *	Reopen_DSP_file (t_data_source source, t_file_ident ident, char * mode);


/*	Purge du repertoire correspondant a la source et date
 */
t_err	Clear_directory (t_data_source source, t_date date);


/*	Redirection sortie standard
 */
t_err	Redirect_stdout (t_data_source source);


/*	Calcul des masques de recherche des fichiers d'entree
 */
t_err	Compute_DSP_filemasks (t_data_source source, t_date date);


/*	Calcul des noms de fichiers des fichiers produits
 */
t_err	Compute_DSP_filenames (t_data_source source, t_date date, int version);


/*	Retourne le nom du fichier correspondant a la source et au type specifies
 */
char *	Product_filename (t_data_source source, t_file_ident ident);


/*	Retourne le numero de version des donnees brute utilisees
 */
t_err	Get_raw_data_version (t_date date, char * version);

#endif
