/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: HEADER.h,v $
 *
 *	Version	: $Revision: 1.7 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2004/02/17 11:09:08 $
 *
 *	==========================================================================================
 *
 *	Module charge de la gestion des entetes de produits scientifiques
 *
 */
 
#ifndef	__HEADER_H
#define	__HEADER_H

typedef	struct {				/* Informations sur un fichier produit		*/

	long		file_size;		/* - taille totale du fichier			*/
	int		record_size;		/* - taille d'un enregistrement			*/
	int		header_size;		/* - taille entete enregistrement		*/
	int		data_size;		/* - taille donnees enregistrement		*/
	int		record_number;		/* - nombre d'enregistrements			*/

}	t_prod_info;

typedef	struct {				/* Structure de donnees d'une entete de produit */

	double		milli;			/* - date d'acquisition des donnees		*/
	double		scet;			/* - spacecraft event time			*/
	uint16_t	source;			/* - numero instrument				*/
	uint16_t	product;		/* - numero du produit				*/
	uint16_t	sensitivity;		/* - indicateur sensitivite			*/
	uint16_t	op_mode;		/* - numero mode HIA				*/
	uint16_t	tlm_rate;		/* - numero mode HIA				*/
	uint16_t	frame_counter;		/* - numero de trame				*/
	uint16_t	spin_frame;		/* - numero de spin de la trame			*/
	uint16_t	spin_phase;		/* - phase du spin				*/
	uint16_t	spin_packet;		/* - numero de spin du paquet			*/
	uint16_t	phase_instr;		/* - phase instrument				*/
	float		pspin;			/* - pediode de spin				*/
	float		completion;		/* - pourcentage de paquets recus/attendus	*/
	int32_t		size;			/* - taille des donnees				*/

}	t_prod_header;


/*	Obtention informations sur le fichier produit
 *	---------------------------------------------
 */
t_err	Get_product_info (t_prod_info * info, FILE * entree);


/*	Ecriture d'une entete de produit sur fichier
 *	--------------------------------------------
 */
t_err	Write_product_header (t_prod_header * ptr, FILE * sortie);


/*	Lecture d'une entete de produit sur fichier
 *	-------------------------------------------
 */
t_err	Read_product_header (t_prod_header * ptr, FILE * sortie);


#endif
