/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: FILES.h,v $
 *
 *	Version	: $Revision: 1.4 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2009/11/25 13:58:45 $
 *
 *	==========================================================================================
 *
 *	Module regroupant les operations specifiques liees a la manipulation des fichiers
 */

#ifndef	__FILES_H
#define	__FILES_H

#define	FILENAME_LENGTH	200

typedef	char		t_filename [FILENAME_LENGTH];

extern	char *		dsp_root;	/* Racine arborescence Double Star				*/

extern	char *		dsp_ope_root;	/* Racine arborescence Double Star commanding operations	*/


/*	Verifie existence variable DSP_ROOT
 *	-----------------------------------
 */
t_err	Check_DSP_root (void);


/*	Verifie existence variable DSP_OPE_ROOT
 *	---------------------------------------
 */
t_err	Check_DSP_ope_root (void);


/*	Recherche de fichiers avec jokers
 *	---------------------------------
 *
 *	Le masque autorise les jokers *, ? et [ a la maniere de la commande ls
 *
 *	count represente le nombre de fichiers correspondant au masque
 */
t_err	Search_files (char * mask, int * count);


/*	Liberation des ressources allouees par la recherche precedente
 *	--------------------------------------------------------------
 */
void	Search_free (void);


/*	Acces au nom d'un des fichiers de la recherche precedente
 *	---------------------------------------------------------
 *
 *	number doit etre compris entre 0 et count -1, sinon retourne NULL
 */
char *	Get_filename (int number);


/*	Lecture d'un ligne dans un fichier texte
 *	----------------------------------------
 *
 *	- recopie la ligne dans la variable buffer
 *	- suppression du saut de ligne "\n" final
 *	- retrourne OK, WAR_eof ou ERR_fgets suivant les cas
 */
t_err   Read_line (char * buffer, FILE * pf);


/*	Verification nombre de valeurs lues = attendues
 *	-----------------------------------------------
 */
t_err	Check_read_values (char * fonction, int count, int expected);


/*	Verification nombre de valeurs ecrites = attendues
 *	--------------------------------------------------
 */
t_err	Check_read_values (char * fonction, int count, int expected);
t_err	Check_write_values (char * fonction, int count, int expected);

#endif
