/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: HSK.c,v $
 *
 *	Version	: $Revision: 1.5 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2009/11/25 14:02:01 $
 *
 *	==========================================================================================
 *
 *	Module charge de la lecture des fichiers de calibration Housekeeping
 */
 
#define	MODULE_NAME	"HSK"

#include "DSPLIB.h"
#include "HSK.h"

#define	MAX_HSK_COEFF	20

typedef	struct {

	char	variable [10];
	float	a;
	float	b;

}	t_hsk_coeff;

static	t_hsk_coeff 	hsk_coeff [MAX_HSK_COEFF];

static	int		nb_hsk_coeff = 0;


/***************************************************************************************************
 *
 *	Lecture coefficients de calibration HSK
 *	---------------------------------------
 */
t_err	Read_calib_HSK (char * filename)
{
	char *		fonction = FNAME ("Read_calib_HSK");
	t_err		error = OK;
	FILE *		entree = NULL;
	char		buffer [200];

	if ((entree = fopen (filename, "r")) == NULL) {

		Affiche_erreur (fonction, "Lecture %s impossible", filename);
		error = ERR_fopen;
		goto EXIT;
	}

	Affiche_trace (1, fonction, "Lecture %s", filename);

	while (Read_line (buffer, entree) == OK) {

		char	variable [10];
		float	a, b;

		if (strlen (buffer) == 0 || buffer [0] == '#') continue;

		if (sscanf (buffer, "%s %f %f", variable, & a, & b) != 3) {

			Affiche_erreur (fonction, "Ligne incorrecte : %s", buffer);
			error = ERROR;
			goto EXIT;
		}

		strcpy (hsk_coeff [nb_hsk_coeff].variable, variable);
		hsk_coeff [nb_hsk_coeff].a = a;
		hsk_coeff [nb_hsk_coeff].b = b;
		nb_hsk_coeff ++;
	}

	if (nb_hsk_coeff != 14) {

		Affiche_erreur (fonction, "%d coefficients lus au lieu de %d", nb_hsk_coeff, 14);
		error = ERROR;
		goto EXIT;
	}
	

EXIT:	if (entree != NULL) fclose (entree);
	return error;
}


/***************************************************************************************************
 *
 *	Calcule la valeur physique d'une variable Housekeeping
 *	------------------------------------------------------
 */
t_err	Compute_HSK_value (char * variable, int value, float * result)
{
	char *		fonction = FNAME ("Compute_HSK_value");
	t_err		error = OK;
	int		i;

	* result = 0.0;

	for (i = 0; i < nb_hsk_coeff; i++) {

		if (strcmp (variable, hsk_coeff [i].variable) == 0) {

			* result = hsk_coeff [i].a * value + hsk_coeff [i].b;
			goto EXIT;
		}
	}

	Affiche_erreur (fonction, "Variable %s inconnue", variable);
	error =  ERROR;

EXIT:	return error;	
}
