/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: EXTERNAL.c,v $
 *
 *	Version	: $Revision: 1.8 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2007/07/13 15:15:00 $
 *
 *	==========================================================================================
 *
 *	Interface IDL - C pour l'acces aux calibrations
 */

#define	MODULE_NAME	"EXTERNAL"

#include "DSPLIB.h"
#include "CALIB.h"
#include "export.h"

static	IDL_MEMINT	dimension [IDL_MAX_ARRAY_DIM];


/***************************************************************************************************
 *
 *	Importation des calibrations HIA vers IDL
 *	-----------------------------------------
 */
static	t_err	Import_HIA (void)
{
	char *		fonction = FNAME ("Import_HIA");
	t_err		error = OK;

	dimension [0] = NB_DSP_MODE;
	dimension [1] = NB_TLM_PRODUCT;

	IDL_ImportNamedArray ("dsp_spin_accumulation", 
		2, dimension, IDL_TYP_LONG, (UCHAR *) dsp_spin_accumulation, NULL, NULL);

	dimension [0] = NB_SENSITIVITY;
	
	IDL_ImportNamedArray ("dsp_geom_factor", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_geom_factor, NULL, NULL);

	dimension [0] = 3;

	IDL_ImportNamedArray ("dsp_anal_k_factor", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_anal_k_factor, NULL, NULL);

	dimension [0] = NB_SENSITIVITY;

	IDL_ImportNamedArray ("dsp_anal_alpha_angle", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_anal_alpha_angle, NULL, NULL);

	dimension [0] = 2;
	dimension [1] = NB_ANODE;
	dimension [2] = NB_SENSITIVITY;

	IDL_ImportNamedArray ("dsp_anode_eff", 
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_anode_eff, NULL, NULL);

	dimension [0] = 2;

	IDL_ImportNamedArray ("dsp_dead_times", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_dead_times, NULL, NULL);

	dimension [0] = NB_SENSITIVITY;

	IDL_ImportNamedArray ("dsp_a", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_a, NULL, NULL);

	dimension [0] = NB_SENSITIVITY;

	IDL_ImportNamedArray ("dsp_b", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_b, NULL, NULL);

	dimension [0] = NB_SENSITIVITY;

	IDL_ImportNamedArray ("dsp_norm_e", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_norm_e, NULL, NULL);

	dimension [0] = NB_SENSITIVITY;

	IDL_ImportNamedArray ("dsp_norm_theta", 
		1, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_norm_theta, NULL, NULL);

	dimension [0] = 5;
	dimension [1] = 3;

	IDL_ImportNamedArray ("dsp_MCP_fitting_param", 
		2, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_MCP_fitting_param, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 62;
	dimension [2] = 11;

	IDL_ImportNamedArray ("dsp_energy_sweep_table_62", 
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_energy_sweep_table_62, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 31;
	dimension [2] = 11;

	IDL_ImportNamedArray ("dsp_energy_sweep_table_31", 
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_energy_sweep_table_31, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 16;
	dimension [2] = 11;

	IDL_ImportNamedArray ("dsp_energy_sweep_table_16", 
		3, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_energy_sweep_table_16, NULL, NULL);

	dimension [0] = 3;
	dimension [1] = 32;

	IDL_ImportNamedArray ("dsp_energy_sweep_table_prom",
		2, dimension, IDL_TYP_FLOAT, (UCHAR *) dsp_energy_sweep_table_prom, NULL, NULL);

EXIT:	return error;
}


/***************************************************************************************************
 *
 *	Initialisation des calibrations pour IDL
 *	----------------------------------------
 */
t_err	CALIB_Init (void)
{
	char *		fonction = FNAME ("CALIB_Init");
	t_err		error = OK;

	if (Erreur (error = Check_DSP_root ())) goto EXIT;

	Affiche_trace (1, fonction, "");

	error = Open_calib ();

EXIT:	return error;
}


/***************************************************************************************************
 *
 *	Cloture de l'acces aux calibrations a partir d'IDL
 *	--------------------------------------------------
 */
t_err	CALIB_Close (void)
{
	char *		fonction = FNAME ("CALIB_Close");
	t_err		error = OK;

	Affiche_trace (1, fonction, "");

	error = Close_calib ();

EXIT:	return error;
}


/***************************************************************************************************
 *
 *	Lecture d'un produit de calibration pour IDL
 *	--------------------------------------------
 */
t_err	CALIB_Lire (int argc, void ** argv)
{
	char *		fonction = FNAME ("CALIB_Lire");
	t_err		error = OK;
	double		date, end_validity;
	IDL_STRING *	produit;

	if (argc != 3) {

		Affiche_erreur (fonction, "Syntaxe : CALIB_LIRE <produit> <date> <fin_validite>");
		error = ERROR;
		goto EXIT;
	}

	produit = (IDL_STRING *) argv [0];

	date = * (double *) argv [1];

	* (double *) argv [2] = 0.0;

	if (Erreur (error = Get_calib (produit->s, date, & end_validity))) goto EXIT;

	if (strcmp (produit->s, "HIA") == 0) error = Import_HIA ();

	* (double *) argv [2] = end_validity;

EXIT:	return error;
}
