/***************************************************************************************************
 *
 *	Fichier	: $RCSfile: HIA.h,v $
 *
 *	Version	: $Revision: 1.7 $
 *
 *	Auteur	: $Author: barthe $
 *
 *	Date	: $Date: 2004/04/08 09:30:03 $
 *
 *	==========================================================================================
 *
 *	Module charge de la lecture des fichiers de calibration HIA
 */
 
#ifndef	__HIA_H
#define	__HIA_H


typedef	struct { float	upper, average, lower; }	t_energy_step;


/*	Coefficients de calibration utilises par HIA
 *	--------------------------------------------
 */
extern int		dsp_spin_accumulation		[NB_TLM_PRODUCT][NB_DSP_MODE];
extern float		dsp_phase_instr			[NB_SENSITIVITY];
extern float		dsp_geom_factor			[NB_SENSITIVITY];
extern float		dsp_anal_k_factor		[3];
extern float		dsp_anal_alpha_angle		[NB_SENSITIVITY];
extern float		dsp_anode_eff			[NB_SENSITIVITY][NB_ANODE][2];
extern float		dsp_dead_times			[2];
extern float		dsp_a				[NB_SENSITIVITY];
extern float		dsp_b				[NB_SENSITIVITY];
extern float		dsp_norm_e			[NB_SENSITIVITY];
extern float		dsp_norm_theta			[NB_SENSITIVITY];
extern float		dsp_MCP_fitting_param		[3][5];
extern t_energy_step	dsp_energy_sweep_table_16	[11][16];
extern t_energy_step	dsp_energy_sweep_table_31	[11][31];
extern t_energy_step	dsp_energy_sweep_table_62	[11][62];
extern t_energy_step	dsp_energy_sweep_table_prom	[32];


/*	Lecture des fichiers de calibration HIA
 *	---------------------------------------
 */
t_err	Read_calib_HIA (char * filename);

#endif
