/*------------------------------------------------------------------------------
 *
 *      Fichier : $RCSfile: temps.c,v $, v $Revision: 1.1 $
 *
 *      Date    : $Date: 2006/01/13 16:28:49 $
 *
 *      Auteur  : $Author: stereo $
 *
 *      Version : %Z% version %I% de %M% du %G%
 *
 *------------------------------------------------------------------------------
 */

#include <time.h>

typedef struct { int annee, mois, jour, heure, minute, seconde, milliseconde;} temps_tu;

/* Informations de recalage en temps:
    - rtb (temps de bord)
    - rtu (temps universel)
    - K   (coefficient de recalage) */
double rtb;
double K;
temps_tu rtu;

/*---------------------------------------------------------------------------*/
int julday (int mm, int id, int iyyy, int *julian) {
/*---------------------------------------------------------------------------*/

	#define igreg1 588829

	int ja,jm,jy,jul;

	if (iyyy==0)
   		return -1;

	if (iyyy < 0)
   		iyyy = iyyy + 1;
	if (mm > 2) {
		jy = iyyy;
     		jm = mm+1;
	} else { 
		jy = iyyy-1;
     		jm = mm+13;
	}
	jul = (int)(365.25*jy) + (int)(30.6001*jm) + id + 1720995;

	if (id+31*(mm+12*iyyy) >= igreg1) {
		ja = (int)(0.01*jy);
     		jul = jul + 2 - ja + (int)(0.25*ja);
	}
	*julian =  jul;

	return 0;

}


/*---------------------------------------------------------------------------*/
void caldat (int *mm, int *id, int *iyyy, int julian) {
/*---------------------------------------------------------------------------*/

	#define igreg2 2299161

	int je,jd,jc,jb,jalpha,ja;

	if (julian > igreg2) {
		jalpha = (int)(((julian-1867216)-0.25)/36524.25);
     		ja = julian + 1 + jalpha - (int)(0.25*jalpha);
	} else
   		ja = julian;

	jb = ja + 1524;
	jc = (int)(6680.0 + ((jb - 2439870)-122.1)/365.25);
	jd = 365*jc + (int)(0.25*jc);
	je = (int)((jb - jd)/30.6001);
	*id = jb - jd - (int)(30.6001*je);
	*mm = je - 1;
	if (*mm > 12)
   		*mm = *mm - 12;
	*iyyy = jc - 4715;
	if (*mm > 2)
   		*iyyy = *iyyy - 1;
	if (*iyyy <= 0)
   		*iyyy = *iyyy - 1;
}

/*---------------------------------------------------------------------------*/
int tb_en_tu (double tb, temps_tu *tu)
/*---------------------------------------------------------------------------*/

/*
Transformation d'un temps de bord (tb) en temps universel (tu)

Entrees: tb = temps de bord (a l'endroit)
Sorties: *tu = structure temps_tu

code retour:  0  OK
             -1  Erreur lors de la conversion
 (dans ce cas, annee=9999, mois=99, jour=99, heure=99, minute=99, seconde=99, milliseconde=999)
*/


{

	int rtu_julian,tu_julian,x;
	double delta;

	if (K!=0)

   		if (julday (rtu.mois,rtu.jour,rtu.annee,&rtu_julian)==0) {

          		delta = (double)(tb-rtb)*1000;
     
        		/* nombre de millisecondes a comptabiliser */
        		delta = delta/K + rtu.milliseconde+1000*(rtu.seconde+60*(rtu.minute+60*rtu.heure));

        		/* nombre de jours que cela represente */
        		x = delta / (3600*24*1000);
        		tu_julian = rtu_julian + x;
        
        		caldat (&tu->mois,&tu->jour,&tu->annee,tu_julian);
        		/* On met a jour les heures, minutes, secondes et millisecondes */
        		x = delta - (double)(x)*3600*24*1000;/* nb de ms dans le jour */
        		tu->heure = x / (3600*1000);
        		x = x - tu->heure*3600*1000; /* nombre de ms dans l'heure */
        		tu->minute = x / (60*1000);
        		x = x - tu->minute*60*1000; /* nombre de ms dans la minute */
        		tu->seconde = x / 1000;
        		x = x - tu->seconde*1000; /* nombre de ms dans la seconde */
        		tu->milliseconde = x;
        		return 0;

		}

	tu->annee = 9999;
	tu->mois = 99;
	tu->jour = 99;
	tu->heure = 99;
	tu->minute = 99;
	tu->seconde = 99;
	tu->milliseconde = 999;

	return -1;

}


/*---------------------------------------------------------------------------*/
void init_recalage (double tb, temps_tu *tu, double fK) {
/*---------------------------------------------------------------------------*/

/*
Initialisation du module avec un temps de bord (tb) et un temps universel (tu)

Entrees: tb = temps de bord
         *tu = structure temps_tu
*/

	rtb = tb;
	rtu = *tu;
	K=fK;

}

/*---------------------------------------------------------------------------*/
void date_to_tu (double date, int *annee, int *mois, int *jour, int *heure, int *minute, double *seconde) {
/*---------------------------------------------------------------------------*/

	int	julian;
	int	julian1958;

	julday (1,1,1958,&julian1958);

	julian = julian1958 + (int)(date/86400000);

	caldat (mois, jour, annee, julian);

	*seconde = (date - (double)(julian-julian1958)*86400000)/1000;

	*heure = *seconde / 3600;

	*seconde = *seconde - *heure*3600;

	*minute = *seconde / 60;

	*seconde = *seconde - *minute*60;

}

/*---------------------------------------------------------------------------*/
double tu_to_date (int ann, int moi, int jou, int heu, int min, double sec) {
/*---------------------------------------------------------------------------*/


	int	julian;
	int	julian1958;
	int	nbjours;
	int	nbms;
	double	date;

	julday (moi, jou, ann, &julian);
	julday (1, 1, 1958, &julian1958);

	nbjours = julian - julian1958;
	nbms    = heu*3600000. + min*60000. + (int)(sec*1000. +0.5); /* pb arrondi */
	date    = nbjours*86400000. + nbms;

	return date;

}
