#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <libgen.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "temps.c"


#define VERT_TEXTE                      "\"#00b000\""
#define VERT                            "\"#00b000\""
#define ROUGE                           "\"#b00000\""
#define ROUGE_TEXTE                     "\"#ff0000\""
#define ORANGE                          "\"#ffa500\""


#define	CHECK_WEBFILE	"check_web.html"
#define	CHECK_FILE	"/var/www/html/"CHECK_WEBFILE
#define NB	2*15

#define FATAL_ERROR_OPEN_WRITE(nom) { printf("FATAL ERROR OPEN WRITE MODE %s\n",nom); exit(-1); }

FILE	*fd;

/*---------------------------------------------------------------------------*/
void get_tu (int *annee, int *mois, int *jour, int *heure, int *minute, int *seconde) {
/*---------------------------------------------------------------------------*/

	time_t          t;
	struct tm       *lt;

	time (&t);
	lt = localtime(&t);

	*annee =        lt->tm_year+1900;
	*mois =         lt->tm_mon+1;
	*jour =         lt->tm_mday;
	*heure =        lt->tm_hour;
	*minute =       lt->tm_min;
	*seconde =      lt->tm_sec;

}


/*---------------------------------------------------------------------------*/
int get_dernier_mag_cdf (char *sc1, char *sc2, int annee, int mois, int jour, char *nom) {
/*---------------------------------------------------------------------------*/

	int		version;
	char		cherche[1024];
	char		*tmps;
        struct stat     info;
	int		date;

	for (version=19 ; version>=0 ; version--) {

		sprintf (cherche, "/DATA/STEREO/DATA/l1data/%s/mag/SC/%04d/%02d/ST%s_L1_MAG_SC_%04d%02d%02d_V%02d.cdf",
			sc1, annee, mois, sc2, annee, mois, jour, version);

		if (access (cherche, F_OK) != -1) {
			// le fichier existe
			if (stat (cherche, &info) != 0) return 0;
			date = info.st_mtime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
			tmps = strdup(cherche);
			sprintf (nom,"%s",23+basename(tmps));
			nom[3]=0;
			return date;
		}

	}
	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_magb_cdf (char *sc1, char *sc2, int annee, int mois, int jour, char *nom) {
/*---------------------------------------------------------------------------*/

	int		version;
	char		cherche[1024];
	char		*tmps;
        struct stat     info;
	int		date;

	for (version=19 ; version>=0 ; version--) {

		sprintf (cherche, "/DATA/STEREO/DATA/l1data/%s/mag/SC/%04d/%02d/ST%s_L1_MAGB_SC_%04d%02d%02d_V%02d.cdf",
			sc1, annee, mois, sc2, annee, mois, jour, version);

		if (access (cherche, F_OK) != -1) {
			// le fichier existe
			if (stat (cherche, &info) != 0) return 0;
			date = info.st_mtime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
			tmps = strdup(cherche);
			sprintf (nom,"%s",24+basename(tmps));
			nom[3]=0;
			return date;
		}

	}
	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_mag_cef (char *sc1, char *sc2, int annee, int mois, int jour, char *nom) {
/*---------------------------------------------------------------------------*/

	int		version;
	char		cherche[1024];
	char		*tmps;
        struct stat     info;
	int		date;

	for (version=19 ; version>=0 ; version--) {

		sprintf (cherche, "/var/www/html/CEF/MAG/%s/ST%s_MAG1MN_%04d%02d%02d_V%02d.cef",
			sc1,sc2, annee, mois, jour, version);

		if (access (cherche, F_OK) != -1) {
			// le fichier existe
			if (stat (cherche, &info) != 0) return 0;
			date = info.st_mtime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
			tmps = strdup(cherche);
			sprintf (nom,"%s",20+basename(tmps));
			nom[3]=0;
			return date;
		}

	}
	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_mom_cef (char *sc1, char *sc2, int annee, int mois, int jour, char *nom) {
/*---------------------------------------------------------------------------*/

	int		version;
	char		cherche[1024];
	char		*tmps;
        struct stat     info;
	int		date;

	for (version=19 ; version>=0 ; version--) {

		sprintf (cherche, "/var/www/html/CEF/MOM/%s/ST%s_L2_SWEA_MOM_%04d%02d%02d_V%02d.cef.gz",
			sc1,sc2, annee, mois, jour, version);

		if (access (cherche, F_OK) != -1) {
			// le fichier existe
			if (stat (cherche, &info) != 0) return 0;
			date = info.st_mtime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
			tmps = strdup(cherche);
			sprintf (nom,"%s",25+basename(tmps));
			nom[3]=0;
			return date;
		}

	}
	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_momb_cef (char *sc1, char *sc2, int annee, int mois, int jour, char *nom) {
/*---------------------------------------------------------------------------*/

	int		version;
	char		cherche[1024];
	char		*tmps;
        struct stat     info;
	int		date;

	for (version=19 ; version>=0 ; version--) {

		sprintf (cherche, "/var/www/html/CEF/MOMB/%s/ST%s_L2_SWEA_MOMB_%04d%02d%02d_V%02d.cef.gz",
			sc1,sc2, annee, mois, jour, version);

		if (access (cherche, F_OK) != -1) {
			// le fichier existe
			if (stat (cherche, &info) != 0) return 0;
			date = info.st_mtime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
			tmps = strdup(cherche);
			sprintf (nom,"%s",26+basename(tmps));
			nom[3]=0;
			return date;
		}

	}
	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_rtn_asc (char *sc1, char *sc2, int annee, int mois, int jour, char *nom) {
/*---------------------------------------------------------------------------*/

	int		version;
	char		cherche[1024];
	char		*tmps;
        struct stat     info;
	int		date;

	for (version=19 ; version>=0 ; version--) {

		sprintf (cherche, "/DATA/STEREO/DATA/ORB/%s/st%s_stereo_rtn_%04d%02d%02d_v01.asc",
			sc1,sc2, annee, mois, jour, version);

		if (access (cherche, F_OK) != -1) {
			// le fichier existe
			if (stat (cherche, &info) != 0) return 0;
			date = info.st_mtime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
			tmps = strdup(cherche);
			sprintf (nom,"%s",24+basename(tmps));
			nom[3]=0;
			return date;
		}

	}
	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_pad_cef (char *sc1, char *sc2, int annee, int mois, int jour, char *nom) {
/*---------------------------------------------------------------------------*/

	int		version;
	char		cherche[1024];
	char		*tmps;
        struct stat     info;
	int		date;

	for (version=19 ; version>=0 ; version--) {

		sprintf (cherche, "/var/www/html/CEF/PAD/%s/ST%s_L2_SWEA_PAD_%04d%02d%02d_V%02d.cef.gz",
			sc1,sc2, annee, mois, jour, version);

		if (access (cherche, F_OK) != -1) {
			// le fichier existe
			if (stat (cherche, &info) != 0) return 0;
			date = info.st_mtime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
			tmps = strdup(cherche);
			sprintf (nom,"%s",25+basename(tmps));
			nom[3]=0;
			return date;
		}

	}
	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_padb_cef (char *sc1, char *sc2, int annee, int mois, int jour, char *nom) {
/*---------------------------------------------------------------------------*/

	int		version;
	char		cherche[1024];
	char		*tmps;
        struct stat     info;
	int		date;

	for (version=19 ; version>=0 ; version--) {

		sprintf (cherche, "/var/www/html/CEF/PADB/%s/ST%s_L2_SWEA_PADB_%04d%02d%02d_V%02d.cef.gz",
			sc1,sc2, annee, mois, jour, version);

		if (access (cherche, F_OK) != -1) {
			// le fichier existe
			if (stat (cherche, &info) != 0) return 0;
			date = info.st_mtime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
			tmps = strdup(cherche);
			sprintf (nom,"%s",26+basename(tmps));
			nom[3]=0;
			return date;
		}

	}
	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_3d_cef (char *sc1, char *sc2, int annee, int mois, int jour, char *nom) {
/*---------------------------------------------------------------------------*/

	int		version;
	char		cherche[1024];
	char		*tmps;
        struct stat     info;
	int		date;

	for (version=19 ; version>=0 ; version--) {

		sprintf (cherche, "/var/www/html/CEF/3D/%s/ST%s_L2_SWEA_3D_%04d%02d%02d_V%02d.cef.gz",
			sc1,sc2, annee, mois, jour, version);

		if (access (cherche, F_OK) != -1) {
			// le fichier existe
			if (stat (cherche, &info) != 0) return 0;
			date = info.st_mtime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
			tmps = strdup(cherche);
			sprintf (nom,"%s",24+basename(tmps));
			nom[3]=0;
			return date;
		}

	}
	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_3db_cef (char *sc1, char *sc2, int annee, int mois, int jour, char *nom) {
/*---------------------------------------------------------------------------*/

	int		version;
	char		cherche[1024];
	char		*tmps;
        struct stat     info;
	int		date;

	for (version=19 ; version>=0 ; version--) {

		sprintf (cherche, "/var/www/html/CEF/3DB/%s/ST%s_L2_SWEA_3DB_%04d%02d%02d_V%02d.cef.gz",
			sc1,sc2, annee, mois, jour, version);

		if (access (cherche, F_OK) != -1) {
			// le fichier existe
			if (stat (cherche, &info) != 0) return 0;
			date = info.st_mtime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
			tmps = strdup(cherche);
			sprintf (nom,"%s",25+basename(tmps));
			nom[3]=0;
			return date;
		}

	}
	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_core_txt (char *sc1, char *sc2, int annee, int mois, int jour, char *nom) {
/*---------------------------------------------------------------------------*/

	int		version;
	char		cherche[1024];
	char		*tmps;
        struct stat     info;
	int		date;

	for (version=19 ; version>=0 ; version--) {

		sprintf (cherche, "/var/www/html/CORE/ST%s_corecaldensity_%04d%02d%02d_V%02d.txt",
			sc2, annee, mois, jour, version);

		if (access (cherche, F_OK) != -1) {
			// le fichier existe
			if (stat (cherche, &info) != 0) return 0;
			date = info.st_mtime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
			tmps = strdup(cherche);
			sprintf (nom,"%s",28+basename(tmps));
			nom[3]=0;
			return date;
		}

	}
	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_plastic_txt (char *sc1, char *sc2, int annee, int mois, int jour, char *nom) {
/*---------------------------------------------------------------------------*/

	int		version;
	char		cherche[1024];
	char		*tmps;
        struct stat     info;
	int		date;

	for (version=19 ; version>=0 ; version--) {

		sprintf (cherche, "/DATA/STEREO/DATA/PLASTIC/L2/ST%s_Proton_Bulk_1mn_%04d%02d%02d_V%02d.asc",sc2,annee, mois, jour, version);

		if (access (cherche, F_OK) != -1) {
			// le fichier existe
			if (stat (cherche, &info) != 0) return 0;
			date = info.st_mtime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
			tmps = strdup(cherche);
			sprintf (nom,"%s",29+basename(tmps));
			nom[3]=0;
			return date;
		}

	}
	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_dist_bin (char *sc1, char *sc2, int annee, int mois, int jour, char *nom) {
/*---------------------------------------------------------------------------*/

	int		version;
	char		cherche[1024];
	char		*tmps;
        struct stat     info;
	int		date;

	for (version=19 ; version>=0 ; version--) {

		sprintf (cherche, "/DATA/STEREO/DATA/L1_CESR/%s/%04d%02d%02d/st%s_l1_swea_dist_%04d%02d%02d_v%02d.bin",
			sc1,annee,mois,jour,sc2,annee,mois,jour,version);

		if (access (cherche, F_OK) != -1) {
			// le fichier existe
			if (stat (cherche, &info) != 0) return 0;
			date = info.st_mtime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
			tmps = strdup(cherche);
			sprintf (nom,"%s",26+basename(tmps));
			nom[3]=0;
			return date;
		}

	}
	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_disb_bin (char *sc1, char *sc2, int annee, int mois, int jour, char *nom) {
/*---------------------------------------------------------------------------*/

	int		version;
	char		cherche[1024];
	char		*tmps;
        struct stat     info;
	int		date;

	for (version=19 ; version>=0 ; version--) {

		sprintf (cherche, "/DATA/STEREO/DATA/L1_CESR/%s/%04d%02d%02d/st%s_l1_swea_disb_%04d%02d%02d_v%02d.bin",
			sc1,annee,mois,jour,sc2,annee,mois,jour,version);

		if (access (cherche, F_OK) != -1) {
			// le fichier existe
			if (stat (cherche, &info) != 0) return 0;
			date = info.st_mtime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
			tmps = strdup(cherche);
			sprintf (nom,"%s",26+basename(tmps));
			nom[3]=0;
			return date;
		}

	}
	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_plot_png (int sc, int annee, int mois, int jour, char *nom) {
/*---------------------------------------------------------------------------*/

	int		version;
	char		cherche[1024];
        struct stat     info;
	int		date;

	for (version=19 ; version>=0 ; version--) {

		sprintf (cherche, "/var/www/html/SPECTRO/%04d%02d%02d/STEREO_BERKELEY_SC%d_%04d%02d%02d000000_86400C.png",
			annee, mois, jour, sc, annee, mois, jour);

		if (access (cherche, F_OK) != -1) {
			// le fichier existe
			if (stat (cherche, &info) != 0) return 0;
			date = info.st_mtime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
			strcpy (nom,"PLOT");
			return date;
		}

	}
	return 0;
}

/*---------------------------------------------------------------------------*/
void table_debut (void) {
/*---------------------------------------------------------------------------*/

	fprintf (fd,"<tr ALIGN=\"CENTER\">");
	fprintf (fd,"</tr>\n");

	fprintf (fd,"<tr ALIGN=\"CENTER\">");
	fprintf (fd,"<td rowspan=2>Date</td>");
	fprintf (fd,"<td colspan=13>Ahead</td>");
	fprintf (fd,"<td>&nbsp;</td>");
	fprintf (fd,"<td colspan=13>Behind</td>");
	fprintf (fd,"</tr>\n");

	fprintf (fd,"<tr ALIGN=\"CENTER\">");
	fprintf (fd,"<td>dist<br>bin</td>");
	fprintf (fd,"<td>disb<br>bin</td>");
	fprintf (fd,"<td>MAG<br>cdf</td>");
	fprintf (fd,"<td>MAGB<br>cdf</td>");
	fprintf (fd,"<td>PLASTIC<br>txt</td>");
	fprintf (fd,"<td>MAG<br>cef</td>");
	fprintf (fd,"<td>MOM<br>cef</td>");
	fprintf (fd,"<td>MOMB<br>cef</td>");
	fprintf (fd,"<td>rtn<br>asc</td>");
	fprintf (fd,"<td>PAD<br>cef</td>");
	fprintf (fd,"<td>PADB<br>cef</td>");
	fprintf (fd,"<td>3D<br>cef</td>");
	fprintf (fd,"<td>3DB<br>cef</td>");
	fprintf (fd,"<td>PLOT<br>png</td>");
	fprintf (fd,"<td>CORE<br>txt</td>");
	fprintf (fd,"<td>&nbsp;</td>");
	fprintf (fd,"<td>dist<br>bin</td>");
	fprintf (fd,"<td>disb<br>bin</td>");
	fprintf (fd,"<td>MAG<br>cdf</td>");
	fprintf (fd,"<td>MAGB<br>cdf</td>");
	fprintf (fd,"<td>PLASTIC<br>txt</td>");
	fprintf (fd,"<td>MAG<br>cef</td>");
	fprintf (fd,"<td>MOM<br>cef</td>");
	fprintf (fd,"<td>MOMB<br>cef</td>");
	fprintf (fd,"<td>rtn<br>asc</td>");
	fprintf (fd,"<td>PAD<br>cef</td>");
	fprintf (fd,"<td>PADB<br>cef</td>");
	fprintf (fd,"<td>3D<br>cef</td>");
	fprintf (fd,"<td>3DB<br>cef</td>");
	fprintf (fd,"<td>PLOT<br>png</td>");
	fprintf (fd,"<td>CORE<br>txt</td>");
	fprintf (fd,"</tr>\n");

}

/*---------------------------------------------------------------------------*/
int get_pb_mom (int date_dist, int date_mag, int date_plastic, int date_rtn, int date) {
/*---------------------------------------------------------------------------*/

	// Utilis pour les fichiers MOM_CEF
	//
	// Retourne:
	//	0:	pas de pb
	//	1:	pb fichier prsent alors qu'il ne devrait pas y en a avoir
	//	2:	pb fichier qui n'est pas plus recent que dist
	//	3:	pb fichier qui n'est pas plus recent que mag (si mag et plastic existent)
	//	4:	pb fichier qui n'est pas plus recent que plastic (si mag et plastic existent)
	//	5:	pb fichier qui n'est pas plus recent que rtn (si mag et plastic existent)


	if (date_dist==0) return date==0 ? 0 : 1;
	if (date_mag==0 && date_plastic==0) return 0;
	if (date_dist && date<date_dist) return 2;
	if (date_mag && date<date_mag) return 3;
	if (date_plastic && date<date_plastic) return 4;
	if (date_rtn && date<date_rtn) return 5;

	return 0;
	
}

/*---------------------------------------------------------------------------*/
int get_pb_pad (int date_dist, int date_mag, int date_plastic, int date) {
/*---------------------------------------------------------------------------*/

	// Utilis pour les fichiers PAD_CEF
	//
	// Retourne:
	//	0:	pas de pb
	//	1:	pb fichier prsent alors qu'il ne devrait pas y en a avoir
	//	2:	pb fichier qui n'est pas plus recent que dist
	//	3:	pb fichier qui n'est pas plus recent que mag (si mag et plastic existent)
	//	4:	pb fichier qui n'est pas plus recent que plastic (si mag et plastic existent)


	if (date_dist==0) return date==0 ? 0 : 1;
	if (date_mag==0 && date_plastic==0) return 0;
	if (date_dist && date<date_dist) return 2;
	if (date_mag && date<date_mag) return 3;
	if (date_plastic && date<date_plastic) return 4;

	return 0;
	
}

/*---------------------------------------------------------------------------*/
int get_pb_3d (int date_dist, int date_mag, int date_plastic, int date) {
/*---------------------------------------------------------------------------*/

	// Utilis pour les fichiers 3D_CEF
	//
	// Retourne:
	//	0:	pas de pb
	//	1:	pb fichier prsent alors qu'il ne devrait pas y en a avoir
	//	2:	pb fichier qui n'est pas plus recent que dist


	if (date_dist==0) return date==0 ? 0 : 1;
	if (date_dist && date<date_dist) return 2;

	return 0;
	
}

/*---------------------------------------------------------------------------*/
int get_pb_plot (int date_dist, int date_mag, int date_plastic, int date_png) {
/*---------------------------------------------------------------------------*/

	// Utilis pour les fichiers tracs
	//
	// Retourne:
	//	0:	pas de pb
	//	1:	pb fichier prsent alors qu'il ne devrait pas y en a avoir
	//	2:	pb fichier qui n'est pas plus recent que dist
	//	3:	pb fichier qui n'est pas plus recent que mag (si mag et plastic existent)
	//	4:	pb fichier qui n'est pas plus recent que plastic (si mag et plastic existent)


	if (date_dist==0 && date_mag==0) return date_png==0 ? 0 : 1; // ni dist ni mag
	//if (date_mag==0 && date_plastic==0) return 0;
	if (date_dist && date_png<date_dist) return 2;
	if (date_mag && date_png<date_mag) return 3;
	if (date_plastic && date_png<date_plastic) return 4;

	return 0;
	
}

/*---------------------------------------------------------------------------*/
int get_pb_core (int date_dist, int date_core) {
/*---------------------------------------------------------------------------*/

	// Utilis pour les fichiers CORE_TXT
	//
	// Retourne:
	//	0:	pas de pb
	//	1:	pb fichier alors qu'il ne devrait pas y en a avoir
	//	2:	pb fichier qui n'est pas plus recent que dist

	if (date_dist==0) return date_core==0 ? 0 : 1;
	if (date_dist && date_core<date_dist) return 2;

	return 0;

}

/*---------------------------------------------------------------------------*/
int get_pb_mag (int date_mag_cdf, int date_mag_cef) {
/*---------------------------------------------------------------------------*/

	// Utilis pour les fichiers MAG_txt
	//
	// Retourne:
	//	0:	pas de pb
	//	1:	pb fichier alors qu'il ne devrait pas y en a avoir
	//	3:	pb fichier qui n'est pas plus recent que mag

	if (date_mag_cdf==0) return date_mag_cef==0 ? 0 : 1;
	if (date_mag_cdf && date_mag_cef<date_mag_cdf) return 3;

	return 0;

}

/*---------------------------------------------------------------------------*/
int main (int argc, char *argv[]) {
/*---------------------------------------------------------------------------*/

	char	nom[NB][1024];
	int	date[NB];
	int	annee,mois,jour,heure,minute,seconde;
	int	annee0,mois0,jour0,heure0,minute0,seconde0;
	int	annee1,mois1,jour1,heure1,minute1;
	double	seconde1;
	int	i;
	int	vide=1;
	double	date1;

	int	pb[NB];
	int	old_mois=-1;
	char	tmps[1024];
	
	fd = fopen (CHECK_FILE,"w");
	if (fd==NULL) FATAL_ERROR_OPEN_WRITE(CHECK_FILE);

	get_tu (&annee0, &mois0, &jour0, &heure0, &minute0, &seconde0);

	fprintf (fd,"<html>\n");
	fprintf (fd,"<body>\n");

	fprintf (fd, "%02d/%02d/%04d %02d:%02d:%02d (/DATA/STEREO/SOFT/UTIL/bin/check_web, utilisateur stereo@stereo1)<br><br>\n",jour0,mois0,annee0,heure0,minute0,seconde0);
	fprintf (fd,"Les donnees MAG sont recuperees sur <a href=\"http://stereo.ssl.berkeley.edu/l1data/\" target=\"_blank\">http://stereo.ssl.berkeley.edu/l1data/</a><br>\n");
	fprintf (fd,"Les donnees PLASTIC sont recuperees sur <a href=\"https://stereo-ssc.nascom.nasa.gov/data/ins_data/plastic/level2/Protons/Derived_from_1D_Maxwellian/ASCII/\" target=\"_blank\">https://stereo-ssc.nascom.nasa.gov/data/ins_data/plastic/level2/Protons/Derived_from_1D_Maxwellian/ASCII/</a><br>\n");
	fprintf (fd, "<br>\n");
	fprintf (fd, "<br>\n");

	fprintf (fd,"<table border=1>\n");

	for (annee=2006 ; annee<=annee0 ; annee++) {

		for (mois=1 ; mois<=12 ; mois++) {

			for (jour=1 ; jour<=31 ; jour++) {

				date1 = tu_to_date (annee,mois,jour,0,0,0);
				date_to_tu (date1, &annee1, &mois1, &jour1, &heure1, &minute1, &seconde1);
				if (annee!=annee1 || mois!=mois1 || jour!=jour1) continue; // jour incorrect

				if (date1 < tu_to_date (2006,10,12,0,0,0)) continue;
				if (date1 > tu_to_date (annee0,mois0,jour0,0,0,0)) continue;

				//printf ("%02d/%02d/%04d\n",jour,mois,annee);

				#define DIST_BIN_AHEAD		0
				#define DISB_BIN_AHEAD		1
				#define MAG_CDF_AHEAD		2
				#define MAGB_CDF_AHEAD		3
				#define PLASTIC_TXT_AHEAD	4
				#define MAG_CEF_AHEAD		5
				#define MOM_CEF_AHEAD		6
				#define MOMB_CEF_AHEAD		7
				#define RTN_ASC_AHEAD		8
				#define PAD_CEF_AHEAD		9
				#define PADB_CEF_AHEAD		10
				#define _3D_CEF_AHEAD		11
				#define _3DB_CEF_AHEAD		12
				#define PLOT_PNG_AHEAD		13
				#define CORE_TXT_AHEAD		14

				#define DIST_BIN_BEHIND		15
				#define DISB_BIN_BEHIND		16
				#define MAG_CDF_BEHIND		17
				#define MAGB_CDF_BEHIND		18
				#define PLASTIC_TXT_BEHIND	19
				#define MAG_CEF_BEHIND		20
				#define MOM_CEF_BEHIND		21
				#define MOMB_CEF_BEHIND		22
				#define RTN_ASC_BEHIND		23
				#define PAD_CEF_BEHIND		24
				#define PADB_CEF_BEHIND		25
				#define _3D_CEF_BEHIND		26
				#define _3DB_CEF_BEHIND		27
				#define PLOT_PNG_BEHIND		28
				#define CORE_TXT_BEHIND		29

				date[DIST_BIN_AHEAD]		= get_dernier_dist_bin    ("ahead", "a", annee, mois, jour, nom[DIST_BIN_AHEAD]);
				date[DISB_BIN_AHEAD]		= get_dernier_disb_bin    ("ahead", "a", annee, mois, jour, nom[DISB_BIN_AHEAD]);
				date[MAG_CDF_AHEAD]		= get_dernier_mag_cdf     ("ahead", "A", annee, mois, jour, nom[MAG_CDF_AHEAD]);
				date[MAGB_CDF_AHEAD]		= get_dernier_magb_cdf    ("ahead", "A", annee, mois, jour, nom[MAGB_CDF_AHEAD]);
				date[PLASTIC_TXT_AHEAD]		= get_dernier_plastic_txt ("ahead", "A", annee, mois, jour, nom[PLASTIC_TXT_AHEAD]);
				date[MAG_CEF_AHEAD]		= get_dernier_mag_cef     ("ahead", "A", annee, mois, jour, nom[MAG_CEF_AHEAD]);
				date[MOM_CEF_AHEAD]		= get_dernier_mom_cef     ("ahead", "A", annee, mois, jour, nom[MOM_CEF_AHEAD]);
				date[MOMB_CEF_AHEAD]		= get_dernier_momb_cef    ("ahead", "A", annee, mois, jour, nom[MOMB_CEF_AHEAD]);
				date[RTN_ASC_AHEAD]		= get_dernier_rtn_asc     ("ahead", "a", annee, mois, jour, nom[RTN_ASC_AHEAD]);
				date[PAD_CEF_AHEAD]		= get_dernier_pad_cef     ("ahead", "A", annee, mois, jour, nom[PAD_CEF_AHEAD]);
				date[PADB_CEF_AHEAD]		= get_dernier_padb_cef    ("ahead", "A", annee, mois, jour, nom[PADB_CEF_AHEAD]);
				date[_3D_CEF_AHEAD]		= get_dernier_3d_cef      ("ahead", "A", annee, mois, jour, nom[_3D_CEF_AHEAD]);
				date[_3DB_CEF_AHEAD]		= get_dernier_3db_cef     ("ahead", "A", annee, mois, jour, nom[_3DB_CEF_AHEAD]);
				date[PLOT_PNG_AHEAD]		= get_dernier_plot_png    (1,            annee, mois, jour, nom[PLOT_PNG_AHEAD]);
				date[CORE_TXT_AHEAD]		= get_dernier_core_txt    ("ahead", "A", annee, mois, jour, nom[CORE_TXT_AHEAD]);

				date[DIST_BIN_BEHIND]		= get_dernier_dist_bin    ("behind", "b", annee, mois, jour, nom[DIST_BIN_BEHIND]);
				date[DISB_BIN_BEHIND]		= get_dernier_disb_bin    ("behind", "b", annee, mois, jour, nom[DISB_BIN_BEHIND]);
				date[MAG_CDF_BEHIND]		= get_dernier_mag_cdf     ("behind", "B", annee, mois, jour, nom[MAG_CDF_BEHIND]);
				date[MAGB_CDF_BEHIND]		= get_dernier_magb_cdf    ("behind", "B", annee, mois, jour, nom[MAGB_CDF_BEHIND]);
				date[PLASTIC_TXT_BEHIND]	= get_dernier_plastic_txt ("behind", "B", annee, mois, jour, nom[PLASTIC_TXT_BEHIND]);
				date[MAG_CEF_BEHIND]		= get_dernier_mag_cef     ("behind", "B", annee, mois, jour, nom[MAG_CEF_BEHIND]);
				date[MOM_CEF_BEHIND]		= get_dernier_mom_cef     ("behind", "B", annee, mois, jour, nom[MOM_CEF_BEHIND]);
				date[MOMB_CEF_BEHIND]		= get_dernier_momb_cef    ("behind", "B", annee, mois, jour, nom[MOMB_CEF_BEHIND]);
				date[RTN_ASC_BEHIND]		= get_dernier_rtn_asc     ("behind", "b", annee, mois, jour, nom[RTN_ASC_BEHIND]);
				date[PAD_CEF_BEHIND]		= get_dernier_pad_cef     ("behind", "B", annee, mois, jour, nom[PAD_CEF_BEHIND]);
				date[PADB_CEF_BEHIND]		= get_dernier_padb_cef    ("behind", "B", annee, mois, jour, nom[PADB_CEF_BEHIND]);
				date[_3D_CEF_BEHIND]		= get_dernier_3d_cef      ("behind", "B", annee, mois, jour, nom[_3D_CEF_BEHIND]);
				date[_3DB_CEF_BEHIND]		= get_dernier_3db_cef     ("behind", "B", annee, mois, jour, nom[_3DB_CEF_BEHIND]);
				date[PLOT_PNG_BEHIND]		= get_dernier_plot_png    (2,             annee, mois, jour, nom[PLOT_PNG_BEHIND]);
				date[CORE_TXT_BEHIND]		= get_dernier_core_txt    ("behind", "B", annee, mois, jour, nom[CORE_TXT_BEHIND]);

				pb[DIST_BIN_AHEAD]	= 0;
				pb[MAG_CDF_AHEAD]	= 0;
				pb[PLASTIC_TXT_AHEAD]	= 0;
				pb[MAG_CEF_AHEAD]	= get_pb_mag		(date[MAG_CDF_AHEAD], date[MAG_CEF_AHEAD]);
				pb[MOM_CEF_AHEAD]	= get_pb_mom	 	(date[DIST_BIN_AHEAD],date[MAG_CDF_AHEAD],date[PLASTIC_TXT_AHEAD],date[RTN_ASC_AHEAD],date[MOM_CEF_AHEAD]);
				pb[MOMB_CEF_AHEAD]	= get_pb_mom	 	(date[DISB_BIN_AHEAD],date[MAGB_CDF_AHEAD],date[PLASTIC_TXT_AHEAD],date[RTN_ASC_AHEAD],date[MOMB_CEF_AHEAD]);
				pb[RTN_ASC_AHEAD]	= 0;
				pb[PAD_CEF_AHEAD]	= get_pb_pad		(date[DIST_BIN_AHEAD],date[MAG_CDF_AHEAD],date[PLASTIC_TXT_AHEAD],date[PAD_CEF_AHEAD]);
				pb[PADB_CEF_AHEAD]	= get_pb_pad		(date[DISB_BIN_AHEAD],date[MAGB_CDF_AHEAD],date[PLASTIC_TXT_AHEAD],date[PADB_CEF_AHEAD]);
				pb[_3D_CEF_AHEAD]	= get_pb_3d		(date[DIST_BIN_AHEAD],date[MAG_CDF_AHEAD],date[PLASTIC_TXT_AHEAD],date[_3D_CEF_AHEAD]);
				pb[_3DB_CEF_AHEAD]	= get_pb_3d		(date[DISB_BIN_AHEAD],date[MAGB_CDF_AHEAD],date[PLASTIC_TXT_AHEAD],date[_3DB_CEF_AHEAD]);
				pb[PLOT_PNG_AHEAD]	= get_pb_plot		(date[DIST_BIN_AHEAD],date[MAG_CDF_AHEAD],date[PLASTIC_TXT_AHEAD],date[PLOT_PNG_AHEAD]);
				pb[CORE_TXT_AHEAD]	= get_pb_core		(date[DIST_BIN_AHEAD],date[CORE_TXT_AHEAD]);

				pb[DIST_BIN_BEHIND]	= 0;
				pb[MAG_CDF_BEHIND]	= 0;
				pb[PLASTIC_TXT_BEHIND]	= 0;
				pb[MAG_CEF_BEHIND]	= get_pb_mag		(date[MAG_CDF_BEHIND],date[MAG_CEF_BEHIND]);
				pb[MOM_CEF_BEHIND]	= get_pb_mom		(date[DIST_BIN_BEHIND],date[MAG_CDF_BEHIND],date[PLASTIC_TXT_BEHIND],date[RTN_ASC_BEHIND],date[MOM_CEF_BEHIND]);
				pb[MOMB_CEF_BEHIND]	= get_pb_mom		(date[DISB_BIN_BEHIND],date[MAGB_CDF_BEHIND],date[PLASTIC_TXT_BEHIND],date[RTN_ASC_BEHIND],date[MOMB_CEF_BEHIND]);
				pb[RTN_ASC_BEHIND]	= 0;
				pb[PAD_CEF_BEHIND]	= get_pb_pad		(date[DIST_BIN_BEHIND],date[MAG_CDF_BEHIND],date[PLASTIC_TXT_BEHIND],date[PAD_CEF_BEHIND]);
				pb[PADB_CEF_BEHIND]	= get_pb_pad		(date[DISB_BIN_BEHIND],date[MAGB_CDF_BEHIND],date[PLASTIC_TXT_BEHIND],date[PADB_CEF_BEHIND]);
				pb[_3D_CEF_BEHIND]	= get_pb_3d		(date[DIST_BIN_BEHIND],date[MAG_CDF_BEHIND],date[PLASTIC_TXT_BEHIND],date[_3D_CEF_BEHIND]);
				pb[_3DB_CEF_BEHIND]	= get_pb_3d		(date[DISB_BIN_BEHIND],date[MAGB_CDF_BEHIND],date[PLASTIC_TXT_BEHIND],date[_3DB_CEF_BEHIND]);
				pb[PLOT_PNG_BEHIND]	= get_pb_plot		(date[DIST_BIN_BEHIND],date[MAG_CDF_BEHIND],date[PLASTIC_TXT_BEHIND],date[PLOT_PNG_BEHIND]);
				pb[CORE_TXT_BEHIND]	= get_pb_core		(date[DIST_BIN_BEHIND],date[CORE_TXT_BEHIND]);

				vide=1;
				for (i=0 ; i<NB ; i++) {
					if (date[i]) vide=0;
				}
	
				//if (vide) continue;

				if (old_mois==-1 || mois!=old_mois) table_debut();

				old_mois=mois;
	
				fprintf (fd,"<tr ALIGN=\"CENTER\">");
				fprintf (fd,"<td>%02d/%02d/%04d</td>", jour,mois,annee);

				for (i=0 ; i<NB ; i++) {
					if (date[i]) {
						if (pb[i]==0) {
							fprintf (fd,"<td bgcolor="VERT">%s</td>",nom[i]);
						} else if (pb[i]==1) {
							fprintf (fd,"<td bgcolor="ORANGE">(remove?)<br>%s</td>",nom[i]);
						} else if (pb[i]==2) {
							fprintf (fd,"<td bgcolor="ROUGE">(dist)<br>%s</td>",nom[i]);
							printf ("ROUGE (dist) i=%d %04d%02d%02d\n", i, annee,mois,jour);
						} else if (pb[i]==3) {
							fprintf (fd,"<td bgcolor="ROUGE">(MAG)<br>%s</td>",nom[i]);
							printf ("ROUGE (MAG) i=%d %04d%02d%02d\n", i, annee,mois,jour);
						} else if (pb[i]==4) {
							fprintf (fd,"<td bgcolor="ROUGE">(PLASTIC)<br>%s</td>",nom[i]);
							printf ("ROUGE (PLASTIC) i=%d %04d%02d%02d\n", i, annee,mois,jour);
						} else if (pb[i]==5) {
							fprintf (fd,"<td bgcolor="ROUGE">(rtn)<br>%s</td>",nom[i]);
							printf ("ROUGE (rtn) i=%d %04d%02d%02d\n", i, annee,mois,jour);
						}
					} else {
						if (pb[i]==0) {
							if (i==PLASTIC_TXT_AHEAD && date1<=tu_to_date(2007,2,13,0,0,0)) {
								fprintf (fd,"<td bgcolor="ORANGE">(3)</td>");
							} else if (i==PLASTIC_TXT_BEHIND &&
									(	date1<=tu_to_date(2007,2,28,0,0,0)	|| 
										date1==tu_to_date(2009,5,9,0,0,0)	||
										date1==tu_to_date(2009,5,10,0,0,0)	||
										date1==tu_to_date(2009,5,13,0,0,0)	||
										date1==tu_to_date(2010,5,25,0,0,0)	||
										date1==tu_to_date(2011,1,9,0,0,0)	||
										date1==tu_to_date(2011,1,10,0,0,0)	||
										date1==tu_to_date(2011,1,11,0,0,0))) {
								fprintf (fd,"<td bgcolor="ORANGE">(4)</td>");
							} else if (i==DIST_BIN_BEHIND && 
								(date1==tu_to_date(2010,5,25,0,0,0) ||
								 date1==tu_to_date(2011,1,9,0,0,0) ||
								 date1==tu_to_date(2011,1,10,0,0,0))) {
								fprintf (fd,"<td bgcolor="ORANGE">(6)</td>");
							} else if (i==MAG_CDF_AHEAD && 
								 (date1==tu_to_date(2010,5,16,0,0,0))) {
								fprintf (fd,"<td bgcolor="ORANGE">(7)</td>");
							} else if (i==MAG_CDF_BEHIND && 
								 (date1==tu_to_date(2010,10,3,0,0,0) ||
								  date1==tu_to_date(2010,10,28,0,0,0) ||
								  date1==tu_to_date(2011,1,10,0,0,0))) {
								fprintf (fd,"<td bgcolor="ORANGE">(8)</td>");
							} else {
								fprintf (fd,"<td bgcolor="ORANGE"></td>");
							}
						} else if (pb[i]==1) {
							fprintf (fd,"<td bgcolor="ORANGE">(remove?)</td>");
						} else if (pb[i]==2) {
							if (i==CORE_TXT_AHEAD && date1>=tu_to_date(2008,2,14,0,0,0) && date1<=tu_to_date(2009,4,16,0,0,0)) {
								// Fichiers CORE Ahead
								fprintf (fd,"<td bgcolor="VERT">(1)</td>");
							} else if (i==CORE_TXT_BEHIND && date1>=tu_to_date(2008,2,16,0,0,0) && date1<=tu_to_date(2009,4,16,0,0,0)) {
								// Fichiers CORE Behind
								fprintf (fd,"<td bgcolor="VERT">(2)</td>");
							} else {
								fprintf (fd,"<td bgcolor="ROUGE">(dis[tb]?)</td>");
								printf ("ROUGE (fdis[tb]) i=%d %04d%02d%02d\n", i, annee,mois,jour);
							}
						} else if (pb[i]==3) {
							fprintf (fd,"<td bgcolor="ROUGE">(MAG?)</td>");
							printf ("ROUGE (MAG?) i=%d %04d%02d%02d\n", i, annee,mois,jour);
						} else if (pb[i]==4) {
							fprintf (fd,"<td bgcolor="ROUGE">(PLASTIC?)</td>");
							printf ("ROUGE (PLASTIC?) i=%d %04d%02d%02d\n", i, annee,mois,jour);
						}
					}
					if (i==NB/2-1) {
						fprintf (fd,"<td>&nbsp;</td>");
					}
				}
				fprintf (fd,"</tr>");
			}

		}

	}

	fprintf (fd,"</table>");

	fprintf (fd,"<br>\n");

	fprintf (fd,"(1) <U>pas de donnees CORE_txt Ahead en sortie:</U><br>\n");
	fprintf (fd," - du 14/02/2008 au 16/04/2009 car c'est la nouvelle table d'energie qui est utilisee (de 7.59 a 2131.46eV)<br>\n");
	fprintf (fd,"<br>\n");
	fprintf (fd,"(2) <U>pas de donnees CORE_txt Behind en sortie:</U><br>\n");
	fprintf (fd," - du 16/02/2008 au 16/04/2009 car c'est la nouvelle table d'energie qui est utilisee (de 7.59 a 2131.46eV)<br>\n");
	fprintf (fd,"<br>\n");
	fprintf (fd,"(3) <U>pas de donnees <a href=\"http://fiji.sr.unh.edu/1dmax_ascii/1min/A\" target=\"_blank\">PLASTIC_txt Ahead</a> en entree:</U><br>\n");
	fprintf (fd," - jusqu'au 13/02/2007 (inclus)<br>\n");
	fprintf (fd,"<br>\n");
	fprintf (fd,"(4) <U>pas de donnees <a href=\"http://fiji.sr.unh.edu/1dmax_ascii/1min/B\" target=\"_blank\">PLASTIC_txt Behind</a> en entree:</U><br>\n");
	fprintf (fd," - jusqu'au 28/02/2007 (inclus)<br>\n");
	fprintf (fd," - du 09/05/2009 au 10/05/2009 (inclus)<br>\n");
	fprintf (fd," - le 13/05/2009<br>\n");
	fprintf (fd," - le 25/05/2010<br>\n");
	fprintf (fd," - du 09/01/2011 au 11/01/2011 (inclus)<br>\n");
	fprintf (fd,"<br>\n");
	fprintf (fd,"(6) <U>pas de donnees DIST_bin Behind en entree:</U><br>\n");
	fprintf (fd," - le 25/05/2010<br>\n");
	fprintf (fd," - du 09/01/2011 au 10/01/2011 (inclus)<br>\n");
	fprintf (fd,"<br>\n");
	fprintf (fd,"(7) <U>pas de donnees <a href=\"http://stereo.ssl.berkeley.edu/l1data/ahead/mag/SC\" target=\"_blank\">MAG_cdf Ahead</a> en entree:</U><br>\n");
	fprintf (fd," - le 16/05/2010<br>\n");
	fprintf (fd,"<br>\n");
	fprintf (fd,"(8) <U>pas de donnees <a href=\"http://stereo.ssl.berkeley.edu/l1data/behind/mag/SC\" target=\"_blank\">MAG_cdf Behind</a> en entree:</U><br>\n");
	fprintf (fd," - le 03/10/2010<br>\n");
	fprintf (fd," - le 28/10/2010<br>\n");
	fprintf (fd," - le 10/01/2011<br>\n");
	fprintf (fd,"<br>\n");

	fprintf (fd,"<U>Pour creer <FONT COLOR="VERT_TEXTE"><B>MOM_CEF</B></FONT>: utilisateur stereo sur stereo1.irap.omp.eu dans /DATA/STEREO/SOFT/UTIL/bin</U><br>");
	fprintf (fd," - <B>L2_SWEA_MOM.sh YYYYMMDD1 YYYYMMDD2</B><br><br>\n");

	fprintf (fd,"<U>Pour creer <FONT COLOR="VERT_TEXTE"><B>MOMB_CEF</B></FONT>: utilisateur stereo sur stereo1.irap.omp.eu dans /DATA/STEREO/SOFT/UTIL/bin</U><br>");
	fprintf (fd," - <B>L2_SWEA_MOMB.sh YYYYMMDD1 YYYYMMDD2</B><br><br>\n");

	fprintf (fd,"<U>Pour creer <FONT COLOR="VERT_TEXTE"><B>PAD_CEF</B></FONT>: utilisateur stereo sur stereo1.irap.omp.eu dans /DATA/STEREO/SOFT/UTIL/bin</U><br>");
	fprintf (fd," - <B>L2_SWEA_PAD.sh YYYYMMDD1 YYYYMMDD2</B><br><br>\n");

	fprintf (fd,"<U>Pour creer <FONT COLOR="VERT_TEXTE"><B>PADB_CEF</B></FONT>: utilisateur stereo sur stereo1.irap.omp.eu dans /DATA/STEREO/SOFT/UTIL/bin</U><br>");
	fprintf (fd," - <B>L2_SWEA_PADB.sh YYYYMMDD1 YYYYMMDD2</B><br><br>\n");

	fprintf (fd,"<U>Pour creer <FONT COLOR="VERT_TEXTE"><B>3D_CEF</B></FONT>: utilisateur stereo sur stereo1.irap.omp.eu dans /DATA/STEREO/SOFT/UTIL/bin</U><br>");
	fprintf (fd," - <B>L2_SWEA_3D.sh YYYYMMDD1 YYYYMMDD2</B><br><br>\n");

	fprintf (fd,"<U>Pour creer <FONT COLOR="VERT_TEXTE"><B>3DB_CEF</B></FONT>: utilisateur stereo sur stereo1.irap.omp.eu dans /DATA/STEREO/SOFT/UTIL/bin</U><br>");
	fprintf (fd," - <B>L2_SWEA_3DB.sh YYYYMMDD1 YYYYMMDD2</B><br><br>\n");

	fprintf (fd,"<U>Pour creer <FONT COLOR="VERT_TEXTE"><B>PLOT</B></FONT>: utilisateur stereo sur stereo1.irap.omp.eu dans/DATA/STEREO/SOFT/UTIL/bin</U><br>");
	fprintf (fd," - <B>L2_SWEA_WEB.sh YYYYMMDD1 YYYYMMDD2</B><br><br>\n");

	fprintf (fd,"<U>Pour creer <FONT COLOR="VERT_TEXTE"><B>MOM_CEF + MOMB_CEF + PAD_CEF + PADB_CEF + 3D_CEF + 3DB_CEF + PLOT</B></FONT>: utilisateur stereo sur stereo1.irap.omp.eu dans /DATA/STEREO/SOFT/UTIL/bin</U><br>");
	fprintf (fd," - <B>L2_SWEA_ALL.sh YYYYMMDD1 YYYYMMDD2</B><br><br>\n");

	fprintf (fd,"<U>Pour creer <FONT COLOR="VERT_TEXTE"><B>CORE_TXT</B></FONT>: utilisateur penou sur stereo1.irap.omp.eu dans /home/penou/corecreater</U><br>");
	fprintf (fd," - <B>GO.sh YYYYMMDD1 YYYYMMDD2</B><br><br>\n");
	fprintf (fd,"</body>");
	fprintf (fd,"</html>");

	fclose (fd);

	printf ("http://stereo.irap.omp.eu/%s\n",CHECK_WEBFILE);

	return 0;

}
