#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <libgen.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "temps.c"


#define VERT_TEXTE                      "\"#00b000\""
#define VERT                            "\"#00b000\""
#define ROUGE                           "\"#b00000\""
#define ROUGE_TEXTE                     "\"#ff0000\""
#define ORANGE                          "\"#ffa500\""


#define	CHECK_WEBFILE	"check_demeter_web.html"
#define	CHECK_FILE	"/var/www/html/"CHECK_WEBFILE
#define NB	6

#define FATAL_ERROR_OPEN_WRITE(nom) { printf("FATAL ERROR OPEN WRITE MODE %s\n",nom); exit(-1); }

FILE	*fd;

/*---------------------------------------------------------------------------*/
void get_tu (int *annee, int *mois, int *jour, int *heure, int *minute, int *seconde) {
/*---------------------------------------------------------------------------*/

	time_t          t;
	struct tm       *lt;

	time (&t);
	lt = localtime(&t);

	*annee =        lt->tm_year+1900;
	*mois =         lt->tm_mon+1;
	*jour =         lt->tm_mday;
	*heure =        lt->tm_hour;
	*minute =       lt->tm_min;
	*seconde =      lt->tm_sec;

}


/*---------------------------------------------------------------------------*/
int get_dernier_IDP (int annee, int mois, int jour) {
/*---------------------------------------------------------------------------*/

	char		cherche[1024];
        struct stat     info;
	int		date;

	sprintf (cherche, "/DATA/DEMETER/DATA/L2/%04d%02d%02d/DEMETER_IDP_SURVEY_%04d%02d%02d_V01.bin",annee,mois,jour,annee,mois,jour);
	if (access (cherche, F_OK) != -1) {
		// le fichier existe
		if (stat (cherche, &info) != 0) return 0;
		date = info.st_ctime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
		return date;
	}

	sprintf (cherche, "/DATA/DEMETER/DATA/L2/%04d%02d%02d/DEMETER_IDP_BURSTx_%04d%02d%02d_V01.bin",annee,mois,jour,annee,mois,jour);
	if (access (cherche, F_OK) != -1) {
		// le fichier existe
		if (stat (cherche, &info) != 0) return 0;
		date = info.st_ctime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
		return date;
	}

	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_ICE (int annee, int mois, int jour) {
/*---------------------------------------------------------------------------*/

	char		cherche[1024];
        struct stat     info;
	int		date;

	sprintf (cherche, "/DATA/DEMETER/DATA/L2/%04d%02d%02d/DEMETER_ICE_HFx1024_%04d%02d%02d_V01.bin",annee,mois,jour,annee,mois,jour);
	if (access (cherche, F_OK) != -1) {
		// le fichier existe
		if (stat (cherche, &info) != 0) return 0;
		date = info.st_ctime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
		return date;
	}

	sprintf (cherche, "/DATA/DEMETER/DATA/L2/%04d%02d%02d/DEMETER_ICE_VLF1024_%04d%02d%02d_V01.bin",annee,mois,jour,annee,mois,jour);
	if (access (cherche, F_OK) != -1) {
		// le fichier existe
		if (stat (cherche, &info) != 0) return 0;
		date = info.st_ctime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
		return date;
	}

	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_IMS (int annee, int mois, int jour) {
/*---------------------------------------------------------------------------*/

	char		cherche[1024];
        struct stat     info;
	int		date;

	sprintf (cherche, "/DATA/DEMETER/DATA/L2/%04d%02d%02d/DEMETER_IMS_VLF1024_%04d%02d%02d_V01.bin",annee,mois,jour,annee,mois,jour);
	if (access (cherche, F_OK) != -1) {
		// le fichier existe
		if (stat (cherche, &info) != 0) return 0;
		date = info.st_ctime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
		return date;
	}

	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_ISL (int annee, int mois, int jour) {
/*---------------------------------------------------------------------------*/

	char		cherche[1024];
        struct stat     info;
	int		date;

	sprintf (cherche, "/DATA/DEMETER/DATA/L2/%04d%02d%02d/DEMETER_ISL_BURSTx_%04d%02d%02d_V01.bin",annee,mois,jour,annee,mois,jour);
	if (access (cherche, F_OK) != -1) {
		// le fichier existe
		if (stat (cherche, &info) != 0) return 0;
		date = info.st_ctime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
		return date;
	}

	sprintf (cherche, "/DATA/DEMETER/DATA/L2/%04d%02d%02d/DEMETER_ISL_SURVEY_%04d%02d%02d_V01.bin",annee,mois,jour,annee,mois,jour);
	if (access (cherche, F_OK) != -1) {
		// le fichier existe
		if (stat (cherche, &info) != 0) return 0;
		date = info.st_ctime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
		return date;
	}

	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_MAG (int annee, int mois, int jour) {
/*---------------------------------------------------------------------------*/

	char		cherche[1024];
        struct stat     info;
	int		date;

	sprintf (cherche, "/DATA/DEMETER/DATA/L2/%04d%02d%02d/DEMETER_MAG_xxxxxx_%04d%02d%02d_V01.bin",annee,mois,jour,annee,mois,jour);
	if (access (cherche, F_OK) != -1) {
		// le fichier existe
		if (stat (cherche, &info) != 0) return 0;
		date = info.st_ctime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
		return date;
	}

	return 0;
}

/*---------------------------------------------------------------------------*/
int get_dernier_ORB (int annee, int mois, int jour) {
/*---------------------------------------------------------------------------*/

	char		cherche[1024];
        struct stat     info;
	int		date;

	sprintf (cherche, "/DATA/DEMETER/DATA/L2/%04d%02d%02d/DEMETER_IDP_ORBITO_%04d%02d%02d_V01.bin",annee,mois,jour,annee,mois,jour);
	if (access (cherche, F_OK) != -1) {
		// le fichier existe
		if (stat (cherche, &info) != 0) return 0;
		date = info.st_ctime; /* nombre de secondes depuis 1/1/1970 00:00:00 */
		return date;
	}

	return 0;
}

/*---------------------------------------------------------------------------*/
void table_debut (void) {
/*---------------------------------------------------------------------------*/

	fprintf (fd,"<tr ALIGN=\"CENTER\">");
	fprintf (fd,"</tr>\n");

	fprintf (fd,"<tr ALIGN=\"CENTER\">");
	fprintf (fd,"<td>Date</td>");
	fprintf (fd,"<td>IDP</td>");
	fprintf (fd,"<td>ICE</td>");
	fprintf (fd,"<td>IMSC</td>");
	fprintf (fd,"<td>ISL</td>");
	fprintf (fd,"<td>MAG</td>");
	fprintf (fd,"<td>ORB</td>");
	fprintf (fd,"</tr>\n");

}


/*---------------------------------------------------------------------------*/
int main (int argc, char *argv[]) {
/*---------------------------------------------------------------------------*/

	char	nom[NB][1024];
	int	date[NB];
	int	annee,mois,jour,heure,minute,seconde;
	int	annee1,mois1,jour1,heure1,minute1;
	double	seconde1;
	int	i;
	int	vide=1;
	double	date1;

	int	pb[NB];
	int	old_mois=-1;
	
	fd = fopen (CHECK_FILE,"w");
	if (fd==NULL) FATAL_ERROR_OPEN_WRITE(CHECK_FILE);

	get_tu (&annee, &mois, &jour, &heure, &minute, &seconde);

	fprintf (fd,"<html>\n");
	fprintf (fd,"<body>\n");

	fprintf (fd, "%02d/%02d/%04d %02d:%02d:%02d (/DATA/STEREO/SOFT/UTIL/bin/check_demeter_web, utilisateur stereo, machine stereo)<br><br>\n",jour,mois,annee,heure,minute,seconde);
	fprintf (fd, "<br>\n");
	fprintf (fd, "<br>\n");

	fprintf (fd,"<table border=1>\n");

	for (annee=2004 ; annee<=2011 ; annee++) {

		for (mois=1 ; mois<=12 ; mois++) {

			for (jour=1 ; jour<=31 ; jour++) {

				date1 = tu_to_date (annee,mois,jour,0,0,0);
				date_to_tu (date1, &annee1, &mois1, &jour1, &heure1, &minute1, &seconde1);
				if (annee!=annee1 || mois!=mois1 || jour!=jour1) continue; // jour incorrect

				if (date1 < tu_to_date (2004, 7, 5,0,0,0)) continue;
				if (date1 > tu_to_date (2011, 3,14,0,0,0)) continue;

				//printf ("%02d/%02d/%04d\n",jour,mois,annee);

				// IDP		0
				// ICE		1
				// IMS		2
				// ISL		3
				// MAG		4
				// ORB		5

				date[0] = get_dernier_IDP     (annee, mois, jour);
				date[1] = get_dernier_ICE     (annee, mois, jour);
				date[2] = get_dernier_IMS     (annee, mois, jour);
				date[3] = get_dernier_ISL     (annee, mois, jour);
				date[4] = get_dernier_MAG     (annee, mois, jour);
				date[5] = get_dernier_ORB     (annee, mois, jour);

				pb[0] = date[0] == 0;
				pb[1] = date[1] == 0;
				pb[2] = date[2] == 0;
				pb[3] = date[3] == 0;
				pb[4] = date[4] == 0;
				pb[5] = date[5] == 0;

				vide=1;
				for (i=0 ; i<NB ; i++) {
					if (date[i]) vide=0;
				}
	
				//if (vide) continue;

				if (old_mois==-1 || mois!=old_mois) table_debut();

				old_mois=mois;
	
				fprintf (fd,"<tr ALIGN=\"CENTER\">");
				fprintf (fd,"<td>%02d/%02d/%04d</td>", jour,mois,annee);

				for (i=0 ; i<NB ; i++) {
					if (date[i]) {
						fprintf (fd,"<td bgcolor="VERT"></td>");
					} else {
						fprintf (fd,"<td bgcolor="ROUGE"></td>");
					}
				}
				fprintf (fd,"</tr>");
			}

		}

	}

	fprintf (fd,"</table>");

	fprintf (fd,"</body>");
	fprintf (fd,"</html>");

	fclose (fd);

	printf ("http://stereo.cesr.fr/%s\n",CHECK_WEBFILE);

	return 0;

}
