/***************************************************************************************************
 *
 *	Fichier	: PERIODE.c,v
 *
 *	Version	: 1.1
 *
 *	Auteur	: barthe
 *
 *	Date	: 2001/12/19 14:19:56
 *
 *	==========================================================================================
 *
 *	Cet utilitaire permet d'afficher la liste des jours compris entre deux dates.
 *
 *	Les arguments sont deux dates donnees sous la forme YYYYMMDD, qui peuvent etre en ordre
 *	croissant ou decroissant.
 *
 *	L'utilitaire affiche alors la liste des dates, a raison d'une par ligne, comprises dans
 *	cette periode.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "temps.h"


/***************************************************************************************************
 *
 *	Affichage de la periode desiree
 *	-------------------------------
 */
int	Affiche_periode (char * str_deb, char * str_fin)
{

	int	annee;
	int	mois;
	int	jour;
	int	julian1;
	int	julian2;


	if (sscanf (str_deb, "%4d%2d%2d", &annee, &mois, &jour) != 3) {

		printf ("Date incorrecte : %s\n", str_deb);
		return -1;
	}
	julday (mois, jour, annee, &julian1);

	if (sscanf (str_fin, "%4d%2d%2d", &annee, &mois, &jour) != 3) {

		printf ("Date incorrecte : %s\n", str_fin);
		return -1;
	}
	julday (mois, jour, annee, &julian2);

	if (julian1 <= julian2) {

		while (julian1 <= julian2) {

			caldat (&mois, &jour, &annee, julian1);

			printf ("%04d%02d%02d\n", annee, mois, jour);

			julian1 ++;
		}
	}
	else {	while (julian1 >= julian2) {

			caldat (&mois, &jour, &annee, julian1);

			printf ("%04d%02d%02d\n", annee, mois, jour);

			julian1 --;
		}
	}

	return 0;

}


/***************************************************************************************************
 *
 *	Programme principal
 *	-------------------
 */
int	main (int argc, char ** argv) {

	int	code;

	if (argc != 3) {

		printf ("Usage : %s <date-deb> <date-fin>\n", argv [0]);
		printf ("\n");
		printf ("Affiche la liste des dates comprises dans la periode\n");
		printf ("\n");
		printf ("Les dates doivent etre au format YYYYMMDD\n");
		return -1;

	}

	code = Affiche_periode (argv [1], argv [2]);
	return code;
	
}
