/***************************************************************************************************
 *
 *	Fichier	: CALENDRIER.c,v
 *
 *	Version	: 1.1
 *
 *	Auteur	: barthe
 *
 *	Date	: 2001/12/19 14:19:55
 *
 *	==========================================================================================
 *
 *	Utilitaire permettant d'effectuer des calculs sur les dates
 *
 *	Le premier argument est une date de reference donnee sous la formme aaaa-mm-jj ou TODAY 
 *	qui represente la date courante.
 *
 *	Le second argument est un nombre positif ou negatif qui est ajoute a la date de reference.
 *
 *	Le resultat est la date obtenue apres addition des deux.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "temps.h"


/***************************************************************************************************
 *
 *	Lecture premier argument
 *	------------------------
 */
int	Traite_date (char * str, int nbjours)
{
	int		lus;
	time_t		secs_now;
	struct tm *	time_now;
        int     	annee;  
        int     	mois;   
        int     	jour;
        int     	julian;

	if (strcasecmp (str, "today") == 0) {

		time (& secs_now);

		time_now = localtime (& secs_now);

		annee	= time_now->tm_year + 1900; 
		mois	= time_now->tm_mon  + 1;
		jour	= time_now->tm_mday;
	}
	else {	lus = sscanf (str, "%4d-%2d-%2d", & annee, & mois, & jour);
			
		if (lus != 3) {

			printf ("Date incorrecte : %s\n", str);
			return -1;
		}
	}

        julday (mois, jour, annee, &julian);
        caldat (&mois, &jour, &annee, julian + nbjours);

	printf ("%04d-%02d-%02d\n", annee, mois, jour);

	return 0;
	
}


/***************************************************************************************************
 *
 *	Programme principal
 *	-------------------
 */
int	main (int argc, char ** argv)
{
	int		code;

	if (argc != 3) {

		printf ("Usage : %s <date> <nbre_jour>\n", argv [0]);
		printf ("\n");
		printf ("Avec <date> au format AAAA-MM-JJ ou TODAY\n");
		printf ("Avec <nbre_jour> entier positif ou negatif\n");

		return -1;
	}

	code = Traite_date (argv [1], atoi (argv [2]));
	return code;

}
