#! /bin/sh
#
#	Fichier	: genere.sh,v, v 1.1
#
#	Date	: 2005/01/13 17:22:04
#
#	Auteur	: pene
#
#	Version	: %Z% version %I% de %M% du %G%
#	___________________________________________________
#
#	Script de generation d'exec. pour le de traitement des donnees

OS=`uname -s`

case	$1 in

	-cc)	CC=cc
		shift
		;;
	-gcc)	CC=gcc
		shift
		;;
	*)	CC=`[ "${OS}" = "Linux" ] && echo "gcc" || echo "cc"`
esac

if	[ $# -lt 1 ]
then
	echo
	echo	"Script de traitement des donnees Xray, ACE, et Indices"
	echo
	echo	"Syntaxe : $0 [-gcc|-cc] [all|clean|raz]"
	echo
	echo	"    -cc : force utilisation compilateur cc"
	echo	"   -gcc : force utilisation compilateur gcc"
	echo
	echo	"    all : generation de l'executable"
	echo	"  clean : suppression des fichiers inutiles"
	echo	"    raz : suppression de tous les fichiers generes"
	echo
	exit	100
fi

MF="mak/Makefile_${CC}_${OS}"

echo
echo	"Script      : $0"
echo	"Systeme     : ${OS}"
echo	"Compilateur : ${CC}"
echo	"Makefile    : ${MF}"
echo	"Arguments   : $*"
echo

if	[ ! -f "${MF}" ]
then
	echo	"ERREUR : fichier ${MF} inexistant"
	exit	100
fi

make -f ${MF} $*
