PRO goes17_xray_nc2txt

	rep1 = '/DATA/GOES/DATA/data.ngdc.noaa.gov'
	rep2 = '/DATA/GOES/DATA/L2/GOES17/1M_XRAY'

	; Les données GOES15 vont jusqu'au 28/11/2021
	; Les données GOES17 commencent le 01/06/2021 mais je les fais commencer me 29/11/2021
	date1 = tu_to_date (2018, 11, 29, 0, 0, 0)
	date2 = get_date()

	FOR date=date1,date2,86400000d DO BEGIN

		date_to_tu, date, annee, mois, jour, heure, minute, seconde
		YYYY = int_str_0(annee,4)
		MM = int_str_0(mois,2)
		DD = int_str_0(jour,2)

		liste1 = my_findfile (rep1 + '/' + YYYY + '/' + MM + '/sci_xrsf-l2-avg1m_g17_d' + YYYY + MM + DD + '*.nc')
		filename1 = liste1[N_ELEMENTS(liste1)-1] ; dernière version

		IF filename1 EQ '' THEN CONTINUE

		filename2_txt = rep2 + '/goes17_1m_xray_' + YYYY + MM + DD + '_v01.txt'
		filename2_bin = rep2 + '/goes17_1m_xray_' + YYYY + MM + DD + '_v01.bin'

		info1 = my_file_info (filename1)
		info2_bin = my_file_info (filename2_bin)
		IF info1.mtime GT info2_bin.mtime THEN BEGIN ; input plus récent que output

			PRINT, YYYY, MM, DD, liste1

			fd1 = NCDF_OPEN (filename1)
			varid = NCDF_VARID (fd1, 'time')
			vinq = NCDF_VARINQ (fd1, varid)
			datatype = vinq.datatype
			dim = vinq.dim
			ndims = vinq.ndims
			NCDF_DIMINQ, fd1, dim[0], a, nblignes
			NCDF_VARGET, fd1, 'time', time, OFFSET=0, COUNT=nblignes
			NCDF_VARGET, fd1, 'xrsa_flux', xrsa_flux, OFFSET=0, COUNT=nblignes
			NCDF_VARGET, fd1, 'xrsb_flux', xrsb_flux, OFFSET=0, COUNT=nblignes
			NCDF_CLOSE,fd1
			dates = tu_to_date (2000, 1, 1, 12, 0, 0) + time*1000d

			OPENW, fd2, filename2_txt, /GET_LUN
			PRINTF, fd2, '# Source: GOES-17'
			FOR i=0L,nblignes-1 DO BEGIN
				date_to_tu, dates[i], annee, mois, jour, heure, minute, seconde
				s = int_str_0(annee,4) + ' ' + int_str_0(mois,2) + ' ' + int_str_0(jour,2) + ' ' + int_str_0(heure,2) + int_str_0(minute,2)
				s += ' ' + '00001' ; julian day
				s += ' ' + '00001' ; second of the day
				s += ' ' + val_to_str(xrsa_flux[i]) ; Short
				s += ' ' + val_to_str(xrsb_flux[i]) ; Long
				PRINTF, fd2, s
			END
			FREE_LUN, fd2

			; conversion ".txt" en ".bin"
			cmd = '/DATA/STEREO/SOFT/UTIL/bin/ascii2bin ' + filename2_txt + ' ' + filename2_bin + ' xray'
			SPAWN, cmd

			; suppression fichier ".txt"
			code = detruire (filename2_txt)

		END

	END


END
