#!/usr/bin/env perl

use File::Basename;
use File::Copy;

use FindBin;
use lib "$FindBin::Bin/../../lib";
use perl::get_modules;

use Socket;
use Sys::Hostname; # non d'hote


# ...............................................................................
#
#  Recuperation des donnees via wget sans aucun post-traitement :
#

sub cdaweb_wget {

	
	my $mainpath=$_[0];	# chemin principal de stockage des donnees
	my $type=$_[1];		# type de donnees satellite (Wind, LANL, ACE, ...)
	my $path;		# chemin global du repertoire de stockage des fichiers CDF
	my $ftp;		# chemin global du repertoire de recuperation des fichiers CDF sur CDAWEB


	my $file;
	my @files_bef;		# tableau de listing fichiers+dates avant le wget
	my @files_aft;		# tableau de listing fichiers+dates apres le wget
	my @file_info;		# tableau de listing des infos fichiers

	my $localpath;		# repertoire du nom de sat (nom du sat)
	my $cdapath;  		# partie du chemin CDAWEB

	my %sats=();		# table de hackage donnant a chaque repertoire local de sat le chemin correspondant sur le cdaweb
	my %manips=();		# table donnant pour chaque nom local de manip. le chemin correspondant sur le cdaweb


	if ($type eq "lanl") {

		# Initialisation pour LANL
		foreach (qw(90 91 94 97 01A 02A)){

			my $localpath="LANL$_\/";
			my $cdapath="lanl/\L$_\E_";

			$sats{$localpath}=$cdapath;

		}

		$manips{"K0_MPA"}="mpa";
		$XXX="CDF";

	} elsif ($type eq "wind") {

		# Initialisation pour WIND

		$sats{""}="wind\/";

		$manips{"K0_3DP"}="3dp";

		foreach (qw(plsp elsp pm ehsp)){
			$manips{"\U$_\E_3DP"}="3dp_$_";
		}

		$manips{"K0_EPA"}="epact";
		$manips{"H1_SWE"}="swe_h1";
		$manips{"H5_SWE"}="swe_h5";
		$manips{"H0_MFI"}="mfi_h0";
		$manips{"OR_PRE"}="pre_or";
		$manips{"K0_SMS"}="sms";
		$manips{"H0_WAV"}="wav_h0";
		$XXX="CDF";

	} elsif ($type eq "geotail") {

		# Initialisation pour GEOTAIL

		$sats{""}="geotail\/";

		$manips{"cpi"}="cpi";
		$manips{"epi"}="epi";
		$manips{"lep"}="lep";
		$manips{"mgf"}="mgf";
		$XXX="Kp";

	} else {

		print "Error : Unknown \U$type\E satellite...\n";
		exit;
	}


	# ...............
	#  WGET :

	foreach $path1 (keys (%sats)) {
		foreach $path2 (keys (%manips)) {

			$path="$mainpath/\U$type\E/DATA/$XXX/$path1$path2";

			# AVANT
			#$ftp="ftp://cdaweb.gsfc.nasa.gov/pub/istp/$sats{$path1}$manips{$path2}/*";

			# APRES le 22/01/2013
			$ftp="http://cdaweb.gsfc.nasa.gov/data/$sats{$path1}$manips{$path2}";

			@files_bef=perl::get_modules::files_scan($path); #  Scan des anciens fichiers

			print  "Gets data from : $ftp\n";
			print  "wget --mirror --no-parent -e robots=off -nd -r -q $ftp -P $path\n";
			#system "wget --mirror --no-parent -e robots=off -nd -r -q $ftp -P $path";
			system "wget --mirror --no-parent -e robots=off -nd -r $ftp -P $path";

			# pour information sur les 2 tables de hackage, $path1$path2 doit former une en entite
			# du type "lanl/01a_mpa", "wind/3dp" ...
			# de meme $sats{$path1}$manips{$path2} doit former une entite de la forme
			# "LANL01A/K0_MPA", "HO_3DP" ...


			# ...............................................................................
			#  Recherche des fichiers modifies ou ajoutes

			my $modif;

			foreach $file (<$path/*>) {

				@file_infos=stat($file); # stats du fichier

				$bfile=basename($file);
				$file="$bfile $file_infos[9]";

				$modif=grep(/^$file/,@files_bef);

				# Le fichier est nouveau ou modifier :
				if ( $modif == 0 ) {

					$file =~ s/^(.+) [0-9]+$/$1/;
					printf "\tnew CDF file -> $file $type ...\t\t[ Ok ]\n";

				}
				#  ici il faut scanner dans file_bef si $ file existe
				# s'il n'existe pas, lets go
			}
			print "\n";


		}
	}

}

# ........................................................................
#
#  Programme principal :
#


my $mainpath="/DATA";

    	my $host = hostname();

	if ( $host =~ /stereo/ ) {
		cdaweb_wget($mainpath,"geotail");
		cdaweb_wget($mainpath,"lanl");
		cdaweb_wget($mainpath,"wind");
	}
	elsif ( $host =~ /cisnew/ ) {
		cdaweb_wget($mainpath,"ace");
	}
