#!/bin/sh

	if [ $# -ne 1 ]; then
		echo usage: $0 YYYY
		exit
	fi
	
	YYYY=$1
	YY=`echo $YYYY | awk '{print substr($1,3,2)}'`

	FILE="/DATA/INDICES/DATA/wdc.kugi.kyoto-u.ac.jp/AEALAOAU_$YYYY.dat"

	for MM in 01 02 03 04 05 06 07 08 09 10 11 12; do

		grep "AEALAOAU    ${YY}${MM}" $FILE > $FILE.$MM
		/DATA/STEREO/SOFT/UTIL/bin/ascii2bin $FILE.$MM /DATA/INDICES/DATA/L2/1M_AEHV/ind_1m_aehv_xxxxxxxx_v01.bin ae3

	done

	/DATA/STEREO/SOFT/UTIL/bin/move_indices.sh
