#!/bin/sh                

#       ==========================================================================================
#
#       Fichier : $RCSfile: WEB_STEREO,v $
#
#       Version : $Revision: 1.15 $
#
#       Auteur  : $Author: stereo $
#
#       Date    : $Date: 2007/06/12 21:11:59 $
#
#       ==========================================================================================
#
#       Creation des traces STEREO sur le serveur Web


# ------------------------------------------------------------------------------
WEB_STEREO_SIMPLE_GO () {
# ------------------------------------------------------------------------------
	VUECL=$1
	YYYY=$2
	MM=$3
	DD=$4
	HH1=$5
	HH2=$6
	SC=$7
	NOM=$8

	DUREE=`expr $HH2 - $HH1`
	DUREE=`expr 3600 \* $DUREE`


	if [ $SC = "0" ]; then
		echo "Web plot of $NOM $YYYYMMDD from "$HH1"H to "$HH2"H"
		NOM="$NOM"_"$YYYYMMDD""$HH1"0000_"$DUREE"C
	else
		echo "Web plot of $NOM SC$SC $YYYYMMDD from "$HH1"H to "$HH2"H"
		NOM="$NOM"_SC"$SC"_"$YYYYMMDD""$HH1"0000_"$DUREE"C
	fi
	REP=$STEREO_ROOT/DATA/SPECTRO/"$YYYY""$MM""$DD"

	rm -f "$REP"/"$NOM".png
	TRACER_STEREO $NOM $VUECL "$YYYY"-"$MM"-"$DD"T""$HH1":00:00.000Z" "$YYYY"-"$MM"-"$DD"T""$HH2":00:00.000Z" $SC
	ls -la "$NOM".png
	if [ -f "$NOM".png ] ; then
		mkdir -p $REP
		mv "$NOM".png $REP
	fi
	ls -la "$REP"/"$NOM".png
	rm -f "$NOM".ps "$NOM".out "$NOM"

}


# ------------------------------------------------------------------------------
WEB_STEREO_SIMPLE () {
# ------------------------------------------------------------------------------

	MAIL=$1
	YYYYMMDD=$2

	if [ ! -d $STEREO_ROOT/DATA/L1_CESR/ahead/$2 ]; then
		if [ ! -d $STEREO_ROOT/DATA/L1_CESR/behind/$2 ]; then
			# pas de donnees L1_CESR ce jour la
			return
		fi
	fi

	# TRACE DE LA JOURNEE ENTIERE
	# ---------------------------
	YYYY=`echo $YYYYMMDD | awk '{print substr($1,1,4)}'`
	MM=`echo $YYYYMMDD | awk '{print substr($1,5,2)}'`
	DD=`echo $YYYYMMDD | awk '{print substr($1,7,2)}'`

	WEB_STEREO_SIMPLE_GO stereo_vue_web_berkeley.cl $YYYY $MM $DD 00 24 1 "STEREO_BERKELEY" # trace de la journee entiere SC1
	WEB_STEREO_SIMPLE_GO stereo_vue_web_berkeley.cl $YYYY $MM $DD 00 24 2 "STEREO_BERKELEY" # trace de la journee entiere SC2

}


# ------------------------------------------------------------------------------
# main () {
# ------------------------------------------------------------------------------

export PATH=/usr/local/exelis/idl84/bin/:/DATA/CLUSTER/SOFT/CLL3/bin:$PATH

export STEREO_ROOT=/DATA/STEREO

case $1 in
 -MAIL) MAIL=1
     shift
     ;;
 *) MAIL=0
esac



if [ $# -eq 1 ]; then

	if [ $1 = "ALL" ]; then

		liste=`ls -d $STEREO_ROOT/DATA/L1_CESR/ahead/* | head -1`
		DATE_DEBUT=`basename $liste`

		liste=`ls -d $STEREO_ROOT/DATA/L1_CESR/ahead/* | tail -1`
		DATE_FIN=`basename $liste`

	else

		DATE_DEBUT=$1
		DATE_FIN=$1

	fi

else

	if [ $# -eq 2 ]; then

		DATE_DEBUT=$1
		DATE_FIN=$2

	else


		echo    "Usage: $0 [-MAIL] YYYYMMDD_DEBUT [YYYYMMDD_FIN]"
		echo    " or    $0 [-MAIL] ALL"
		echo
		exit

	fi

fi

YYYYMMDD_MIN=$DATE_DEBUT
YYYYMMDD_MAX=$DATE_FIN

for YYYYMMDD in `PERIODE $YYYYMMDD_MIN $YYYYMMDD_MAX`; do

	WEB_STEREO_SIMPLE $MAIL $YYYYMMDD

	# Mettre a jour la liste des fichiers png
        REP=`pwd`
        cd $STEREO_ROOT/DATA/SPECTRO
        rm -f listepng_BERKELEY_86400
	find . -name "STEREO_BERKELEY*_86400C.png" | awk '{print substr($1,3,length($1))}' | sort > listepng_BERKELEY_86400
        cd $REP

done
