#!/bin/sh

oneday() {

	if [ $# -ne 2 ]; then
		echo "Usage: $0 YYYYMMDD [1 ou 2]"
		exit
	fi

	YYYY=`echo $1 | awk '{print substr($1,1,4)}'`
	MM=`echo $1 | awk '{print substr($1,5,2)}'`
	DD=`echo $1 | awk '{print substr($1,7,2)}'`
	SAT=$2
	NOM1SAT=`echo $SAT | awk '{print $1==1 ? "ahead" : "behind"}'`
	NOM2SAT=`echo $SAT | awk '{print $1==1 ? "A" : "B"}'`
	NOMMAG=`ls /DATA/STEREO/DATA/l1data/"$NOM1SAT"/mag/SC/"$YYYY"/"$MM"/ST"$NOM2SAT"_L1_MAG_SC_"$YYYY""$MM""$DD"_*.cdf | tail -1 2> /dev/null`
	if [ -z "$NOMMAG" ]; then
		NOMMAG="UNAVAILABLE"
	else
		NOMMAG=`basename $NOMMAG`
	fi
	NOMPLASTIC=`ls /DATA/STEREO/DATA/PLASTIC/1dmax_ascii/stereo-ssc.nascom.nasa.gov/data/ins_data/plastic/level2/Protons/Derived_from_1D_Maxwellian/ASCII/1min/"$NOM2SAT"/$YYYY/ST"$NOM2SAT"_L2_PLA_1DMax_1min_"$YYYY""$MM""$DD"_*.txt 2> /dev/null`
	if [ -z "$NOMPLASTIC" ]; then
		NOMPLASTIC=`ls /DATA/STEREO/DATA/PLASTIC/1dmax_ascii/stereo-ssc.nascom.nasa.gov/data/ins_data/plastic/level2/Protons/Derived_from_1D_Maxwellian/ASCII/10min/"$NOM2SAT"/$YYYY/ST"$NOM2SAT"_L2_PLA_1DMax_10min_"$YYYY""$MM""$DD"_*.txt 2> /dev/null`
		if [ -z "$NOMPLASTIC" ]; then
			NOMPLASTIC="UNAVAILABLE"
		else
			NOMPLASTIC=`basename $NOMPLASTIC`
		fi
	else
		NOMPLASTIC=`basename $NOMPLASTIC`
	fi

	cp ~/cl.cfg cl.cfg.org
	cp /DATA/STEREO/SOFT/UTIL/bin/L2_SWEA_cl.cfg ~/cl.cfg

	# Nom du fichier ascii que l'on va crer pour BERKELEY
	OUTPUT_FINAL=/DATA/STEREO/DATA/CEF.new/MOM/"$NOM1SAT"/ST"$NOM2SAT"_L2_SWEA_MOM_$1_V05.cef

	# Suppression des fichiers ascii qui doivent tre nouvellement crer par cl
	rm -f obj3.asc

	rm batch
	echo "Nomcl			=       L2_SWEA_MOM.cl"				>> batch
	echo "Nomps			=       L2_SWEA_MOM"				>> batch
	echo "Satellite			=       $SAT"					>> batch
	echo "Temps_debut		=       "$YYYY"-"$MM"-"$DD"T00:00:00.000Z"	>> batch
	echo "Temps_fin			=       "$YYYY"-"$MM"-"$DD"T24:00:00.000Z"	>> batch
	echo "Nombre_de_vues		=       1"					>> batch
	echo "Orientation		=       Portrait"				>> batch
	echo "Ascii			=       1"					>> batch

	cl -D -batch batch


	# Cration du fichier ascii pour BERKELEY  partir des fichiers temporaires
	rm -f $OUTPUT_FINAL
	echo "! DATA FILE HEADER"												>> $OUTPUT_FINAL
	echo "!"														>> $OUTPUT_FINAL
	echo "! Spacecraft:             STEREO" $NOM2SAT 									>> $OUTPUT_FINAL
	echo "! Instrument:             IMPACT/SWEA (electron electrostatic analyzer)"						>> $OUTPUT_FINAL
	echo "! Energy range:           ~45 - 2188 eV"										>> $OUTPUT_FINAL
	echo "! Data type:              On ground moments from 3D distributions"						>> $OUTPUT_FINAL
	echo "! Data units:             See metadata below"									>> $OUTPUT_FINAL
	echo "! Data timing:            Time tag is middle of the 2 s sample"							>> $OUTPUT_FINAL
	echo "! Data time resolution:   Every 30 s in normal mode"								>> $OUTPUT_FINAL
	echo "! Data provider:          CESR, Toulouse, France"									>> $OUTPUT_FINAL
	echo "! Data mag:               "$NOMMAG										>> $OUTPUT_FINAL
	echo "! Data plastic:           "$NOMPLASTIC										>> $OUTPUT_FINAL
	echo "! IMPACT PI:              J. G. Luhmann (SSL, Berkeley, USA)"							>> $OUTPUT_FINAL
	echo "! SWEA Co-I:              J.-A. Sauvaud (CESR, Toulouse, France)"							>> $OUTPUT_FINAL
	echo "!"														>> $OUTPUT_FINAL
	echo "! QUALITY_LABEL IN TIME SERIES:"											>> $OUTPUT_FINAL
	echo "!         quality_index_0 = 0 --> B field INSIDE instrument field-of-view: moments well determined."		>> $OUTPUT_FINAL
	echo "!         quality_index_0 = 1 --> B field OUTSIDE instrument field-of-view: moments NOT well determined."		>> $OUTPUT_FINAL
	echo "!         quality_index_1 = 0 --> Temperature/Heat Flux corrected for ion bulk flow (from STEREO/PLASTIC)"	>> $OUTPUT_FINAL
	echo "!         quality_index_1 = 1 --> Temperature/Heat Flux NOT corrected for ion bulk flow (Data unavailable)"	>> $OUTPUT_FINAL
	echo ""															>> $OUTPUT_FINAL
	cat obj3.asc 													 	>> $OUTPUT_FINAL		

	gzip -f $OUTPUT_FINAL
	echo $OUTPUT_FINAL created

	# Suppression du fichier ps cre par cl
	rm L2_SWEA_MOM_1.ps

	mv cl.cfg.org ~/cl.cfg

}

	export PATH=/usr/local/exelis/idl84/bin/:/DATA/CLUSTER/SOFT/CLL3/bin:$PATH

	if [ $# -eq 1 ]; then

		YYYYMMDD1=$1
		YYYYMMDD2=$1

	else

		if [ $# -eq 2 ]; then

			YYYYMMDD1=$1
			YYYYMMDD2=$2

		else

			echo    "Usage: $0 YYYYMMDD_DEBUT [YYYYMMDD_FIN]"
			exit 

		fi

	fi

	for YYYYMMDD in `PERIODE $YYYYMMDD1 $YYYYMMDD2`; do

		oneday $YYYYMMDD 1
		oneday $YYYYMMDD 2

	done
