#!/bin/sh

oneday() {

	if [ $# -ne 2 ]; then
		echo "Usage: $0 YYYYMMDD [1 ou 2]"
		exit
	fi

	YYYY=`echo $1 | awk '{print substr($1,1,4)}'`
	MM=`echo $1 | awk '{print substr($1,5,2)}'`
	DD=`echo $1 | awk '{print substr($1,7,2)}'`
	SAT=$2
	NOM1SAT=`echo $SAT | awk '{print $1==1 ? "ahead" : "behind"}'`
	NOM2SAT=`echo $SAT | awk '{print $1==1 ? "A" : "B"}'`

	cp ~/cl.cfg cl.cfg.org
	cp /DATA/STEREO/SOFT/UTIL/bin/L2_SWEA_cl.cfg ~/cl.cfg

	# Nom du fichier ascii que l'on va crer pour BERKELEY
	OUTPUT_FINAL=/DATA/STEREO/DATA/CEF/3DB/"$NOM1SAT"/ST"$NOM2SAT"_L2_SWEA_3DB_$1_V01.cef

	# Suppression des fichiers ascii qui doivent tre nouvellement crer par cl
	rm -f obj3_Panel01_STEREO_SWEA_P01_SC"$SAT".cef

	rm batch
	echo "Nomcl			=       L2_SWEA_3DB.cl"				>> batch
	echo "Nomps			=       L2_SWEA_3DB"				>> batch
	echo "Satellite			=       $SAT"					>> batch
	echo "Temps_debut		=       "$YYYY"-"$MM"-"$DD"T00:00:00.000Z"	>> batch
	echo "Temps_fin			=       "$YYYY"-"$MM"-"$DD"T24:00:00.000Z"	>> batch
	echo "Nombre_de_vues		=       1"					>> batch
	echo "Orientation		=       Portrait"				>> batch
	echo "Cef			=       1"					>> batch

	cl -D -batch batch


	# Cration du fichier ascii pour BERKELEY  partir des fichiers temporaires
	rm -f $OUTPUT_FINAL
	echo "! DATA FILE HEADER"												>> $OUTPUT_FINAL
	echo "!"														>> $OUTPUT_FINAL
	echo "! Spacecraft:             STEREO" $NOM2SAT 									>> $OUTPUT_FINAL
	echo "! Instrument:             IMPACT/SWEA (electron electrostatic analyzer)"						>> $OUTPUT_FINAL
	echo "! Energy range:           ~45 - 2188 eV"										>> $OUTPUT_FINAL
	echo "! Data type:              3D distributions"									>> $OUTPUT_FINAL
	echo "! Data units:             Phase Space Density (PSD; sec^3/km^6)"							>> $OUTPUT_FINAL
	echo "! Data timing:            Time tag is start of the 2 s sample"							>> $OUTPUT_FINAL
	echo "! Data time resolution:   Every 2 s in burst mode"								>> $OUTPUT_FINAL
	echo "! Data provider:          CESR, Toulouse, France"									>> $OUTPUT_FINAL
	echo "! IMPACT PI:              J. G. Luhmann (SSL, Berkeley, USA)"							>> $OUTPUT_FINAL
	echo "! SWEA Co-I:              J.-A. Sauvaud (CESR, Toulouse, France)"							>> $OUTPUT_FINAL
	echo ""															>> $OUTPUT_FINAL
	cat obj3_Panel01_STEREO_SWEA_P02_SC"$SAT".cef 								 		>> $OUTPUT_FINAL		

	gzip -f $OUTPUT_FINAL
	echo $OUTPUT_FINAL created

	# Suppression du fichier ps cre par cl
	rm L2_SWEA_3DB_1.ps

	mv cl.cfg.org ~/cl.cfg

}

	export PATH=/usr/local/exelis/idl84/bin/:/DATA/CLUSTER/SOFT/CLL3/bin:$PATH

	if [ $# -eq 1 ]; then

		YYYYMMDD1=$1
		YYYYMMDD2=$1

	else

		if [ $# -eq 2 ]; then

			YYYYMMDD1=$1
			YYYYMMDD2=$2

		else

			echo    "Usage: $0 YYYYMMDD_DEBUT [YYYYMMDD_FIN]"
			exit 

		fi

	fi

	for YYYYMMDD in `PERIODE $YYYYMMDD1 $YYYYMMDD2`; do

		oneday $YYYYMMDD 1
		oneday $YYYYMMDD 2

	done
