#!/usr/bin/env perl

use File::Basename;
use File::Copy;

use FindBin;
use lib "$FindBin::Bin/../../lib";
use perl::get_modules;

# ...............................................................................
sub conversion {
# ...............................................................................

	#
	#  Conversion de fichiers ascii en fichiers binaires
	#


	my $path=$_[0];
	my $file=$_[1];
	my $type=$_[2];
	my $goespath="/DATA/GOES/DATA/L2";


	my $prg_path="$FindBin::Bin";			# chemin des binaires
	my $prg_bin="ascii2bin"; 			# nom du programme a executer
	my $typ2;					# type de donnees a traiter (sis, swepam, epam...)
	my $charac2;					# chaine de caractere donnee a partir de typ2
	my $file2;

	my %type_name;		# table de hackage donnant les correspondances de noms pour $type
	$type_name{"xray"}="xr";
	$type_name{"pchan"}="pchan";
	$type_name{"particle"}="part";
	$type_name{"geomag"}="mag";

	printf "\ttraitement de -> $file $type ...\t\t";

	if ($type eq ("xray") or $type eq ("pchan") or $type eq ("particle") or $type eq ("geomag")) {

		# donnees de type GOES:

		$file2=$file;

		# AVANT: le nom du fichier contenait le numero du satellite GOES
		#$file2=~ s/^([0-9]{8})_G([0-9]+)${type_name{$type}}_([0-9]{1,2})m\.txt/GOES$2\/$3M_\U${type}\E\/goes$2_$3m_${type}_$1_v01.bin/;

		# APRES: le nom du fichier ne contient plus le numero du satellite GOES, mais simplement Gp ou Gs
		# extraire le numero du satellite GOES en cherchant dans le fichier la ligne avec "# Source: GOES-no"
		$no=`awk '{if (\$2=="Source:") printf ("%s", substr(\$3,6,length(\$3-6)));}' $path/$file`;

		$file2=~ s/^([0-9]{8})_G[sp]_${type_name{$type}}_([0-9]{1,2})m\.txt/GOES${no}\/$2M_\U${type}\E\/goes${no}_$2m_${type}_$1_v01.bin/;

		#print "file=$file file2=$file2\n";
		#if ($file eq $file2) {
		#	return;
		#}

		# Commande de traitement des fichiers :
		system "$prg_path/$prg_bin $path/$file $goespath/$file2 $type" || die "can't execute $prg_bin";

	} elsif ($type eq "ace") {

		# donnees de type ACE :

		$file2=$file;
		$typ2=$file;
		$typ2=~ s/^[0-9]{6,8}_ace_([a-z]{3,6})_[0-9][mh]\.txt/$1/;
		if ($typ2 eq "sis" ){$charac2="SIS"};
		if ($typ2 eq "mag" ){$charac2="MAG"};
		if ($typ2 eq "epam" ){$charac2="EPM"};
		if ($typ2 eq "swepam" ){$charac2="SWE"};
		if ($typ2 eq "loc" ){$charac2="LOC"};

		$file2=~ s/^[0-9]{6,8}_ace_[a-z]{3,6}_([0-9][mh])\.txt/AC_\U$1\E_${charac2}_xxxxxxxx_V01.bin/;
		my $chain="\U$1\E_${charac2}";

		system "$prg_path/$prg_bin $path/$file $path/../L2/$chain/$file2 $typ2" || die "can't execute $prg_bin";

	} elsif ($type eq "dst") {

		# donnees de type DST :

		my $vers="01";
		if ($file =~ /v([0-9]{1})$/ ) { $vers="0$1";}
		if ($file =~ /v([0-9]{2})$/ ) { $vers="$1";}

		$file2= "ind_1h_dst_xxxxxxxx_v${vers}.bin";
		#print "vesion : $file2";

		system "$prg_path/$prg_bin $path/$file $path/../L2/1H_DST/$file2 $type" || die "can't execute $prg_bin";

	} elsif ($type eq "kpap") {

		# donnees de type KP/AP :

		my $vers="01";
		if ($file =~ /v([0-9]{1})$/ ) { $vers="0$1";}
		if ($file =~ /v([0-9]{2})$/ ) { $vers="$1";}

		$file2= "ind_3h_kpap_xxxxxxxx_v${vers}.bin";

		system "$prg_path/$prg_bin $path/$file $path/../L2/3H_KPAP/$file2 $type" || die "can't execute $prg_bin";

	} elsif ($type eq "ae") {

		# donnees de type AE :

		$file2= "ind_1h_aehv_xxxxxxxx_v01.bin";

		system "$prg_path/$prg_bin $path/$file $path/../L2/1H_AEHV/$file2 $type" || die "can't execute $prg_bin";

	} elsif (($type eq "pcn") || ($type eq "zippcn") ) {

		# donnees de type PCN :

		$file2= "ind_1m_pcn_xxxxxxxx_v01.bin";

		system "$prg_path/$prg_bin $path/$file $path/../L2/1M_PCN/$file2 $type" || die "can't execute $prg_bin";

	} else {

		print "ERROR : unknown argument!!!\n";

	}

}

# ...............................................................................
sub wget {
# ...............................................................................

	#
	#  Recuperation des donnees via wget et listing des nouvelles donnees
	#
	
	# my $path=$_[0]; # chemin de stockage des donnees
	# my $ftp=$_[1];  # URL de recuperation des donnees
	# my $ext=$_[2];  # extension des fichier a recuperer
	# my $type=$_[3]; # type de donnees a traiter (Xrays, ACE ou indices)

	my ($path,$ftp,$type,@ext)=@_;

	my $ext1;
	my $typ2;
	my $file;
	my @files_before; # tableau de listing fichiers+dates avant le wget

	# .................................
	#  Scan des anciens fichiers
	# .................................

	@files_before=perl::get_modules::files_scan($path);

	print "Gets data from : $ftp\n";
	foreach $ext1 (@ext) {
		system "wget --mirror --no-parent -nd -r -q \"$ftp/$ext1\" -P $path/";
	}
	#print "ICI2\n";


	# ...............................................................................
	#  Recherche des fichiers modifies ou ajoutes et exec. du prg. de traitemment :
	# ...............................................................................

	my $modif;

	foreach $file (<$path/*>) {

		#print "ICI1 $file\n";

		@file_infos=stat($file); # stats du fichier

		$bfile=basename($file);
		$file="$bfile $file_infos[9]";

		$modif=grep(/^$file/,@files_before);

		#$modif=0;
		#if ($bfile eq "20110630_Gp_xr_5m.txt") {
		#	$modif=0;
		#}
		      
		# Le fichier est nouveau ou modifie :
		if ($modif == 0) {

			#print "ICI2 $file\n";

			$file =~ s/^(.+) [0-9]+$/$1/;
			if ($type eq "ind") {
				if ($file =~ /dst[12]/) {
					$typ2="dst";
					conversion ($path,$file,$typ2);
				} elsif ($file =~ /[12][0-9][0-9][0-9]/) {
					$typ2="kpap";
					conversion ($path,$file,$typ2);
				} elsif ($file =~ /^ae[0-9][0-9]hv/) {
					$typ2="ae";
					conversion ($path,$file,$typ2); }
			} elsif ($type eq "ind2") {
				if ( $file =~ /\.zip$/) {
					$typ2="zippcn";
					conversion ($path,$file,$typ2);
				} elsif ($file =~ /\.iag/) {
					$typ2="pcn";
					conversion ($path,$file,$typ2); }
			} else {
				conversion ($path,$file,$type);
			}
				
		}
	}
	print "\n";

}



# ........................................................................
#
#  Programme principal
#
# ........................................................................

	my $mainpath="/DATA";
	my @path;
	my $type;

	# Path des fichiers ascii a traiter :
	$path[0]="$mainpath/GOES/DATA/sec.noaa.gov";
	#$path[0]="/DATA/STEREO/DATA/SSWDB/goes";
	$path[1]="$mainpath/ACE/DATA/sec.noaa.gov";
	$path[2]="$mainpath/INDICES/DATA/ngdc.noaa.gov";
	#$path[3]="$mainpath/INDICES/DATA/dmi.dk";
	$path[3]="$mainpath/INDICES/DATA/space.dtu.dk";

	my %type_goes;		# table de hackage donnant les correspondances des noms de manip. pour GOES
	$type_goes{"xr"}="xray";
	$type_goes{"pchan"}="pchan";
	$type_goes{"part"}="particle";
	$type_goes{"mag"}="geomag";

	my $file;


	if ($ARGV[0] eq "") {

		# recuperation des donnees GOES :
		foreach $type (qw/xray geomag particle pchan/) {
			wget($path[0],"ftp://ftp.sec.noaa.gov/pub/lists/$type",$type,"[1-2]*m.txt");
		}

		# recuperation des donnees ACE :
		wget($path[1],"ftp://ftp.sec.noaa.gov/pub/lists/ace","ace","[0-9]*.txt");
		wget($path[1],"ftp://ftp.sec.noaa.gov/pub/lists/ace2","ace","[0-9]*.txt");
	
		# recuperation des Indices :
		wget($path[2],"ftp://ftp.ngdc.noaa.gov/STP/GEOMAGNETIC_DATA/INDICES","ind","*");
		# wget($path[3],"ftp://ftp.dmi.dk/pub/wdcc1/indices/pcn","ind2","*.zip","*.iag")	# ce lien ne marche plus
		wget($path[3],"ftp://ftp.space.dtu.dk/WDC/indices/pcn","ind2","*.zip","*.iag");		# ce lien le remplace

	} elsif ($ARGV[0] eq "penou") {

		wget($path[0],"ftp://ftp.sec.noaa.gov/pub/lists/xray","xray","[1-2]*m.txt");


	} elsif ($ARGV[0] eq "goes") {

		print "[-o-] Generate goes binary files :\n";
		foreach $file (<$path[0]/*>) {
			$file=basename($file);
			my $type=$file;
			$type =~ s/[0-9]+_G[0-9]+([a-z]+)_[0-9]+[mh]\.txt/$1/;
			conversion ($path[0],$file,$type_goes{$type});
		}

	} elsif ($ARGV[0] eq "ace") {

		print "[-o-] Generate ace binary files :\n";
		foreach $file (<$path[1]/*>) {
			$file=basename($file);
			conversion ($path[1],$file,$ARGV[0]);
		}

	} elsif ($ARGV[0] eq "dst") {

		print "[-o-] Generate dst binary files :\n";
		foreach $file (<$path[2]/dst[12]*>) {
			$file=basename($file);
			conversion ($path[2],$file,$ARGV[0]);
		}

	} elsif ($ARGV[0] eq "kpap") {

		print "[-o-] Generate dst binary files :\n";
		foreach $file (<$path[2]/[12][0-9][0-9][0-9]*>) {
			$file=basename($file);
			conversion ($path[2],$file,$ARGV[0]);
		}

	} elsif ($ARGV[0] eq "ae") {

		print "[-o-] Generate ae binary files :\n";
		foreach $file (<$path[2]/ae[0-9][0-9]hv>) {
			$file=basename($file);
			conversion ($path[2],$file,$ARGV[0]);
		}

	} elsif ($ARGV[0] eq "pcn") {

		print "[-o-] Generate indices binary files :\n";
		# foreach $file (<$path[3]/*.zip>,<$path[3]/*.iag>) {
		foreach $file (<$path[3]/*.iag>) {
			$file=basename($file);
			conversion ($path[3],$file,$ARGV[0]);
		}
		#foreach $file (<$path[3]/*.zip>) {
		#	$file=basename($file);
		#	conversion ($path[3],$file,"zippcn");
		#}

	} else {

		print "ERROR : unknown argument!!!\n";

	}

	system "/DATA/STEREO/SOFT/UTIL/bin/TRAITER_GOES17.sh";

	system "/DATA/STEREO/SOFT/UTIL/bin/move_indices.sh";

	print "Termine\n";
