#!/usr/bin/perl

use File::Basename;

my $VERS = "1.1";
my $PRG = basename($0);


my @cal=(31,28,31,30,31,30,31,31,30,31,30,31);
my $file;
my $l0path="/DATA/INDICES/DATA/swdcwww.kugi.kyoto-u.ac.jp";
my $l1path="/DATA/INDICES/DATA/L2/1M_AEHV";

# Data get
if ( $ARGV[0] eq "-g" ) {


	for ($year=2001;$year>1997;$year--) {
		if ( $year%4==0 ) { $cal[1]++ } 
		if ( ! -d $l0path/$year ) { `mkdir -p $l0path/$year` }

		for ($month=1;$month<13;$month++) {
			for ($day=1;$day<$cal[$month-1]+1;$day++) {
				$file= sprintf("%04d%02d%02d",$year,$month,$day);
				print "$file\n";
				system "wget -m -q -nd http://swdcwww.kugi.kyoto-u.ac.jp/aedir/qday/$file.qae -P $l0path/$year";
			}
		}
	}
} 
# binary file gen
elsif ( $ARGV[0] eq "-dat") {

        my $month_max=12;

        for ($year=2007;$year<=2007;$year++) {
            if ($year==2007) {$month_max=7};

            for ($month=1;$month<=$month_max;$month++) {
                        $file= sprintf("%04d%02d",$year,$month);
                        print "$file ...\n";
                        system "ascii2bin $l0path/$year/${file}_telecharge_le_20110222.dat $l1path/ind_1m_aehv_xxxxxxxx_v01.bin ae3";
            }
        }


}
# binary file gen
elsif ( $ARGV[0] eq "-qae") {

        for ($year=2001;$year>1997;$year--) {
                if ( $year%4==0 ) { $cal[1]++ }

                for ($month=1;$month<13;$month++) {
                        for ($day=1;$day<$cal[$month-1]+1;$day++) {
                                $file= sprintf("%04d%02d%02d",$year,$month,$day);
                                print "$file ...";
                                system "ascii2bin $l0path/$year/$file.qae $l1path/ind_1m_aehv_xxxxxxxx_v01.bin ae2";
                        }
                }
        }


}
else {

        #printf "$PRG version $VERS\n\n";
        #printf "usage:\t $PRG -g\n";
        #printf "usage:\t $PRG -bin\n";
        #printf "Global Parameters:\n";
        #printf "\t-g\tGet AE files since 1997 to 2001\n";
        #printf "\t-qae\tL2 AE data generation for *.qae files (1997 to 2001) files)\n";
        #printf "\t-dat\tL2 AE data generation for *.dat files (2007 files)\n";

	#printf "\n";
	#printf "Pour avoir de nouvelles donnees AE AU AL AO a la minute:\n";
	#printf "--------------------------------------------------------\n";
	#printf " - aller sur http://swdcwww.kugi.kyoto-u.ac.jp/aeasy/index.html\n";
	#printf " - demander exactement un mois de donnees AUALAEAO (40kb/day)\n";
	#printf " - telecharger le fichier\n";
	#printf " - le copier dans /DATA/INDICES/DATA/swdcwww.kugi.kyoto-u.ac.jp/ANNEE\n";
	#printf " - modifier eventuellement la partie -dat de $PRG\n";
	#printf " - lancer $PRG -dat pour re-creer tous les fichiers binaires\n";
	
	printf "\n";
	printf "Pour avoir de nouvelles donnees AE AU AL AO a la minute:\n";
	printf "--------------------------------------------------------\n";
	printf " - utilisateur stereo sur stereo1\n";
	printf " - aller sur http://swdcwww.kugi.kyoto-u.ac.jp/aeasy/index.html\n";
	printf " - demander exactement un an de donnees AE output pour l'annee YYYY cad 366 jours\n";
	printf " - mettre le fichier dans /DATA/INDICES/DATA/wdc.kugi.kyoto-u.ac.jp/AEALAOAU_YYYY.dat\n";
	printf " - lancer /DATA/STEREO/SOFT/UTIL/bin/TRAITER_AEALAOAU.sh YYYY pour créer les fichiers binaires\n";
}

system "/DATA/STEREO/SOFT/UTIL/bin/move_indices.sh";

printf "Termine\n";
